<?php
// This file is part of MuTMS suite of plugins for Moodle™ LMS.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

// phpcs:disable moodle.Files.BoilerplateComment.CommentEndedTooSoon
// phpcs:disable moodle.Files.LineLength.TooLong
// phpcs:disable moodle.Commenting.DocblockDescription.Missing

namespace tool_mutenancy\phpunit\patch;

use tool_mutenancy\local\tenancy;

/**
 * Multi-tenancy tests for lib/mutenancylib.php core additions.
 *
 * @group       MuTMS
 * @package     tool_mutenancy
 * @copyright   2025 Petr Skoda
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
final class navigationlib_test extends \advanced_testcase {
    public function setUp(): void {
        parent::setUp();
        $this->resetAfterTest();
    }

    /**
     * @covers \settings_navigation::initialise, \settings_navigation::load_tenant_settings
     */
    public function test_settings_navigation_initialise(): void {
        global $PAGE;

        if (tenancy::is_active()) {
            tenancy::deactivate();
        }

        $this->setAdminUser();

        $syscontext = \context_system::instance();

        $PAGE = new \moodle_page();
        $PAGE->set_url(new \moodle_url('/'));
        $PAGE->set_context($syscontext);
        $nav = new \settings_navigation($PAGE);
        $nav->initialise();
        $this->assertNotContains('tenantsettings', $nav->get_children_key_list());

        /** @var \tool_mutenancy_generator $generator */
        $generator = $this->getDataGenerator()->get_plugin_generator('tool_mutenancy');

        $tenant = $generator->create_tenant();
        $tenantcontext = \context_tenant::instance($tenant->id);

        $PAGE = new \moodle_page();
        $PAGE->set_url(new \moodle_url('/'));
        $PAGE->set_context($syscontext);
        $nav = new \settings_navigation($PAGE);
        $nav->initialise();
        $this->assertNotContains('tenantsettings', $nav->get_children_key_list());

        $PAGE = new \moodle_page();
        $PAGE->set_url(new \moodle_url('/'));
        $PAGE->set_context($tenantcontext);
        $nav = new \settings_navigation($PAGE);
        $nav->initialise();
        $this->assertContains('tenantsettings', $nav->get_children_key_list());
    }
}
