# Multi-tenancy plugin for Moodle™ LMS

![Moodle Plugin CI](https://github.com/mutms/moodle-tool_mutenancy/actions/workflows/moodle-ci.yml/badge.svg)

Multi-tenancy refers to the ability to create isolated entities, known as tenants, within a single instance of an LMS
(Learning Management System). Each tenant operates independently, managing its own users, roles, appearance, courses,
and settings. This feature is particularly beneficial for organizations that require multiple self-contained business
units or client organizations within a single LMS installation.

The standard, free Moodle™ LMS distribution does not include support for multi-tenancy. This functionality is
available through [Moodle Workplace™](https://moodle.com/solutions/workplace-learning/), provided by Moodle HQ and
a limited number of certified partners and solution providers, as a closed source commercial product.

**Multi-tenancy plugin** for Moodle™ LMS is a plugin that, together with a required core patch, introduces
limited multi-tenancy functionality to standard Moodle™ LMS installations. The source code is fully open and free,
governed by the terms of the GPL 3.0 license, with no restrictions on commercial use or distribution.

MuTMS suite of plugins is not associated with Moodle HQ in any way.

## Roadmap

* Target for production release and availability of paid support: Q2 2026
* Additional planned feature: improved tenant separation

## Documentation

See [online documentation](https://github.com/mutms/moodle-tool_mutenancy/wiki) for more information.
