<?php
// This file is part of MuTMS suite of plugins for Moodle™ LMS.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

// phpcs:disable moodle.Files.BoilerplateComment.CommentEndedTooSoon

/**
 * My credits.
 *
 * @package    tool_mutrain
 * @copyright  2025 Petr Skoda
 * @license    https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

/** @var moodle_database $DB */
/** @var moodle_page $PAGE */
/** @var core_renderer $OUTPUT */
/** @var stdClass $CFG */
/** @var stdClass $USER */

require('../../../../config.php');

$userid = optional_param('userid', 0, PARAM_INT);

require_login();

if (!$userid) {
    $userid = $USER->id;
}
$usercontext = context_user::instance($userid);
$PAGE->set_context($usercontext);

if (!\tool_mulib\local\mulib::is_mutrain_active()) {
    redirect(new moodle_url('/'));
}
if (isguestuser()) {
    redirect(new moodle_url('/'));
}

$currenturl = new moodle_url('/admin/tool/mutrain/my/index.php');

$user = $DB->get_record('user', ['id' => $userid, 'deleted' => 0], '*', MUST_EXIST);

if ($userid != $USER->id) {
    require_capability('tool/mutrain:viewusercredits', $usercontext);
    $currenturl->param('userid', $userid);
    $title = get_string('credits', 'tool_mutrain');
} else {
    $title = get_string('credits_my', 'tool_mutrain');
}

$PAGE->navigation->extend_for_user($user);
$PAGE->set_title($title);
$PAGE->set_url($currenturl);
$PAGE->set_pagelayout('report');
$PAGE->navbar->add(get_string('profile'), new moodle_url('/user/profile.php', ['id' => $user->id]));
$PAGE->navbar->add($title);

echo $OUTPUT->header();
echo $OUTPUT->heading($title);

$report = \core_reportbuilder\system_report_factory::create(
    \tool_mutrain\reportbuilder\local\systemreports\frameworks_user::class,
    $usercontext
);
echo $report->output();

echo $OUTPUT->footer();
