# MyCourseID Quiz Helper (local_mycourseid)

A lightweight Moodle plugin that allows authorized external tools (e.g., the MyCourseID LTI 1.3 app) to update quiz settings — specifically the **password** and **description (intro HTML)** — via a secure web service.

## Features

- `local_mycourseid_update_quiz` - Update quiz password and description HTML via web services
- Minimal implementation focused only on quiz password and intro text updates
- Privacy API compliant (null provider - no personal data stored)
- Custom capability for fine-grained access control

## Requirements

- **Moodle 4.2 or higher**
- Web services must be enabled
- User must have `local/mycourseid:manage` capability (granted to teachers and managers by default)

## Installation

1. Copy the `local_mycourseid` directory to your Moodle's `local/` directory
2. Visit **Site Administration → Notifications** to complete installation
3. The capability `local/mycourseid:manage` will be automatically assigned to teachers and managers
4. Enable "MyCourseID Quiz Update Service" under
   **Site Administration → Server → Web services → Manage services**

## Web Service API

### Function: `local_mycourseid_update_quiz`

**Endpoint:**
```
POST [yourmoodle]/webservice/rest/server.php?wstoken=[TOKEN]&wsfunction=local_mycourseid_update_quiz&moodlewsrestformat=json
```

**Parameters:**
- `quizid` (int, required) - Quiz instance ID (not course module ID)
- `password` (string, optional) - New quiz password (empty string removes password)
- `intro` (string, optional) - New quiz description HTML

**Example Request:**
```json
{
  "quizid": 42,
  "password": "newpassword",
  "intro": "<p>Updated description for this quiz.</p>"
}
```

**Returns:**
```json
true
```

## Permissions

The plugin defines a custom capability:
- **`local/mycourseid:manage`** - Allows updating quiz password and description
- By default granted to: Teachers, Editing Teachers, Managers
- Context level: Course
- Risk: RISK_CONFIG

## License

GPL v3 or later

