<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * External API for updating quiz settings.
 *
 * @package    local_mycourseid
 * @copyright  2025 MyCourseID <support@mycourseid.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_mycourseid;

use external_function_parameters;
use external_value;
use external_single_structure;
use context_module;
use external_api;

defined('MOODLE_INTERNAL') || die();

require_once($CFG->libdir . '/externallib.php');

class external extends external_api {

    public static function update_quiz_parameters() {
        return new external_function_parameters([
            'quizid' => new external_value(PARAM_INT, 'Quiz instance ID'),
            'password' => new external_value(PARAM_RAW, 'New password (optional)', VALUE_OPTIONAL),
            'intro' => new external_value(PARAM_RAW, 'New quiz description HTML (optional)', VALUE_OPTIONAL)
        ]);
    }

    public static function update_quiz($quizid, $password = null, $intro = null) {
        global $DB;

        $params = self::validate_parameters(self::update_quiz_parameters(), compact('quizid', 'password', 'intro'));
        require_login();

        // Get course module from quiz instance ID
        $cm = get_coursemodule_from_instance('quiz', $params['quizid']);
        if (!$cm) {
            throw new \moodle_exception('invalidquizid', 'local_mycourseid');
        }

        $context = context_module::instance($cm->id);
        require_capability('local/mycourseid:manage', $context);

        $fields = [];
        if ($params['password'] !== null) {
            $fields['password'] = $params['password'];
        }
        if ($params['intro'] !== null) {
            $fields['intro'] = $params['intro'];
            $fields['introformat'] = FORMAT_HTML;
        }

        if (!empty($fields)) {
            $fields['id'] = $params['quizid'];
            $DB->update_record('quiz', (object)$fields);
        }

        return true;
    }

    public static function update_quiz_returns() {
        return new external_value(PARAM_BOOL, 'True on success');
    }
}

