<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Web service definitions.
 *
 * @package    local_mycourseid
 * @copyright  2025 MyCourseID <support@mycourseid.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$functions = array(
    'local_mycourseid_update_quiz' => array(
        'classname'   => 'local_mycourseid\external',
        'methodname'  => 'update_quiz',
        'description' => 'Update quiz password and description HTML',
        'type'        => 'write',
        'ajax'        => true,
        'capabilities'=> 'local/mycourseid:manage',
        'services'    => array(MOODLE_OFFICIAL_MOBILE_SERVICE)
    ),
);

$services = array(
    'MyCourseID Quiz Update Service' => array(
        'functions' => array(
            'local_mycourseid_update_quiz'
        ),
        'restrictedusers' => 0,
        'enabled' => 1,
    )
);

