<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     mod_plugnmeet
 * @category    string
 * @author     Jibon L. Costa <jibon@mynaparrot.com>
 * @copyright  2022 MynaParrot
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = 'Leia-me ao selecionar o tema.';
$string['missingidandcmid'] = 'Falta id e cmid';
$string['modulename'] = 'plugNmeet';
$string['modulename_help'] = 'Use o módulo plugNmeet para...';
$string['modulenameplural'] = 'plugNmeets';
$string['newmodulename'] = 'nome plugNmeet';
$string['newmodulename_help'] = 'Este é o conteúdo da dica de ferramenta de ajuda associada ao campo plugNmeet';
$string['newmodulesettings'] = 'Configurações';
$string['nonewmodules'] = 'Sem plugNmeet';
$string['pluginadministration'] = 'administração plugNmeet';
$string['pluginname'] = 'plugNmeet';
$string['pluginname_help'] = 'Texto de ajuda ao adicionar este tipo de pergunta.';
$string['pluginnameadding'] = 'Renderizado ao adicionar este tipo de pergunta.';
$string['pluginnameediting'] = 'Renderizado ao editar este tipo de pergunta.';
$string['pluginnamesummary'] = 'Renderizado ao escolher o tipo de pergunta a ser adicionada.';
$string['plugnmeet:access'] = 'Aceder a conteúdos';
$string['plugnmeet:addinstance'] = 'Adicionar uma nova atividade plugNmeet';
$string['plugnmeet:edit'] = 'Editar plugNmeet';
$string['plugnmeet:enrol'] = 'Inscrever utilizadores';
$string['plugnmeet:manage'] = 'Gerenciar usuários';
$string['plugnmeet:unenrol'] = 'Cancelar inscrição de usuários';
$string['plugnmeet:upload'] = 'Carregar conteúdo';
$string['plugnmeet:useeditor'] = 'Editar conteúdo';
$string['plugnmeet:view'] = 'Ver plugNmeet';
$string['privacy:metadata:plugnmeet'] = 'Para se integrar com um servidor plugnmeet remoto, os dados do usuário precisam ser trocados com esse servidor.';
$string['privacy:metadata:plugnmeet:userid'] = 'O userid é enviado do Moodle para permitir que você acesse seus dados no sistema remoto.';
$string['privacy:metadata:plugnmeet:fullname'] = 'O seu nome completo é enviado para o sistema remoto para permitir uma melhor experiência do utilizador.';

$string['view'] = 'Visão';
$string['yes'] = 'Sim';
$string['no'] = 'Não';
$string['join'] = 'Aderir';
$string['plugnmeetname'] = 'plugNmeet';
$string['plugnmeetname_help'] = 'Ajuda';
$string['plugnmeet_viewed'] = 'atividade plugNmeet visualizada';
$string['joined_session'] = 'Sessão assistida';

$string['plugnmeetconfig'] = 'configuração do plugNmeet';
$string['plugnmeet_server_url'] = 'URL do servidor PlugnMeet';
$string['plugnmeet_server_url_des'] = 'Insira a URL do servidor plugNmeet';
$string['plugnmeet_api_key'] = 'plugnmeet API Key';
$string['plugnmeet_api_key_des'] = 'Insira a chave da API do plugnmeet';
$string['plugnmeet_secret'] = 'plugnmeet Segredo';
$string['plugnmeet_secret_des'] = 'Entrar plugnmeet Secret';
$string['livekit_server_url'] = 'URL do servidor Livekit';
$string['livekit_server_url_des'] = 'Insira o URL do servidor Livekit';
$string['custom_logo'] = 'Logótipo personalizado';
$string['custom_logo_des'] = 'Logótipo personalizado para sala de conferências';

$string['plugnmeetoptions'] = 'opções plugNmeet';
$string['enable_dynacast'] = 'Ativar dynacast';
$string['enable_dynacast_des'] = 'Ativar dynacast';
$string['enable_simulcast'] = 'Ativar simulcast';
$string['enable_simulcast_des'] = 'Ativar simulcast';
$string['stop_mic_track_on_mute'] = 'Pare a faixa do microfone no mudo';
$string['stop_mic_track_on_mute_des'] = 'Pare a faixa do microfone no mudo';
$string['video_codec'] = 'Codec de vídeo';
$string['video_codec_des'] = 'Codec de vídeo';
$string['default_webcam_resolution'] = 'Resolução padrão da webcam';
$string['default_webcam_resolution_des'] = 'Resolução padrão da webcam';
$string['default_screen_share_resolution'] = 'Resolução de compartilhamento de tela padrão';
$string['default_screen_share_resolution_des'] = 'Resolução de compartilhamento de tela padrão';
$string['default_audio_preset'] = 'Predefinição de áudio';
$string['default_audio_preset_des'] = 'Predefinição de áudio para microfone';
$string['copyright_display'] = 'Ativar exibição de direitos autorais';
$string['copyright_display_des'] = 'Se ativado, ele exibirá o texto abaixo';
$string['copyright_text'] = 'Texto dos direitos de autor';
$string['copyright_text_des'] = 'Este texto pode ser definido se a configuração do servidor permitir substituir';

$string['roomtitle'] = 'Título do quarto';
$string['welcome_message'] = 'Mensagem de boas-vindas';
$string['max_participants'] = 'Máximo de participantes (0 = ilimitado)';

$string['room_features'] = 'Características do quarto';
$string['roomfeatures'] = 'Características do quarto';
$string['allow_webcams'] = 'Permitir webcams';
$string['mute_on_start'] = 'Mudo no início';
$string['allow_screen_share'] = 'Permitir partilha de ecrã';
$string['allow_rtmp'] = 'Permitir RTMP';
$string['allow_view_other_webcams'] = 'Permitir ver outras webcams';
$string['allow_view_other_users_list'] = 'Permitir ver outros utilizadores';
$string['admin_only_webcams'] = 'Webcams apenas para administradores';
$string['allow_polls'] = 'Permitir sondagens';
$string['room_duration'] = 'Duração do quarto (em minutos, 0 = ilimitado)';
$string['moderator_join_first'] = 'Moderador junte-se primeiro';
$string['moderator_join_first_error'] = 'A reunião ainda não começou, por favor, volte mais tarde';
$string['enable_analytics'] = 'Habilite a análise';
$string['allow_virtual_bg'] = 'Permitir plano de fundo virtual';
$string['allow_raise_hand'] = 'Permitir levantar a mão';
$string['auto_gen_user_id'] = 'Gerar automaticamente ID de usuário';

$string['other_features'] = 'Outras características';

$string['recordingfeatures'] = 'Recursos de gravação';
$string['allow_recording'] = 'Permitir gravação';
$string['allow_cloud_recording'] = 'Permitir gravação na nuvem';
$string['enable_auto_cloud_recording'] = 'Ativar o início automático da gravação na nuvem';
$string['allow_local_recording'] = 'Permitir gravação local';
$string['is_allow_view_recording'] = 'Permitir que os alunos visualizem a gravação';
$string['is_allow_download_recording'] = 'Permitir que os alunos baixem a gravação';

$string['chatfeatures'] = 'Recursos de bate-papo';
$string['allow_chat'] = 'Permitir bate-papo';
$string['allow_file_upload'] = 'Permitir o carregamento de ficheiros';

$string['shared_note_pad_features'] = 'Recursos compartilhados do bloco de notas';
$string['allow_shared_notepad'] = 'Permitir bloco de notas partilhado';

$string['whiteboard_features'] = 'Recursos do quadro de comunicações';
$string['allow_whiteboard'] = 'Permitir Quadro de Comunicações';

$string['external_media_player_features'] = 'Funcionalidades do leitor multimédia externo';
$string['allowed_external_media_player'] = 'Permitir media player externo';

$string['waiting_room_features'] = 'Características da sala de espera';
$string['activate_waiting_room'] = 'Ativar sala de espera';
$string['waiting_room_msg'] = 'Mensagem da sala de espera';

$string['breakout_room_features'] = 'Características do quarto Breakout';
$string['allow_breakout_rooms'] = 'Permitir salas de intervalo';
$string['allowed_number_rooms'] = 'Número de quartos';

$string['display_external_link_features'] = 'Exibir recursos de link externo';
$string['allow_display_external_link_features'] = 'Permitir a exibição de recursos de link externo';
$string['allow_ingress_features'] = 'Permitir a criação de ingresso';

$string['defaultlock'] = 'Configurações de bloqueio padrão';
$string['lock_microphone'] = 'Bloquear microfone';
$string['lock_webcam'] = 'Bloquear webcam';
$string['lock_screen_sharing'] = 'Compartilhamento de tela de bloqueio';
$string['lock_whiteboard'] = 'Quadro branco de bloqueio';
$string['lock_shared_notepad'] = 'Bloquear bloco de notas partilhado';
$string['lock_chat'] = 'Bloquear chat';
$string['lock_chat_send_message'] = 'Bloquear enviar mensagem';
$string['lock_chat_file_share'] = 'Bloquear partilha de ficheiros';
$string['lock_private_chat'] = 'Bloquear chat privado';

$string['available'] = 'Disponível em';
$string['deadline'] = 'Prazo';

$string['extraoption'] = 'Opções extras';

$string['client_load'] = 'Carga do cliente a partir de';
$string['client_load_des'] = 'Padrão: remoto';
$string['remote'] = 'Controlo remoto';
$string['local'] = 'Locais';

$string['client_download_url'] = 'URL de download do cliente local';
$string['client_download_url_des'] = 'URL de download do cliente local. Github padrão';
$string['update_client_code'] = '<button class="btn btn-sm btn-secondary mb-6" id="updateClient">Transferir o cliente mais recente</button>';
$string['error_file_open'] = 'Erro ao abrir o ficheiro zip';
$string['client_updated_success'] = 'Cliente atualizado com sucesso';
$string['client_updated_failed'] = 'Falha ao atualizar o cliente';

$string['join'] = 'Aderir';
$string['end'] = 'Fim';
$string['recordings'] = 'Gravações';
$string['recording_date'] = 'Data de gravação';
$string['meeting_date'] = 'Data da reunião';
$string['file_size'] = 'Tamanho do ficheiro (MB)';
$string['play'] = 'Reproduzir';
$string['download'] = 'Baixar';
$string['delete'] = 'Suprimir';
$string['sure_to_delete'] = 'Tem certeza de excluir?';

$string['design_customization'] = 'Personalização de Design';
$string['custom_css_url'] = 'URL CSS personalizado';
$string['custom_css_url_des'] = 'Deve ser https direto CSS url arquivo';
$string['primary_color'] = 'Cor primária';
$string['primary_color_des'] = 'Cor primária para interface';
$string['secondary_color'] = 'Cor secundária';
$string['secondary_color_des'] = 'Cor secundária para interface';
$string['background_color'] = 'Cor de fundo';
$string['background_color_des'] = 'Cor de fundo da interface';
$string['background_image'] = 'Imagem de fundo';
$string['background_image_des'] = 'Deve ter 1920X1080 de tamanho para melhor resultado.';
$string['header_color'] = 'Cor do cabeçalho';
$string['header_color_des'] = 'Cor do cabeçalho da interface';
$string['footer_color'] = 'Cor do rodapé';
$string['footer_color_des'] = 'Cor do rodapé da interface';
$string['left_color'] = 'Cor do lado esquerdo';
$string['left_color_des'] = 'Cor da barra lateral esquerda';
$string['right_color'] = 'Cor do lado direito';
$string['right_color_des'] = 'Cor da barra lateral direita';
$string['column_camera_position'] = 'Posição da câmara da coluna';
$string['column_camera_position_des'] = 'Posição da câmara da coluna. Padrão: left';
$string['column_camera_width'] = 'Largura da câmara da coluna';
$string['column_camera_width_des'] = 'Largura da câmara da coluna';

$string['allow_speech_to_text_translation_features'] = 'Permitir recursos de fala em texto/tradução';
$string['allow_speech_translation'] = 'Permitir tradução';

$string['enable_end_to_end_encryption_features'] = 'Habilitar criptografia de ponta a ponta (E2EE)';
$string['included_e2ee_chat_messages'] = "Ativar criptografia para bate-papo";
$string['included_e2ee_whiteboard'] = "Ativar criptografia para quadro de comunicações";
