<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     mod_plugnmeet
 * @category    string
 * @author     Jibon L. Costa <jibon@mynaparrot.com>
 * @copyright  2022 MynaParrot
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = '选择主题时的自述文件。';
$string['missingidandcmid'] = '缺少 id 和 cmid';
$string['modulename'] = 'plugNmeet 插件';
$string['modulename_help'] = '使用 plugNmeet 模块...';
$string['modulenameplural'] = 'plugNmeets';
$string['newmodulename'] = 'plugNmeet 名称';
$string['newmodulename_help'] = '这是与 plugNmeet 字段关联的帮助工具提示的内容';
$string['newmodulesettings'] = '设置';
$string['nonewmodules'] = '没有 plugNmeet';
$string['pluginadministration'] = 'plugNmeet 管理';
$string['pluginname'] = 'plugNmeet 插件';
$string['pluginname_help'] = '添加此问题类型时的帮助文本。';
$string['pluginnameadding'] = '在添加此问题类型时呈现。';
$string['pluginnameediting'] = '在编辑此问题类型时呈现。';
$string['pluginnamesummary'] = '选择要添加的问题类型时呈现。';
$string['plugnmeet:access'] = '访问内容';
$string['plugnmeet:addinstance'] = '添加新的 plugNmeet 活动';
$string['plugnmeet:edit'] = '编辑 plugNmeet';
$string['plugnmeet:enrol'] = '注册用户';
$string['plugnmeet:manage'] = '管理用户';
$string['plugnmeet:unenrol'] = '取消注册用户';
$string['plugnmeet:upload'] = '上传内容';
$string['plugnmeet:useeditor'] = '编辑内容';
$string['plugnmeet:view'] = '查看 plugNmeet';
$string['privacy:metadata:plugnmeet'] = '为了与远程 plugnmeet 服务器集成，需要与该服务器交换用户数据。';
$string['privacy:metadata:plugnmeet:userid'] = '用户 ID 从 Moodle 发送，以允许您访问远程系统上的数据。';
$string['privacy:metadata:plugnmeet:fullname'] = '您的全名将发送到远程系统，以获得更好的用户体验。';

$string['view'] = '视图';
$string['yes'] = '是的';
$string['no'] = '不';
$string['join'] = '加入';
$string['plugnmeetname'] = 'plugNmeet 插件';
$string['plugnmeetname_help'] = '帮助';
$string['plugnmeet_viewed'] = '已查看 plugNmeet 活动';
$string['joined_session'] = '已加入的会话';

$string['plugnmeetconfig'] = 'plugNmeet 配置';
$string['plugnmeet_server_url'] = 'Plugnmeet 服务器 URL';
$string['plugnmeet_server_url_des'] = '输入 plugNmeet 服务器 URL';
$string['plugnmeet_api_key'] = 'plugnmeet API 密钥';
$string['plugnmeet_api_key_des'] = '输入 plugnmeet API 密钥';
$string['plugnmeet_secret'] = 'plugnmeet 密钥';
$string['plugnmeet_secret_des'] = '输入 plugnmeet Secret';
$string['livekit_server_url'] = 'Livekit 服务器 url';
$string['livekit_server_url_des'] = '输入 Livekit 服务器 url';
$string['custom_logo'] = '自定义 logo';
$string['custom_logo_des'] = '会议室定制标志';

$string['plugnmeetoptions'] = 'plugNmeet 选项';
$string['enable_dynacast'] = '启用 dynacast';
$string['enable_dynacast_des'] = '启用 dynacast';
$string['enable_simulcast'] = '启用联播';
$string['enable_simulcast_des'] = '启用联播';
$string['stop_mic_track_on_mute'] = '静音时停止麦克风轨道';
$string['stop_mic_track_on_mute_des'] = '静音时停止麦克风轨道';
$string['video_codec'] = '视频编解码器';
$string['video_codec_des'] = '视频编解码器';
$string['default_webcam_resolution'] = '默认网络摄像头分辨率';
$string['default_webcam_resolution_des'] = '默认网络摄像头分辨率';
$string['default_screen_share_resolution'] = '默认屏幕共享分辨率';
$string['default_screen_share_resolution_des'] = '默认屏幕共享分辨率';
$string['default_audio_preset'] = '音频预设';
$string['default_audio_preset_des'] = '麦克风的音频预设';
$string['copyright_display'] = '启用版权显示';
$string['copyright_display_des'] = '如果启用，则它将显示以下文本';
$string['copyright_text'] = '版权文本';
$string['copyright_text_des'] = '如果服务器配置允许覆盖，则可以设置此文本';

$string['roomtitle'] = '房间标题';
$string['welcome_message'] = '欢迎辞';
$string['max_participants'] = '最大参与者数（0 = 无限制）';

$string['room_features'] = '客房特色';
$string['roomfeatures'] = '客房特色';
$string['allow_webcams'] = '允许网络摄像头';
$string['mute_on_start'] = '启动时静音';
$string['allow_screen_share'] = '允许屏幕共享';
$string['allow_rtmp'] = '允许 RTMP';
$string['allow_view_other_webcams'] = '允许查看其他网络摄像头';
$string['allow_view_other_users_list'] = '允许查看其他用户';
$string['admin_only_webcams'] = '仅限管理员的网络摄像机';
$string['allow_polls'] = '允许轮询';
$string['room_duration'] = '房间持续时间（以分钟为单位，0 = 无限制）';
$string['moderator_join_first'] = '版主先加入';
$string['moderator_join_first_error'] = '会议尚未开始，请稍后再来';
$string['enable_analytics'] = '启用分析';
$string['allow_virtual_bg'] = '允许虚拟背景';
$string['allow_raise_hand'] = '允许举手';
$string['auto_gen_user_id'] = '自动生成 User ID';

$string['other_features'] = '其他功能';

$string['recordingfeatures'] = '录制功能';
$string['allow_recording'] = '允许录制';
$string['allow_cloud_recording'] = '允许云录制';
$string['enable_auto_cloud_recording'] = '启用自动启动云录制';
$string['allow_local_recording'] = '允许本地录制';
$string['is_allow_view_recording'] = '允许学生查看录制内容';
$string['is_allow_download_recording'] = '允许学生下载录音';

$string['chatfeatures'] = '聊天功能';
$string['allow_chat'] = '允许聊天';
$string['allow_file_upload'] = '允许文件上传';

$string['shared_note_pad_features'] = '共享记事本功能';
$string['allow_shared_notepad'] = '允许共享记事本';

$string['whiteboard_features'] = '白板功能';
$string['allow_whiteboard'] = '允许白板';

$string['external_media_player_features'] = '外部媒体播放器功能';
$string['allowed_external_media_player'] = '允许外部媒体播放器';

$string['waiting_room_features'] = '等候室功能';
$string['activate_waiting_room'] = '激活等候室';
$string['waiting_room_msg'] = '等候室消息';

$string['breakout_room_features'] = '分组会议室功能';
$string['allow_breakout_rooms'] = '允许分组会议';
$string['allowed_number_rooms'] = '房间数';

$string['display_external_link_features'] = '显示外部链接功能';
$string['allow_display_external_link_features'] = '允许显示外部链接功能';
$string['allow_ingress_features'] = '允许创建 Ingress';

$string['defaultlock'] = '默认锁定设置';
$string['lock_microphone'] = '锁定麦克风';
$string['lock_webcam'] = '锁定网络摄像头';
$string['lock_screen_sharing'] = '锁屏共享';
$string['lock_whiteboard'] = '锁定白板';
$string['lock_shared_notepad'] = '锁定共享记事本';
$string['lock_chat'] = '锁定聊天';
$string['lock_chat_send_message'] = '锁定发送消息';
$string['lock_chat_file_share'] = '锁定文件共享';
$string['lock_private_chat'] = '锁定私人聊天';

$string['available'] = '可从';
$string['deadline'] = '限期';

$string['extraoption'] = '额外选项';

$string['client_load'] = '客户端负载来自';
$string['client_load_des'] = '默认值：远程';
$string['remote'] = '远程';
$string['local'] = '当地';

$string['client_download_url'] = '本地客户端下载 URL';
$string['client_download_url_des'] = '本地客户端下载 URL。默认 github';
$string['update_client_code'] = '<button class="btn btn-sm btn-secondary mb-6" id="updateClient">下载最新客户端</button>';
$string['error_file_open'] = 'zip 文件打开时出错';
$string['client_updated_success'] = '客户端更新成功';
$string['client_updated_failed'] = '无法更新客户端';

$string['join'] = '加入';
$string['end'] = '结束';
$string['recordings'] = '录音';
$string['recording_date'] = '录制日期';
$string['meeting_date'] = '会议日期';
$string['file_size'] = '文件大小 （MB）';
$string['play'] = '玩';
$string['download'] = '下载';
$string['delete'] = '删除';
$string['sure_to_delete'] = '您确定要删除吗？';

$string['design_customization'] = '设计定制';
$string['custom_css_url'] = '自定义 CSS URL';
$string['custom_css_url_des'] = '应为 https 直接 CSS 文件 url';
$string['primary_color'] = '原色';
$string['primary_color_des'] = '界面的 Primary Color';
$string['secondary_color'] = '辅助颜色';
$string['secondary_color_des'] = '界面的 Secondary Color';
$string['background_color'] = '背景颜色';
$string['background_color_des'] = '界面背景颜色';
$string['background_image'] = '背景图片';
$string['background_image_des'] = '大小应为 1920X1080 以获得最佳效果。';
$string['header_color'] = '标题颜色';
$string['header_color_des'] = '接口标题颜色';
$string['footer_color'] = '页脚颜色';
$string['footer_color_des'] = '界面页脚颜色';
$string['left_color'] = '左侧颜色';
$string['left_color_des'] = '左侧栏颜色';
$string['right_color'] = '右侧颜色';
$string['right_color_des'] = '右侧栏颜色';
$string['column_camera_position'] = '列相机位置';
$string['column_camera_position_des'] = '列摄像机位置。默认值：left';
$string['column_camera_width'] = '柱式摄像机宽度';
$string['column_camera_width_des'] = '柱式摄像机宽度';

$string['allow_speech_to_text_translation_features'] = '允许语音到文本/翻译功能';
$string['allow_speech_translation'] = '允许翻译';

$string['enable_end_to_end_encryption_features'] = '启用端到端加密 （E2EE）';
$string['included_e2ee_chat_messages'] = "启用聊天加密";
$string['included_e2ee_whiteboard'] = "为白板启用加密";
