<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     mod_plugnmeet
 * @category    string
 * @author     Jibon L. Costa <jibon@mynaparrot.com>
 * @copyright  2022 MynaParrot
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['choosereadme'] = 'اقرأني عند تحديد السمة.';
$string['missingidandcmid'] = 'معرف مفقود و cmid';
$string['modulename'] = 'بلجونميت';
$string['modulename_help'] = 'استخدم وحدة plugNmeet من أجل ...';
$string['modulenameplural'] = 'بلج نيميتس';
$string['newmodulename'] = 'اسم بلكونميت';
$string['newmodulename_help'] = 'هذا هو محتوى تلميح أداة المساعدة المرتبط بحقل plugNmeet';
$string['newmodulesettings'] = 'اعدادات';
$string['nonewmodules'] = 'لا يوجد قابس Nmeet';
$string['pluginadministration'] = 'إدارة بلج نيميت';
$string['pluginname'] = 'بلجونميت';
$string['pluginname_help'] = 'نص التعليمات عند إضافة نوع السؤال هذا.';
$string['pluginnameadding'] = 'يتم تقديمه عند إضافة نوع السؤال هذا.';
$string['pluginnameediting'] = 'يتم تقديمه عند تحرير نوع السؤال هذا.';
$string['pluginnamesummary'] = 'يتم تقديمه عند اختيار نوع السؤال المراد إضافته.';
$string['plugnmeet:access'] = 'الوصول إلى المحتوى';
$string['plugnmeet:addinstance'] = 'إضافة مكون إضافي جديدنشاط Nmeet';
$string['plugnmeet:edit'] = 'تحرير البرنامج المساعدNmeet';
$string['plugnmeet:enrol'] = 'تسجيل المستخدمين';
$string['plugnmeet:manage'] = 'إدارة المستخدمين';
$string['plugnmeet:unenrol'] = 'المستخدمون غير المسجلين';
$string['plugnmeet:upload'] = 'تحميل المحتوى';
$string['plugnmeet:useeditor'] = 'تحرير المحتوى';
$string['plugnmeet:view'] = 'عرض البرنامج المساعدNmeet';
$string['privacy:metadata:plugnmeet'] = 'من أجل التكامل مع خادم plugnmeet بعيد ، يجب تبادل بيانات المستخدم مع هذا الخادم.';
$string['privacy:metadata:plugnmeet:userid'] = 'يتم إرسال معرف المستخدم من Moodle للسماح لك بالوصول إلى بياناتك على النظام البعيد.';
$string['privacy:metadata:plugnmeet:fullname'] = 'يتم إرسال اسمك الكامل إلى النظام البعيد للسماح بتجربة مستخدم أفضل.';

$string['view'] = 'منظر';
$string['yes'] = 'نعم';
$string['no'] = 'لا';
$string['join'] = 'ينضم';
$string['plugnmeetname'] = 'بلجونميت';
$string['plugnmeetname_help'] = 'تعليمات';
$string['plugnmeet_viewed'] = 'تم عرض نشاط plugNmeet';
$string['joined_session'] = 'جلسة مشتركة';

$string['plugnmeetconfig'] = 'تكوين plugNmeet';
$string['plugnmeet_server_url'] = 'رابط خادم PlugnMeet';
$string['plugnmeet_server_url_des'] = 'أدخل عنوان URL لخادم plugNmeet';
$string['plugnmeet_api_key'] = 'مفتاح واجهة برمجة تطبيقات plugnmeet';
$string['plugnmeet_api_key_des'] = 'أدخل مفتاح واجهة برمجة تطبيقات plugnmeet';
$string['plugnmeet_secret'] = 'بلوجنميت سيكريت';
$string['plugnmeet_secret_des'] = 'أدخل البرنامج المساعد ميت سر';
$string['livekit_server_url'] = 'رابط خادم Livekit';
$string['livekit_server_url_des'] = 'أدخل عنوان url لخادم Livekit';
$string['custom_logo'] = 'شعار مخصص';
$string['custom_logo_des'] = 'شعار مخصص لغرفة الاجتماعات';

$string['plugnmeetoptions'] = 'خيارات بلكونميت';
$string['enable_dynacast'] = 'تمكين ديناكاست';
$string['enable_dynacast_des'] = 'تمكين ديناكاست';
$string['enable_simulcast'] = 'تمكين البث المتزامن';
$string['enable_simulcast_des'] = 'تمكين البث المتزامن';
$string['stop_mic_track_on_mute'] = 'إيقاف مسار الميكروفون عند كتم الصوت';
$string['stop_mic_track_on_mute_des'] = 'إيقاف مسار الميكروفون عند كتم الصوت';
$string['video_codec'] = 'برنامج ترميز الفيديو';
$string['video_codec_des'] = 'برنامج ترميز الفيديو';
$string['default_webcam_resolution'] = 'دقة كاميرا الويب الافتراضية';
$string['default_webcam_resolution_des'] = 'دقة كاميرا الويب الافتراضية';
$string['default_screen_share_resolution'] = 'دقة مشاركة الشاشة الافتراضية';
$string['default_screen_share_resolution_des'] = 'دقة مشاركة الشاشة الافتراضية';
$string['default_audio_preset'] = 'الإعداد المسبق للصوت';
$string['default_audio_preset_des'] = 'إعداد مسبق للصوت للميكروفون';
$string['copyright_display'] = 'تمكين عرض حقوق الطبع والنشر';
$string['copyright_display_des'] = 'إذا تم تمكينه ، عرض النص أدناه';
$string['copyright_text'] = 'نص حقوق الطبع والنشر';
$string['copyright_text_des'] = 'يمكن تعيين هذا النص إذا كان تكوين الخادم يسمح بالتجاوز';

$string['roomtitle'] = 'عنوان الغرفة';
$string['welcome_message'] = 'رسالة ترحيب';
$string['max_participants'] = 'الحد الأقصى للمشاركين (0 = غير محدود)';

$string['room_features'] = 'ميزات الغرفة';
$string['roomfeatures'] = 'ميزات الغرفة';
$string['allow_webcams'] = 'السماح بكاميرات الويب';
$string['mute_on_start'] = 'كتم الصوت عند البدء';
$string['allow_screen_share'] = 'السماح بمشاركة الشاشة';
$string['allow_rtmp'] = 'السماح ب RTMP';
$string['allow_view_other_webcams'] = 'السماح بعرض كاميرات الويب الأخرى';
$string['allow_view_other_users_list'] = 'السماح بعرض المستخدمين الآخرين';
$string['admin_only_webcams'] = 'كاميرات الويب للمشرف فقط';
$string['allow_polls'] = 'السماح باستطلاعات الرأي';
$string['room_duration'] = 'مدة الغرفة (بالدقائق، 0 = غير محدود)';
$string['moderator_join_first'] = 'انضم المنسق أولا';
$string['moderator_join_first_error'] = 'لم يبدأ الاجتماع بعد ، يرجى العودة لاحقا';
$string['enable_analytics'] = 'تمكين التحليلات';
$string['allow_virtual_bg'] = 'السماح بالخلفية الافتراضية';
$string['allow_raise_hand'] = 'السماح برفع اليد';
$string['auto_gen_user_id'] = 'إنشاء معرف المستخدم تلقائيا';

$string['other_features'] = 'الميزات المتقدمة';

$string['recordingfeatures'] = 'ميزات التسجيل';
$string['allow_recording'] = 'السماح بالتسجيل';
$string['allow_cloud_recording'] = 'السماح بالتسجيل السحابي';
$string['enable_auto_cloud_recording'] = 'تمكين التسجيل السحابي لبدء التشغيل التلقائي';
$string['allow_local_recording'] = 'السماح بالتسجيل المحلي';
$string['is_allow_view_recording'] = 'السماح للطلاب بمشاهدة التسجيل';
$string['is_allow_download_recording'] = 'السماح للطلاب بتنزيل التسجيل';

$string['chatfeatures'] = 'ميزات الدردشة';
$string['allow_chat'] = 'السماح بالدردشة';
$string['allow_file_upload'] = 'السماح بتحميل الملفات';

$string['shared_note_pad_features'] = 'ميزات المفكرة المشتركة';
$string['allow_shared_notepad'] = 'السماح بالمفكرة المشتركة';

$string['whiteboard_features'] = 'ميزات السبورة البيضاء';
$string['allow_whiteboard'] = 'السماح بلوح المعلومات';

$string['external_media_player_features'] = 'ميزات مشغل الوسائط الخارجية';
$string['allowed_external_media_player'] = 'السماح بمشغل وسائط خارجي';

$string['waiting_room_features'] = 'ميزات غرفة الانتظار';
$string['activate_waiting_room'] = 'تفعيل غرفة الانتظار';
$string['waiting_room_msg'] = 'رسالة غرفة الانتظار';

$string['breakout_room_features'] = 'ميزات غرفة الاستراحة';
$string['allow_breakout_rooms'] = 'السماح بالغرف الفرعية';
$string['allowed_number_rooms'] = 'عدد الغرف';

$string['display_external_link_features'] = 'عرض ميزات الارتباط الخارجي';
$string['allow_display_external_link_features'] = 'السماح بعرض ميزات الارتباط الخارجي';
$string['allow_ingress_features'] = 'السماح بإنشاء دخول';

$string['defaultlock'] = 'إعدادات القفل الافتراضية';
$string['lock_microphone'] = 'قفل الميكروفون';
$string['lock_webcam'] = 'قفل كاميرا الويب';
$string['lock_screen_sharing'] = 'مشاركة شاشة القفل';
$string['lock_whiteboard'] = 'قفل السبورة';
$string['lock_shared_notepad'] = 'قفل المفكرة المشتركة';
$string['lock_chat'] = 'قفل الدردشة';
$string['lock_chat_send_message'] = 'قفل إرسال رسالة';
$string['lock_chat_file_share'] = 'قفل مشاركة الملف';
$string['lock_private_chat'] = 'قفل الدردشة الخاصة';

$string['available'] = 'متاح من';
$string['deadline'] = 'موعد نهائي';

$string['extraoption'] = 'خيارات إضافية';

$string['client_load'] = 'تحميل العميل من';
$string['client_load_des'] = 'الافتراضي: بعيد';
$string['remote'] = 'بعيد';
$string['local'] = 'محلي';

$string['client_download_url'] = 'رابط تنزيل العميل المحلي';
$string['client_download_url_des'] = 'عنوان url لتنزيل العميل المحلي. جيثب الافتراضي';
$string['update_client_code'] = '<button class="btn btn-sm btn-secondary mb-6" id="updateClient">تحميل أحدث عميل</button>';
$string['error_file_open'] = 'خطأ في فتح ملف مضغوط';
$string['client_updated_success'] = 'تم تحديث العميل بنجاح';
$string['client_updated_failed'] = 'فشل تحديث العميل';

$string['join'] = 'ينضم';
$string['end'] = 'انتهاء';
$string['recordings'] = 'التسجيلات';
$string['recording_date'] = 'تاريخ التسجيل';
$string['meeting_date'] = 'تاريخ الاجتماع';
$string['file_size'] = 'حجم الملف (MB)';
$string['play'] = 'لعب';
$string['download'] = 'تحميل';
$string['delete'] = 'حذف';
$string['sure_to_delete'] = 'هل أنت متأكد من حذف؟';

$string['design_customization'] = 'تخصيص التصميم';
$string['custom_css_url'] = 'عنوان URL المخصص ل CSS';
$string['custom_css_url_des'] = 'يجب أن يكون https رابط ملف CSS المباشر';
$string['primary_color'] = 'اللون الأساسي';
$string['primary_color_des'] = 'اللون الأساسي للواجهة';
$string['secondary_color'] = 'اللون الثانوي';
$string['secondary_color_des'] = 'لون ثانوي للواجهة';
$string['background_color'] = 'لون الخلفية';
$string['background_color_des'] = 'لون خلفية الواجهة';
$string['background_image'] = 'صورة الخلفية';
$string['background_image_des'] = 'يجب أن يكون حجم 1920 × 1080 للحصول على أفضل نتيجة.';
$string['header_color'] = 'لون الرأس';
$string['header_color_des'] = 'لون رأس الواجهة';
$string['footer_color'] = 'لون التذييل';
$string['footer_color_des'] = 'لون تذييل الواجهة';
$string['left_color'] = 'لون الجانب الأيسر';
$string['left_color_des'] = 'لون شريط الجانب الأيسر';
$string['side_panel_bg_color'] = 'لون خلفية اللوحة الجانبية';
$string['side_panel_bg_color_des'] = 'لون خلفية اللوحة على الجانب الأيمن';
$string['column_camera_position'] = 'موضع الكاميرا العمودية';
$string['column_camera_position_des'] = 'موضع كاميرا العمود. الافتراضي: يسار';
$string['column_camera_width'] = 'عرض كاميرا العمود';
$string['column_camera_width_des'] = 'عرض كاميرا العمود';

$string['allow_speech_to_text_translation_features'] = 'السماح بميزات تحويل الكلام إلى نص/ترجمة';
$string['allow_speech_translation'] = 'السماح بالترجمة';

$string['enable_end_to_end_encryption_features'] = 'تمكين التشفير من طرف إلى طرف (E2EE)';
$string['enabled_self_insert_encryption_key'] = 'تفعيل مفتاح E2EE اليدوي';
$string['included_e2ee_chat_messages'] = "تمكين التشفير للدردشة";
$string['included_e2ee_whiteboard'] = "تمكين تشفير لوح المعلومات";

$string['insights_features'] = 'رؤى الذكاء الاصطناعي';
$string['insights_features_is_allow'] = 'تمكين ميزات الرؤية';
$string['insights_transcription_features_is_allow'] = 'السماح بالنسخ';
$string['insights_transcription_features_is_allow_translation'] = 'السماح بترجمة النسخ';
$string['insights_transcription_features_is_allow_speech_synthesis'] = 'السماح بتوليف الكلام';
$string['insights_chat_translation_features_is_allow'] = 'السماح بترجمة الدردشة';
$string['insights_ai_features_is_allow'] = 'السماح بميزات الذكاء الاصطناعي';
$string['insights_ai_text_chat_features_is_allow'] = 'السماح بالمحادثة النصية الذكاء الاصطناعي';
$string['insights_ai_meeting_summarization_features_is_allow'] = 'السماح بتلخيص اجتماعات الذكاء الاصطناعي';
