# Manual Testing Guide: Backup & Restore

This guide provides step-by-step instructions for manually testing the Navigatr plugin's backup and restore functionality.

## Overview

The plugin implements Moodle's Backup/Restore API to ensure badge mappings and audit records are properly backed up and restored when courses are backed up or imported.

## Prerequisites

- ✅ Moodle 4.1+ or 5.x installed
- ✅ Navigatr plugin installed and configured
- ✅ At least one course with a badge mapping configured
- ✅ Admin or teacher access to backup/restore courses

---

## Test Scenario 1: Basic Badge Mapping Backup & Restore

### Objective
Verify that course badge mappings are backed up and restored correctly.

### Steps

#### 1. Create Test Course with Badge Mapping

1. Log in as admin
2. Create a new course (or use existing)
   - Go to **Site Administration → Courses → Add a new course**
   - Name: "Test Course - Backup Restore"
   - Save changes
3. Configure badge mapping
   - Go to course page
   - Click **Course Settings → Navigatr Badge**
   - Select a provider
   - Select a badge
   - Save mapping
4. **Verify**: Badge mapping appears in "Current Badge Mapping" section

#### 2. Backup the Course

1. Go to **Course Administration → Backup**
2. **Initial settings:**
   - ✅ Include activities and resources
   - ✅ Include blocks
   - ✅ Include filters
   - Choose user data option (test both scenarios below)
3. Click **Next**
4. **Schema settings:** Keep defaults, click **Next**
5. **Confirmation:** Review, click **Perform backup**
6. **Download** the backup file (.mbz)
7. **Verify**: Backup completes successfully

#### 3. Delete Original Mapping (Optional - to test restore)

1. Go to course → **Course Settings → Navigatr Badge**
2. Click **"Remove Badge"**
3. **Verify**: No mapping exists anymore

#### 4. Restore to New Course

1. Go to **Site Administration → Courses → Restore course**
2. **Upload** the backup file
3. Click **Restore**
4. **Select restore target:**
   - Option A: **Restore as a new course** (recommended)
   - Option B: **Restore into existing course** (test overwrite protection)
5. **Settings:** Keep defaults, click **Next**
6. **Schema:** Keep defaults, click **Next**
7. **Review:** Click **Perform restore**
8. **Verify**: Restore completes successfully

#### 5. Verify Badge Mapping Restored

1. Go to restored course
2. Click **Course Settings → Navigatr Badge**
3. **Verify:**
   - ✅ Badge mapping exists
   - ✅ Correct provider selected
   - ✅ Correct badge selected
   - ✅ Badge name and image display correctly

---

## Test Scenario 2: Backup WITH User Data (Audit Records)

### Objective
Verify that audit records are included when user data is backed up.

### Prerequisites
- Course with badge mapping
- At least one completed course with badge issued (audit record exists)

### Steps

#### 1. Verify Audit Records Exist

```sql
-- In database
SELECT * FROM mdl_local_navigatr_audit WHERE courseid = [your_course_id];
```

Or check logs to confirm badge was issued.

#### 2. Backup Course WITH User Data

1. Go to **Course Administration → Backup**
2. **Initial settings:**
   - ✅ **Include user data** ← IMPORTANT!
3. Complete backup as in Scenario 1

#### 3. Restore to New Course WITH User Data

1. Restore the backup
2. **Settings:**
   - ✅ **Include user data** ← IMPORTANT!
3. Complete restore

#### 4. Verify Audit Records Restored

```sql
-- Check audit records in restored course
SELECT * FROM mdl_local_navigatr_audit WHERE courseid = [new_course_id];
```

**Verify:**
- ✅ Audit records exist in new course
- ✅ User IDs are correctly mapped
- ✅ Badge IDs preserved
- ✅ Timestamps preserved
- ✅ Status and response data intact

---

## Test Scenario 3: Backup WITHOUT User Data (No Audit Records)

### Objective
Verify that audit records are NOT included when user data is excluded.

### Steps

#### 1. Backup Course WITHOUT User Data

1. Go to **Course Administration → Backup**
2. **Initial settings:**
   - ❌ **Uncheck "Include user data"** ← IMPORTANT!
3. Complete backup

#### 2. Restore

1. Restore the backup
2. **Settings:**
   - ❌ User data not included
3. Complete restore

#### 3. Verify Audit Records NOT Restored

```sql
-- Check audit records (should be empty)
SELECT * FROM mdl_local_navigatr_audit WHERE courseid = [new_course_id];
```

**Verify:**
- ✅ Badge mapping DOES exist (course configuration)
- ✅ Audit records DO NOT exist (user data excluded)

---

## Test Scenario 4: Existing Mapping Protection

### Objective
Verify that existing badge mappings are NOT overwritten during restore.

### Steps

#### 1. Create Course A with Badge 1

1. Create "Course A"
2. Map to **Badge 1** (e.g., "JavaScript Fundamentals")
3. Backup Course A

#### 2. Create Course B with Badge 2

1. Create "Course B"
2. Map to **Badge 2** (e.g., "Python Basics")
3. **Verify**: Badge 2 mapping exists

#### 3. Restore Course A Backup to Course B

1. Restore Course A backup
2. **Target**: Restore into **Course B** (existing course)
3. Complete restore

#### 4. Verify Original Mapping Preserved

1. Go to Course B → **Navigatr Badge**
2. **Verify:**
   - ✅ **Badge 2** still configured (NOT replaced by Badge 1)
   - ✅ Existing mapping protected from overwrite

---

## Test Scenario 5: Cross-Site Restore

### Objective
Verify restore works across different Moodle installations.

### Steps

#### 1. Backup from Site A

1. On **Site A**: Create course with badge mapping
2. Backup the course
3. Download .mbz file

#### 2. Restore to Site B

1. On **Site B**: Upload backup file
2. Restore as new course
3. **Verify:**
   - ✅ Badge mapping restored
   - ✅ Provider ID and Badge ID preserved
   - ⚠️ Note: User audit records may not restore if users don't exist on Site B

---

## Expected Results Summary

| Test Scenario | Badge Mapping | Audit Records | Status |
|--------------|---------------|---------------|---------|
| Basic backup/restore | ✅ Restored | N/A | Should pass |
| WITH user data | ✅ Restored | ✅ Restored | Should pass |
| WITHOUT user data | ✅ Restored | ❌ Not restored | Should pass |
| Existing mapping | ✅ Protected | N/A | Should pass |
| Cross-site restore | ✅ Restored | ⚠️ Partial* | Should pass |

*Audit records only restore if users exist in target site

---

## Troubleshooting

### Issue: Mapping Not Restored

**Possible causes:**
- Existing mapping already present (by design, won't overwrite)
- Backup didn't include course structure
- Plugin not properly installed

**Solution:**
1. Check if mapping exists in target course
2. Verify backup included "Activities and resources"
3. Re-install plugin if needed

### Issue: Audit Records Missing

**Possible causes:**
- User data not included in backup
- User data not included in restore
- Users don't exist in target system

**Solution:**
1. Ensure "Include user data" checked during backup
2. Ensure "Include user data" checked during restore
3. Check user mapping in restore logs

### Issue: Restore Fails

**Possible causes:**
- Database errors
- Permissions issues
- Corrupted backup file

**Solution:**
1. Check Moodle error logs
2. Verify database permissions
3. Try creating fresh backup

---

## Debug Logging

To see detailed backup/restore logs:

### Enable Debugging

```php
// In config.php
$CFG->debug = DEBUG_DEVELOPER;
$CFG->debugdisplay = 1;
```

### Look for Navigatr Debug Messages

During backup/restore, you should see:

```
local_navigatr: Starting backup structure definition (userinfo: included)
local_navigatr: Badge mappings structure defined for backup
local_navigatr: Audit records structure defined for backup (user data included)
local_navigatr: Backup structure definition complete

local_navigatr: Starting restore structure definition
local_navigatr: Badge mappings path defined for restore
local_navigatr: Audit records path defined for restore (user data included)
local_navigatr: Processing mapping restore (old courseid: X, badge_id: Y)
local_navigatr: Mapped to new courseid: Z
local_navigatr: Mapping restored successfully (new id: N)
```

---

## Validation Checklist

After completing manual tests, verify:

- ✅ Badge mappings backup correctly
- ✅ Badge mappings restore correctly
- ✅ Audit records backup when user data included
- ✅ Audit records restore when user data included
- ✅ Audit records excluded when user data not included
- ✅ Existing mappings NOT overwritten
- ✅ No errors in Moodle logs
- ✅ Cross-site restore works (with caveats)

---

## Reporting Issues

If you encounter issues during manual testing:

1. **Enable debug logging** (see above)
2. **Document the steps** that caused the issue
3. **Capture error messages** from logs
4. **Note the test scenario** that failed
5. **Check database state** before and after
6. **Report with details** for investigation

---

## Success Criteria

Manual testing is considered successful when:

1. ✅ All 5 test scenarios pass
2. ✅ No errors in Moodle logs
3. ✅ Data integrity maintained
4. ✅ Expected behavior matches implementation
5. ✅ Edge cases handled gracefully

---

## Next Steps

After successful manual testing:

1. Document any findings
2. Update test cases if needed
3. Mark implementation as validated
4. Consider implementing automated test fixes
5. Proceed with deployment

---

## References

- [Moodle Backup API](https://moodledev.io/docs/5.0/apis/subsystems/backup)
- [Moodle Restore API](https://moodledev.io/docs/5.0/apis/subsystems/backup/restore)
- Navigatr plugin documentation: `README.md`
- Implementation details: `docs/backup-restore-implementation.md`

