# Moodle Code Checker Setup and Usage

This document provides instructions for setting up and using the Moodle code checker (`moodle-local_codechecker`) to validate code standards compliance for the `local_navigatr` plugin.

## Prerequisites

- PHP 7.4 or higher
- Composer installed
- Git access to clone the codechecker repository

## Installation

### 1. Clone the Code Checker Repository

```bash
git clone https://github.com/moodlehq/moodle-local_codechecker.git /Users/omufeed/Documents/Projects/Navigatr/moodle-local_codechecker
```

### 2. Install Dependencies

```bash
cd /Users/omufeed/Documents/Projects/Navigatr/moodle-local_codechecker
composer install
```

### 3. Set Execute Permissions

```bash
chmod +x /Users/omufeed/Documents/Projects/Navigatr/moodle-local_codechecker/vendor/bin/phpcs
chmod +x /Users/omufeed/Documents/Projects/Navigatr/moodle-local_codechecker/vendor/bin/phpcbf
```

### 4. Install Moodle Coding Standard

```bash
php /Users/omufeed/Documents/Projects/Navigatr/moodle-local_codechecker/vendor/bin/phpcs --config-set installed_paths /Users/omufeed/Documents/Projects/Navigatr/moodle-local_codechecker/vendor/moodlehq/moodle-cs
```

## Usage

### Run Code Standards Check

To check the `local_navigatr` plugin for code standards violations:

```bash
/Users/omufeed/Documents/Projects/Navigatr/moodle-local_codechecker/vendor/bin/phpcs --standard=Moodle /Users/omufeed/Documents/Projects/Navigatr/navigatr-moodle-plugin
```

**Note**: If you encounter errors with the Moodle standard, you can use PSR12 as an alternative:

```bash
/Users/omufeed/Documents/Projects/Navigatr/moodle-local_codechecker/vendor/bin/phpcs --standard=PSR12 /Users/omufeed/Documents/Projects/Navigatr/navigatr-moodle-plugin
```

### Auto-fix Code Standards Issues

To automatically fix code standards violations that can be auto-corrected:

```bash
/Users/omufeed/Documents/Projects/Navigatr/moodle-local_codechecker/vendor/bin/phpcbf --standard=Moodle /Users/omufeed/Documents/Projects/Navigatr/navigatr-moodle-plugin
```

**Alternative with PSR12** (if Moodle standard has issues):

```bash
/Users/omufeed/Documents/Projects/Navigatr/moodle-local_codechecker/vendor/bin/phpcbf --standard=PSR12 /Users/omufeed/Documents/Projects/Navigatr/navigatr-moodle-plugin
```

### Check Specific Files

To check specific files or directories:

```bash
/Users/omufeed/Documents/Projects/Navigatr/moodle-local_codechecker/vendor/bin/phpcs --standard=Moodle /path/to/specific/file.php
```

## Understanding the Results

### Before Auto-fix (Initial Scan - October 2025)

- **Total Violations**: 1080 errors + 57 warnings = **1137 total**
- **Auto-fixable**: 837 violations
- **Manual fixes required**: 300 violations

### After Auto-fix (Current Status)

- **Remaining Violations**: 244 errors + 56 warnings = **300 total**
- **Fixed**: **837 violations automatically** ✅
- **Improvement**: 78% reduction in violations

### High-Impact Files Requiring Attention (Current)

- `classes/local/api_client.php` (6 errors, 1 warning)
- `classes/local/password_manager.php` (7 errors, 1 warning)
- `classes/privacy/provider.php` (8 errors, 2 warnings)
- `classes/task/issue_badge_task.php` (4 errors, 1 warning)
- `tests/backup_restore_test.php` (11 errors, 9 warnings)
- `tests/observer_test.php` (18 errors, 1 warning)

### Common Issues Remaining

1. **Naming Conventions**: Class names not in PascalCase (e.g., `api_client` → `ApiClient`)
2. **Method Names**: Methods not in camelCase (e.g., `get_base_url` → `getBaseUrl`)
3. **File Structure**: Side effects mixed with class definitions
4. **Line Length**: Some lines exceed 120 characters

## Common Issues and Solutions

### 1. Permission Denied Error

```bash
zsh: permission denied: /Users/omufeed/Documents/Projects/Navigatr/moodle-local_codechecker
```

**Solution**: Set execute permissions as shown in step 3 above.

### 2. Missing Coding Standard

```text
ERROR: the "moodle" coding standard is not installed
```

**Solution**: Install the Moodle coding standard as shown in step 4 above.

### 3. Moodle Standard Errors

```text
ERROR: Referenced sniff "PHPCompatibility" does not exist
```

**Solution**: Use PSR12 standard instead, which is more stable:

```bash
/Users/omufeed/Documents/Projects/Navigatr/moodle-local_codechecker/vendor/bin/phpcs --standard=PSR12 /Users/omufeed/Documents/Projects/Navigatr/navigatr-moodle-plugin
```

### 4. Path Issues

Make sure to use absolute paths to avoid path resolution issues.

## Integration with Development Workflow

### Pre-commit Hook (Optional)

You can set up a pre-commit hook to automatically run code standards checks:

```bash
# Create pre-commit hook
cat > .git/hooks/pre-commit << 'EOF'
#!/bin/bash
/Users/omufeed/Documents/Projects/Navigatr/moodle-local_codechecker/vendor/bin/phpcs --standard=Moodle --report=summary .
EOF

chmod +x .git/hooks/pre-commit
```

### Continuous Integration

For CI/CD pipelines, use the same commands with appropriate exit codes:

```bash
# Exit with error code if violations found
/Users/omufeed/Documents/Projects/Navigatr/moodle-local_codechecker/vendor/bin/phpcs --standard=Moodle --report=summary /Users/omufeed/Documents/Projects/Navigatr/navigatr-moodle-plugin
```

## Best Practices

1. **Run Before Committing**: Always run the code checker before committing changes
2. **Auto-fix First**: Use `phpcbf` to fix auto-correctable issues first
3. **Manual Review**: Review and fix remaining issues manually
4. **Incremental Fixes**: Fix issues file by file to avoid overwhelming changes
5. **Document Exceptions**: Document any necessary exceptions to coding standards

## Troubleshooting

### Check Installation

```bash
/Users/omufeed/Documents/Projects/Navigatr/moodle-local_codechecker/vendor/bin/phpcs --config-show
```

### List Available Standards

```bash
/Users/omufeed/Documents/Projects/Navigatr/moodle-local_codechecker/vendor/bin/phpcs -i
```

### Verbose Output

```bash
/Users/omufeed/Documents/Projects/Navigatr/moodle-local_codechecker/vendor/bin/phpcs --standard=Moodle --report=full /Users/omufeed/Documents/Projects/Navigatr/navigatr-moodle-plugin
```

## References

- [Moodle Code Checker Repository](https://github.com/moodlehq/moodle-local_codechecker)
- [Moodle Coding Standards](https://docs.moodle.org/dev/Coding_style)
- [PHP_CodeSniffer Documentation](https://github.com/squizlabs/PHP_CodeSniffer)

---

**Last Updated**: October 29, 2025  
**Version**: 1.1  
**Maintainer**: Navigatr Development Team
