# Moodle Cron Setup for Docker Container

## Current Status
✅ **Cron is now working** - The cron service is installed and running with a Moodle cron job configured.

## Persistence Issues
❌ **Won't persist across container restarts** - The current setup will be lost when the container restarts.

## Solutions for Persistent Cron

### Option 1: Manual Setup After Each Restart (Current)
Run this command after each container restart:
```bash
docker exec moodle-docker-webserver-1 /usr/local/bin/setup-moodle-cron.sh
```

### Option 2: Docker Compose Override (Recommended)
Create a `docker-compose.override.yml` file in your Docker Compose directory:

```yaml
version: '3.8'
services:
  webserver:
    command: >
      bash -c "
        apache2ctl start &&
        service cron start &&
        echo '* * * * * /usr/bin/php /var/www/html/admin/cli/cron.php >/dev/null 2>&1' | crontab - &&
        tail -f /var/log/apache2/error.log
      "
```

### Option 3: Custom Dockerfile (Most Permanent)
Create a custom Dockerfile that extends the Moodle image:

```dockerfile
FROM moodlehq/moodle-php-apache:latest

# Install cron
RUN apt-get update && apt-get install -y cron

# Create startup script
RUN echo '#!/bin/bash\n\
service cron start\n\
echo "* * * * * /usr/bin/php /var/www/html/admin/cli/cron.php >/dev/null 2>&1" | crontab -\n\
apache2-foreground' > /usr/local/bin/start-moodle.sh && \
chmod +x /usr/local/bin/start-moodle.sh

# Set custom entrypoint
ENTRYPOINT ["/usr/local/bin/start-moodle.sh"]
```

### Option 4: Init Container Pattern
Use an init container to set up cron before starting the main container.

## Verification Commands

Check if cron is running:
```bash
docker exec moodle-docker-webserver-1 ps aux | grep cron
```

Check cron jobs:
```bash
docker exec moodle-docker-webserver-1 crontab -l
```

Test Moodle cron manually:
```bash
docker exec moodle-docker-webserver-1 php /var/www/html/admin/cli/cron.php
```

## Available Scripts

The following scripts have been created in the container:

1. **`/usr/local/bin/setup-moodle-cron.sh`** - Quick setup script
2. **`/usr/local/bin/start-moodle-cron.sh`** - Startup script with monitoring
3. **`/usr/local/bin/moodle-startup.sh`** - Complete startup script

## Recommendation

For immediate use: **Option 1** (manual setup after restart)
For production: **Option 2** (Docker Compose override) or **Option 3** (custom Dockerfile)

## Current Cron Job
```
* * * * * /usr/bin/php /var/www/html/admin/cli/cron.php >/dev/null 2>&1
```
This runs Moodle's cron every minute, which is the recommended frequency.

