/**
 * Handle opening a modal for activity selection.
 *
 * @module     mod_roadmap/stepactivityselect
 * @copyright  2021 Steve Bader <smbader@ncsu.edu>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_roadmap/step_activity_select",["jquery","core/str","core/notification","core/templates","mod_roadmap/repository","core/modal_save_cancel","core/modal_events","mod_roadmap/step_save"],(function($,Str,Notification,Templates,RoadmapRepository,ModalSaveCancel,ModalEvents,StepSave){var SELECTORS_SELECT_ACTIVITY_BUTTON=".btn_completion_selector",StepActivitySelector=function(){this.registerEventListeners()};return StepActivitySelector.prototype.registerEventListeners=function(){var trigger=$(SELECTORS_SELECT_ACTIVITY_BUTTON),stringkeys=[{key:"chooseactivities",component:"mod_roadmap"},{key:"saveselection",component:"mod_roadmap"}];trigger.off("click").on("click",function(e){let stepId=$(e.target).parent(".btn_completion_selector").data("stepid");Str.get_strings(stringkeys).then(function(strings){return Promise.all([ModalSaveCancel.create({title:strings[0],body:""}),strings[1]]).then(function(_ref){let[modal,string]=_ref;return this.setupFormModal(modal,stepId,string),modal}.bind(this))}.bind(this)).catch(Notification.exception)}.bind(this))},StepActivitySelector.prototype.getBody=async()=>{const response=await RoadmapRepository.fetchCourseModules();return Templates.render("mod_roadmap/configuration_activityselect",response)},StepActivitySelector.prototype.setupFormModal=function(modal,stepId,saveText){modal.setLarge(),modal.setSaveButtonText(saveText),modal.getRoot().on(ModalEvents.hidden,this.destroy.bind(this)),modal.setBody(this.getBody()),modal.getRoot().on("click",'#activity-select-window .activity input[type="checkbox"]',function(){this.updateExpectedCompleteDropdown()}.bind(this)),modal.getRoot().on(ModalEvents.bodyRendered,function(){$("#step-id").val(stepId);let stepCompletionModules=$("#step-"+stepId+"-completion-modules").val().split(","),stepExpectedCompletionCourseModule=$("#step-"+stepId+"-expectedcomplete-coursemoduleid").val(),stepExpectedCompleteDatetime=$("#step-"+stepId+"-expectedcomplete-datetime").val();if($.each(stepCompletionModules,(function(i,val){$('#activity-select-window .activity input[type="checkbox"][data-coursemoduleid="'+val+'"]').prop("checked",!0)})),this.updateExpectedCompleteDropdown(),stepExpectedCompletionCourseModule>0&&$('#select-expected-activity-completion option[value="'+stepExpectedCompletionCourseModule+'"]').length>0)$('#select-expected-activity-completion option[value="'+stepExpectedCompletionCourseModule+'"]').attr("selected","selected");else if(stepExpectedCompleteDatetime>0){var date=new Date(1e3*stepExpectedCompleteDatetime);$('#select-expected-activity-completion option[value="-1"]').attr("selected","selected"),$('#customExpectedDateContainer select[name="today"] option[value="'+date.getDate()+'"]').attr("selected","selected"),$('#customExpectedDateContainer select[name="tomonth"] option[value="'+(date.getMonth()+1)+'"]').attr("selected","selected"),$('#customExpectedDateContainer select[name="toyear"] option[value="'+date.getFullYear()+'"]').attr("selected","selected"),$('#customExpectedDateContainer select[name="tohour"] option[value="'+date.getHours()+'"]').attr("selected","selected"),$('#customExpectedDateContainer select[name="tominute"] option[value="'+date.getMinutes()+'"]').attr("selected","selected")}else $('#select-expected-activity-completion option[value="0"]').attr("selected","selected");this.expectedCompleteDropdownChanged()}.bind(this)),modal.getRoot().on(ModalEvents.save,this.submitForm.bind(this)),modal.getRoot().on("submit","form",this.submitForm.bind(this)),this.modal=modal,modal.show()},StepActivitySelector.prototype.expectedCompleteDropdownChanged=function(){"-1"==$("#select-expected-activity-completion").find(":selected").val()?$("#customExpectedDateContainer").show():$("#customExpectedDateContainer").hide()},StepActivitySelector.prototype.updateExpectedCompleteDropdown=function(){let select=$("#select-expected-activity-completion");$('#activity-select-window .activity input[type="checkbox"]').each((function(){let coursemoduleid=$(this).data("coursemoduleid"),completionexpecteddatetime=$(this).data("completionexpecteddatetime"),completionexpectedreadable=$(this).data("completionexpectedreadable");if(0!=completionexpecteddatetime)if($(this).is(":checked")){let found=!1;$("#select-expected-activity-completion option").each((function(){$(this).val()==coursemoduleid&&(found=!0)})),!1===found&&select.append($("<option>",{value:coursemoduleid,text:completionexpectedreadable+" "+$(this).data("name"),"data-completionexpecteddatetime":completionexpecteddatetime}))}else $("#select-expected-activity-completion option").each((function(){$(this).val()==coursemoduleid&&$(this).remove()}))})),select.unbind("change").change(this.expectedCompleteDropdownChanged.bind(this))},StepActivitySelector.prototype.submitForm=function(e){e.preventDefault();let stepId=$("#step-id").val();$("#step-"+stepId+"-completion-list li").remove(),$('#activity-select-window .activity input[type="checkbox"]:checked').each((function(){$("#step-"+stepId+"-completion-list").append("<li>"+$(this).data("name")+"</li>")}));let selectedOption=$("#select-expected-activity-completion").find(":selected");if(0==selectedOption.val())$("#step-"+stepId+"-expectedcomplete-coursemoduleid").val(0),$("#step-"+stepId+"-expectedcomplete-datetime").val(0),$("#step-"+stepId+"-expectedcomplete-readable").html(selectedOption.text());else if(-1==selectedOption.val()){$("#step-"+stepId+"-expectedcomplete-coursemoduleid").val(-1);let day=$('#customExpectedDateContainer select[name="today"]').find(":selected").val(),month=$('#customExpectedDateContainer select[name="tomonth"]').find(":selected").val(),year=$('#customExpectedDateContainer select[name="toyear"]').find(":selected").val(),hours=$('#customExpectedDateContainer select[name="tohour"]').find(":selected").val(),minutes=$('#customExpectedDateContainer select[name="tominute"]').find(":selected").val(),jsDate=new Date(year,month-1,day,hours,minutes),unixTimestamp=Math.floor(jsDate.getTime()/1e3);$("#step-"+stepId+"-expectedcomplete-datetime").val(unixTimestamp),$("#step-"+stepId+"-expectedcomplete-readable").html(month+"/"+day+"/"+year+" "+hours+":"+minutes)}else $("#step-"+stepId+"-expectedcomplete-datetime").val(selectedOption.data("completionexpecteddatetime")),$("#step-"+stepId+"-expectedcomplete-coursemoduleid").val(selectedOption.val()),$("#step-"+stepId+"-expectedcomplete-readable").html(selectedOption.text());let values=$('#activity-select-window .activity input[type="checkbox"]:checked').map((function(){return $(this).data("coursemoduleid")})).get().join(",");$("#step-"+stepId+"-completion-modules").val(values).trigger("change"),StepSave.rebindInputs(),this.destroy()},StepActivitySelector.prototype.destroy=function(){this.modal.destroy()},{init:function(){return new StepActivitySelector},rebindButtons:function(){StepActivitySelector.prototype.registerEventListeners()}}}));

//# sourceMappingURL=step_activity_select.min.js.map