/**
 * Choice group settings JavaScript module
 *
 * @copyright  2025 UNIL
 * @author     Pierre Guarnieri <pierre.guarnieri@unil.ch>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_choicegroup/choicegroupsetting",(function(){return{init:function(param){const availableSelect=document.getElementById("availablegroups"),selectedSelect=document.getElementById("id_selectedGroups"),addBtn=document.getElementById("addGroupButton"),removeBtn=document.getElementById("removeGroupButton"),expandAllBtn=document.getElementById("expandButton"),collapseAllBtn=document.getElementById("collapseButton"),form=document.getElementById(param.formid),serializedselectedgroups=document.getElementById("serializedselectedgroups"),removedOptionsMap=new Map;let sortBy=param.sortgroupsby;if(Array.from(availableSelect.options).forEach(((opt,index)=>{opt.dataset.originalIndex=index})),""!==serializedselectedgroups.value){let selectedGroups=serializedselectedgroups.value.split(";").filter((n=>""!==n)),inSelected=[];Array.from(availableSelect.options).forEach((opt=>{opt.classList.contains("group")&&!inSelected.includes(opt.value)&&(opt.selected=selectedGroups.includes(opt.value),inSelected.push(opt.value))})),moveToSelected()}if(!availableSelect||!selectedSelect)return;let groupingStates={};function toggleGrouping(groupingOption){const groupingValue=groupingOption.value;groupingStates[groupingValue]=!groupingStates[groupingValue];const isExpanded=groupingStates[groupingValue],currentText=groupingOption.textContent;if(groupingOption.textContent=currentText.replace(/^[\u25BC\u25B6]/,isExpanded?"▼":"▶"),isExpanded){const removedOptions=removedOptionsMap.get(groupingValue);if(removedOptions&&removedOptions.length>0){const groupingIndex=Array.from(availableSelect.options).indexOf(groupingOption);removedOptions.forEach(((option,i)=>{const insertPosition=groupingIndex+1+i;insertPosition<availableSelect.options.length?availableSelect.add(option,insertPosition):availableSelect.add(option)})),removedOptionsMap.delete(groupingValue)}}else{const optionsToRemove=[];let nextIndex=Array.from(availableSelect.options).indexOf(groupingOption)+1;for(;nextIndex<availableSelect.options.length;){const nextOption=availableSelect.options[nextIndex];if(nextOption.classList.contains("grouping"))break;nextOption.classList.contains("nested")&&optionsToRemove.push(nextOption),nextIndex++}for(let i=optionsToRemove.length-1;i>=0;i--)optionsToRemove[i].remove();removedOptionsMap.set(groupingValue,optionsToRemove)}}function expandAll(){Array.from(availableSelect.options).filter((opt=>opt.classList.contains("grouping"))).forEach((opt=>{groupingStates[opt.value]||toggleGrouping(opt)}))}function collapseAll(){Array.from(availableSelect.options).filter((opt=>opt.classList.contains("grouping"))).forEach((opt=>{groupingStates[opt.value]&&toggleGrouping(opt)}))}function moveToSelected(){const data=[],usedValues=[];Array.from(availableSelect.selectedOptions).forEach((selectedOpt=>{if(selectedOpt.classList.contains("group")&&!usedValues.includes(selectedOpt.value)){const originalIndexes=findAllOptions(availableSelect,selectedOpt.value,"group").map((o=>Number(o.dataset.originalIndex)));selectedOpt.dataset.originalIndexes=JSON.stringify(originalIndexes),usedValues.push(selectedOpt.value),data.push(selectedOpt)}})),data.forEach((opt=>{selectedSelect.appendChild(opt),opt.selected=!1,findAllOptions(availableSelect,opt.value,"group").forEach((optToRemove=>optToRemove.remove()))}));Array.from(selectedSelect.options).sort(((a,b)=>{if("name"===sortBy)return a.text.localeCompare(b.text);if("timecreated"===sortBy){return Number(a.dataset.timecreated||0)-Number(b.dataset.timecreated||0)}return 0})).forEach((opt=>selectedSelect.appendChild(opt)))}function moveToAvailable(){const toRestore=[];Array.from(selectedSelect.selectedOptions).forEach((opt=>{const originalIndexes=JSON.parse(opt.dataset.originalIndexes||"[".concat(opt.dataset.originalIndex||-1,"]"));opt.remove(),originalIndexes.forEach(((origIndex,idx)=>{const newOpt=0===idx?opt:opt.cloneNode(!0);newOpt.removeAttribute("id"),newOpt.dataset.originalIndex=String(origIndex),newOpt.dataset.originalIndexes=JSON.stringify(originalIndexes),toRestore.push({index:Number(origIndex),option:newOpt})}))})),toRestore.sort(((a,b)=>a.index-b.index)),toRestore.forEach((_ref=>{let{index:index,option:option}=_ref;const nextOpt=Array.from(availableSelect.options).find((o=>Number(o.dataset.originalIndex)>index));nextOpt?availableSelect.add(option,nextOpt):availableSelect.add(option),option.selected=!1}))}function findAllOptions(selectElement,value){let className=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null;return Array.from(selectElement.options).filter((opt=>opt.value===value&&(!className||opt.classList.contains(className))))}Array.from(availableSelect.options).forEach((opt=>{opt.classList.contains("grouping")&&(groupingStates[opt.value]=!0)})),function(){availableSelect.addEventListener("dblclick",(function(e){const clickedIndex=e.currentTarget.selectedIndex;if(clickedIndex>=0){const option=this.options[clickedIndex];option&&option.classList.contains("grouping")?(e.preventDefault(),toggleGrouping(option)):option&&option.classList.contains("group")&&(e.preventDefault(),moveToSelected())}})),selectedSelect.addEventListener("dblclick",(function(e){e.currentTarget.selectedIndex>=0&&(e.preventDefault(),moveToAvailable())})),addBtn&&addBtn.addEventListener("click",moveToSelected);removeBtn&&removeBtn.addEventListener("click",moveToAvailable);expandAllBtn&&expandAllBtn.addEventListener("click",expandAll);collapseAllBtn&&collapseAllBtn.addEventListener("click",collapseAll);form.addEventListener("submit",(function(e){if(selectedSelect.options.length<1&&!window.skipClientValidation)return alert(M.util.get_string("pleaseselectonegroup","choicegroup")),e.preventDefault(),void e.stopPropagation();let serializedSelection="";selectedSelect.options.forEach((option=>{serializedSelection+=";"+option.value})),serializedselectedgroups.value=serializedSelection}))}()}}}));

//# sourceMappingURL=choicegroupsetting.min.js.map