/**
 * @module     mod_onlyofficedocspace/admin_settings
 * @copyright  2025 Ascensio System SIA <integration@onlyoffice.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/
define("mod_onlyofficedocspace/admin_settings",["core_form/changechecker","core/notification","core/str","mod_onlyofficedocspace/repository"],(function(ChangeChecker,Notification,Str,Repository){const selectors_notifications="#user-notifications",selectors_fieldRows={url:"#admin-docspace_server_url",apiKey:"#admin-docspace_api_key"},selectors_icons={rightArrow:".right-arrow",spinner:".spinner-border",checkMark:".ds-check-icon"},selectors_buttons={checkUrl:"#check-docspace-url-btn",connect:"#connect-docspace-btn",change:"#change-docspace-btn",disconnect:"#disconnect-docspace-btn"},selectors_inputs={url:"#id_s_onlyofficedocspace_docspace_server_url",apiKey:"#id_s_onlyofficedocspace_docspace_api_key"},selectors_errors={url:"#id_s_onlyofficedocspace_docspace_server_url-error",apiKey:"#id_s_onlyofficedocspace_docspace_api_key-error"},STEPS_CONNECTED="connected",STEPS_CHECK_URL="check_url",STEPS_CHECK_API_KEY="check_api_key",state={step:STEPS_CONNECTED,isUrlValid:!1},setState=function(newState){render({...state,...newState})},render=async function(state){const isCheckingUrl=Boolean(state.isCheckingUrl),isConnecting=Boolean(state.isConnecting);if(document.querySelector(selectors_notifications).innerHTML="",document.querySelector(selectors_fieldRows.url).classList.toggle("disabled",state.step===STEPS_CONNECTED),document.querySelector(selectors_fieldRows.apiKey).classList.toggle("disabled",state.step!==STEPS_CHECK_API_KEY),document.querySelector(selectors_buttons.checkUrl).classList.toggle("hidden",state.step===STEPS_CONNECTED),document.querySelector(selectors_buttons.connect).classList.toggle("hidden",state.step===STEPS_CONNECTED),document.querySelector(selectors_buttons.change).classList.toggle("hidden",state.step!==STEPS_CONNECTED),document.querySelector(selectors_buttons.disconnect).classList.toggle("hidden",state.step!==STEPS_CONNECTED),document.querySelector(selectors_icons.spinner).classList.toggle("hidden",!isCheckingUrl),document.querySelector(selectors_icons.rightArrow).classList.toggle("hidden",isCheckingUrl),document.querySelector(selectors_inputs.url).classList.toggle("pr-5",state.isUrlValid),document.querySelector(selectors_icons.checkMark).classList.toggle("hidden",!state.isUrlValid),document.querySelector(selectors_buttons.connect).disabled=state.step!==STEPS_CHECK_API_KEY||isConnecting,document.querySelector(selectors_buttons.checkUrl).disabled=isCheckingUrl,document.querySelector(selectors_errors.url).classList.toggle("hidden",!(state.errors&&state.errors.url)),document.querySelector(selectors_errors.apiKey).classList.toggle("hidden",!(state.errors&&state.errors.apiKey)),document.querySelectorAll(".ds-create-key-link").forEach((link=>{const url=document.querySelector(selectors_inputs.url).value;link.href=state.isUrlValid?url:"#"})),state.success&&await Notification.addNotification({message:state.success,type:"success"}),state.errors){const errorMessages=[];state.errors.url&&(document.querySelector(selectors_errors.url).textContent=state.errors.url,errorMessages.push(state.errors.url)),state.errors.apiKey&&(document.querySelector(selectors_errors.apiKey).textContent=state.errors.apiKey,errorMessages.push(state.errors.apiKey)),state.errors.general&&errorMessages.push(state.errors.general),errorMessages.forEach((async error=>{await Notification.addNotification({message:error,type:"error"})}))}},handleCheckUrl=async function(){state.step=STEPS_CHECK_URL,state.isUrlValid=!1,setState({isCheckingUrl:!0});const url=document.querySelector(selectors_inputs.url).value.trim();if(0!==url.length){try{new URL(url)}catch(TypeError){return void setState({errors:{url:await Str.getString("validationerror:invalidurl","onlyofficedocspace")}})}try{const result=await Repository.checkDocSpaceConnectivity(url);if(result.status&&"success"===result.status)return state.isUrlValid=!0,state.step=STEPS_CHECK_API_KEY,void setState({});result.errors&&setState({errors:{url:result.errors[0]}})}catch(error){console.log(error),setState({errors:{general:await Str.getString("unexpectederror:docspaceurl","onlyofficedocspace")}})}}else setState({errors:{url:await Str.getString("validationerror:emptyurl","onlyofficedocspace")}})},handleConnect=async function(event){const connectButton=event.target;connectButton.disabled=!0;const url=document.querySelector(selectors_inputs.url).value.trim(),apiKey=document.querySelector(selectors_inputs.apiKey).value.trim();if(0!==apiKey.length){try{const result=await Repository.connectDocSpace(url,apiKey);result.status&&"success"===result.status?(state.step=STEPS_CONNECTED,state.isUrlValid=!0,setState({success:await Str.getString("successfulconnection","onlyofficedocspace")})):result.errors&&setState({errors:{apiKey:result.errors[0]}})}catch(error){console.log(error),setState({errors:{general:await Str.getString("unexpectederror:connectdocspace","onlyofficedocspace")}})}ChangeChecker.disableAllChecks(),connectButton.disabled=!1}else setState({errors:{apiKey:await Str.getString("validationerror:emptyapikey","onlyofficedocspace")}})},handleChangeDocSpace=async function(){await Notification.saveCancel(Str.getString("warning","onlyofficedocspace"),Str.getString("confirmchange_desc","onlyofficedocspace"),Str.getString("change","onlyofficedocspace"),(async()=>{state.step=STEPS_CHECK_URL,state.isUrlValid=!1,setState({})}),null)},handleDisconnectDocSpace=async function(){await Notification.saveCancel(Str.getString("warning","onlyofficedocspace"),Str.getString("confirmdisconnect_desc","onlyofficedocspace"),Str.getString("disconnect","onlyofficedocspace"),(async()=>{const result=await Repository.disconnectDocSpace();if(result.status&&"success"===result.status)return ChangeChecker.disableAllChecks(),void window.location.reload();result.errors&&setState({errors:{general:result.errors}})}),null)},resetStepToCheckUrl=function(){state.step=STEPS_CHECK_URL,state.isUrlValid=!1,setState({})},updateClearButton=function(event){const input=event.target,clearButton=input.closest(".ds-input-wrapper").querySelector(".ds-clear-btn"),focusedAndNonEmpty=input.value&&document.activeElement===input;input.classList.toggle("pr-5",focusedAndNonEmpty),clearButton.classList.toggle("hidden",!focusedAndNonEmpty)},resetInputValue=function(event){if(event.target.closest(".ds-clear-btn")){const input=event.target.closest(".ds-input-wrapper").querySelector("input");input.value="",input.dispatchEvent(new Event("input",{bubbles:!0})),input.focus()}};return{init:async function(connected){document.querySelector(selectors_buttons.checkUrl).addEventListener("click",handleCheckUrl),document.querySelector(selectors_buttons.connect).addEventListener("click",handleConnect),document.querySelector(selectors_buttons.change).addEventListener("click",handleChangeDocSpace),document.querySelector(selectors_buttons.disconnect).addEventListener("click",handleDisconnectDocSpace),document.querySelector(selectors_inputs.url).addEventListener("input",resetStepToCheckUrl),document.querySelector(selectors_inputs.url).addEventListener("focus",resetStepToCheckUrl),document.querySelector(selectors_inputs.url).addEventListener("input",updateClearButton),document.querySelector(selectors_inputs.url).addEventListener("focus",updateClearButton),document.querySelector(selectors_inputs.url).addEventListener("blur",(e=>{setTimeout((()=>{updateClearButton(e)}),200)})),document.querySelector(selectors_inputs.apiKey).addEventListener("input",updateClearButton),document.querySelector(selectors_inputs.apiKey).addEventListener("focus",updateClearButton),document.querySelector(selectors_inputs.apiKey).addEventListener("blur",(e=>{setTimeout((()=>{updateClearButton(e)}),200)})),document.addEventListener("click",resetInputValue),state.step=connected?STEPS_CONNECTED:STEPS_CHECK_URL,state.isUrlValid=connected,setState({})}}}));

//# sourceMappingURL=admin_settings.min.js.map