/**
 * @module mod_onlyofficedocspace/docspace_editor
 * @copyright  2025 Ascensio System SIA <integration@onlyoffice.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/
define("mod_onlyofficedocspace/docspace_editor",["core/str","core/templates","jquery","mod_onlyofficedocspace/docspace_integration_sdk"],(function(Str,Templates,$,DocSpaceIntegrationSDK){return{init:async function(docspaceUrl,config,user,errorTemplateName){config.events={onNotFound:()=>{Templates.renderForPromise(errorTemplateName,{}).then((_ref=>{let{html:html,js:js}=_ref;DocSpace.SDK.frames[config.frameId].destroyFrame(),Templates.appendNodeContents("#ds-editor-error",html,js)}))}},await DocSpaceIntegrationSDK.initScript("oodsp-api-js",docspaceUrl).then((async()=>{DocSpace.SDK.initSystem({src:docspaceUrl,frameId:config.frameId,width:config.width,height:config.height,events:{onAppReady:async function(){const docSpace=DocSpace.SDK.frames[config.frameId],currentUser=await docSpace.getUserInfo();(!user&&currentUser||currentUser&&currentUser.email!==user.email)&&await docSpace.logout(),user&&user.hash&&await docSpace.login(user.email,user.hash),docSpace.initFrame(config)}}})})),"editor"===config.mode&&function(){let enterFullScreenText=Str.getString("enterfullscreen","onlyofficedocspace"),exitFullScreenText=Str.getString("exitfullscreen","onlyofficedocspace");const navLeftButton=$(".drawertoggle")[1],navRightButton=$(".drawertoggle")[2],editorContainer=$(".ds-editor-container")[0];$.when(enterFullScreenText).done((function(localized){enterFullScreenText=localized;const enterButton=document.createElement("button"),enterIcon=document.createElement("i");enterIcon.className="icon fa fa-expand fa-fw",enterButton.appendChild(enterIcon),enterButton.className="ds-editor-fs-button",enterButton.id="ds-editor-enter-fs-button",enterButton.innerHTML+=enterFullScreenText,enterButton.onclick=function(){$("header").hide(),$("footer").hide(),navLeftButton&&null===navLeftButton.getAttribute("data-aria-hidden-tab-index")&&$(navLeftButton).click(),navRightButton&&null===navRightButton.getAttribute("data-aria-hidden-tab-index")&&$(navRightButton).click(),$(".editmode-switch-form").length>0&&$(".editmode-switch-form")[0][0].checked&&$(editorContainer).addClass("ds-editor-rightindent"),$(editorContainer).addClass("ds-editor-fullscreen"),editorContainer.children[0].style.height="93vh",$("#ds-editor-enter-fs-button").hide(),$("#ds-editor-exit-fs-button").show()},document.querySelector("#page-content h2").style.display="inline-block",editorContainer.before(enterButton)})),$.when(exitFullScreenText).done((function(localized){exitFullScreenText=localized;const exitButton=document.createElement("button"),exitIcon=document.createElement("i");exitIcon.className="icon fa fa-compress fa-fw",exitButton.appendChild(exitIcon),exitButton.innerHTML+=exitFullScreenText,exitButton.className="ds-editor-fs-button",exitButton.id="ds-editor-exit-fs-button",exitButton.onclick=function(){$(editorContainer).removeClass("ds-editor-fullscreen"),$(editorContainer).removeClass("ds-editor-rightindent"),editorContainer.children[0].style.height="95vh",$("header").show(),$("footer").show(),$("#ds-editor-enter-fs-button").show(),$("#ds-editor-exit-fs-button").hide()},$("#usernavigation")[0].prepend(exitButton),$("#ds-editor-exit-fs-button").hide()}))}()}}}));

//# sourceMappingURL=docspace_editor.min.js.map