/**
 * @module mod_onlyofficedocspace/docspace_users
 * @copyright  2025 Ascensio System SIA <integration@onlyoffice.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/
define("mod_onlyofficedocspace/docspace_users",["core/str","core/notification","core_form/changechecker","core/templates","mod_onlyofficedocspace/repository","mod_onlyofficedocspace/pagination"],(function(Str,Notification,ChangeChecker,Templates,Repository,Pagination){const data={users:[],selectedUsers:[],pagination:{currentPage:1,total:0,limit:10}},selectors_usersTable="table[id='ds-invite-users-table']",selectors_checkers='input[name="users"]',selectors_checkAll='input[id="check-all-users"]',selectors_actionsButtons=".action-buttons",selectors_buttons={invite:"#invite-to-docspace",unlink:"#unlink-docspace-account"},selectors_pagination="#pagination",iconTemplates={},toggle=function(event){const checked=event.target.checked,checkboxes=document.querySelector(selectors_usersTable).querySelectorAll(selectors_checkers);checkboxes.forEach((checkbox=>{checkbox.checked=checked})),data.selectedUsers=checked?[...checkboxes].map((checkbox=>checkbox.value)):[],toggleActionButtons()},toggleActionButtons=function(){document.querySelectorAll(".action-buttons button").forEach((button=>{button.disabled=data.selectedUsers.length<1})),data.selectedUsers.length<1&&ChangeChecker.disableAllChecks()},handleUnlinkDocspaceUser=async function(event){const unlinkButton=event.target;unlinkButton.disabled=!0,await Notification.saveCancel(Str.getString("warning","onlyofficedocspace"),Str.getString("unlinkwarningmessage","onlyofficedocspace"),Str.getString("unlinkdocspaceaccount","onlyofficedocspace"),(async()=>{clearNotificationsSection();try{const result=await Repository.unlinkDocSpaceUsers(data.selectedUsers);"success"===result.status&&(result.unlinkedcount>0&&(Notification.addNotification({message:await Str.getString("successfuldisable","onlyofficedocspace","".concat(result.unlinkedcount,"/").concat(result.totalcount)),type:"success"}),await updateUsersList(),updateUsersTable(),ChangeChecker.disableAllChecks()),result.skippedcount>0&&Notification.addNotification({message:await Str.getString("skippeddisable","onlyofficedocspace","".concat(result.skippedcount,"/").concat(result.totalcount)),type:"warning"}))}catch(error){console.log(error),Notification.addNotification({message:await Str.getString("unexpectederror:unlinkusers","onlyofficedocspace"),type:"error"})}}),null),unlinkButton.disabled=!1},handleInviteToDocspace=async function(event){const inviteButton=event.target;inviteButton.disabled=!0;try{const result=await Repository.inviteUsersToDocSpace(data.selectedUsers);result.status&&"success"===result.status&&(clearNotificationsSection(),result.invitedcount>0&&(Notification.addNotification({message:await Str.getString("sentinvitations","onlyofficedocspace","".concat(result.invitedcount,"/").concat(result.totalcount)),type:"success"}),await updateUsersList(),updateUsersTable(),ChangeChecker.disableAllChecks()),result.skippedcount>0&&Notification.addNotification({message:await Str.getString("skippedinvitations","onlyofficedocspace","".concat(result.skippedcount,"/").concat(result.totalcount)),type:"warning"}),result.failedcount>0&&Notification.addNotification({message:await Str.getString("failedinvitations","onlyofficedocspace","".concat(result.failedcount,"/").concat(result.totalcount)),type:"error"}))}catch(error){console.log(error),Notification.addNotification({message:await Str.getString("unexpectederror:inviteusers","onlyofficedocspace"),type:"error"})}inviteButton.disabled=!1},handleSelectUser=function(event){if(event.target.matches(selectors_checkers)){const checkbox=event.target,userValue=checkbox.value;checkbox.checked?data.selectedUsers.push(userValue):data.selectedUsers=data.selectedUsers.filter((user=>user!==userValue)),toggleActionButtons()}},updateUsersList=async function(){try{const response=await Repository.fetchDocSpaceUsers(data.pagination.currentPage,data.pagination.limit);data.users=response.users,data.pagination.total=response.pagination.total}catch(error){console.log(error),data.users=[],data.pagination.total=0}},updateUsersTable=async function(){const table=document.querySelector("#ds-invite-users-table"),tbody=table.querySelector("tbody"),checkAllInput=table.querySelector(selectors_checkAll),selectButtons=document.querySelector(selectors_actionsButtons);if(tbody.innerHTML="",checkAllInput.checked=!1,data.selectedUsers=[],selectButtons.classList.toggle("hidden",!(data.users&&data.users.length>0)),data.users.length<1){const tr=document.createElement("tr"),td=document.createElement("td");return td.textContent=await Str.getString("emptyuserslist","onlyofficedocspace"),td.colSpan=6,td.classList.add("text-center"),tr.appendChild(td),void tbody.appendChild(tr)}const fragment=document.createDocumentFragment();data.users.forEach((user=>{fragment.appendChild(generateUsersTableRow(user))})),tbody.appendChild(fragment);const totalPages=Math.ceil(data.pagination.total/data.pagination.limit);Pagination.render(selectors_pagination,totalPages,data.pagination.currentPage,(async page=>{data.pagination.currentPage=page,await updateUsersList(),updateUsersTable()}))},generateUsersTableRow=function(user){const tr=document.createElement("tr");let td=document.createElement("td");const checkbox=document.createElement("input");return checkbox.type="checkbox",checkbox.name="users",checkbox.value=user.id,td.appendChild(checkbox),tr.appendChild(td),td=document.createElement("td"),td.textContent="".concat(user.firstname," ").concat(user.lastname),tr.appendChild(td),td=document.createElement("td"),td.textContent=user.email,tr.appendChild(td),td=document.createElement("td"),td.textContent=user.role,tr.appendChild(td),td=document.createElement("td"),td.innerHTML=getStatusTemplate(user.status),tr.appendChild(td),td=document.createElement("td"),td.textContent=user.type,tr.appendChild(td),tr},sortUsersTable=function(event){const button=event.target,sortProperty=button.dataset.sortProperty,headers=document.querySelector(selectors_usersTable).querySelectorAll("th button"),newSort="ascending"===button.getAttribute("aria-sort")?"descending":"ascending";headers.forEach((h=>{h.setAttribute("aria-sort","none"),h.classList.remove("asc"),h.classList.remove("desc")})),button.setAttribute("aria-sort",newSort),button.classList.add("ascending"===newSort?"asc":"desc"),data.users.sort(((a,b)=>{const valA=a[sortProperty],valB=b[sortProperty],ascending="ascending"===newSort;return!valA&&valB?ascending?1:-1:valA&&!valB?ascending?-1:1:valA||valB?ascending?valA.localeCompare(valB):valB.localeCompare(valA):0})),updateUsersTable()},getStatusTemplate=function(status){switch(status){case"active":return iconTemplates.checkMark;case"exists":return iconTemplates.hourglass;default:return""}},clearNotificationsSection=function(){document.getElementById("user-notifications").innerHTML=""};return{init:async function(){document.addEventListener("click",handleSelectUser);document.querySelector(selectors_checkAll).addEventListener("click",toggle);document.querySelector(selectors_buttons.unlink).addEventListener("click",handleUnlinkDocspaceUser);document.querySelector(selectors_buttons.invite).addEventListener("click",handleInviteToDocspace);document.querySelectorAll(selectors_usersTable+" th button").forEach((button=>button.addEventListener("click",sortUsersTable)));let template=await Templates.renderForPromise("mod_onlyofficedocspace/icons/hourglass",{});iconTemplates.hourglass=template.html,template=await Templates.renderForPromise("mod_onlyofficedocspace/icons/check_mark",{}),iconTemplates.checkMark=template.html,await updateUsersList(),updateUsersTable()}}}));

//# sourceMappingURL=docspace_users.min.js.map