/**
 * @module mod_onlyofficedocspace/select_element
 * @copyright  2025 Ascensio System SIA <integration@onlyoffice.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/
define("mod_onlyofficedocspace/select_element",["core/modal_events","core/str","mod_onlyofficedocspace/docspace_integration_sdk","mod_onlyofficedocspace/select_modal","mod_onlyofficedocspace/login_modal","mod_onlyofficedocspace/repository"],(function(ModalEvents,Str,DocspaceIntegrationSDK,DocSpaceSelectModal,DocSpaceLogInModal,Repository){const STEPS_LOADING="loading",STEPS_LOGIN="login",STEPS_SELECT_ITEM="select_item",STEPS_DOCSPACE_ITEM="docspace_item",STEPS_ERROR="error",selectors_frames={system:"ds-system-frame",select:"ds-select-frame",container:"ds-frame-container"},selectors_modal={ids:{email:"ds-login-email",password:"ds-login-password",submit:"ds-login-submit",cancel:"ds-login-cancel"}},selectors_select={ids:{containers:{login:"ds-login-container",item:"ds-item-container",itemInfo:"ds-item-info",itemType:"ds-item-type",select:"ds-select-container",error:"ds-error"},buttons:{login:"ds-show-login-modal",selectRoom:"ds-select-room",selectFile:"ds-select-file",remove:"ds-item-remove"}}},data={url:"",user:null,item:null};let state={step:STEPS_LOADING};const setState=function(newState){state={...state,...newState},render()},render=async function(){document.getElementById(selectors_select.ids.containers.item).classList.toggle("d-none",state.step!==STEPS_DOCSPACE_ITEM),document.getElementById(selectors_select.ids.containers.login).classList.toggle("d-none",state.step!==STEPS_LOGIN),document.getElementById(selectors_select.ids.containers.error).classList.toggle("d-none",state.step!==STEPS_ERROR),document.getElementById(selectors_select.ids.containers.select).classList.toggle("d-none",state.step!==STEPS_SELECT_ITEM),document.getElementById(selectors_frames.container).classList.toggle("d-none",state.step!==STEPS_LOADING),state.step===STEPS_LOADING&&initDocSpace(),state.step===STEPS_DOCSPACE_ITEM&&(document.getElementById(selectors_select.ids.containers.itemType).querySelector("p").textContent=await Str.getString("selecteditemtype:"+data.item.docspaceitemtype,"onlyofficedocspace"),document.getElementById(selectors_select.ids.containers.itemInfo).querySelector("img").src=data.item.docspaceitemicon,document.getElementById(selectors_select.ids.containers.itemInfo).querySelector("p").textContent=data.item.docspaceitemname)},initDocSpace=async function(){await DocspaceIntegrationSDK.initScript("oodsp-api-js",data.url).then((async()=>{DocSpace.SDK.initSystem({frameId:selectors_frames.system,src:data.url,events:{async onAppReady(){data.user&&data.user.email&&data.user.passwordHash?await authenticateWithDocSpace(data.user.email,data.user.passwordHash,(()=>{setState({step:data.item?STEPS_DOCSPACE_ITEM:STEPS_SELECT_ITEM})}),(()=>{setState({step:STEPS_LOGIN})})):setState({step:STEPS_LOGIN})},onAppError(){setState({step:STEPS_ERROR})}}})})).catch((()=>{setState({step:STEPS_ERROR})}))},showLoginModal=async function(){await DocSpaceLogInModal.create({templateContext:{email:data.user?data.user.email:"",url:data.url},removeOnClose:!0}).then((modal=>{modal.getRoot().on(ModalEvents.cancel,(()=>{modal.destroy()})),modal.modal[0].classList.add("modal-dialog-centered"),modal.modal[0].style="max-width: 440px;",modal.show(),document.getElementById(selectors_modal.ids.submit).addEventListener("click",(async function(event){const submitButton=event.target;submitButton.disabled=!0;const email=document.getElementById(selectors_modal.ids.email).value.trim(),password=document.getElementById(selectors_modal.ids.password).value.trim(),docspace=DocSpace.SDK.frames[selectors_frames.system],hashSettings=await docspace.getHashSettings(),passwordHash=await docspace.createHash(password.trim(),hashSettings);await authenticateWithDocSpace(email,passwordHash,(async()=>{await Repository.updateUserPassword(email,passwordHash).catch((error=>{console.log(error)})),modal.destroy(),setState({step:data.item?STEPS_DOCSPACE_ITEM:STEPS_SELECT_ITEM})}),(()=>{document.getElementById("ds-login-error").style.display="block"})),submitButton.disabled=!1})),document.getElementById(selectors_modal.ids.cancel).addEventListener("click",(function(){modal.destroy()}))}))},showSelectModal=async function(event){const selectorType=event.target.dataset.selectorType,titleText="room"===selectorType?await Str.getString("selectroom","mod_onlyofficedocspace"):await Str.getString("selectfile","mod_onlyofficedocspace"),modal=await DocSpaceSelectModal.create({templateContext:{titleText:titleText},removeOnClose:!0});modal.body[0].classList.add("p-0","py-2"),modal.modal[0].classList.add("modal-dialog-centered"),modal.modal[0].querySelector(".modal-content").style="max-width:480px;border-radius: 0",modal.getRoot().on(ModalEvents.hidden,(async()=>{await DocSpace.SDK.frames[selectors_frames.select].destroyFrame()})),modal.show();const config={frameId:selectors_frames.select,src:data.url,width:"100%",height:"538px",showSelectorCancel:!0,theme:"Base",roomType:6,events:{onSelectCallback:async function(event){var _URL$parse;const itemInfo="room"===selectorType?event[0]:event,name="room"===selectorType?itemInfo.label:itemInfo.title+itemInfo.fileExst,icon=null!==(_URL$parse=URL.parse(itemInfo.icon))&&void 0!==_URL$parse?_URL$parse:new URL(itemInfo.icon,data.url),requestToken=itemInfo.requestTokens[0].requestToken;data.item={docspaceitemtype:selectorType,docspaceitemname:name,docspaceitemicon:icon.href},selectItem(itemInfo.id,selectorType,requestToken,name,icon.href),setState({step:STEPS_DOCSPACE_ITEM}),modal.destroy()},onCloseCallback:function(){modal.destroy()}}};"room"===selectorType?config.mode="room-selector":"file"===selectorType&&(config.mode="file-selector",config.rootPath="/rooms/share",config.selectorType="roomsOnly"),DocSpace.SDK.initFrame(config)},authenticateWithDocSpace=async function(email,passwordHash){let onSuccess=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null,onFail=arguments.length>3&&void 0!==arguments[3]?arguments[3]:null;const docspace=DocSpace.SDK.frames[selectors_frames.system],docspaceUser=await docspace.getUserInfo();docspaceUser&&docspaceUser.email!==email&&await docspace.logout(),await docspace.login(email,passwordHash).then((result=>{result.status&&200!==result.status?onFail&&onFail():onSuccess&&onSuccess()})).catch((()=>{onFail&&onFail()}))},selectItem=async function(id,type,requestToken,name,icon){document.getElementsByName("docspaceitemid")[0].value=id,document.getElementsByName("docspaceitemtype")[0].value=type,document.getElementsByName("docspacerequesttoken")[0].value=requestToken,document.getElementsByName("docspaceitemname")[0].value=name,document.getElementsByName("docspaceitemicon")[0].value=icon},removeItem=async function(){selectItem("","","","",""),setState({step:STEPS_SELECT_ITEM})};return{init:async function(url,user,item){data.url=url,data.user=user,data.item=item,document.getElementById(selectors_select.ids.buttons.login).addEventListener("click",showLoginModal),document.getElementById(selectors_select.ids.buttons.selectRoom).addEventListener("click",showSelectModal),document.getElementById(selectors_select.ids.buttons.remove).addEventListener("click",removeItem),setState({step:STEPS_LOADING})}}}));

//# sourceMappingURL=select_element.min.js.map