<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Url admin setting.
 *
 * @package    mod_onlyofficeeditor
 * @copyright  2025 Ascensio System SIA <integration@onlyoffice.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace mod_onlyofficeeditor\local\admin\settings;

/**
 * Url admin setting.
 *
 * @package    mod_onlyofficeeditor
 * @copyright  2025 Ascensio System SIA <integration@onlyoffice.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class onlyoffice_admin_setting_url extends onlyoffice_admin_setting_text {
    /**
     * Write setting.
     *
     * @param string $data Data to write
     * @return string Empty string
     */
    public function write_setting($data) {
        // Clean up the data before saving.
        $data = rtrim(trim($data), '/');

        return parent::write_setting($data);
    }

    /**
     * Validate data before storage.
     *
     * @param string $data The string to be validated.
     * @return bool|string true for success or error string if invalid.
     */
    public function validate($data) {
        $cleaned = clean_param($data, PARAM_URL);
        if (!empty($data) && ($data !== $cleaned || filter_var($cleaned, FILTER_VALIDATE_URL) === false)) {
            return get_string('validationerror:invalidurl', 'onlyofficeeditor');
        }

        return parent::validate($data);
    }
}
