/**
 * @module     mod_onlyofficeeditor/check_docserver_button
 * @copyright  2025 Ascensio System SIA <integration@onlyoffice.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/
define("mod_onlyofficeeditor/check_docserver_button",["core/notification","core/str","mod_onlyofficeeditor/repository","mod_onlyofficeeditor/url_validator","mod_onlyofficeeditor/docs_integration_api"],(function(Notification,Str,Repository,UrlValidator,DocsIntegrationAPI){let checkButton=null;const fields={},validationElements=[],checkDocumentServerConnection=async event=>{event.preventDefault(),checkButton.disabled=!0,checkButton.classList.add("loading");const data={docsurl:fields.docsurl.value.trim(),secret:fields.secret.value.trim(),jwtheader:fields.jwtheader.value.trim(),internalurl:fields.internalurl.value.trim(),storageurl:fields.storageurl.value.trim(),disableverifyssl:fields.disableverifyssl.checked},errors=await validateFields(data);clearValidationOutput(),errors.length>0?await displayErrors(errors):Notification.addNotification({message:await Str.get_string("connectionsuccess","onlyofficeeditor"),type:"success"}),checkButton.disabled=!1,checkButton.classList.remove("loading")},highlightErrorField=error=>{const fieldForm=document.getElementById("admin-"+error.field),fieldSetting=fieldForm?fieldForm.querySelector(".form-setting"):null;if(fieldSetting){fieldSetting.querySelectorAll(".error").forEach((el=>{el.remove()}));const errorElement=document.createElement("div");errorElement.innerHTML='<span class="error">'+error.message+"</span>",fieldSetting.prepend(errorElement),validationElements.push(errorElement)}},clearValidationOutput=()=>{for(const element of validationElements)element.remove();validationElements.length=0;document.getElementById("user-notifications").innerHTML=""},displayErrors=async errors=>{for(const error of errors)"general"===error.field?Notification.addNotification({message:error.message,type:"error"}):highlightErrorField(error);Notification.addNotification({message:await Str.get_string("connectionerror","onlyofficeeditor"),type:"error"})},validateFields=async data=>{const errors=await preValidateFields(data);return errors.length>0||await Repository.checkDocumentServerConnection(data.secret,data.jwtheader,data.internalurl.length>0?data.internalurl:data.docsurl,data.storageurl,data.disableverifyssl).then((async response=>{if("error"===response.status)for(const error of response.errors)errors.push({field:error.field,message:error.message})})).catch((async error=>{console.error("Error checking Document Server connection:",error),errors.push({field:"general",message:await Str.get_string("connectionerror:unexpected","onlyofficeeditor")})})),errors},preValidateFields=async data=>{const errors=[];try{await validateDocumentServerUrl(data.docsurl)}catch(e){errors.push({field:"documentserverurl",message:e.message})}return data.internalurl&&!UrlValidator.isValidUrl(data.internalurl)&&errors.push({field:"documentserverinternal",message:await Str.get_string("validationerror:invalidurl","onlyofficeeditor")}),data.storageurl&&!UrlValidator.isValidUrl(data.storageurl)&&errors.push({field:"storageurl",message:await Str.get_string("validationerror:invalidurl","onlyofficeeditor")}),errors},validateDocumentServerUrl=async url=>{if(!url)throw new Error(await Str.get_string("validationerror:emptyurl","onlyofficeeditor"));if(!UrlValidator.isValidUrl(url))throw new Error(await Str.get_string("validationerror:docsinvalidurl","onlyofficeeditor"));if(UrlValidator.isMixedContent(url))throw new Error(await Str.get_string("validationerror:mixedcontent","onlyofficeeditor"));if(await DocsIntegrationAPI.loadDocsApi(url).catch((e=>{console.log(e)})),"undefined"==typeof DocsAPI||null===DocsAPI)throw new Error(await Str.get_string("validationerror:apijsunavailable","onlyofficeeditor"));DocsIntegrationAPI.removeDocsApi()};return{init:function(){fields.docsurl=document.getElementById("id_s_onlyofficeeditor_documentserverurl"),fields.secret=document.getElementById("id_s_onlyofficeeditor_documentserversecret"),fields.jwtheader=document.getElementById("id_s_onlyofficeeditor_jwtheader"),fields.internalurl=document.getElementById("id_s_onlyofficeeditor_documentserverinternal"),fields.storageurl=document.getElementById("id_s_onlyofficeeditor_storageurl"),fields.disableverifyssl=document.getElementById("id_s_onlyofficeeditor_disable_verify_ssl"),fields.docsurl&&fields.secret&&fields.jwtheader&&fields.internalurl&&fields.storageurl&&fields.disableverifyssl?(checkButton=document.querySelector("button[data-action='check-documentserver-connection']"),checkButton&&checkButton.addEventListener("click",checkDocumentServerConnection)):console.error("One or more required fields are missing in the form.")}}}));

//# sourceMappingURL=check_docserver_button.min.js.map