/**
 * @module mod_onlyofficeeditor/editor
 * @copyright  2025 Ascensio System SIA <integration@onlyoffice.com>
 * @copyright  based on work by 2018 Olumuyiwa Taiwo <muyi.taiwo@logicexpertise.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 **/
define("mod_onlyofficeeditor/editor",["jquery"],(function($){var displayNotification=function(error,type){require(["core/notification"],(function(notification){require(["core/str"],(function(str){var errorIsAvailable=str.get_string(error,"onlyofficeeditor");$.when(errorIsAvailable).done((function(localizedStr){notification.addNotification({message:localizedStr,type:type})}))}))}))};$.urlParam=function(name){var results=new RegExp("[\\?&]"+name+"=([^&#]*)").exec(window.location.href);return null===results?null:decodeURI(results[1])||0};var replaceActionLink=function(href,linkParam){var actionIndex=href.indexOf("&actionType=");return-1!=actionIndex?href.substring(0,actionIndex)+"&actionType="+encodeURIComponent(linkParam.type)+"&actionData="+encodeURIComponent(linkParam.data):href+"&actionType="+encodeURIComponent(linkParam.type)+"&actionData="+encodeURIComponent(linkParam.data)};return{init:function(courseid,cmid){if("undefined"!=typeof DocsAPI){require(["core/str"],(function(str){var enterFullScreenText=str.get_string("editorenterfullscreen","onlyofficeeditor"),exitFullScreenText=str.get_string("editorexitfullscreen","onlyofficeeditor"),navLeftButton=$(".drawertoggle")[1],navRightButton=$(".drawertoggle")[2],editorContainer=$(".onlyofficeeditor-container")[0];$.when(enterFullScreenText).done((function(localized){enterFullScreenText=localized;var enterButton=document.createElement("button"),enterIcon=document.createElement("i");enterIcon.className="icon fa fa-expand fa-fw",enterButton.appendChild(enterIcon),enterButton.className="onlyofficeeditor-editor-fs-button",enterButton.id="onlyofficeeditor-enter-fs-button",enterButton.innerHTML+=enterFullScreenText,enterButton.onclick=function(){$("header").hide(),$("footer").hide(),navLeftButton&&null===navLeftButton.getAttribute("data-aria-hidden-tab-index")&&$(navLeftButton).click(),navRightButton&&null===navRightButton.getAttribute("data-aria-hidden-tab-index")&&$(navRightButton).click(),$(".editmode-switch-form").length>0&&$(".editmode-switch-form")[0][0].checked&&$(editorContainer).addClass("onlyofficeeditor-rightindent"),$(editorContainer).addClass("onlyofficeeditor-fullscreen"),editorContainer.children[0].style.height="93vh",$("#onlyofficeeditor-enter-fs-button").hide(),$("#onlyofficeeditor-exit-fs-button").show()},editorContainer.before(enterButton)})),$.when(exitFullScreenText).done((function(localized){exitFullScreenText=localized;var exitButton=document.createElement("button"),exitIcon=document.createElement("i");exitIcon.className="icon fa fa-compress fa-fw",exitButton.appendChild(exitIcon),exitButton.innerHTML+=exitFullScreenText,exitButton.className="onlyofficeeditor-editor-fs-button",exitButton.id="onlyofficeeditor-exit-fs-button",exitButton.onclick=function(){$(editorContainer).removeClass("onlyofficeeditor-fullscreen"),$(editorContainer).removeClass("onlyofficeeditor-rightindent"),editorContainer.children[0].style.height="95vh",$("header").show(),$("footer").show(),$("#onlyofficeeditor-enter-fs-button").show(),$("#onlyofficeeditor-exit-fs-button").hide()},$("#usernavigation")[0].prepend(exitButton),$("#onlyofficeeditor-exit-fs-button").hide()}))}));var ajaxUrl=M.cfg.wwwroot+"/mod/onlyofficeeditor/dsconfig.php";$.getJSON(ajaxUrl,{courseid:courseid,cmid:cmid,actionType:$.urlParam("actionType"),actionData:$.urlParam("actionData")}).done((function(data){var docEditor=null,config=data.config;document.head.innerHTML+='<link type="image/x-icon" rel="icon" href="/mod/onlyofficeeditor/pix/'+config.documentType+'.ico" />';var canAddInstance=data.addinstance;const innerAlert=(message,inEditor)=>{console&&console.log&&console.log(message),inEditor&&docEditor&&docEditor.showMessage(message)};config.events={onAppReady:()=>{innerAlert("Document editor ready")},onError:event=>{event&&innerAlert(event.data)},onMakeActionLink:function(event){var actionData=event.data.action;docEditor.setActionLink(replaceActionLink(location.href,actionData))}};canAddInstance&&(config.events.onRequestSaveAs=function(event){!function(saveAsData,cmid,courseid){require(["mod_onlyofficeeditor/modal_saveas"],(function(ModalSaveas){ModalSaveas.build(cmid,courseid,saveAsData)}))}({title:event.data.title,url:event.data.url,courseid:courseid,section:null},cmid,courseid)});var usersToMention=data.userstomention;null!==usersToMention&&(config.events.onRequestUsers=function(){docEditor.setUsers({users:usersToMention})},config.events.onRequestSendNotify=function(event){var mentionData={comment:event.data.message,emails:event.data.emails,link:replaceActionLink(location.href,event.data.actionLink.action),courseid:courseid};$.ajax(M.cfg.wwwroot+"/mod/onlyofficeeditor/onlyofficeeditorapi.php?apiType=mention&cmid="+cmid,{type:"POST",dataType:"json",data:mentionData}).fail((()=>{displayNotification("onmentionerror","error")}))}),"pdf"===config.document.fileType&&DocsAPI.DocEditor.version().split(".")[0]<8?displayNotification("oldversion","error"):docEditor=new DocsAPI.DocEditor("onlyofficeeditor-editor",config)}))}else displayNotification("docserverunreachable","error")}}}));

//# sourceMappingURL=editor.min.js.map