# Use cases

## Learning pathway

Program content defines a required learning sequence via a hierarchy of
courses and course sets.

Students are enrolled into courses when assigned to a program. Enrolments
are activated depending on program start dates, completion sequence and
program end dates.

This is one of main use cases.

## Category and cohort enrolment alternative

Programs can be used as a full replacement of category and cohort enrolments.

This is another main use case for programs.

## One course in multiple categories problem

All users see the same course category structure in standard course browsing
interface. One course cannot be in multiple course categories at the same time.

It is possible to used programs for presentation purposes and rely on standard
course enrolment plugins. This way programs can be useful even without user
allocations and program completion tracking.

This use case would benefit from Program catalogue improvements or integration
of programs into standard course browsing interface.

## Course level multi-tenancy

Programs contain a setting for creating of course groups for program members.
If used together with separate group mode then it allows delegation of course
enrolment to different trainers that cannot change each others enrolments.

This use case allows better course separation for non-editing trainers with
enrolment capability.

## Individualised course access scheduling

Course start date and end dates do not affect enrolments in Moodle.
If you put a single course into a program, then program scheduling settings
can be used to automatically restrict students access to course.

This use case illustrates the extra functionality of program allocations
compared to standard enrolment methods.