<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Program enrolment plugin language file.
 *
 * @package    enrol_programs
 * @copyright  2022 Open LMS (https://www.openlms.net/)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addprogram'] = 'Gehitu programa';
$string['addset'] = 'Gehitu sorta berria';
$string['allocationend'] = 'Esleipenaren amaiera';
$string['allocationend_help'] = 'Esleipenaren amaiera-dataren esanahia gaitutako esleipen-iturburuen araberakoa da. Normalean ezin da esleipen berririk egin data hau eta gero, data hori zehaztuz gero.';
$string['allocation'] = 'Esleipen';
$string['allocations'] = 'Esleipen';
$string['programallocations'] = 'Programaren esleipenak';
$string['allocationdate'] = 'Esleipen-data';
$string['allocationsources'] = 'Esleipenaren iturburuak';
$string['allocationstart'] = 'Esleipenaren hasiera';
$string['allocationstart_help'] = 'Esleipenaren hasiera-dataren esanahia gaitutako esleipen-iturburuen araberakoa da. Normalean esleipen berriak data hau eta gero soilik egin daitezke, data hori zehaztuz gero.';
$string['allprograms'] = 'Programa guztiak';
$string['appenditem'] = 'Erantsi elementua';
$string['appendinto'] = 'Erantsi elementuan';
$string['archived'] = 'Artxibatuta';
$string['catalogue'] = 'Programen katalogoa';
$string['catalogue_dofilter'] = 'Bilatu';
$string['catalogue_resetfilter'] = 'Garbitu';
$string['catalogue_searchtext'] = 'Bilatu testua';
$string['catalogue_tag'] = 'Iragazi etiketaren arabera';
$string['certificatetemplatechoose'] = 'Aukeratu txantiloia…';
$string['cohorts'] = 'Ikusgai lan-taldeentzat';
$string['cohorts_help'] = 'Publikoak ez diren programak ikusgai egin daitezke lan-taldeko kide jakinentzat.

Ikusgaitasunaren egoerak ez du eraginik jada esleitutako programetan.';
$string['completiondate'] = 'Osatze-data';
$string['creategroups'] = 'Ikastaro-taldeak';
$string['creategroups_help'] = 'Gaituta badago, talde bat programan gehitutako ikastaro bakoitzean sortuko da , eta esleitutako erabiltzaile guztiak talde-kide gisa gehituko da.';
$string['deleteallocation'] = 'Ezabatu programaren esleipenak';
$string['deletecourse'] = 'Kendu ikastaroa';
$string['deleteprogram'] = 'Ezabatu programa';
$string['deleteset'] = 'Ezabatu sorta';
$string['documentation'] = 'Programs for Moodle dokumentazioaren programak';
$string['duedate'] = 'Muga-eguna';
$string['enrolrole'] = 'Ikastaroko funtzioa';
$string['enrolrole_desc'] = 'Hautatu ikastaroan erregistratzeko programek erabiliko duten funtzioa';
$string['errorcontentproblem'] = 'Arazo bat hauteman da programaren eduki-egituran. Programaren osaeraren jarraipena ez da ongi egingo!';
$string['errordifferenttenant'] = 'Ezin da atzitu beste maizter baten programa';
$string['errornoallocations'] = 'Ez da erabiltzaile-esleipenik aurkitu';
$string['errornoallocation'] = 'Programa esleitu gabe dago';
$string['errornomyprograms'] = 'Ez zaizu inongo programara esleitu.';
$string['errornoprograms'] = 'Ez da aurkitu programarik.';
$string['errornorequests'] = 'Ez da aurkitu eskatutako programarik';
$string['errornotenabled'] = 'Programen plugina gaitu gabe dago';
$string['event_program_completed'] = 'Programa osatu da';
$string['event_program_created'] = 'Programa sortu da';
$string['event_program_deleted'] = 'Programa ezabatu da';
$string['event_program_updated'] = 'Programa eguneratu da';
$string['event_program_viewed'] = 'Programa ikusi da';
$string['event_user_allocated'] = 'Erabiltzailea esleitu da programara';
$string['event_user_deallocated'] = 'Erabiltzaileari programaren esleipena kendu da';
$string['evidence'] = 'Beste froga bat';
$string['evidence_details'] = 'Xehetasunak';
$string['fixeddate'] = 'Data finko batean';
$string['item'] = 'Elementua';
$string['itemcompletion'] = 'Programaren elementua osatu da';
$string['management'] = 'Programaren kudeaketa';
$string['messageprovider:allocation_notification'] = 'Programaren esleipenaren jakinarazpena';
$string['messageprovider:approval_request_notification'] = 'Programa onartzeko eskaeraren jakinarazpena';
$string['messageprovider:approval_reject_notification'] = 'Programaren eskaera baztertu izanaren jakinarazpena';
$string['messageprovider:completion_notification'] = 'Programa osatu izanaren jakinarazpena';
$string['messageprovider:deallocation_notification'] = 'Programaren esleipena kendu izanaren jakinarazpena';
$string['messageprovider:duesoon_notification'] = 'Programaren muga-eguna laster dela adierazteko jakinarazpena';
$string['messageprovider:due_notification'] = 'Programa muga-eguneratu izanaren jakinarazpena';
$string['messageprovider:endsoon_notification'] = 'Programaren amaiera-data laster dela adierazteko jakinarazpena';
$string['messageprovider:endcompleted_notification'] = 'Osatutako programa amaitu izanaren jakinarazpena';
$string['messageprovider:endfailed_notification'] = 'Programa ezin izan dela amaitu adierazteko jakinarazpena';
$string['messageprovider:start_notification'] = 'Programa hasi izanaren jakinarazpena';
$string['moveitem'] = 'Eraman elementua';
$string['moveitemcancel'] = 'Utzi eramatea';
$string['moveafter'] = 'Eraman "{$a->item}" "{$a->target}” atzera';
$string['movebefore'] = 'Eraman "{$a->item}" "{$a->target}" aurrera';
$string['moveinto'] = 'Eraman "{$a->item}" "{$a->target}" elementura';
$string['myprograms'] = 'Nire programak';
$string['notification_allocation'] = 'Erabiltzailea esleitu da';
$string['notification_completion'] = 'Programa osatu da';
$string['notification_completion_subject'] = 'Programa osatu da';
$string['notification_completion_body'] = 'Kaixo, {$a->user_fullname}:

osatu duzu "{$a->program_fullname}” programa.'
;
$string['notification_deallocation'] = 'Erabiltzailearen esleipena kendu da';
$string['notification_duesoon'] = 'Laster programaren muga-eguna izango da';
$string['notification_duesoon_subject'] = 'Programa laster amaitzea espero da';
$string['notification_duesoon_body'] = 'Kaixo, {$a->user_fullname}:

completion of program "{$a->program_fullname}" laster amaitzea espero da ({$a->program_duedate})'
;
$string['notification_due'] = 'Programa muga-eguneratuta dago';
$string['notification_due_subject'] = 'Programa amaituta egotea espero zen';
$string['notification_due_body'] = 'Kaixo, {$a->user_fullname}:

"{$a->program_fullname}" programa {$a->program_duedate} baino lehen amaitzea espero zen.'
;
$string['notification_endsoon'] = 'Laster programaren amaiera-data izango da';
$string['notification_endsoon_subject'] = 'Programa laster amaituko da';
$string['notification_endsoon_body'] = 'Kaixo, {$a->user_fullname}:

"{$a->program_fullname}" programa {$a->program_enddate} datan amaituko da.'
;
$string['notification_endcompleted'] = 'Osatutako programa amaitu da';
$string['notification_endcompleted_subject'] = 'Amaitu da osatutako programa';
$string['notification_endcompleted_body'] = 'Kaixo, {$a->user_fullname}:

"{$a->program_fullname}" programa amaitu da, lehenago amaitu duzu.'
;
$string['notification_endfailed'] = 'Ezin izan da programa amaitu';
$string['notification_endfailed_subject'] = 'Ezin izan da programa amaitu';
$string['notification_endfailed_body'] = 'Kaixo, {$a->user_fullname}:

"{$a->program_fullname}" programa amaitu da, baina ez duzu osatu.'
;
$string['notification_start'] = 'Programa hasi da';
$string['notification_start_subject'] = 'Programa hasi da';
$string['notification_start_body'] = 'Kaixo, {$a->user_fullname}:

"{$a->program_fullname}” programa hasi da.'
;
$string['notificationdates'] = 'Jakinarazpen-datak';
$string['notset'] = 'Ezarri gabe';
$string['plugindisabled'] = 'Programa erregistratzeko plugina desgaituta dago, eta programak ez du funtzionatuko.

[Enable plugin now]({$a->url})';
$string['pluginname'] = 'Programak';
$string['pluginname_desc'] = 'Programak ikastaro sortak sortzeko baimena emateko diseinatu dira.';
$string['privacy:metadata:field:programid'] = 'Programaren IDa';
$string['privacy:metadata:field:userid'] = 'Erabiltzailearen IDa';
$string['privacy:metadata:field:allocationid'] = 'Programaren esleipen-IDa';
$string['privacy:metadata:field:sourceid'] = 'Esleipenaren iturburua';
$string['privacy:metadata:field:itemid'] = 'Elementuaren IDa';
$string['privacy:metadata:field:timecreated'] = 'Sortze-data';
$string['privacy:metadata:field:timecompleted'] = 'Osatze-data';

$string['privacy:metadata:table:enrol_programs_allocations'] = 'Programen esleipenari buruzko informazioa';
$string['privacy:metadata:field:archived'] = 'Erregistroa artxibatuta dago';
$string['privacy:metadata:field:sourcedatajson'] = 'Esleipenaren iturburuari buruzko informazioa';
$string['privacy:metadata:field:timeallocated'] = 'Programaren esleipen-data';
$string['privacy:metadata:field:timestart'] = 'Hasiera-data';
$string['privacy:metadata:field:timedue'] = 'Muga-eguna';
$string['privacy:metadata:field:timeend'] = 'Amaiera-data';
$string['privacy:metadata:field:timenotifiedallocation'] = 'Programaren esleipena jakinarazitako ordua';
$string['privacy:metadata:field:timenotifiedstart'] = 'Hasiera-data jakinarazitako ordua';
$string['privacy:metadata:field:timenotifiedcompleted'] = 'Osatze-data jakinarazitako ordua';
$string['privacy:metadata:field:timenotifiedduesoon'] = 'Muga-eguna gerturatzen ari dela jakinarazitako ordua';
$string['privacy:metadata:field:timenotifieddue'] = 'Muga-eguna iritsi dela jakinarazitako ordua';
$string['privacy:metadata:field:timenotifiedendsoon'] = 'Amaiera-data iristen ari dela jakinarazitako ordua';
$string['privacy:metadata:field:timenotifiedendcompleted'] = 'Programa osatu dela jakinarazitako ordua';
$string['privacy:metadata:field:timenotifiedendfailed'] = 'Programak huts egin duela jakinarazitako ordua';
$string['privacy:metadata:field:timenotifieddeallocation'] = 'Programaren esleipena kendu egin dela jakinarazitako ordua';

$string['privacy:metadata:table:enrol_programs_certs_issues'] = 'Programaren esleipena ziurtatzeko arazoak';
$string['privacy:metadata:field:issueid'] = 'Arazoaren IDa';

$string['privacy:metadata:table:enrol_programs_completions'] = 'Programa-esleipenen osatzeak';

$string['privacy:metadata:table:enrol_programs_evidences'] = 'Beste osatze-froga batzuei buruzko informazioa';
$string['privacy:metadata:field:evidencejson'] = 'Osatu izanaren frogei buruzko informazioa';
$string['privacy:metadata:field:createdby'] = 'Frograren sortzailea';

$string['privacy:metadata:table:enrol_programs_requests'] = 'Esleipen-eskaerari buruzko informazioa';
$string['privacy:metadata:field:datajson'] = 'Eskaerari buruzko informazioa';
$string['privacy:metadata:field:timerequested'] = 'Eskaera-data';
$string['privacy:metadata:field:timerejected'] = 'Baztertze-data';
$string['privacy:metadata:field:rejectedby'] = 'Eskaera baztertu duena';


$string['privacy:metadata:table:enrol_programs_usr_snapshots'] = 'Programa-esleipenen argazkiak';
$string['privacy:metadata:field:reason'] = 'Arrazoia';
$string['privacy:metadata:field:timesnapshot'] = 'Argazkiaren data';
$string['privacy:metadata:field:snapshotby'] = 'Argazkiaren egilea';
$string['privacy:metadata:field:explanation'] = 'Azalpena';
$string['privacy:metadata:field:completionsjson'] = 'Osatzeari buruzko informazioa';
$string['privacy:metadata:field:evidencesjson'] = 'Osatu izanaren frogei buruzko informazioa';

$string['program'] = 'Programa';
$string['programautofix'] = 'Konpondu automatikoki programa';
$string['programdue'] = 'Programaren iraungitze-data';
$string['programdue_help'] = 'Erabiltzaileek programa amaitzea noiz espero den adierazten du programaren iraungitze-datak.';
$string['programdue_delay'] = 'Hasi eta geroko muga-eguna';
$string['programdue_date'] = 'Muga-eguna';
$string['programend'] = 'Programaren amaiera';
$string['programend_help'] = 'Programa amaitu eta gero, erabiltzaileek ezin dute sartu programako ikastaroetan.';
$string['programend_delay'] = 'Amaitu hasi eta gero';
$string['programend_date'] = 'Programaren amaiera-data';
$string['programcompletion'] = 'Programaren osatze-data';
$string['programidnumber'] = 'Programaren ID zenbakia';
$string['programimage'] = 'Programaren irudia';
$string['programname'] = 'Programaren izena';
$string['programurl'] = 'Programaren URLa';
$string['programs'] = 'Programak';
$string['programsactive'] = 'Aktibo';
$string['programsarchived'] = 'Artxibatuta';
$string['programsarchived_help'] = 'Artxibatutako programak erabiltzaileengandik ezkutatuta daude, eta haien aurrerapena blokeatuta dago.';
$string['programstart'] = 'Programaren hasiera';
$string['programstart_help'] = 'Erabiltzaileak ezin dira sartu programako ikastaroetan programa hasi baino lehen.';
$string['programstart_allocation'] = 'Hasi esleitu eta berehala';
$string['programstart_delay'] = 'Atzeratu hasiera esleitu arte';
$string['programstart_date'] = 'Programaren hasiera-data';
$string['programstatus'] = 'Programaren egoera';
$string['programstatus_completed'] = 'Osatuta';
$string['programstatus_any'] = 'Edozein programa-egoera';
$string['programstatus_archived'] = 'Artxibatuta';
$string['programstatus_archivedcompleted'] = 'Artxibatu da';
$string['programstatus_overdue'] = 'Muga-eguneratuta';
$string['programstatus_open'] = 'Ireki';
$string['programstatus_future'] = 'Ez da ireki oraindik';
$string['programstatus_failed'] = 'Huts egin du';
$string['programs:addcourse'] = 'Gehitu ikastaroa programetan';
$string['programs:allocate'] = 'Esleitu ikasleak programetan';
$string['programs:delete'] = 'Ezabatu programak';
$string['programs:edit'] = 'Gehitu eta eguneratu programak';
$string['programs:admin'] = 'Programen kudeaketa aurreratua';
$string['programs:manageevidence'] = 'Kudeatu osatze-froga batzuk';
$string['programs:view'] = 'Ikusi programaren kudeaketa';
$string['programs:viewcatalogue'] = 'Sartu programaren katalogoan';
$string['public'] = 'Publikoa';
$string['public_help'] = 'Erabiltzaile guztiek ikus ditzakete programa publikoak.

Ikusgaitasunaren egoerak ez du eraginik jada esleitutako programetan.';
$string['sequencetype'] = 'Osatze mota';
$string['sequencetype_allinorder'] = 'Dena ordenan';
$string['sequencetype_allinanyorder'] = 'Dena edozein ordenatan';
$string['sequencetype_atleast'] = 'Gutxienez {$a->min}';
$string['selectcategory'] = 'Hautatu kategoria';
$string['source'] = 'Iturburua';
$string['source_approval'] = 'Onarpena duten eskaerak';
$string['source_approval_allownew'] = 'Baimendu onarpenak';
$string['source_approval_allownew_desc'] = 'Baimendu onarpen_iturburuak dituzten eskaera_berriak programetan gehitzea';
$string['source_approval_allowrequest'] = 'Baimendu eskaera berriak';
$string['source_approval_confirm'] = 'Berretsi programako esleipena eskatu nahi duzula.';
$string['source_approval_daterequested'] = 'Eskatutako data';
$string['source_approval_daterejected'] = 'Baztertutako data';
$string['source_approval_makerequest'] = 'Eskatu sarbidea';
$string['source_approval_notification_allocation_subject'] = 'Programa onartu izanaren jakinarazpena';
$string['source_approval_notification_allocation_body'] = 'Kaixo, {$a->user_fullname}:

onartu da "{$a->program_fullname}” programan izena emateko eskaera0. Hasiera-data {$a->program_startdate} da.'
;
$string['source_approval_notification_approval_request_subject'] = 'Programaren eskaeraren jakinarazpena';
$string['source_approval_notification_approval_request_body'] = '
{$a->user_fullname} erabiltzaileak "{$a->program_fullname}” programan sartzeko eskaera egin du.'
;
$string['source_approval_notification_approval_reject_subject'] = 'Programaren eskaera baztertu izanaren jakinarazpena';
$string['source_approval_notification_approval_reject_body'] = 'Kaixo, {$a->user_fullname}:

"{$a->program_fullname}" programa sartzeko eskaera baztertu egin da.

{$a->reason}
';
$string['source_approval_requestallowed'] = 'Eskaerak onartu egiten dira';
$string['source_approval_requestnotallowed'] = 'Eskaerak ez dira onartzen';
$string['source_approval_requests'] = 'Eskaerak';
$string['source_approval_requestpending'] = 'Sartzeko eskaera zain';
$string['source_approval_requestrejected'] = 'Sartzeko eskaera baztertu egin da';
$string['source_approval_requestapprove'] = 'Onartu eskaera';
$string['source_approval_requestreject'] = 'Baztertu eskaera';
$string['source_approval_requestdelete'] = 'Ezabatu eskaera';
$string['source_approval_rejectionreason'] = 'Baztertzek arrazoia';
$string['source_base_notification_allocation_subject'] = 'Programa esleitu izanaren jakinarazpena';
$string['source_base_notification_allocation_body'] = 'Kaixo, {$a->user_fullname}:

"{$a->program_fullname}” programa esleitu zaizu. Hasiera-data {$a->program_startdate} da.'
;
$string['source_base_notification_deallocation_subject'] = 'Programaren esleipena kendu izanaren jakinarazpena';
$string['source_base_notification_deallocation_body'] = 'Kaixo, {$a->user_fullname}:

"{$a->program_fullname}” programaren esleipena kendu zaizu.
';
$string['source_cohort'] = 'Lan-taldeak automatikoki esleitzea';
$string['source_cohort_allownew'] = 'Baimendu lan-taldeak esleitzea';
$string['source_cohort_allownew_desc'] = 'Baimendu -talde_berriaren esleipen_iturburu automatikoak programan gehitzea';
$string['source_manual'] = 'Eskuz esleitzea';
$string['source_manual_allocateusers'] = 'Esleitu erabiltzaileak';
$string['source_manual_csvfile'] = 'CSV fitxategia';
$string['source_manual_hasheaders'] = 'Lehen lerroa goiburua da';
$string['source_manual_potusersmatching'] = 'Bat datozen esleipen-hautagaiak';
$string['source_manual_potusers'] = 'Esleipen-hautagaiak';
$string['source_manual_result_assigned'] = '{$a} erabiltzaile esleitu dira programara.';
$string['source_manual_result_errors'] = '{$a} errore detektatu dira programak esleitzean.';
$string['source_manual_result_skipped'] = '{$a} erabiltzaile esleituta zeuden jada programara.';
$string['source_manual_uploadusers'] = 'Kargatu esleipenak';
$string['source_manual_usercolumn'] = 'Erabiltzaileen identifikazioaren zutabea';
$string['source_manual_usermapping'] = 'Esleitu erabiltzaileak honela';
$string['source_manual_userupload_allocated'] = 'Hona esleituta: \'{$a}\'';
$string['source_manual_userupload_alreadyallocated'] = 'Hona esleituta jada: \'{$a}\'';
$string['source_manual_userupload_invalidprogram'] = 'Ezin da esleitu hona: \'{$a}\'';
$string['source_selfallocation'] = 'Esleitu norbera';
$string['source_selfallocation_allocate'] = 'Erregistratu';
$string['source_selfallocation_allownew'] = 'Baimendu norbera esleitzea';
$string['source_selfallocation_allownew_desc'] = 'Baimendu norbera_berria esleipen_iturbuetara allocation_ sources to programs';
$string['source_selfallocation_allowsignup'] = 'Baimendu erregistro berriak';
$string['source_selfallocation_confirm'] = 'Berretsi programara esleitzea nahi duzula.';
$string['source_selfallocation_enable'] = 'Gaitu norbera esleitzea';
$string['source_selfallocation_key'] = 'Erregistratzeko gakoa';
$string['source_selfallocation_keyrequired'] = 'Erregistratzeko gakoa';
$string['source_selfallocation_maxusers'] = 'Geh. erabiltzaileak';
$string['source_selfallocation_maxusersreached'] = 'Norberak esleitutako erabiltzaileen gehieneko kopurura iritsi da jada';
$string['source_selfallocation_maxusers_status'] = '{$a->count}/{$a->max} erabiltzaile';
$string['source_selfallocation_notification_allocation_subject'] = 'Programa esleitu izanaren jakinarazpena';
$string['source_selfallocation_notification_allocation_body'] = 'Kaixo, {$a->user_fullname}:

"{$a->program_fullname}” programan erregistratu zara. Hasiera-data {$a->program_startdate} da.'
;
$string['source_selfallocation_signupallowed'] = 'Erregistroak baimenduta daude';
$string['source_selfallocation_signupnotallowed'] = 'Erregistroak baimendu gabe daude';
$string['set'] = 'Ikastaroa ezarrita';
$string['settings'] = 'Programaren ezarpenak';
$string['scheduling'] = 'Antolaketa';
$string['taballocation'] = 'Esleipen-ezarpenak';
$string['tabcontent'] = 'Edukia';
$string['tabgeneral'] = 'Orokorra';
$string['tabusers'] = 'Erabiltzaileak';
$string['tabvisibility'] = 'Ikusgaitasunaren ezarpenak';
$string['tagarea_program'] = 'Programak';
$string['taskcertificate'] = 'Cron igortzen duten programen ziurtagiria';
$string['taskcron'] = 'Programen cron plugina';
$string['unlinkeditems'] = 'Askatutako elementuak';
$string['updateprogram'] = 'Eguneratu programa';
$string['updateallocation'] = 'Eguneratu esleipena';
$string['updateallocations'] = 'Eguneratu esleipenak';
$string['updateset'] = 'Eguneratu multzoa';
$string['updatescheduling'] = 'Eguneratu antolaketa';
$string['updatesource'] = 'Eguneratu {$a}';
