<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Program enrolment plugin language file.
 *
 * @package    enrol_programs
 * @copyright  2022 Open LMS (https://www.openlms.net/)
 * @author     Petr Skoda
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addprogram'] = 'Programma toevoegen';
$string['addset'] = 'Nieuwe set toevoegen';
$string['allocationend'] = 'Einde toekenning';
$string['allocationend_help'] = 'De betekenis van de einddatum van de toewijzing is afhankelijk van ingeschakelde toewijzingsbronnen. Gewoonlijk is een nieuwe toewijzing na deze datum, indien gespecificeerd, niet meer mogelijk.';
$string['allocation'] = 'Toekenning';
$string['allocations'] = 'Toekenningen';
$string['programallocations'] = 'Programmatoekenningen';
$string['allocationdate'] = 'Toekenningsdatum';
$string['allocationsources'] = 'Toekenningsbronnen';
$string['allocationstart'] = 'Start toekenning';
$string['allocationstart_help'] = 'De betekenis van de startdatum van de toewijzing is afhankelijk van ingeschakelde toewijzingsbronnen. Gewoonlijk is een nieuwe toewijzing alleen na deze datum, indien gespecificeerd, mogelijk.';
$string['allprograms'] = 'Alle programma\'s';
$string['appenditem'] = 'Nieuw item toevoegen';
$string['appendinto'] = 'In item toevoegen';
$string['archive'] = 'Archiveren';
$string['archived'] = 'Gearchiveerd';
$string['benefitname'] = '{$a}: Programmatoewijzing';
$string['calendarprogramend'] = '{$a} eindigt';
$string['calendarprogramdue'] = '{$a} is gepland';
$string['calendarprogramstart'] = '{$a} begint';
$string['catalogue'] = 'Programmacatalogus';
$string['catalogue_dofilter'] = 'Zoeken';
$string['catalogue_resetfilter'] = 'Wissen';
$string['catalogue_searchtext'] = 'Tekst zoeken';
$string['catalogue_tag'] = 'Filteren op basis van tag';
$string['certificatetemplatechoose'] = 'Een sjabloon kiezen...';
$string['cohorts'] = 'Zichtbaar voor sitegroepen';
$string['cohorts_help'] = 'Niet-openbare programma\'s kunnen zichtbaar worden gemaakt voor bepaalde sitegroepleden.

De zichtbaarheidsstatus heeft geen invloed op reeds toegewezen programma\'s.';
$string['columnusedalready'] = 'Kolom wordt al gebruikt';
$string['completiondate'] = 'Voltooiingsdatum';
$string['completiondelay'] = 'Voltooiingsvertraging';
$string['completionoverride'] = 'Voltooiing overschrijven';
$string['creategroups'] = 'Cursusgroepen';
$string['creategroups_help'] = 'Als deze optie is ingeschakeld, wordt een groep gemaakt in elke cursus die aan het programma is toegevoegd en worden alle toegekende gebruikers als groepsleden toegevoegd.';
$string['customfields'] = 'Aangepaste programmavelden';
$string['customfieldsettings'] = 'Algemene instellingen aangepaste programmavelden';
$string['customfieldvisibleto'] = 'Veldinhoud is zichtbaar voor';
$string['customfieldvisible:allocated'] = 'Gebruikers toegewezen aan programma\'s';
$string['customfieldvisible:everyone'] = 'Iedereen die andere programmadetails kan zien';
$string['customfieldvisible:viewcapability'] = 'Gebruikers met de mogelijkheid om programma\'s te bekijken';
$string['deleteallocation'] = 'Programmatoewijzing verwijderen';
$string['deletecourse'] = 'Cursus verwijderen';
$string['deleteprogram'] = 'Programma verwijderen';
$string['deleteset'] = 'Set verwijderen';
$string['deletetraining'] = 'Training verwijderen';
$string['documentation'] = 'Programma\'s voor Moodle-documentatie';
$string['duedate'] = 'Einddatum';
$string['enrolrole'] = 'Cursusrol';
$string['enrolrole_desc'] = 'Selecteer de rol die wordt gebruikt door programma\'s voor cursusinschrijving';
$string['errorcontentproblem'] = 'Probleem gedetecteerd in de structuur van de programma-inhoud, de voltooiing van het programma wordt niet correct gevolgd!';
$string['errorcoursemissing'] = 'Cursus ontbreekt';
$string['errorcoursesmissing'] = 'Ontbrekende cursussen: {$a}';
$string['errorinvalidoverridedates'] = 'Ongeldige datumoverschrijvingen';
$string['errordifferenttenant'] = 'Programma van een andere tenant kan niet worden geopend';
$string['errornoallocations'] = 'Geen gebruikerstoekenningen gevonden';
$string['errornoallocation'] = 'Programma is niet toegekend';
$string['errornomyprograms'] = 'U bent aan geen enkel programma toegekend.';
$string['errornoprograms'] = 'Geen programma\'s gevonden.';
$string['errornorequests'] = 'Geen programma-aanvragen gevonden';
$string['errornotenabled'] = 'Programmaplugin is niet ingeschakeld';
$string['event_program_completed'] = 'Programma voltooid';
$string['event_program_created'] = 'Programma aangemaakt';
$string['event_program_deleted'] = 'Programma verwijderd';
$string['event_program_updated'] = 'Programma bijgewerkt';
$string['event_program_viewed'] = 'Programma bekeken';
$string['event_user_allocated'] = 'Gebruiker toegekend aan programma';
$string['event_user_deallocated'] = 'Gebruiker uitgeschreven uit programma';
$string['evidence'] = 'Ander bewijs';
$string['evidencedate'] = 'Voltooiingsdatum bewijs';
$string['evidenceupdate'] = 'Ander bewijs bijwerken';
$string['evidenceupload'] = 'Voltooiingsbewijzen uploaden';
$string['evidenceupload_csvfile'] = 'CSV-bestand';
$string['evidenceupload_errors'] = '{$a} ongeldige rijen gedetecteerd';
$string['evidenceupload_skipped'] = '{$a} rijen overgeslagen';
$string['evidenceupload_updated'] = 'Voltooiingsbewijs bijgewerkt voor {$a} gebruikers';
$string['evidence_details'] = 'Details';
$string['evidence_detailsdefault'] = 'Standaarddetails';
$string['export'] = 'Programma\'s exporteren';
$string['exportfile_info'] = 'info';
$string['exportfile_programs'] = 'programma\'s';
$string['exportformat'] = 'Bestandsformaat';
$string['exportformat_csv'] = 'CSV';
$string['exportformat_json'] = 'JSON';
$string['extra_menu_management_index'] = 'Programma-acties';
$string['extra_menu_management_program_general'] = 'Programma-acties';
$string['extra_menu_management_program_users'] = 'Gebruikersacties';
$string['extra_menu_management_program_allocation'] = 'Toewijzingsacties';
$string['fixeddate'] = 'Op een vaste datum';
$string['importallocationend'] = 'Einde toewijzing ({$a})';
$string['importallocationstart'] = 'Start toewijzing ({$a})';
$string['importprogramallocation'] = 'Programmatoewijzing importeren';
$string['importprogramallocationconfirmation'] = 'U importeert alle toewijzingsinstellingen van programma __{$a->fullname} / {$a->idnumber} / {$a->category}__.

Selecteer alle instellingen die u wilt importeren.';
$string['importprogramcontent'] = 'Programma-inhoud importeren';
$string['importprogramcontentconfirmation'] = 'U importeert inhoud van programma __{$a->fullname} / {$a->idnumber} / {$a->category}__.';
$string['importprogramdue'] = 'Programmadeadline ({$a})';
$string['importprogramend'] = 'Programmaeind ({$a})';
$string['importprogramstart'] = 'Programmabegin ({$a})';
$string['importselectprogram'] = 'Programma selecteren';
$string['invalidallocationdates'] = 'Ongeldige programmatoewijzingsdatums';
$string['invalidcompletiondate'] = 'Ongeldige programmavoltooiingsdatum';
$string['item'] = 'Item';
$string['itemcompletion'] = 'Voltooiing programma-item';
$string['itempoints'] = 'Punten';
$string['itemrecalculate'] = 'Itemvoltooiing herberekenen';
$string['management'] = 'Programmabeheer';
$string['messageprovider:allocation_notification'] = 'Melding programmatoewijzing';
$string['messageprovider:approval_request_notification'] = 'Melding aanvraag goedkeuring programma';
$string['messageprovider:approval_reject_notification'] = 'Melding weigering aanvraag programma';
$string['messageprovider:completion_notification'] = 'Melding voltooiing programma';
$string['messageprovider:completion_relateduser_notification'] = 'Melding voltooiing programma - gerelateerde gebruiker';
$string['messageprovider:deallocation_notification'] = 'Melding uitschrijving programma';
$string['messageprovider:duesoon_notification'] = 'Melding binnenkort deadline programma';
$string['messageprovider:duesoon_relateduser_notification'] = 'Melding binnenkort deadline programma bereikt - gerelateerde gebruiker';
$string['messageprovider:due_notification'] = 'Melding programma te laat';
$string['messageprovider:due_relateduser_notification'] = 'Melding programma te laat - gerelateerde gebruiker';
$string['messageprovider:endsoon_notification'] = 'Melding binnenkort einddatum programma';
$string['messageprovider:endsoon_relateduser_notification'] = 'Melding binnenkort einddatum programma - gerelateerde gebruiker';
$string['messageprovider:endcompleted_notification'] = 'Melding beëindiging voltooid programma';
$string['messageprovider:endfailed_notification'] = 'Melding beëindiging mislukt programma';
$string['messageprovider:endfailed_relateduser_notification'] = 'Melding beëindiging mislukt programma - gerelateerde gebruiker';
$string['messageprovider:reset_notification'] = 'Resetmelding programma';
$string['messageprovider:start_notification'] = 'Melding gestart programma';
$string['moveitem'] = 'Item verplaatsen';
$string['moveitemcancel'] = 'Verplaatsing annuleren';
$string['moveafter'] = 'Verplaats "{$a->item}" na "{$a->target}"';
$string['movebefore'] = 'Verplaats "{$a->item}" vóór "{$a->target}"';
$string['moveinto'] = 'Verplaats "{$a->item}" naar "{$a->target}"';
$string['myprograms'] = 'Mijn programma\'s';
$string['notification_allocation'] = 'Gebruiker toegekend';
$string['notification_allocation_subject'] = 'Melding programmatoewijzing';
$string['notification_allocation_body'] = 'Hallo {$a->user_fullname},

u bent toegewezen aan programma "{$a->program_fullname}", de startdatum is {$a->program_startdate}.
';
$string['notification_allocation_description'] = 'Melding verzonden naar gebruikers wanneer ze zijn toegewezen aan programma.';
$string['notification_completion'] = 'Programma voltooid';
$string['notification_completion_subject'] = 'Programma voltooid';
$string['notification_completion_body'] = 'Hallo {$a->user_fullname},

u hebt programma "{$a->program_fullname}" voltooid.
';
$string['notification_completion_description'] = 'Melding verzonden naar gebruikers wanneer ze hun programma hebben voltooid.';
$string['notification_completion_relateduser'] = 'Programma voltooid - gerelateerde gebruiker';
$string['notification_completion_relateduser_subject'] = 'Gebruiker {$a->user_fullname} heeft programma voltooid';
$string['notification_completion_relateduser_body'] = 'Hallo {$a->relateduser_fullname},

gebruiker {$a->user_fullname} heeft programma "{$a->program_fullname}" voltooid.
';
$string['notification_completion_relateduser_description'] = 'Melding verzonden naar gebruikers gerelateerd aan gebruiker wanneer ze hun programma hebben voltooid.';
$string['notification_deallocation'] = 'Gebruiker uitgeschreven';
$string['notification_deallocation_subject'] = 'Melding uitschrijving programma';
$string['notification_deallocation_body'] = 'Hallo {$a->user_fullname},

u bent uitgeschreven voor programma "{$a->program_fullname}".
';
$string['notification_deallocation_description'] = 'Melding verzonden naar gebruikers wanneer ze voor het programma zijn uitgeschreven.';
$string['notification_duesoon'] = 'Binnenkort deadline programma bereikt';
$string['notification_duesoon_subject'] = 'Voltooiing van het programma wordt binnenkort verwacht';
$string['notification_duesoon_body'] = 'Hallo {$a->user_fullname},

voltooiing van programma "{$a->program_fullname}" wordt verwacht op {$a->program_duedate}.
';
$string['notification_duesoon_description'] = 'Melding verzonden naar gebruikers vóór de voltooiingsdatum van het programma, tenzij het programma al is voltooid.';
$string['notification_duesoon_relateduser'] = 'Binnenkort deadline programma bereikt - gerelateerde gebruiker';
$string['notification_duesoon_relateduser_subject'] = 'Voltooiing van programma wordt binnenkort verwacht voor gebruiker {$a->user_fullname}';
$string['notification_duesoon_relateduser_body'] = 'Hallo {$a->relateduser_fullname},

voltooiing van programma "{$a->program_fullname}" voor gebruiker {$a->user_fullname} wordt verwacht op {$a->program_duedate}.
';
$string['notification_duesoon_relateduser_description'] = 'Melding verzonden naar gebruikers gerelateerd aan gebruiker vóór de voltooiingsdatum van het programma, tenzij het programma al is voltooid.';
$string['notification_due'] = 'Programma te laat';
$string['notification_due_subject'] = 'Voltooiing van het programma werd verwacht';
$string['notification_due_body'] = 'Hallo {$a->user_fullname},

voltooiing van programma "{$a->program_fullname}" was verwacht vóór {$a->program_duedate}.
';
$string['notification_due_description'] = 'Melding verzonden naar gebruikers wanneer hun programma te laat is voltooid.';
$string['notification_due_relateduser'] = 'Programma te laat - gerelateerde gebruiker';
$string['notification_due_relateduser_subject'] = 'Voltooiing van programma werd verwacht voor gebruiker {$a->user_fullname}';
$string['notification_due_relateduser_body'] = 'Hallo {$a->relateduser_fullname},

voltooiing van programma "{$a->program_fullname}" voor gebruiker {$a->user_fullname} werd verwacht op {$a->program_duedate}.
';
$string['notification_due_relateduser_description'] = 'Melding verzonden naar gebruikers gerelateerd aan gebruiker wanneer hun programma te laat is voltooid.';
$string['notification_endsoon'] = 'Binnenkort einddatum programma';
$string['notification_endsoon_subject'] = 'Programma eindigt binnenkort';
$string['notification_endsoon_body'] = 'Hallo {$a->user_fullname},

programma "{$a->program_fullname}" eindigt op {$a->program_enddate}.
';
$string['notification_endsoon_description'] = 'Melding verzonden naar gebruikers vóór de einddatum van het programma, tenzij het programma al is voltooid.';
$string['notification_endsoon_relateduser'] = 'Binnenkort einddatum programma - gerelateerde gebruiker';
$string['notification_endsoon_relateduser_subject'] = 'Programma eindigt binnenkort voor gebruiker {$a->user_fullname}';
$string['notification_endsoon_relateduser_body'] = 'Hallo {$a->relateduser_fullname},

programma "{$a->program_fullname}" voor gebruiker {$a->user_fullname} eindigt op {$a->program_enddate}.
';
$string['notification_endsoon_relateduser_description'] = 'Melding verzonden naar gebruikers gerelateerd aan gebruiker vóór de einddatum van het programma, tenzij het programma al is voltooid.';
$string['notification_endcompleted'] = 'Voltooid programma beëindigd';
$string['notification_endcompleted_subject'] = 'Voltooid programma beëindigd';
$string['notification_endcompleted_body'] = 'Hallo {$a->user_fullname},

programma "{$a->program_fullname}" is beëindigd, u hebt het eerder voltooid.
';
$string['notification_endcompleted_description'] = 'Melding verzonden naar gebruikers wanneer hun voltooide programma eindigt.';
$string['notification_endfailed'] = 'Mislukt programma beëindigd';
$string['notification_endfailed_subject'] = 'Mislukt programma beëindigd';
$string['notification_endfailed_body'] = 'Hallo {$a->user_fullname},

programma "{$a->program_fullname}" is beëindigd, u hebt het niet voltooid.
';
$string['notification_endfailed_description'] = 'Melding verzonden naar gebruikers wanneer het programma dat ze niet hebben voltooid, eindigt.';
$string['notification_endfailed_relateduser'] = 'Beëindiging mislukt programma - gerelateerde gebruiker';
$string['notification_endfailed_relateduser_subject'] = 'Beëindiging mislukt programma voor gebruiker {$a->user_fullname}';
$string['notification_endfailed_relateduser_body'] = 'Hallo {$a->relateduser_fullname},

programma "{$a->program_fullname}" is beëindigd en gebruiker {$a->user_fullname} heeft het niet voltooid.
';
$string['notification_endfailed_relateduser_description'] = 'Melding verzonden naar gebruikers gerelateerd aan gebruiker wanneer het programma dat ze niet hebben voltooid, eindigt.';
$string['notification_relateduserfield'] = 'Veld gerelateerde gebruiker melding';
$string['notification_relateduserfield_desc'] = 'Selecteer het profielveld voor gerelateerde gebruikers dat moet worden gebruikt voor melding aan gerelateerde gebruikers.';
$string['notification_reset'] = 'Voortgang gebruikers resetten';
$string['notification_reset_subject'] = 'Resetmelding programma';
$string['notification_reset_body'] = 'Hallo {$a->user_fullname},

uw voortgang in programma "{$a->program_fullname}" is gereset.
';
$string['notification_reset_description'] = 'Melding verzonden naar gebruikers wanneer de voortgang van hun programma is gereset.';
$string['notification_start'] = 'Programma gestart';
$string['notification_start_subject'] = 'Programma gestart';
$string['notification_start_body'] = 'Hallo {$a->user_fullname},

programma "{$a->program_fullname}" is gestart.
';
$string['notification_start_description'] = 'Melding verzonden naar gebruikers wanneer hun programma is gestart.';
$string['notificationdates'] = 'Meldingsdatums';
$string['notset'] = 'Niet ingesteld';
$string['plugindisabled'] = 'De plug-in van de programma-inschrijving is uitgeschakeld, programma\'s zullen niet functioneel zijn.

[Enable plugin now]({$a->url})';
$string['pluginname'] = 'Programma\'s';
$string['pluginname_desc'] = 'Programma\'s zijn ontworpen om het maken van cursussets mogelijk te maken.';
$string['privacy:metadata:field:programid'] = 'Programma-ID';
$string['privacy:metadata:field:userid'] = 'Gebruikers-ID';
$string['privacy:metadata:field:allocationid'] = 'ID programmatoewijzing';
$string['privacy:metadata:field:sourceid'] = 'Bron van toekenning';
$string['privacy:metadata:field:itemid'] = 'Item-ID';
$string['privacy:metadata:field:timecreated'] = 'Aanmaakdatum';
$string['privacy:metadata:field:timecompleted'] = 'Voltooiingsdatum';

$string['privacy:metadata:table:enrol_programs_allocations'] = 'Informatie over programmatoekenningen';
$string['privacy:metadata:field:archived'] = 'Is de record gearchiveerd';
$string['privacy:metadata:field:sourcedatajson'] = 'Informatie over de bron van de toekenning';
$string['privacy:metadata:field:timeallocated'] = 'Datum programmatoekenning';
$string['privacy:metadata:field:timestart'] = 'Startdatum';
$string['privacy:metadata:field:timedue'] = 'Einddatum';
$string['privacy:metadata:field:timeend'] = 'Einddatum';

$string['privacy:metadata:table:enrol_programs_certs_issues'] = 'Problemen met certificaten voor programmatoekenningen';
$string['privacy:metadata:field:issueid'] = 'Probleem-ID';

$string['privacy:metadata:table:enrol_programs_completions'] = 'Voltooiingen programmatoekenning';

$string['privacy:metadata:table:enrol_programs_evidences'] = 'Informatie over andere bewijzen van voltooiing';
$string['privacy:metadata:field:evidencejson'] = 'Informatie over bewijs van voltooiing';
$string['privacy:metadata:field:createdby'] = 'Bewijs gemaakt door';

$string['privacy:metadata:table:enrol_programs_requests'] = 'Informatie over toekenningsaanvraag';
$string['privacy:metadata:field:datajson'] = 'Informatie over de aanvraag';
$string['privacy:metadata:field:timerequested'] = 'Aanvraagdatum';
$string['privacy:metadata:field:timerejected'] = 'Afwijzingsdatum';
$string['privacy:metadata:field:rejectedby'] = 'Aanvraag afgewezen door';


$string['privacy:metadata:table:enrol_programs_usr_snapshots'] = 'Snapshots programmatoekenning';
$string['privacy:metadata:field:reason'] = 'Reden';
$string['privacy:metadata:field:timesnapshot'] = 'Snapshotdatum';
$string['privacy:metadata:field:snapshotby'] = 'Snapshot door';
$string['privacy:metadata:field:explanation'] = 'Verklaring';
$string['privacy:metadata:field:completionsjson'] = 'Informatie over voltooiing';
$string['privacy:metadata:field:evidencesjson'] = 'Informatie over bewijs van voltooiing';

$string['privacy:metadata:table:enrol_programs_src_commholds'] = 'Reserveringen voor commercetoewijzing';
$string['privacy:metadata:field:quantity'] = 'Aantal';

$string['program'] = 'Programma';
$string['programautofix'] = 'Autom. reparatieprogramma';
$string['programdue'] = 'Programma-deadline';
$string['programdue_help'] = 'De programma-deadline geeft aan wanneer gebruikers het programma moeten voltooien.';
$string['programdue_delay'] = 'Deadline na start';
$string['programdue_date'] = 'Einddatum';
$string['programend'] = 'Programma-einde';
$string['programend_help'] = 'Gebruikers kunnen na afloop van het programma geen programmacursussen meer openen.';
$string['programend_delay'] = 'Einde na start';
$string['programend_date'] = 'Einddatum programma';
$string['programcompletion'] = 'Voltooiingsdatum programma';
$string['programcompletionoverride'] = 'Programmavoltooiing overschrijven';
$string['programidnumber'] = 'Programma-ID-nummer';
$string['programimage'] = 'Programma-afbeelding';
$string['programname'] = 'Programmanaam';
$string['programurl'] = 'Programma-URL';
$string['programs'] = 'Programma\'s';
$string['programsactive'] = 'Actief';
$string['programsarchived'] = 'Gearchiveerd';
$string['programsarchived_help'] = 'Gearchiveerde programma\'s zijn verborgen voor gebruikers en hun voortgang is vergrendeld.';
$string['programstart'] = 'Start programma';
$string['programstart_help'] = 'Gebruikers kunnen geen programmacursussen openen voordat het programma start.';
$string['programstart_allocation'] = 'Onmiddellijk starten na toekenning';
$string['programstart_delay'] = 'Start vertragen na toekenning';
$string['programstart_date'] = 'Begindatum programma';
$string['programstatus'] = 'Programmastatus';
$string['programstatus_completed'] = 'Voltooid';
$string['programstatus_any'] = 'Elke programmastatus';
$string['programstatus_archived'] = 'Gearchiveerd';
$string['programstatus_archivedcompleted'] = 'Gearchiveerd voltooid';
$string['programstatus_overdue'] = 'Te laat';
$string['programstatus_open'] = 'Open';
$string['programstatus_future'] = 'Nog niet open';
$string['programstatus_failed'] = 'Mislukt';
$string['programs:addcourse'] = 'Cursus toevoegen aan programma\'s';
$string['programs:addtocertifications'] = 'Programma toevoegen aan certificeringen';
$string['programs:addtoplan'] = 'Programma toevoegen aan plannen';
$string['programs:allocate'] = 'Studenten toewijzen aan programma\'s';
$string['programs:archive'] = 'Programmatoewijzingen archiveren';
$string['programs:clone'] = 'Klonen van programma-inhoud en -instellingen toestaan';
$string['programs:configframeworks'] = 'Beschikbaarheid van programma\'s configureren in plankaders';
$string['programs:configurecustomfields'] = 'Aangepaste programmavelden configureren';
$string['programs:delete'] = 'Programma\'s verwijderen';
$string['programs:edit'] = 'Programma\'s toevoegen en bijwerken';
$string['programs:export'] = 'Programma\'s exporteren';
$string['programs:admin'] = 'Geavanceerd programmabeheer';
$string['programs:manageallocation'] = 'Gebruikerstoewijzingen beheren';
$string['programs:manageevidence'] = 'Ander bewijs van voltooiing beheren';
$string['programs:reset'] = 'Voortgang programma\'s resetten';
$string['programs:upload'] = 'Programma\'s uploaden';
$string['programs:view'] = 'Programmabeheer weergeven';
$string['programs:viewcatalogue'] = 'Programmacatalogus openen';
$string['public'] = 'Openbaar';
$string['public_help'] = 'Openbare programma\'s zijn zichtbaar voor alle gebruikers.

De zichtbaarheidsstatus heeft geen invloed op reeds toegekende programma\'s.';
$string['purchaseaccess'] = 'Toegang kopen';
$string['resetallocation'] = 'Voortgang programma\'s resetten';
$string['resettype'] = 'Resettype';
$string['resettype_deallocate'] = 'Alleen uitschrijving uit programma';
$string['resettype_full'] = 'Volledige cursus verwijderen';
$string['resettype_none'] = 'Geen';
$string['resettype_standard'] = 'Verwijdering standaardcursus';
$string['sequencetype'] = 'Voltooiingstype';
$string['sequencetype_allinorder'] = 'Alles op volgorde';
$string['sequencetype_allinanyorder'] = 'Alles in elke volgorde';
$string['sequencetype_atleast'] = 'Minimaal {$a->min}';
$string['sequencetype_minpoints'] = 'Minimaal {$a->minpoints} punten';
$string['selectcategory'] = 'Categorie selecteren';
$string['source'] = 'Bron';
$string['source_approval'] = 'Aanvragen met goedkeuring';
$string['source_approval_allownew'] = 'Goedkeuringen toestaan';
$string['source_approval_allownew_desc'] = 'Toevoegen van nieuwe bronnen van _aanvragen met goedkeuring_ aan programma\'s toestaan';
$string['source_approval_allowrequest'] = 'Nieuwe aanvragen toestaan';
$string['source_approval_confirm'] = 'Bevestig dat u toekenning aan het programma wilt aanvragen.';
$string['source_approval_daterequested'] = 'Datum van aanvraag';
$string['source_approval_daterejected'] = 'Datum afgewezen';
$string['source_approval_makerequest'] = 'Toegang aanvragen';
$string['source_approval_notification_approval_request_subject'] = 'Melding programma-aanvraag';
$string['source_approval_notification_approval_request_body'] = '
Gebruiker {$a->user_fullname} heeft toegang aangevraagd tot programma "{$a->program_fullname}".
';
$string['source_approval_notification_approval_reject_subject'] = 'Melding weigering aanvraag programma';
$string['source_approval_notification_approval_reject_body'] = 'Hallo {$a->user_fullname},

uw aanvraag voor toegang tot programma "{$a->program_fullname}" is afgewezen.

{$a->reason}
';
$string['source_approval_requestallowed'] = 'Aanvragen zijn toegestaan';
$string['source_approval_requestnotallowed'] = 'Aanvragen zijn niet toegestaan';
$string['source_approval_requests'] = 'Aanvragen';
$string['source_approval_requestpending'] = 'Toegangsaanvraag in behandeling';
$string['source_approval_requestrejected'] = 'Toegangsaanvraag is afgewezen';
$string['source_approval_requestapprove'] = 'Aanvraag goedkeuren';
$string['source_approval_requestreject'] = 'Aanvraag afwijzen';
$string['source_approval_requestdelete'] = 'Aanvraag verwijderen';
$string['source_approval_rejectionreason'] = 'Reden afwijzing';
$string['source_certify'] = 'Certificeringen';
$string['source_certify_allownew'] = 'Toewijzing certificeringen toestaan';
$string['source_certify_allownew_desc'] = 'Toestaan dat nieuwe bronnen van _certificering_ aan programma\'s worden toegevoegd';
$string['source_cohort'] = 'Automatische sitegroeptoekenning';
$string['source_cohort_allownew'] = 'Sitegroeptoekenning toestaan';
$string['source_cohort_allownew_desc'] = 'Toevoegen van nieuwe bronnen van _automatische sitegroeptoekenning_ aan programma\'s toestaan';
$string['source_cohort_cohortstoallocate'] = 'Sitegroepen toewijzen';
$string['source_ecommerce'] = 'E-commerce toewijzen';
$string['source_ecommerce_allownew'] = 'Toewijzing e-commerce toestaan';
$string['source_ecommerce_allownew_desc'] = 'Toestaan dat nieuwe bronnen voor automatische toewijzing van e-commerce aan programma\'s worden toegevoegd';
$string['source_ecommerce_allowsignup'] = 'Nieuwe toekenningen toestaan';
$string['source_ecommerce_cohortmembershiprequirement'] = 'Gebruikers moeten lid zijn van een van de volgende sitegroepen: {$a}';
$string['source_ecommerce_maxusers'] = 'Maximale aantal gebruikers';
$string['source_ecommerce_nocapacity'] = 'Er is geen resterende capaciteit in dit programma';
$string['source_manual'] = 'Manueel toewijzen';
$string['source_manual_allocateusers'] = 'Gebruikers toewijzen';
$string['source_manual_csvfile'] = 'CSV-bestand';
$string['source_manual_hasheaders'] = 'Eerste regel is koptekst';
$string['source_manual_potusersmatching'] = 'Overeenkomende toekenningskandidaten';
$string['source_manual_potusers'] = 'Toekenningskandidaten';
$string['source_manual_result_assigned'] = 'Er zijn {$a} gebruikers toegewezen aan programma.';
$string['source_manual_result_errors'] = '{$a} fouten gedetecteerd bij toewijzen van programma\'s.';
$string['source_manual_result_skipped'] = 'Er zijn al {$a} gebruikers toegewezen aan programma.';
$string['source_manual_timeduecolumn'] = 'Kolom deadline';
$string['source_manual_timeendcolumn'] = 'Kolom tijd eind';
$string['source_manual_timestartcolumn'] = 'Kolom tijd start';
$string['source_manual_uploadusers'] = 'Toekenningen uploaden';
$string['source_manual_usercolumn'] = 'Kolom gebruikersidentificatie';
$string['source_manual_usermapping'] = 'Mapping van gebruikers via';
$string['source_manual_userupload_allocated'] = 'Toegewezen aan \'{$a}\'';
$string['source_manual_userupload_alreadyallocated'] = 'Al toegewezen aan \'{$a}\'';
$string['source_manual_userupload_invalidprogram'] = 'Kan niet toewijzen aan \'{$a}\'';
$string['source_selfallocation'] = 'Zelftoekenning';
$string['source_selfallocation_allocate'] = 'Aanmelden';
$string['source_selfallocation_allownew'] = 'Zelftoekenning toestaan';
$string['source_selfallocation_allownew_desc'] = 'Toevoegen van nieuwe bronnen van _zelftoekenning_ aan programma\'s toestaan';
$string['source_selfallocation_allowsignup'] = 'Nieuwe aanmeldingen toestaan';
$string['source_selfallocation_confirm'] = 'Bevestig dat u wilt worden toegekend aan het programma.';
$string['source_selfallocation_enable'] = 'Zelftoekenning inschakelen';
$string['source_selfallocation_key'] = 'Aanmeldsleutel';
$string['source_selfallocation_keyrequired'] = 'Aanmeldsleutel is vereist';
$string['source_selfallocation_maxusers'] = 'Maximale aantal gebruikers';
$string['source_selfallocation_maxusersreached'] = 'Maximumaantal van zelftoegekende gebruikers is al bereikt';
$string['source_selfallocation_maxusers_status'] = 'Gebruikers {$a->count}/{$a->max}';
$string['source_selfallocation_signupallowed'] = 'Aanmeldingen zijn toegestaan';
$string['source_selfallocation_signupnotallowed'] = 'Aanmeldingen zijn niet toegestaan';
$string['source_udplans'] = 'Ontwikkelingsplannen gebruiker';
$string['source_udplans_allownew'] = 'Ontwikkelingsplannen gebruiker';
$string['source_udplans_allownew_desc'] = 'Nieuwe bronnen van _ontwikkelingsplannen gebruiker_ aan programma\'s toevoegen toestaan';
$string['source_udplans_allowed'] = 'Toegelaten';
$string['source_udplans_noframeworks'] = 'Kan niet aan enig plan worden toegevoegd';
$string['source_udplans_notallowed'] = 'Niet toegestaan';
$string['source_udplans_requirecap'] = 'Vereiste mogelijkheid toevoegena';
$string['set'] = 'Cursusset';
$string['settings'] = 'Programma-instellingen';
$string['scheduling'] = 'Planning';
$string['taballocation'] = 'Toekenningsinstellingen';
$string['tabcontent'] = 'Inhoud';
$string['tabgeneral'] = 'Algemeen';
$string['tabusers'] = 'Gebruikers';
$string['tabvisibility'] = 'Zichtbaarheidsinstellingen';
$string['tagarea_program'] = 'Programma\'s';
$string['taskcertificate'] = 'Cron afgifte programmacertificaat';
$string['taskcron'] = 'Cron plugin programma\'s';
$string['training'] = 'Training';
$string['trainingcompletion'] = 'Vereiste training: {$a}';
$string['trainingprogress'] = 'Trainingsvoortgang: {$a->current}/{$a->total}';
$string['unarchive'] = 'Herstellen';
$string['unlinkeditems'] = 'Niet-gekoppelde items';
$string['updateprogram'] = 'Programma bijwerken';
$string['updateallocation'] = 'Toekenning bijwerken';
$string['updateallocations'] = 'Toekenningen bijwerken';
$string['updatecourse'] = 'Cursus bijwerken';
$string['updateset'] = 'Set bijwerken';
$string['updatescheduling'] = 'Planning bijwerken';
$string['updatesource'] = '{$a} bijwerken';
$string['updatetraining'] = 'Training bijwerken';
$string['upload'] = 'Programma\'s uploaden';
$string['upload_invalidcount'] = 'Ongeldige records';
$string['upload_files'] = 'Bestanden';
$string['upload_files_error'] = 'Er worden meerdere CSV-bestanden, één JSON-bestand of één Zip-archief verwacht';
$string['upload_preview'] = 'Voorbeeld van gegevens bekijken';
$string['upload_status'] = 'Status';
$string['upload_status_invalid'] = 'Ongeldig';
$string['upload_targetcontext'] = 'Programma\'s in context toevoegen';
$string['upload_uploadcount'] = 'Programma\'s voor uploaden';
$string['upload_usecategory'] = 'Categoriekolom gebruiken voor contexten';
$string['userupload_completion_error'] = 'Programmavoltooiing kan niet worden bijgewerkt';
$string['userupload_completion_updated'] = 'Programmavoltooiing is bijgewerkt';

$string['rb_allocatedprograms'] = 'Programma\'s toewijzen';
$string['rb_complete'] = 'Voltooid';
$string['rb_completiondate'] = 'Voltooiingsdatum';
$string['rb_completionstatus'] = 'Voltooiingsstatus';
$string['rb_datecompleted'] = 'Datum voltooid';
$string['rb_dateallocated'] = 'Datum toegewezen';
$string['rb_datestarted'] = 'Datum gestart';
$string['rb_coursesall'] = 'Cursus(sen) - Alle';
$string['rb_incomplete'] = 'Onvoltooid';
$string['rb_isallocated'] = 'Is toegewezen';
$string['rb_iscomplete'] = 'Is voltooid?';
$string['rb_iscompleteany'] = 'Is voltooid? (elke methode)';
$string['rb_isinprogress'] = 'Is bezig?';
$string['rb_isnotcomplete'] = 'Is onvoltooid?';
$string['rb_isnotyetstarted'] = 'Is nog niet begonnen?';
$string['rb_notstarted'] = 'Niet begonnen';
$string['rb_officewhencompletedbasic'] = 'Kantoor na voltooiing (basis)';
$string['rb_privacy:metadata'] = 'Er worden geen persoonlijke gegevens opgeslagen door de plug-in.';
$string['rb_programcategory'] = 'Programmacategorie (of -site)';
$string['rb_programcategoryid'] = 'ID programmacategorie (n.v.t. indien site)';
$string['rb_programcategoryidnumber'] = 'ID-nummer programmacategorie (n.v.t. indien site)';
$string['rb_programcategorymultichoice'] = 'Programmacategorie (meerkeuze)';
$string['rb_programedatecreated'] = 'Aanmaakdatum programma';
$string['rb_programduedate'] = 'Deadline programma';
$string['rb_programenddate'] = 'Einddatum programmatoewijzing';
$string['rb_programallocationtype'] = 'Toewijzingstype';
$string['rb_programallocationtypes'] = 'Toewijzingstypen';
$string['rb_programexpandlink'] = 'Programmanaam (details uitvouwen)';
$string['rb_programid'] = 'ID programma';
$string['rb_programidnumber'] = 'ID-nummer programma';
$string['rb_programname'] = 'Programmanaam';
$string['rb_programnameandsummary'] = 'Programmanaam en -beschrijving';
$string['rb_programnamelinked'] = 'Programmanaam (gekoppeld aan programmapagina)';
$string['rb_programmultiitem'] = 'Programma (multi-item)';
$string['rb_programsingleitem'] = 'Programma';
$string['rb_programstartdate'] = 'Startdatum programmatoewijzing';
$string['rb_programsummary'] = 'Programmabeschrijving';
$string['rb_programvisible'] = 'Programma is openbaar';
$string['rb_programvisibledisabled'] = 'Programma zichtbaar (niet van toepassing)';
$string['rb_progress'] = 'Voortgang';
$string['rb_progressnumeric'] = 'Voortgang (numeriek)';
$string['rb_progresspercent'] = 'Voortgang (% voltooid)';
$string['rb_source_allocation'] = 'Programmatoekenningen';
$string['rb_timetocompletesinceenrol'] = 'Tijd tot voltooiing (vanaf toewijzingsdatum)';
$string['rb_timetocompletesincestart'] = 'Tijd tot voltooiing (vanaf startdatum)';
$string['rb_type_program'] = 'Programma';
$string['rb_type_program_category'] = 'Categorie';
$string['rb_type_program_completion'] = 'Programmatoewijzing';
$string['rb_type_program_customfields'] = 'Aangepaste programmavelden';
$string['rb_user'] = 'De gebruiker';
$string['rb_viewprogram'] = 'Programma bekijken';
$string['rb_visiblecohorts'] = 'Sitegroepen met zichtbaarheid';
