<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Program enrolment plugin language file.
 *
 * @package    enrol_programs
 * @copyright  2022 Open LMS (https://www.openlms.net/)
 * @author     Petr Skoda
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addprogram'] = 'เพิ่มโปรแกรม';
$string['addset'] = 'เพิ่มชุดใหม่';
$string['allocationend'] = 'สิ้นสุดการจัดสรร';
$string['allocationend_help'] = 'ความหมายของวันที่สิ้นสุดการจัดสรรขึ้นอยู่กับแหล่งที่มาของการจัดสรรที่เปิดใช้งาน โดยปกติการจัดสรรใหม่จะเป็นไปไม่ได้หลังจากวันที่นี้หากมีการระบุไว้';
$string['allocation'] = 'การจัดสรร';
$string['allocations'] = 'การจัดสรร';
$string['programallocations'] = 'การจัดสรรโปรแกรม';
$string['allocationdate'] = 'วันที่การจัดสรร';
$string['allocationsources'] = 'แหล่งที่มาการจัดสรร';
$string['allocationstart'] = 'เริ่มต้นการจัดสรร';
$string['allocationstart_help'] = 'ความหมายของวันที่เริ่มต้นการจัดสรรขึ้นอยู่กับแหล่งของการจัดสรรที่เปิดใช้งาน โดยปกติการจัดสรรใหม่จะเป็นไปได้หลังจากวันที่นี้เท่านั้นหากมีการระบุไว้';
$string['allprograms'] = 'โปรแกรมทั้งหมด';
$string['appenditem'] = 'ผนวกรายการ';
$string['appendinto'] = 'ผนวกลงในรายการ';
$string['archive'] = 'การเก็บถาวร';
$string['archived'] = 'เก็บถาวร';
$string['benefitname'] = '{$a}: การจัดสรรโปรแกรม';
$string['calendarprogramend'] = '{$a} สิ้นสุด';
$string['calendarprogramdue'] = '{$a} ครบกำหนด';
$string['calendarprogramstart'] = '{$a} เริ่มต้น';
$string['catalogue'] = 'แคตตาล็อกโปรแกรม';
$string['catalogue_dofilter'] = 'ค้นหา';
$string['catalogue_resetfilter'] = 'ล้าง';
$string['catalogue_searchtext'] = 'ค้นหาข้อความ';
$string['catalogue_tag'] = 'กรองตามแท็ก';
$string['certificatetemplatechoose'] = 'เลือกเทมเพลต...';
$string['cohorts'] = 'ปรากฏแก่กลุ่ม';
$string['cohorts_help'] = 'ทำโปรแกรมที่ไม่ใช่สาธารณะให้ปรากฏแก่สมาชิกกลุ่มที่ระบุได้

สถานะการปรากฏไม่ส่งผลกระทบต่อโปรแกรมที่จัดสรรแล้ว';
$string['columnusedalready'] = 'คอลัมน์ถูกใช้แล้ว';
$string['completiondate'] = 'วันที่เสร็จสมบูรณ์';
$string['completiondelay'] = 'การจบหลักสูตรล่าช้า';
$string['completionoverride'] = 'เขียนทับการจบหลักสูตร';
$string['creategroups'] = 'กลุ่มรายวิชา';
$string['creategroups_help'] = 'หากเปิดใช้งาน กลุ่มจะถูกสร้างในแต่ละรายวิชาที่เพิ่มลงในโปรแกรม และผู้ใช้ที่จัดสรรทั้งหมดจะถูกเพิ่มเป็นสมาชิกกลุ่ม';
$string['customfields'] = 'เลือกฟิลด์แบบกำหนดเองของโปรแกรม';
$string['customfieldsettings'] = 'การตั้งค่าฟิลด์แบบกำหนดเองสำหรับโปรแกรมร่วม';
$string['customfieldvisibleto'] = 'เนื้อหาของฟิลด์จะแสดงขึ้นสำหรับ';
$string['customfieldvisible:allocated'] = 'ผู้ใช้งานที่จัดสรรไปยังโปรแกรม';
$string['customfieldvisible:everyone'] = 'ทุกคนที่สามารถดูรายละเอียดของโปรแกรมอื่นๆ';
$string['customfieldvisible:viewcapability'] = 'ผู้ใช้งานที่มีความสามารถในการดูโปรแกรม';
$string['deleteallocation'] = 'ลบการจัดสรรโปรแกรม';
$string['deletecourse'] = 'ลบรายวิชาออก';
$string['deleteprogram'] = 'ลบโปรแกรม';
$string['deleteset'] = 'ลบชุด';
$string['deletetraining'] = 'ลบการฝึกอบรม';
$string['documentation'] = 'โปรแกรมสำหรับเอกสารประกอบ Moodle';
$string['duedate'] = 'กำหนดส่งงาน';
$string['enrolrole'] = 'บทบาทของรายวิชา';
$string['enrolrole_desc'] = 'เลือกบทบาทที่โปรแกรมจะใช้สำหรับการลงทะเบียนรายวิชา';
$string['errorcontentproblem'] = 'ตรวจพบปัญหาในโครงสร้างเนื้อหาโปรแกรม ความสำเร็จของโปรแกรมจะไม่ถูกติดตามอย่างถูกต้อง!';
$string['errorcoursemissing'] = 'รายวิชาขาดหายไป';
$string['errorcoursesmissing'] = 'รายวิชาที่หายไป: {$a}';
$string['errorinvalidoverridedates'] = 'การเขียนทับวันที่ไม่ถูกต้อง';
$string['errordifferenttenant'] = 'ไม่สามารถเข้าถึงโปรแกรมจากผู้ใช้งานอื่น';
$string['errornoallocations'] = 'ไม่พบการจัดสรรผู้ใช้งาน';
$string['errornoallocation'] = 'โปรแกรมไม่ได้รับการจัดสรร';
$string['errornomyprograms'] = 'คุณไม่ได้รับการจัดสรรลงในโปรแกรมใด';
$string['errornoprograms'] = 'ไม่พบโปรแกรม';
$string['errornorequests'] = 'ไม่พบคำขอโปรแกรม';
$string['errornotenabled'] = 'ปลั๊กอินโปรแกรมไม่ได้เปิดใช้งาน';
$string['event_program_completed'] = 'โปรแกรมเสร็จสมบูรณ์แล้ว';
$string['event_program_created'] = 'สร้างโปรแกรมแล้ว';
$string['event_program_deleted'] = 'ลบโปรแกรมแล้ว';
$string['event_program_updated'] = 'อัปเดตโปรแกรมแล้ว';
$string['event_program_viewed'] = 'ดูโปรแกรมแล้ว';
$string['event_user_allocated'] = 'จัดสรรผู้ใช้งานไปยังโปรแกรมแล้ว';
$string['event_user_deallocated'] = 'ยกเลิกจัดสรรผู้ใช้งานไปยังโปรแกรมแล้ว';
$string['evidence'] = 'หลักฐานอื่น';
$string['evidencedate'] = 'วันที่การจบหลักสูตรของหลักฐาน';
$string['evidenceupdate'] = 'อัปเดตหลักฐานอื่น';
$string['evidenceupload'] = 'อัปโหลดหลักฐานการจบหลักสูตร';
$string['evidenceupload_csvfile'] = 'ไฟล์ CSV';
$string['evidenceupload_errors'] = 'ตรวจพบ {$a} แถวที่ไม่ถูกต้อง';
$string['evidenceupload_skipped'] = 'ข้าม {$a} แถว';
$string['evidenceupload_updated'] = 'อัปเดตหลักฐานการจบหลักสูตรสำหรับผู้ใช้ {$a} ราย';
$string['evidence_details'] = 'รายละเอียด';
$string['evidence_detailsdefault'] = 'รายละเอียดเริ่มต้น';
$string['export'] = 'ส่งออกโปรแกรม';
$string['exportfile_info'] = 'ข้อมูล';
$string['exportfile_programs'] = 'โปรแกรม';
$string['exportformat'] = 'รูปแบบไฟล์';
$string['exportformat_csv'] = 'CSV';
$string['exportformat_json'] = 'JSON';
$string['extra_menu_management_index'] = 'การดำเนินการโปรแกรม';
$string['extra_menu_management_program_general'] = 'การดำเนินการโปรแกรม';
$string['extra_menu_management_program_users'] = 'การดำเนินการของผู้ใช้';
$string['extra_menu_management_program_allocation'] = 'การดำเนินการจัดสรร';
$string['fixeddate'] = 'ในวันที่กำหนด';
$string['importallocationend'] = 'สิ้นสุดการจัดสรร ({$a})';
$string['importallocationstart'] = 'เริ่มต้นการจัดสรร ({$a})';
$string['importprogramallocation'] = 'นำเข้าการจัดสรรโปรแกรม';
$string['importprogramallocationconfirmation'] = 'คุณกำลังนำเข้าการตั้งค่าการจัดสรรจากโปรแกรม __{$a->fullname} / {$a->idnumber} / {$a->category}__

โปรดเลือกการตั้งค่าทั้งหมดที่คุณต้องการนำเข้า';
$string['importprogramcontent'] = 'นำเข้าเนื้อหาโปรแกรม';
$string['importprogramcontentconfirmation'] = 'คุณกำลังนำเข้าเนื้อหาจากโปรแกรม __{$a->fullname} / {$a->idnumber} / {$a->category}__';
$string['importprogramdue'] = 'ครบกำหนดโปรแกรม ({$a})';
$string['importprogramend'] = 'สิ้นสุดโปรแกรม ({$a})';
$string['importprogramstart'] = 'เริ่มต้นโปรแกรม ({$a})';
$string['importselectprogram'] = 'เลือกโปรแกรม';
$string['invalidallocationdates'] = 'วันที่การจัดสรรโปรแกรมไม่ถูกต้อง';
$string['invalidcompletiondate'] = 'วันที่จบหลักสูตรของโปรแกรมไม่ถูกต้อง';
$string['item'] = 'ชิ้น';
$string['itemcompletion'] = 'การเสร็จสมบูรณ์ของรายการโปรแกรม';
$string['itempoints'] = 'จุด';
$string['itemrecalculate'] = 'คำนวณการจบหลักสูตรของรายการใหม่';
$string['management'] = 'การจัดการโปรแกรม';
$string['messageprovider:allocation_notification'] = 'การแจ้งเตือนการจัดสรรโปรแกรม';
$string['messageprovider:approval_request_notification'] = 'การแจ้งเตือนคำขอการอนุมัติโปรแกรม';
$string['messageprovider:approval_reject_notification'] = 'การแจ้งเตือนการปฏิเสธคำขอโปรแกรม';
$string['messageprovider:completion_notification'] = 'การแจ้งเตือนโปรแกรมเสร็จสมบูรณ์';
$string['messageprovider:completion_relateduser_notification'] = 'การแจ้งเตือนโปรแกรมเสร็จสมบูรณ์ - ผู้ใช้งานที่เกี่ยวข้อง';
$string['messageprovider:deallocation_notification'] = 'การแจ้งเตือนยกเลิกการจัดสรรโปรแกรม';
$string['messageprovider:duesoon_notification'] = 'การแจ้งเตือนวันที่ครบกำหนดโปรแกรมในไม่ช้า';
$string['messageprovider:duesoon_relateduser_notification'] = 'การแจ้งเตือนวันที่ครบกำหนดโปรแกรมในไม่ช้า - ผู้ใช้งานที่เกี่ยวข้อง';
$string['messageprovider:due_notification'] = 'การแจ้งเตือนโปรแกรมเกินกำหนด';
$string['messageprovider:due_relateduser_notification'] = 'การแจ้งเตือนโปรแกรมเกินกำหนด - ผู้ใช้งานที่เกี่ยวข้อง';
$string['messageprovider:endsoon_notification'] = 'การแจ้งเตือนวันที่สิ้นสุดโปรแกรมในไม่ช้า';
$string['messageprovider:endsoon_relateduser_notification'] = 'การแจ้งเตือนวันที่สิ้นสุดโปรแกรมในไม่ช้า - ผู้ใช้งานที่เกี่ยวข้อง';
$string['messageprovider:endcompleted_notification'] = 'การแจ้งเตือนการสิ้นสุดโปรแกรมที่เสร็จสมบูรณ์';
$string['messageprovider:endfailed_notification'] = 'การแจ้งเตือนการสิ้นสุดโปรแกรมที่ล้มเหลว';
$string['messageprovider:endfailed_relateduser_notification'] = 'การแจ้งเตือนการสิ้นสุดโปรแกรมที่ล้มเหลว - ผู้ใช้งานที่เกี่ยวข้อง';
$string['messageprovider:reset_notification'] = 'การแจ้งเตือนการรีเซ็ตโปรแกรม - ผู้ใช้ที่เกี่ยวข้อง';
$string['messageprovider:start_notification'] = 'การแจ้งเตือนโปรแกรมเริ่มต้น';
$string['moveitem'] = 'ย้ายรายการ';
$string['moveitemcancel'] = 'ยกเลิกการย้าย';
$string['moveafter'] = 'ย้าย "{$a->item}" ไปหลัง "{$a->target}"';
$string['movebefore'] = 'ย้าย "{$a->item}" ไปหน้า "{$a->target}"';
$string['moveinto'] = 'ย้าย "{$a->item}" ไปยัง "{$a->target}"';
$string['myprograms'] = 'โปรแกรมของฉัน';
$string['notification_allocation'] = 'จัดสรรผู้ใช้งานแล้ว';
$string['notification_allocation_subject'] = 'การแจ้งเตือนการจัดสรรโปรแกรม';
$string['notification_allocation_body'] = 'สวัสดี {$a->user_fullname}

คุณได้รับการจัดสรรลงในโปรแกรม "{$a->program_fullname}" ซึ่งจะเริ่มต้นในวันที่ {$a->program_startdate}
';
$string['notification_allocation_description'] = 'การแจ้งเตือนที่ส่งไปยังผู้ใช้เมื่อพวกเขาถูกจัดสรรไปยังโปรแกรม';
$string['notification_completion'] = 'โปรแกรมเสร็จสมบูรณ์แล้ว';
$string['notification_completion_subject'] = 'โปรแกรมเสร็จสมบูรณ์แล้ว';
$string['notification_completion_body'] = 'สวัสดี {$a->user_fullname}

คุณทำโปรแกรม "{$a->program_fullname}" เสร็จสมบูรณ์แล้ว
';
$string['notification_completion_description'] = 'การแจ้งเตือนที่ส่งไปยังผู้ใช้งานเมื่อพวกเขาทำโปรแกรมเสร็จสมบูรณ์';
$string['notification_completion_relateduser'] = 'โปรแกรมเสร็จสมบูรณ์แล้ว - ผู้ใช้งานที่เกี่ยวข้อง';
$string['notification_completion_relateduser_subject'] = 'ผู้ใช้งาน {$a->user_fullname} ทำโปรแกรมเสร็จสมบูรณ์แล้ว';
$string['notification_completion_relateduser_body'] = 'สวัสดี {$a->relateduser_fullname}

ผู้ใช้ {$a->user_fullname} ได้ทำโปรแกรม "{$a->program_fullname}” เสร็จสมบูรณ์แล้ว
';
$string['notification_completion_relateduser_description'] = 'การแจ้งเตือนที่ส่งไปยังผู้ใช้งานที่เกี่ยวข้องกับผู้ใช้งานเมื่อพวกเขาทำโปรแกรมเสร็จสมบูรณ์';
$string['notification_deallocation'] = 'เลิกจัดสรรผู้ใช้งานแล้ว';
$string['notification_deallocation_subject'] = 'การแจ้งเตือนยกเลิกการจัดสรรโปรแกรม';
$string['notification_deallocation_body'] = 'สวัสดี {$a->user_fullname}

คุณถูกเลิกการจัดสรรจากโปรแกรม "{$a->program_fullname}"
';
$string['notification_deallocation_description'] = 'การแจ้งเตือนที่ส่งไปยังผู้ใช้เมื่อพวกเขาถูกยกเลิกการจัดสรรจากโปรแกรม';
$string['notification_duesoon'] = 'วันที่ครบกำหนดโปรแกรมในไม่ช้า';
$string['notification_duesoon_subject'] = 'โปรแกรมใกล้เสร็จสมบูรณ์แล้ว';
$string['notification_duesoon_body'] = 'สวัสดี {$a->user_fullname}

โปรแกรม "{$a->program_fullname}" คาดว่าจะจบหลักสูตรในวันที่ {$a->program_duedate}
';
$string['notification_duesoon_description'] = 'การแจ้งเตือนที่ส่งไปยังผู้ใช้งานก่อนถึงวันที่โปรแกรมจบหลักสูตร นอกจากโปรแกรมจะจบหลักสูตรไปแล้ว';
$string['notification_duesoon_relateduser'] = 'การแจ้งเตือนวันที่ครบกำหนดโปรแกรมในไม่ช้า - ผู้ใช้งานที่เกี่ยวข้อง';
$string['notification_duesoon_relateduser_subject'] = 'โปรแกรมใกล้จบหลักสูตรแล้วสำหรับผู้ใช้งาน {$a->user_fullname}';
$string['notification_duesoon_relateduser_body'] = 'สวัสดี {$a->relateduser_fullname}

โปรแกรม "{$a->program_fullname}" สำหรับผู้ใช้งาน {$a->user_fullname} คาดว่าจะจบหลักสูตรในวันที่ {$a->program_duedate}
';
$string['notification_duesoon_relateduser_description'] = 'การแจ้งเตือนที่ส่งไปยังผู้ใช้งานที่เกี่ยวข้องกับผู้ใช้งานก่อนถึงวันที่โปรแกรมจบหลักสูตร นอกจากโปรแกรมจะจบหลักสูตรแล้ว';
$string['notification_due'] = 'โปรแกรมเกินกำหนด';
$string['notification_due_subject'] = 'โปรแกรมใกล้เสร็จสมบูรณ์แล้ว';
$string['notification_due_body'] = 'สวัสดี {$a->user_fullname}

โปรแกรม "{$a->program_fullname}" คาดว่าจะจบหลักสูตรก่อนวันที่ {$a->program_duedate}
';
$string['notification_due_description'] = 'การแจ้งเตือนที่ส่งไปยังผู้ใช้เมื่อการจบหลักสูตรของโปรแกรมของพวกเขาเกินกำหนด';
$string['notification_due_relateduser'] = 'โปรแกรมเกินกำหนด - ผู้ใช้งานที่เกี่ยวข้อง';
$string['notification_due_relateduser_subject'] = 'โปรแกรมใกล้จบหลักสูตรแล้วสำหรับผู้ใช้งาน {$a->user_fullname}';
$string['notification_due_relateduser_body'] = 'สวัสดี {$a->relateduser_fullname}

โปรแกรม "{$a->program_fullname}” สำหรับผู้ใช้ {$a->user_fullname} คาดว่าจะจบหลักสูตรก่อนวันที่ {$a->program_duedate}
';
$string['notification_due_relateduser_description'] = 'การแจ้งเตือนที่ส่งไปยังผู้ใช้ที่เกี่ยวข้องกับผู้ใช้เมื่อการจบหลักสูตรของโปรแกรมของพวกเขาเกินกำหนด';
$string['notification_endsoon'] = 'วันที่สิ้นสุดโปรแกรมในไม่ช้า';
$string['notification_endsoon_subject'] = 'โปรแกรมสิ้นสุดในไม่ช้า';
$string['notification_endsoon_body'] = 'สวัสดี {$a->user_fullname}

โปรแกรม "{$a->program_fullname}” กำลังจะสิ้นสุดในวันที่ {$a->program_enddate}
';
$string['notification_endsoon_description'] = 'การแจ้งเตือนที่ส่งไปยังผู้ใช้งานก่อนถึงวันที่โปรแกรมสิ้นสุด นอกจากโปรแกรมจะเสร็จสมบูรณ์ไปแล้ว';
$string['notification_endsoon_relateduser'] = 'วันที่สิ้นสุดโปรแกรมในไม่ช้า - ผู้ใช้งานที่เกี่ยวข้อง';
$string['notification_endsoon_relateduser_subject'] = 'โปรแกรมสิ้นสุดในไม่ช้าสำหรับผู้ใช้งาน {$a->user_fullname}';
$string['notification_endsoon_relateduser_body'] = 'สวัสดี {$a->relateduser_fullname}

โปรแกรม "{$a->program_fullname}" สำหรับผู้ใช้ {$a->user_fullname} กำลังจะสิ้นสุดในวันที่ {$a->program_enddate}
';
$string['notification_endsoon_relateduser_description'] = 'การแจ้งเตือนที่ส่งไปยังผู้ใช้งานที่เกี่ยวข้องกับผู้ใช้งานก่อนถึงวันที่โปรแกรมสิ้นสุด นอกจากโปรแกรมจะเสร็จสมบูรณ์แล้ว';
$string['notification_endcompleted'] = 'การสิ้นสุดโปรแกรมที่เสร็จสมบูรณ์';
$string['notification_endcompleted_subject'] = 'การสิ้นสุดโปรแกรมที่เสร็จสมบูรณ์';
$string['notification_endcompleted_body'] = 'สวัสดี {$a->user_fullname}

โปรแกรม "{$a->program_fullname}" สิ้นสุดแล้ว คุณได้ทำเสร็จสมบูรณ์เร็วกว่ากำหนด
';
$string['notification_endcompleted_description'] = 'การแจ้งเตือนที่ส่งไปยังผู้ใช้เมื่อโปรแกรมที่เสร็จสมบูรณ์ของพวกเขาสิ้นสุด';
$string['notification_endfailed'] = 'การสิ้นสุดโปรแกรมที่ล้มเหลว';
$string['notification_endfailed_subject'] = 'การสิ้นสุดโปรแกรมที่ล้มเหลว';
$string['notification_endfailed_body'] = 'สวัสดี {$a->user_fullname}

โปรแกรม "{$a->program_fullname}" สิ้นสุดแล้ว คุณทำไม่เสร็จสมบูรณ์
';
$string['notification_endfailed_description'] = 'การแจ้งเตือนที่ส่งไปยังผู้ใช้งานเมื่อโปรแกรมที่พวกเขาทำไม่เสร็จสมบูรณ์สิ้นสุด';
$string['notification_endfailed_relateduser'] = 'การสิ้นสุดโปรแกรมที่ล้มเหลว - ผู้ใช้งานที่เกี่ยวข้อง';
$string['notification_endfailed_relateduser_subject'] = 'โปรแกรมที่ล้มเหลวสิ้นสุดแล้วสำหรับผู้ใช้งาน {$a->user_fullname}';
$string['notification_endfailed_relateduser_body'] = 'สวัสดี {$a->relateduser_fullname}

โปรแกรม "{$a->program_fullname}" สิ้นสุดแล้ว ผู้ใช้งาน {$a->user_fullname} ทำไม่เสร็จสมบูรณ์
';
$string['notification_endfailed_relateduser_description'] = 'การแจ้งเตือนที่ส่งไปยังผู้ใช้งานที่เกี่ยวข้องกับผู้ใช้งานเมื่อโปรแกรมที่พวกเขาทำไม่เสร็จสมบูรณ์สิ้นสุด';
$string['notification_relateduserfield'] = 'ฟิลด์ผู้ใช้งานที่เกี่ยวข้องของการแจ้งเตือน';
$string['notification_relateduserfield_desc'] = 'เลือกฟิลด์ผู้ใช้งานที่เกี่ยวข้องที่จะใช้สำหรับการแจ้งเตือนของผู้ใช้ที่เกี่ยวข้อง';
$string['notification_reset'] = 'รีเซ็ตความคืบหน้าของผู้ใช้';
$string['notification_reset_subject'] = 'การแจ้งเตือนการรีเซ็ตโปรแกรม - ผู้ใช้ที่เกี่ยวข้อง';
$string['notification_reset_body'] = 'สวัสดี {$a->user_fullname}

ความคืบหน้าของคุณในโปรแกรม "{$a->program_fullname}" ถูกรีเซ็ต
';
$string['notification_reset_description'] = 'การแจ้งเตือนที่ส่งไปยังผู้ใช้งานเมื่อความคืบหน้าของโปรแกรมของพวกเขาถูกรีเซ็ต';
$string['notification_start'] = 'โปรแกรมเริ่มต้น';
$string['notification_start_subject'] = 'โปรแกรมเริ่มต้น';
$string['notification_start_body'] = 'สวัสดี {$a->user_fullname}

โปรแกรม "{$a->program_fullname}" เริ่มต้นแล้ว
';
$string['notification_start_description'] = 'การแจ้งเตือนที่ส่งถึงผู้ใช้งานเมื่อโปรแกรมของพวกเขาเริ่มต้น';
$string['notificationdates'] = 'วันที่การแจ้งเตือน';
$string['notset'] = 'ไม่ได้ตั้งค่า';
$string['plugindisabled'] = 'ปลั๊กอินการลงทะเบียนโปรแกรมถูกปิดใช้งาน โปรแกรมจะไม่ทำงาน

[Enable plugin now]({$a->url})';
$string['pluginname'] = 'โปรแกรม';
$string['pluginname_desc'] = 'โปรแกรมได้รับการออกแบบให้อนุญาตการสร้างชุดรายวิชา';
$string['privacy:metadata:field:programid'] = 'ID โปรแกรม';
$string['privacy:metadata:field:userid'] = 'ID ผู้ใช้งาน';
$string['privacy:metadata:field:allocationid'] = 'ID การจัดสรรโปรแกรม';
$string['privacy:metadata:field:sourceid'] = 'แหล่งที่มาของการจัดสรร';
$string['privacy:metadata:field:itemid'] = 'รหัสรายการ';
$string['privacy:metadata:field:timecreated'] = 'วันที่สร้าง';
$string['privacy:metadata:field:timecompleted'] = 'วันที่เสร็จสมบูรณ์';

$string['privacy:metadata:table:enrol_programs_allocations'] = 'ข้อมูลเกี่ยวกับการจัดสรรโปรแกรม';
$string['privacy:metadata:field:archived'] = 'บันทึกถูกเก็บถาวรหรือไม่';
$string['privacy:metadata:field:sourcedatajson'] = 'ข้อมูลเกี่ยวกับแหล่งที่มาของการจัดสรร';
$string['privacy:metadata:field:timeallocated'] = 'วันที่การจัดสรรโปรแกรม';
$string['privacy:metadata:field:timestart'] = 'วันที่เริ่มต้น';
$string['privacy:metadata:field:timedue'] = 'กำหนดส่งงาน';
$string['privacy:metadata:field:timeend'] = 'วันที่สิ้นสุด';

$string['privacy:metadata:table:enrol_programs_certs_issues'] = 'ออกใบรับรองการจัดสรรโปรแกรม';
$string['privacy:metadata:field:issueid'] = 'ID การออก';

$string['privacy:metadata:table:enrol_programs_completions'] = 'การเสร็จสมบูรณ์การจัดสรรโปรแกรม';

$string['privacy:metadata:table:enrol_programs_evidences'] = 'ข้อมูลเกี่ยวกับหลักฐานการเสร็จสมบูรณ์อื่น ๆ';
$string['privacy:metadata:field:evidencejson'] = 'ข้อมูลเกี่ยวกับหลักฐานการเสร็จสมบูรณ์';
$string['privacy:metadata:field:createdby'] = 'สร้างหลักฐานโดย';

$string['privacy:metadata:table:enrol_programs_requests'] = 'ข้อมูลเกี่ยวกับคำขอการจัดสรร';
$string['privacy:metadata:field:datajson'] = 'ข้อมูลเกี่ยวกับคำขอ';
$string['privacy:metadata:field:timerequested'] = 'วันที่ที่ขอ';
$string['privacy:metadata:field:timerejected'] = 'วันที่ที่ปฏิเสธ';
$string['privacy:metadata:field:rejectedby'] = 'ปฏิเสธคำขอโดย';


$string['privacy:metadata:table:enrol_programs_usr_snapshots'] = 'สแนปช็อตการจัดสรรโปรแกรม';
$string['privacy:metadata:field:reason'] = 'สาเหตุ';
$string['privacy:metadata:field:timesnapshot'] = 'วันที่สแนปช็อต';
$string['privacy:metadata:field:snapshotby'] = 'สแนปช็อตโดย';
$string['privacy:metadata:field:explanation'] = 'คำอธิบาย';
$string['privacy:metadata:field:completionsjson'] = 'ข้อมูลเกี่ยวกับการเสร็จสมบูรณ์';
$string['privacy:metadata:field:evidencesjson'] = 'ข้อมูลเกี่ยวกับหลักฐานการเสร็จสมบูรณ์';

$string['privacy:metadata:table:enrol_programs_src_commholds'] = 'การจองการจัดสรรคอมเมิร์ซ';
$string['privacy:metadata:field:quantity'] = 'จำนวน';

$string['program'] = 'โปรแกรม';
$string['programautofix'] = 'เกี่ยวกับโปรแกรมซ่อมแซม';
$string['programdue'] = 'ครบกำหนดโปรแกรม';
$string['programdue_help'] = 'วันที่ครบกำหนดโปรแกรมระบุเวลาที่ผู้ใช้งานคาดว่าจะทำโปรแกรมเสร็จสมบูรณ์';
$string['programdue_delay'] = 'ครบกำหนดหลังจากเริ่มต้น';
$string['programdue_date'] = 'กำหนดส่งงาน';
$string['programend'] = 'สิ้นสุดโปรแกรม';
$string['programend_help'] = 'ผู้ใช้งานไม่สามารถป้อนรายวิชาโปรแกรมหลังจากสิ้นสุดโปรแกรม';
$string['programend_delay'] = 'สิ้นสุดหลังจากเริ่มต้น';
$string['programend_date'] = 'วันที่สิ้นสุดโปรแกรม';
$string['programcompletion'] = 'วันที่โปรแกรมเสร็จสมบูรณ์';
$string['programcompletionoverride'] = 'เขียนทับการจบหลักสูตรของโปรแกรม';
$string['programidnumber'] = 'หมายเลข ID โปรแกรม';
$string['programimage'] = 'รูปภาพโปรแกรม';
$string['programname'] = 'ชื่อโปรแกรม';
$string['programurl'] = 'URL โปรแกรม';
$string['programs'] = 'โปรแกรม';
$string['programsactive'] = 'ใช้งานอยู่';
$string['programsarchived'] = 'เก็บถาวร';
$string['programsarchived_help'] = 'โปรแกรมที่เก็บถาวรจะถูกซ่อนจากผู้ใช้งานและความคืบหน้าจะถูกล็อก';
$string['programstart'] = 'เริ่มต้นโปรแกรม';
$string['programstart_help'] = 'ผู้ใช้งานไม่สามารถป้อนรายวิชาโปรแกรมก่อนเริ่มต้นโปรแกรม';
$string['programstart_allocation'] = 'เริ่มต้นทันทีหลังการจัดสรร';
$string['programstart_delay'] = 'หน่วงเวลาเริ่มต้นหลังการจัดสรร';
$string['programstart_date'] = 'วันที่เริ่มต้นโปรแกรม';
$string['programstatus'] = 'สถานะโปรแกรม';
$string['programstatus_completed'] = 'เสร็จสมบูรณ์';
$string['programstatus_any'] = 'ทุกสถานะโปรแกรม';
$string['programstatus_archived'] = 'เก็บถาวร';
$string['programstatus_archivedcompleted'] = 'เก็บถาวรเสร็จสมบูรณ์';
$string['programstatus_overdue'] = 'เกินกำหนด';
$string['programstatus_open'] = 'เปิด';
$string['programstatus_future'] = 'ยังไม่เปิด';
$string['programstatus_failed'] = 'ล้มเหลว';
$string['programs:addcourse'] = 'เพิ่มรายวิชาลงในโปรแกรม';
$string['programs:addtocertifications'] = 'เพิ่มโปรแกรมลงในใบรับรอง';
$string['programs:addtoplan'] = 'เพิ่มโปรแกรมลงในแผน';
$string['programs:allocate'] = 'จัดสรรผู้เรียนลงในโปรแกรม';
$string['programs:archive'] = 'เก็บถาวรการจัดสรรโปรแกรม';
$string['programs:clone'] = 'อนุญาตการโคลนเนื้อหาและการตั้งค่าโปรแกรม';
$string['programs:configframeworks'] = 'กำหนดค่าความพร้อมใช้งานของโปรแกรมในกรอบงานของแผน';
$string['programs:configurecustomfields'] = 'กำหนดค่าฟิลด์แบบกำหนดเองของโปรแกรม';
$string['programs:delete'] = 'ลบโปรแกรม';
$string['programs:edit'] = 'เพิ่มและอัปเดตโปรแกรม';
$string['programs:export'] = 'ส่งออกโปรแกรม';
$string['programs:admin'] = 'การจัดการโปรแกรมขั้นสูง';
$string['programs:manageallocation'] = 'จัดการการจัดสรรผู้ใช้งาน';
$string['programs:manageevidence'] = 'จัดการหลักฐานการเสร็จสมบูรณ์อื่น';
$string['programs:reset'] = 'รีเซ็ตความคืบหน้าโปรแกรม';
$string['programs:upload'] = 'อัปโหลดโปรแกรม';
$string['programs:view'] = 'ดูการจัดการโปรแกรม';
$string['programs:viewcatalogue'] = 'เข้าถึงแคตตาล็อกโปรแกรม';
$string['public'] = 'สาธารณะ';
$string['public_help'] = 'โปรแกรมสาธารณะจะปรากฏแก่ผู้ใช้งานทั้งหมด

สถานะการปรากฏไม่ส่งผลกระทบต่อโปรแกรมที่จัดสรรแล้ว';
$string['purchaseaccess'] = 'ซื้อการเข้าถึง';
$string['resetallocation'] = 'รีเซ็ตความคืบหน้าโปรแกรม';
$string['resettype'] = 'ประเภทการรีเซ็ต';
$string['resettype_deallocate'] = 'การยกเลิกการจัดสรรโปรแกรมเท่านั้น';
$string['resettype_full'] = 'ล้างรายวิชาแบบเต็ม';
$string['resettype_none'] = 'ไม่มี';
$string['resettype_standard'] = 'ล้างรายวิชาแบบมาตรฐาน';
$string['sequencetype'] = 'ประเภทการเสร็จสมบูรณ์';
$string['sequencetype_allinorder'] = 'ทั้งหมดตามลำดับ';
$string['sequencetype_allinanyorder'] = 'ทั้งหมดตามลำดับใดก็ได้';
$string['sequencetype_atleast'] = 'อย่างน้อย {$a->min}';
$string['sequencetype_minpoints'] = 'ขั้นต่ำ {$a->minpoints} คะแนน';
$string['selectcategory'] = 'เลือกประเภท';
$string['source'] = 'แหล่งที่มา';
$string['source_approval'] = 'คำขอที่มีการอนุมัติ';
$string['source_approval_allownew'] = 'อนุญาตการอนุมัติ';
$string['source_approval_allownew_desc'] = 'อนุญาตการเพิ่ม new _requests ที่มี approval_ sources ลงในโปรแกรม';
$string['source_approval_allowrequest'] = 'อนุญาตคำขอใหม่';
$string['source_approval_confirm'] = 'โปรดยืนยันว่าคุณต้องการดำเนินการขอการจัดสรรลงในโปรแกรม';
$string['source_approval_daterequested'] = 'วันที่ขอ';
$string['source_approval_daterejected'] = 'วันที่ที่ปฏิเสธ';
$string['source_approval_makerequest'] = 'ขอการเข้าถึง';
$string['source_approval_notification_approval_request_subject'] = 'การแจ้งเตือนคำขอโปรแกรม';
$string['source_approval_notification_approval_request_body'] = '
ผู้ใช้งาน {$a->user_fullname} ส่งคำขอการเข้าถึงโปรแกรม "{$a->program_fullname}"
';
$string['source_approval_notification_approval_reject_subject'] = 'การแจ้งเตือนการปฏิเสธคำขอโปรแกรม';
$string['source_approval_notification_approval_reject_body'] = 'สวัสดี {$a->user_fullname}

คำขอเข้าถึงโปรแกรม "{$a->program_fullname}" ถูกปฏิเสธ

{$a->reason}
';
$string['source_approval_requestallowed'] = 'คำขอได้รับอนุญาต';
$string['source_approval_requestnotallowed'] = 'คำขอไม่ได้รับอนุญาต';
$string['source_approval_requests'] = 'คำขอ';
$string['source_approval_requestpending'] = 'คำขอการเข้าถึงรอการยืนยัน';
$string['source_approval_requestrejected'] = 'คำขอการเข้าถึงถูกปฏิเสธ';
$string['source_approval_requestapprove'] = 'อนุมัติคำขอ';
$string['source_approval_requestreject'] = 'ปฏิเสธคำขอ';
$string['source_approval_requestdelete'] = 'ลบคำขอ';
$string['source_approval_rejectionreason'] = 'เหตุผลของการปฏิเสธ';
$string['source_certify'] = 'ใบรับรอง';
$string['source_certify_allownew'] = 'อนุญาตการจัดสรรใบรับรอง';
$string['source_certify_allownew_desc'] = 'อนุญาตการเพิ่ม new _certification_ sources ลงในโปรแกรม';
$string['source_cohort'] = 'การจัดสรรกลุ่มอัตโนมัติ';
$string['source_cohort_allownew'] = 'อนุญาตการจัดสรรกลุ่ม';
$string['source_cohort_allownew_desc'] = 'อนุญาตการเพิ่ม new _cohort อัตโนมัติ allocation_ sources ลงในโปรแกรม';
$string['source_cohort_cohortstoallocate'] = 'กลุ่มการจัดสรร';
$string['source_ecommerce'] = 'การจัดสรรอีคอมเมิร์ซ';
$string['source_ecommerce_allownew'] = 'อนุญาตการจัดสรรอีคอมเมิร์ซ';
$string['source_ecommerce_allownew_desc'] = 'อนุญาตการเพิ่มแหล่งที่มาของการจัดสรรอัตโนมัติของอีคอมเมิร์ซลงในโปรแกรม';
$string['source_ecommerce_allowsignup'] = 'อนุญาตการจัดสรรใหม่';
$string['source_ecommerce_cohortmembershiprequirement'] = 'ผู้ใช้ต้องเป็นสมาชิกของกลุ่มใดกลุ่มหนึ่งต่อไปนี้: {$a}';
$string['source_ecommerce_maxusers'] = 'ผู้ใช้งานสูงสุด';
$string['source_ecommerce_nocapacity'] = 'ไม่มีขีดความสามารถที่เหลืออยู่ในโปรแกรมนี้';
$string['source_manual'] = 'การจัดสรรด้วยตนเอง';
$string['source_manual_allocateusers'] = 'จัดสรรผู้ใช้งาน';
$string['source_manual_csvfile'] = 'ไฟล์ CSV';
$string['source_manual_hasheaders'] = 'บรรทัดแรกคือหัวเรื่อง';
$string['source_manual_potusersmatching'] = 'การจับคู่การจัดสรรผู้สมัคร';
$string['source_manual_potusers'] = 'การจัดสรรผู้สมัคร';
$string['source_manual_result_assigned'] = '{$a} ผู้ใช้งานได้รับการมอบหมายไปยังโปรแกรม';
$string['source_manual_result_errors'] = 'ตรวจพบ {$a} ข้อผิดพลาดเมื่อมอบหมายโปรแกรม';
$string['source_manual_result_skipped'] = '{$a} ผู้ใช้งานได้รับมอบหมายไปยังโปรแกรมอยู่แล้ว';
$string['source_manual_timeduecolumn'] = 'คอลัมน์เวลาครบกำหนด';
$string['source_manual_timeendcolumn'] = 'คอลัมน์เวลาสิ้นสุด';
$string['source_manual_timestartcolumn'] = 'คอลัมน์เวลาเริ่มต้น';
$string['source_manual_uploadusers'] = 'อัปโหลดการจัดสรร';
$string['source_manual_usercolumn'] = 'คอลัมน์การระบุตัวตนผู้ใช้งาน';
$string['source_manual_usermapping'] = 'แมปผู้ใช้งานผ่าน';
$string['source_manual_userupload_allocated'] = 'จัดสรรลงใน \'{$a}\'';
$string['source_manual_userupload_alreadyallocated'] = 'จัดสรรลงใน \'{$a}\' อยู่แล้ว';
$string['source_manual_userupload_invalidprogram'] = 'ไม่สามารถจัดสรรลงใน \'{$a}\'';
$string['source_selfallocation'] = 'การจัดสรรด้วยตนเอง';
$string['source_selfallocation_allocate'] = 'สมัคร';
$string['source_selfallocation_allownew'] = 'อนุญาตการจัดสรรตนเอง';
$string['source_selfallocation_allownew_desc'] = 'อนุญาตการเพิ่ม new _self allocation_ sources ลงในโปรแกรม';
$string['source_selfallocation_allowsignup'] = 'อนุญาตการสมัครใหม่';
$string['source_selfallocation_confirm'] = 'โปรดยืนยันว่าคุณต้องการการจัดสรรลงในโปรแกรม';
$string['source_selfallocation_enable'] = 'เปิดใช้งานการจัดสรรตนเอง';
$string['source_selfallocation_key'] = 'คีย์การสมัคร';
$string['source_selfallocation_keyrequired'] = 'ต้องใช้คีย์การสมัคร';
$string['source_selfallocation_maxusers'] = 'ผู้ใช้งานสูงสุด';
$string['source_selfallocation_maxusersreached'] = 'ครบจำนวนผู้ใช้งานสูงสุดที่จัดสรรตนเองแล้ว';
$string['source_selfallocation_maxusers_status'] = 'ผู้ใช้งาน {$a->count}/{$a->max}';
$string['source_selfallocation_signupallowed'] = 'อนุญาตให้สมัคร';
$string['source_selfallocation_signupnotallowed'] = 'ไม่อนุญาตให้สมัคร';
$string['source_udplans'] = 'แผนการพัฒนาของผู้ใช้';
$string['source_udplans_allownew'] = 'แผนการพัฒนาของผู้ใช้';
$string['source_udplans_allownew_desc'] = 'อนุญาตการเพิ่มแหล่งที่มาของ _user development plans_ ใหม่ลงในโปรแกรม';
$string['source_udplans_allowed'] = 'ได้รับอนุญาต';
$string['source_udplans_noframeworks'] = 'ไม่สามารถเพิ่มลงในแผนใดๆ';
$string['source_udplans_notallowed'] = 'ไม่อนุญาต';
$string['source_udplans_requirecap'] = 'เพิ่มความสามารถที่จำเป็น';
$string['set'] = 'ชุดรายวิชา';
$string['settings'] = 'การตั้งค่าโปรแกรม';
$string['scheduling'] = 'การกำหนดเวลา';
$string['taballocation'] = 'การตั้งค่าการจัดสรร';
$string['tabcontent'] = 'เนื้อหา';
$string['tabgeneral'] = 'ทั่วไป';
$string['tabusers'] = 'ผู้ใช้งาน';
$string['tabvisibility'] = 'การตั้งค่าการปรากฏ';
$string['tagarea_program'] = 'โปรแกรม';
$string['taskcertificate'] = 'Cron การออกใบรับรองโปรแกรม';
$string['taskcron'] = 'Cron ปลั๊กอินโปรแกรม';
$string['training'] = 'การฝึกอบรม';
$string['trainingcompletion'] = 'การฝึกอบรมที่จำเป็น: {$a}';
$string['trainingprogress'] = 'ความคืบหน้าของการฝึกอบรม: {$a->current}/{$a->total}';
$string['unarchive'] = 'กู้คืนข้อมูล';
$string['unlinkeditems'] = 'รายการที่ยกเลิกการเชื่อมโยง';
$string['updateprogram'] = 'อัปเดตโปรแกรม';
$string['updateallocation'] = 'อัปเดตการจัดสรร';
$string['updateallocations'] = 'อัปเดตการจัดสรร';
$string['updatecourse'] = 'อัปเดตรายวิชา';
$string['updateset'] = 'อัปเดตชุด';
$string['updatescheduling'] = 'อัปเดตกำหนดการ';
$string['updatesource'] = 'อัปเดต {$a}';
$string['updatetraining'] = 'อัปเดตการฝึกอบรม';
$string['upload'] = 'อัปโหลดโปรแกรม';
$string['upload_invalidcount'] = 'บันทึกไม่ถูกต้อง';
$string['upload_files'] = 'ไฟล์';
$string['upload_files_error'] = 'คาดว่าให้มีไฟล์ CSV หลายไฟล์, ไฟล์ JSON หนึ่งไฟล์ หรือการเก็บถาวร Zip หนึ่งรายการ';
$string['upload_preview'] = 'การแสดงตัวอย่างข้อมูล';
$string['upload_status'] = 'สถานะ';
$string['upload_status_invalid'] = 'ไม่ถูกต้อง';
$string['upload_targetcontext'] = 'เพิ่มโปรแกรมลงในบริบท';
$string['upload_uploadcount'] = 'โปรแกรมที่จะอัปโหลด';
$string['upload_usecategory'] = 'ใช้คอมลัมน์หมวดหมู่สำหรับบริบท';
$string['userupload_completion_error'] = 'ไม่สามารถอัปเดตการจบหลักสูตรของโปรแกรม';
$string['userupload_completion_updated'] = 'อัปเดตการจบหลักสูตรของโปรแกรมแล้ว';

$string['rb_allocatedprograms'] = 'โปรแกรมที่จัดสรร';
$string['rb_complete'] = 'เสร็จสมบูรณ์';
$string['rb_completiondate'] = 'วันที่เสร็จสมบูรณ์';
$string['rb_completionstatus'] = 'สถานะการจบหลักสูตร';
$string['rb_datecompleted'] = 'วันที่เสร็จสมบูรณ์';
$string['rb_dateallocated'] = 'วันที่จัดสรร';
$string['rb_datestarted'] = 'วันที่เริ่มต้น';
$string['rb_coursesall'] = 'หลักสูตร - ทั้งหมด';
$string['rb_incomplete'] = 'ไม่สมบูรณ์';
$string['rb_isallocated'] = 'จัดสรรแล้ว';
$string['rb_iscomplete'] = 'เสร็จสิ้นแล้ว?';
$string['rb_iscompleteany'] = 'เสร็จสิ้นแล้ว? (ทุกวิธี)';
$string['rb_isinprogress'] = 'กำลังดำเนินการ?';
$string['rb_isnotcomplete'] = 'ไม่เสร็จสมบูรณ์?';
$string['rb_isnotyetstarted'] = 'ยังไม่เริ่มต้น?';
$string['rb_notstarted'] = 'ยังไม่เริ่มต้น';
$string['rb_officewhencompletedbasic'] = 'ออฟฟิศเมื่อเสร็จสมบูรณ์ (พื้นฐาน)';
$string['rb_privacy:metadata'] = 'ปลั๊กอินจะไม่จัดเก็บข้อมูลส่วนบุคคลใดๆ';
$string['rb_programcategory'] = 'หมวดหมู่โปรแกรม (หรือไซต์)';
$string['rb_programcategoryid'] = 'ID หมวดหมู่โปรแกรม (N/A หากเป็นไซต์)';
$string['rb_programcategoryidnumber'] = 'หมายเลข ID หมวดหมู่โปรแกรม (N/A หากเป็นไซต์)';
$string['rb_programcategorymultichoice'] = 'ประเภทโปรแกรม (หลายตัวเลือก)';
$string['rb_programedatecreated'] = 'วันที่สร้างโปรแกรม';
$string['rb_programduedate'] = 'วันที่ครบกำหนดโปรแกรม';
$string['rb_programenddate'] = 'วันที่สิ้นสุดการจัดสรรโปรแกรม';
$string['rb_programallocationtype'] = 'ประเภทการจัดสรร';
$string['rb_programallocationtypes'] = 'ประเภทการจัดสรร';
$string['rb_programexpandlink'] = 'ชื่อโปรแกรม (รายละเอียดเพิ่มเติม)';
$string['rb_programid'] = 'ID โปรแกรม';
$string['rb_programidnumber'] = 'หมายเลข ID โปรแกรม';
$string['rb_programname'] = 'ชื่อโปรแกรม';
$string['rb_programnameandsummary'] = 'ชื่อและคำอธิบายโปรแกรม';
$string['rb_programnamelinked'] = 'ชื่อโปรแกรม (เชื่อมโยงกับหน้าโปรแกรม)';
$string['rb_programmultiitem'] = 'โปรแกรม (หลายรายการ)';
$string['rb_programsingleitem'] = 'โปรแกรม';
$string['rb_programstartdate'] = 'วันที่เริ่มต้นการจัดสรรโปรแกรม';
$string['rb_programsummary'] = 'คำอธิบายโปรแกรม';
$string['rb_programvisible'] = 'โปรแกรมเป็นสาธารณะ';
$string['rb_programvisibledisabled'] = 'โปรแกรมปรากฏ (ไม่เกี่ยวข้อง)';
$string['rb_progress'] = 'ความคืบหน้า';
$string['rb_progressnumeric'] = 'ความคืบหน้า (ตัวเลข)';
$string['rb_progresspercent'] = 'ความคืบหน้า (% ที่เสร็จสมบูรณ์)';
$string['rb_source_allocation'] = 'การจัดสรรโปรแกรม';
$string['rb_timetocompletesinceenrol'] = 'เวลาจนกว่าจะเสร็จสมบูรณ์ (นับจากวันที่จัดสรร)';
$string['rb_timetocompletesincestart'] = 'เวลาจนกว่าจะเสร็จสมบูรณ์ (นับจากวันที่เริ่มต้น)';
$string['rb_type_program'] = 'โปรแกรม';
$string['rb_type_program_category'] = 'ประเภท';
$string['rb_type_program_completion'] = 'การจัดสรรโปรแกรม';
$string['rb_type_program_customfields'] = 'ฟิลด์แบบกำหนดเองของโปรแกรม';
$string['rb_user'] = 'ผู้ใช้งาน';
$string['rb_viewprogram'] = 'ดูโปรแกรม';
$string['rb_visiblecohorts'] = 'กลุ่มที่มีการแสดงผล';
