<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Task for deleting sessions that were previously attempted to be deleted via the API but failed.
 * @author    Guy Thomas
 * @copyright Copyright (c) 2017 Open LMS
 * @package   mod_collaborate
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
namespace mod_collaborate\task;

use mod_collaborate\sessionlink;

class cleanup_sessions_task extends \core\task\scheduled_task {

    /**
     * Name for this task.
     *
     * @return string
     */
    public function get_name() {
        return get_string('cleanupsessionstask', 'mod_collaborate');
    }

    /**
     * Run task for cleaning up failed deletions.
     */
    public function execute() {
        sessionlink::task_cleanup_failed_deletions();
    }

}
