# This file is part of Moodle - http://moodle.org/
#
# Moodle is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Moodle is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Moodle.  If not, see <http://www.gnu.org/licenses/>.
#
# Behat feature for Collab grade default
#
# @package    mod_collaborate
# @copyright  Copyright (c) 2016 Open LMS (https://www.openlms.net)
# @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later

@mod @mod_collaborate
Feature: Have a sensible default grade type when creating a Collaborate instance
  In order to quickly add Collaborate instances
  As a teacher
  I want the grade type set to "None"

  Background:
    Given the following "users" exist:
      | username | firstname | lastname | email |
      | teacher1 | Teacher | 1 | teacher1@example.com |
    And the following "courses" exist:
      | fullname | shortname | category |
      | Course 1 | C1 | 0 |
    And the following "course enrolments" exist:
      | user | course | role |
      | teacher1 | C1 | editingteacher |

  Scenario: Teacher can create a Collaborate instance that has grade type default to None
    Given I log in as "teacher1"
    And the following "activity" exists:
      | activity                 | collaborate                      |
      | course                   | C1                               |
      | section                  | 1                                |
      | name                     | Test collab                      |
      | grade[modgrade_type]     | none                             |
      | grade                    | 0                                |
    And I am on "Course 1" course homepage with editing mode on
    And I follow "Test collab"
    And I navigate to "Settings" in current page administration
    Then the field "grade[modgrade_type]" matches value "none"

  Scenario: Teacher can create a Collaborate instance that has grade type of Point
    Given I log in as "teacher1"
    And the following "activity" exists:
      | activity                 | collaborate                      |
      | course                   | C1                               |
      | section                  | 1                                |
      | name                     | Test collab                      |
      | grade[modgrade_type]     | point                            |
      | grade                    | 100                              |
    And I am on "Course 1" course homepage with editing mode on
    And I follow "Test collab"
    And I navigate to "Settings" in current page administration
    Then the field "grade[modgrade_type]" matches value "point"
