define("theme_snap/sidebar_menu",["exports","core/pagehelpers","core_user/repository"],(function(_exports,_pagehelpers,_repository){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0;
/**
   * JavaScript for the Snap theme sidebar menu functionality
   *
   * @module     theme_snap/sidebar_menu
   * @copyright  2024 Open LMS (https://www.openlms.net)
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
const SELECTORS_SIDEBAR="#snap-sidebar-menu",SELECTORS_TRIGGER=".snap-sidebar-menu-trigger",SELECTORS_TRIGGER_ICON=".snap-sidebar-menu-trigger i",SELECTORS_HEADER="header",SELECTORS_DRAWER_BUTTON=".snap-sidebar-menu-item[data-activeselector]",SELECTORS_MESSAGES_POPOVER='[data-region="popover-region-messages"]',SELECTORS_CLOSE_DRAWER_BUTTON='[data-action="closedrawer"]',SELECTORS_SIDEBAR_MENU_ITEM=".snap-sidebar-menu-item",SELECTORS_NAV_UNPINNED="#mr-nav.headroom--unpinned",SELECTORS_GOTO_TOP_LINK="#goto-top-link",CLASSES_CUSTOM_MENU_ITEM="custom-menu-item",CLASSES_SHOW="show",CLASSES_ACTIVE="active",CLASSES_COLLAPSED="collapsed",CLASSES_ROTATE="rotate-180",CLASSES_POSITIONING_OFFSCREEN="positioning-offscreen",DRAWERS={SELECTORS:[".drawer",".block_settings.block","#snap_feeds_side_menu",".drawer:has(.message-app)"],ACTIVE_SELECTORS:[".drawer.show",".block_settings.block.state-visible","#snap_feeds_side_menu.state-visible",".drawer:not(.hidden):has(.message-app)"]},POPOVERS_DROPDOWNS={CLICKABLE_SELECTORS:["#user-menu-toggle","#nav-intellicart-popover-container","#nav-notification-popover-container"]},PREFERENCE_MAP={["drawer-open-block"]:'[data-activeselector="#theme_snap-drawers-blocks.show"]',["snap-feeds-open"]:'[data-activeselector="#snap_feeds_side_menu_trigger.active"]',["snap-message-drawer-open"]:"[data-activeselector='[data-region=\"popover-region-messages\"]:not(.collapsed)']"};let lastScrollX=0;const toggleSidebar=()=>{const sidebar=document.querySelector(SELECTORS_SIDEBAR),icon=document.querySelector(SELECTORS_TRIGGER_ICON),isClosing=sidebar.classList.contains(CLASSES_SHOW);sidebar.classList.toggle(CLASSES_SHOW),icon.classList.toggle(CLASSES_ROTATE),updateElementPositions(),isClosing&&closeAllDrawers()},updateElementPositions=function(){let selectors=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null;const header=document.querySelector(SELECTORS_HEADER);if(!header)return;const headerRect=header.getBoundingClientRect(),visibleHeight=window.innerHeight,topPosition=Math.max(0,headerRect.bottom),isNavUnpinned=document.querySelector(SELECTORS_NAV_UNPINNED),sidebar=document.querySelector(SELECTORS_SIDEBAR);if(sidebar&&(isNavUnpinned?(sidebar.style.top="0px",sidebar.style.height="100vh"):(sidebar.style.top="".concat(topPosition,"px"),sidebar.style.height="".concat(visibleHeight-topPosition,"px")),setTimeout((()=>{sidebar.classList.remove(CLASSES_POSITIONING_OFFSCREEN)}),100)),selectors){(Array.isArray(selectors)?selectors:[selectors]).forEach((selector=>{queryActiveDrawers(selector).forEach((element=>{isNavUnpinned?(element.style.top="0px",element.style.height="100vh"):(element.style.top="".concat(topPosition,"px"),element.style.height="".concat(visibleHeight-topPosition,"px")),(element.classList.contains(CLASSES_SHOW)||element.classList.contains(CLASSES_ACTIVE)||!element.classList.contains(CLASSES_COLLAPSED))&&(element.style.maxHeight=isNavUnpinned?"100vh":"".concat(visibleHeight-topPosition,"px"))}))}))}},handleDrawerButtonClick=e=>{setTimeout((()=>{const button=e.target.closest(SELECTORS_DRAWER_BUTTON);if(repositionGotoTopLink(),!button)return;const activeSelector=button.dataset.activeselector;if(!activeSelector)return;const activeElements=document.querySelectorAll(activeSelector);Array.from(activeElements).some((el=>el.classList.contains(CLASSES_SHOW)||el.classList.contains(CLASSES_ACTIVE)||!el.classList.contains(CLASSES_COLLAPSED)))?(closeOtherDrawers(activeSelector,button),button.classList.add(CLASSES_ACTIVE),setDrawerPreference(activeSelector,!0)):(button.classList.remove(CLASSES_ACTIVE),setDrawerPreference(activeSelector,!1))}),50)},closeOtherDrawers=(currentSelector,currentButton)=>{const drawerButtons=document.querySelectorAll(SELECTORS_DRAWER_BUTTON);repositionGotoTopLink(),drawerButtons.forEach((button=>{if(button===currentButton)return;const activeSelector=button.dataset.activeselector;if(!activeSelector||activeSelector===currentSelector)return;const activeElements=document.querySelectorAll(activeSelector);if(Array.from(activeElements).some((el=>el.classList.contains(CLASSES_SHOW)||el.classList.contains(CLASSES_ACTIVE)||!el.classList.contains(CLASSES_COLLAPSED)))){if(button.classList.contains(CLASSES_CUSTOM_MENU_ITEM)){(button.querySelector("a, button")||button).click()}else button.click();setDrawerPreference(activeSelector,!1),button.classList.remove(CLASSES_ACTIVE)}}))},closeAllDrawers=()=>{const drawerButtons=document.querySelectorAll(SELECTORS_DRAWER_BUTTON);repositionGotoTopLink(),drawerButtons.forEach((button=>{const activeSelector=button.dataset.activeselector;if(!activeSelector)return;const activeElements=document.querySelectorAll(activeSelector);if(Array.from(activeElements).some((el=>el.classList.contains(CLASSES_SHOW)||el.classList.contains(CLASSES_ACTIVE)||!el.classList.contains(CLASSES_COLLAPSED)))){if(button.classList.contains(CLASSES_CUSTOM_MENU_ITEM)){(button.querySelector("a, button")||button).click()}else button.click();button.classList.remove(CLASSES_ACTIVE)}}))},handleMessagesPopoverClick=e=>{const sidebarItem=e.currentTarget.closest(SELECTORS_SIDEBAR_MENU_ITEM);if(repositionGotoTopLink(),sidebarItem){e.currentTarget.classList.contains(CLASSES_COLLAPSED)?e.currentTarget.classList.remove(CLASSES_COLLAPSED):e.currentTarget.classList.add(CLASSES_COLLAPSED)}},setDrawerPreference=(activeSelector,value)=>{for(const[preference,selector]of Object.entries(PREFERENCE_MAP))selector.includes(activeSelector)&&!(0,_pagehelpers.isSmall)()&&value?(0,_repository.setUserPreferences)([{name:preference,value:!0}]):(value||selector.includes(activeSelector)&&!value)&&(0,_repository.setUserPreferences)([{name:preference,value:!1}])},handleCloseDrawerClick=()=>{repositionGotoTopLink(),document.querySelectorAll(SELECTORS_DRAWER_BUTTON).forEach((button=>{button.classList.remove(CLASSES_ACTIVE)}));const messagesPopover=document.querySelector(SELECTORS_MESSAGES_POPOVER);messagesPopover&&!messagesPopover.classList.contains(CLASSES_COLLAPSED)&&messagesPopover.classList.add(CLASSES_COLLAPSED)};_exports.init=()=>{(()=>{const trigger=document.querySelector(SELECTORS_TRIGGER);trigger&&trigger.addEventListener("click",toggleSidebar),window.addEventListener("resize",(()=>{updateElementPositions(DRAWERS.SELECTORS)})),window.addEventListener("scroll",(()=>{setTimeout((()=>{updateElementPositions(DRAWERS.SELECTORS);const gotoTopLink=document.querySelector(SELECTORS_GOTO_TOP_LINK);gotoTopLink&&"visible"===window.getComputedStyle(gotoTopLink).visibility&&repositionGotoTopLink(),toggleSidebarOnHorizontalScroll(window.scrollX)}),50)})),document.querySelectorAll(SELECTORS_DRAWER_BUTTON).forEach((button=>{button.addEventListener("click",handleDrawerButtonClick)}));const messagesPopover=document.querySelector(SELECTORS_MESSAGES_POPOVER);messagesPopover&&messagesPopover.addEventListener("click",handleMessagesPopoverClick),document.querySelectorAll(SELECTORS_CLOSE_DRAWER_BUTTON).forEach((element=>{element.addEventListener("click",handleCloseDrawerClick)})),setupPopoverClickHandlers()})(),updateElementPositions(),updateElementPositions(DRAWERS.SELECTORS),(async()=>{const preferences=await(0,_repository.getUserPreferences)(),preferencesArray={};preferences.preferences.forEach((pref=>{M.cfg.behatsiterunning?preferencesArray[pref.name]=0:preferencesArray[pref.name]=pref.value}));for(const[prefKey,drawerSelector]of Object.entries(PREFERENCE_MAP))if(1===preferencesArray[prefKey]||"1"===preferencesArray[prefKey]){const button=document.querySelector(drawerSelector);button&&(button.querySelector("a, button")||button).click()}})()};const queryActiveDrawers=selector=>{if(".drawer:not(.hidden):has(.message-app)"===selector){const potentialDrawers=document.querySelectorAll(".drawer:not(.hidden)");return Array.from(potentialDrawers).filter((drawer=>drawer.querySelector(".message-app")))}if(".drawer:has(.message-app)"===selector){const potentialDrawers=document.querySelectorAll(".drawer");return Array.from(potentialDrawers).filter((drawer=>drawer.querySelector(".message-app")))}return document.querySelectorAll(selector)},repositionGotoTopLink=()=>{const gotoTopLink=document.querySelector(SELECTORS_GOTO_TOP_LINK);if(!gotoTopLink)return;gotoTopLink.style.marginRight="";const sidebar=document.querySelector(SELECTORS_SIDEBAR);if(sidebar&&sidebar.classList.contains(CLASSES_SHOW))for(const selector of DRAWERS.ACTIVE_SELECTORS){const activeDrawers=queryActiveDrawers(selector);if(activeDrawers.length>0){const drawer=activeDrawers[0];if(drawer.offsetWidth>0){const drawerWidth=drawer.offsetWidth;return void(gotoTopLink.style.marginRight="".concat(drawerWidth,"px"))}}}},toggleSidebarOnHorizontalScroll=scrollX=>{const sidebar=document.querySelector(SELECTORS_SIDEBAR);sidebar&&(0!==scrollX?0===lastScrollX&&(sidebar.style.right="-100%",DRAWERS.ACTIVE_SELECTORS.forEach((selector=>{queryActiveDrawers(selector).forEach((drawer=>{drawer.style.right="-100%"}))}))):0!==lastScrollX&&(sidebar.style.right="",DRAWERS.ACTIVE_SELECTORS.forEach((selector=>{queryActiveDrawers(selector).forEach((drawer=>{drawer.style.right=""}))}))),lastScrollX=scrollX)},setupPopoverClickHandlers=()=>{let isClosingDrawers=!1;const checkAndCloseDrawers=()=>{if(isClosingDrawers)return!1;let hasOpenDrawers=!1;return DRAWERS.ACTIVE_SELECTORS.forEach((selector=>{queryActiveDrawers(selector).length>0&&(hasOpenDrawers=!0)})),!!hasOpenDrawers&&(isClosingDrawers=!0,closeAllDrawers(),isClosingDrawers=!1,!0)};POPOVERS_DROPDOWNS.CLICKABLE_SELECTORS.forEach((selector=>{document.querySelectorAll(selector).forEach((element=>{element.addEventListener("click",(()=>{checkAndCloseDrawers()}),!0),element.addEventListener("keydown",(e=>{"Enter"!==e.key&&13!==e.keyCode||checkAndCloseDrawers()}),!0)}))}))}}));

//# sourceMappingURL=sidebar_menu.min.js.map