/**
 * This file is part of Moodle - http://moodle.org/
 *
 * Moodle is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Moodle is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Moodle.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package
 * @copyright Copyright (c) 2015 Open LMS (https://www.openlms.net)
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("theme_snap/snap",["jquery","core/log","core/aria","theme_snap/headroom","theme_snap/util","theme_snap/cover_image","theme_snap/progressbar","core/templates","core/str","core/ajax","theme_snap/accessibility","theme_snap/messages","theme_snap/scroll"],(function($,log,Aria,Headroom,util,coverImage,ProgressBar,templates,str,ajax,accessibility,messages,Scroll){M.theme_snap=M.theme_snap||{};log.disableAll(!0);var brandColorSuccess="",brandColorWarning="",GRADE_DISPLAY_TYPE_PERCENTAGE="",GRADE_DISPLAY_TYPE_PERCENTAGE_REAL="",GRADE_DISPLAY_TYPE_PERCENTAGE_LETTER="",GRADE_DISPLAY_TYPE_REAL="",GRADE_DISPLAY_TYPE_REAL_PERCENTAGE="",GRADE_DISPLAY_TYPE_REAL_LETTER="",getURLParams=function(href){var ta=href.split("?");if(ta.length<2)return!1;for(var urlparams=ta[1],items=(urlparams=urlparams.split("#")[0]).split("&"),params=[],i=0;i<items.length;i++){var item=items[i].split("="),key=item[0],val=item[1];params[key]=val}return params};$(window).on("resize",(function(){mobileFormChecker(),updateGraderHeadersTop(),updateSubmissionsHeaderTop()}));var mobileFormChecker=function(){var savebuttonsformrequired=$("div[role=main] .mform div.snap-form-required fieldset > div.form-group.fitem"),savebuttonsformadvanced=$("div[role=main] .mform div.snap-form-advanced > div:nth-of-type(3)"),width=$(window).width();width<992?$(".snap-form-advanced").append(savebuttonsformrequired):width>992&&$(".snap-form-required fieldset#id_general").append(savebuttonsformadvanced)};const updateGraderHeadersTop=function(){const graderHeader=$(".path-grade-report-grader .gradeparent tr.heading");graderHeader.length&&graderHeader.css("top",$("#mr-nav").height()+"px")},updateSubmissionsHeaderTop=function(){const submissionsHeader=$("#page-mod-assign-grading #submissions");submissionsHeader.length&&submissionsHeader.css("top",$("#mr-nav").height()+"px")},regionMain=$('.path-grade-report-grader #region-main div[role="main"]');if(regionMain.length>0){regionMain[0].querySelector(".gradeparent")&&regionMain.addClass("snap-grade-reporter")}updateGraderHeadersTop();var onCoursePage=function(){return 0===$("body").attr("id").indexOf("page-course-view-")},processSearchString=function(searchString){return searchString=searchString.trim().toLowerCase()},createColoredDataCircle=function(nodePointer,dataCallback){let valueCallback=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null;var circle=new ProgressBar.Circle(nodePointer,{color:"inherit",easing:"linear",strokeWidth:6,trailWidth:3,duration:1400,text:{value:"0"}}),value=$(nodePointer).attr("value")/100,endColor=brandColorSuccess;0===value||"-"===$(nodePointer).attr("value")?circle.setText("-"):($(nodePointer).attr("value")<50&&(endColor=brandColorWarning),circle.setText(dataCallback(nodePointer)));var valueAnimate=0;valueAnimate=null===valueCallback?value:valueCallback(nodePointer),circle.animate(valueAnimate,{from:{color:"#999"},to:{color:endColor},step:function(state,circle){circle.path.setAttribute("stroke",state.color)}})},addListeners=function(){$(document).on("click",[".chapters a",".section_footer a"," #toc-search-results a"].join(", "),(function(e){var href=this.getAttribute("href");window.history&&window.history.pushState?(history.pushState(null,null,href),$(window).trigger("hashchange"),e.preventDefault()):location.hash=href}));var myElement=document.querySelector("#mr-nav"),headroom=new Headroom(myElement,{tolerance:5,offset:100,classes:{initial:"headroom",pinned:"headroom--pinned",unpinned:"headroom--unpinned",top:"headroom--top",notTop:"headroom--not-top"},onPin:()=>{$(".snap-drawer-no-headroom").addClass("snap-drawer-headroom"),$(".snap-drawer-headroom").removeClass("snap-drawer-no-headroom")},onUnpin:()=>{$(".snap-drawer-headroom").addClass("snap-drawer-no-headroom"),$(".snap-drawer-no-headroom").removeClass("snap-drawer-headroom")}});$(".notloggedin").length||headroom.init();var dataList=$("#toc-searchables").find("li").clone(!0);$("#course-toc").on("keyup","#toc-search-input",(function(){!function(dataList){var i,ua=window.navigator.userAgent;(ua.indexOf("MSIE ")||ua.indexOf("Trident/"))&&(dataList=$("#toc-searchables").find("li").clone(!0));var searchString=$("#toc-search-input").val();if(0===(searchString=processSearchString(searchString)).length)$("#toc-search-results").html(""),$("#toc-search-input").removeClass("state-active");else{$("#toc-search-input").addClass("state-active");var matches=[];for(i=0;i<dataList.length;i++){var dataItem=dataList[i];processSearchString($(dataItem).text()).indexOf(searchString)>-1&&matches.push(dataItem)}$("#toc-search-results").html(matches)}}(dataList)})),$("#course-toc").on("keydown","#toc-search-input",(function(e){9===(e.keyCode||e.which)&&$("#toc-search-results a").last().blur((function(){$(this).off("blur"),$("#toc-search-input").val(""),$("#toc-search-results").html(""),$("#toc-search-input").removeClass("state-active")}))})),$("#course-toc").on("click","#toc-search-results a",(function(){$("#toc-search-input").val(""),$("#toc-search-results").html(""),$("#toc-search-input").removeClass("state-active")})),$(document).on("click",(function(event){$(event.target).closest("#toc-search-input").length||($("#toc-search-input").val(""),$("#toc-search-results").html(""),$("#toc-search-input").removeClass("state-active"))})),$(document).on("click",'#admin-menu-trigger, #toc-mobile-menu-toggle, [id^="message-drawer-toggle-"]',(function(e){var href=this.getAttribute("href");("admin-menu-trigger"===this.getAttribute("id")||this.getAttribute("id").startsWith("message-drawer-toggle-"))&&($(this).toggleClass("active"),$("#page").toggleClass("offcanvas"),"true"===$(this).attr("aria-expanded")?$(this).attr("aria-expanded",!1):$(this).attr("aria-expanded",!0)),0!=$("#sticky-footer").length&&$("#sticky-footer").toggleClass("snap-mod-data-sticky-footer"),$(href).attr("tabindex","0"),$(href).toggleClass("state-visible").focus(),e.preventDefault(),$(href).hasClass("state-visible")?Aria.unhide(document.querySelector("#settingsnav")):Aria.hide(document.querySelector("#settingsnav")),0===$(".message-app.main").length&&document.dispatchEvent(new Event("messages-drawer:toggle"))})),$(document).on("click","#snap_feeds_side_menu_trigger",(function(e){var href=this.getAttribute("href");"snap_feeds_side_menu_trigger"===this.getAttribute("id")&&($(this).toggleClass("active"),$("#page").toggleClass("offcanvas"),"true"===$(this).attr("aria-expanded")?$(this).attr("aria-expanded",!1):$(this).attr("aria-expanded",!0)),$(href).toggleClass("state-visible").focus(),e.preventDefault(),0!=$("#sticky-footer").length&&$("#sticky-footer").toggleClass("snap-mod-data-sticky-footer")})),$(document).on("click",'[data-region="popover-region-messages"] a',(function(){0!=$("#sticky-footer").length&&$("#sticky-footer").toggleClass("snap-mod-data-sticky-footer")})),$(document).on("click",'[id^="message-drawer-"] > div.closewidget > a',(function(e){$("#page").toggleClass("offcanvas"),e.preventDefault()})),$(document).on("click","#course-toc.state-visible a",(function(){$("#course-toc").removeClass("state-visible")})),"CSS1Compat"!==document.compatMode&&log.error('The document is rendering in "quirks mode". This may cause issues with the site\'s functionality. Please ensure that the DOCTYPE declaration is present and correctly placed at the very start of the HTML document.'),$(document).on("click",".section_footer a, .chapter-title, .toc-footer a",(function(){const videos=$('[title="watch"], .video-js, iframe:not([id])');for(let i=0;i<videos.length;i++)if(videos[i].classList.contains("video-js")){if(videos[i].classList.contains("vjs-playing")){videos[i].querySelector(".vjs-play-control.vjs-control.vjs-button").click()}}else"IFRAME"===videos[i].nodeName?videos[i].src.includes("vimeo")&&(videos[i].src+=""):videos[i].querySelector("iframe").src+=""})),$(document).on("click",".news-article .toggle",(function(e){var $news=$(this).closest(".news-article"),$newstoggle=$(this);util.scrollToElement($news),$(".news-article").not($news).removeClass("state-expanded"),$(".news-article a.toggle:not(.snap-icon-close), .news-article h3.toggle a").not($newstoggle).attr("aria-expanded","false"),$(".news-article-message").css("display","none"),$news.toggleClass("state-expanded"),$news.attr("state-expanded")||($news.focus(),$newstoggle.hasClass("news-article-image")||$newstoggle.hasClass("snap-icon-close")||$newstoggle.find("a").attr("aria-expanded","false")),$(".state-expanded").find(".news-article-message").slideDown("fast",(function(){$news.is(".state-expanded")?($news.find(".news-article-message").focus(),$newstoggle.hasClass("news-article-image")||$newstoggle.hasClass("snap-icon-close")||$newstoggle.find("a").attr("aria-expanded","true")):($news.focus(),$newstoggle.hasClass("news-article-image")||$newstoggle.hasClass("snap-icon-close")||$newstoggle.find("a").attr("aria-expanded","false")),$(document).trigger("snapContentRevealed")})),e.preventDefault()})),$(document).on("click",".anim-play-button",(function(){$(this).parent().prev().css("visibility","visible")})),$(document).on("click",".anim-pause-button",(function(){$(this).parent().prev().css("visibility","hidden")})),(new Scroll).init(),$((function(){var supportsTouch=!1;if(("ontouchstart"in window||window.navigator.msPointerEnabled)&&(supportsTouch=!0),!supportsTouch){var tooltipNode=$('[data-toggle="tooltip"]');$.isFunction(tooltipNode.tooltip)&&tooltipNode.tooltip()}}))},editToggleURL=function(courseFormat){const editModeToggleObserver=function(mutationsList,observer){for(const mutation of mutationsList)if("attributes"===mutation.type){document.querySelector(".editmode-switch-form .custom-control-input").hasAttribute("aria-checked")&&(observer.disconnect(),location.reload())}};var courseEditSwitch=document.querySelector("#page-course-view-"+courseFormat+" .editmode-switch-form .custom-control-input");if(courseEditSwitch){var urlHash=window.location.hash,originalUrl=courseEditSwitch.getAttribute("data-pageurl"),modifiedURL=originalUrl+urlHash;courseEditSwitch.setAttribute("data-pageurl",modifiedURL),window.onhashchange=function(){urlHash=window.location.hash,courseEditSwitch.setAttribute("data-pageurl",originalUrl+urlHash)};new MutationObserver(editModeToggleObserver).observe(document.body,{attributes:!0})}},setHomeCourseFavourite=function(selector){document.querySelectorAll(".snap-home-course .favouriteicon ."+selector).forEach((function(button){button.addEventListener("click",(function(){const course=button.dataset.courseid;const request={methodname:"core_course_set_favourite_courses",args:{courses:[{id:course,favourite:"unset-favourite"!==selector}]},done:function(response){if(!response.warnings.length){if(document.querySelectorAll(".favouriteicon ."+selector+'[data-courseid="'+course+'"]').forEach((function(relatedButton){relatedButton.classList.add("d-none")})),"unset-favourite"===selector){document.querySelectorAll('.favouriteicon .set-favourite[data-courseid="'+course+'"]').forEach((function(setButton){setButton.classList.remove("d-none")}))}else{document.querySelectorAll('.favouriteicon .unset-favourite[data-courseid="'+course+'"]').forEach((function(setButton){setButton.classList.remove("d-none")}))}}}};return ajax.call([request])[0]}))}))};return{snapInit:function(courseConfig,pageHasCourseContent,siteMaxBytes,forcePassChange,messageBadgeCountEnabled,userId,inAlternativeRole,brandColors,gradingConstants){brandColorSuccess=brandColors.success,brandColorWarning=brandColors.warning,GRADE_DISPLAY_TYPE_PERCENTAGE=gradingConstants.gradepercentage,GRADE_DISPLAY_TYPE_PERCENTAGE_REAL=gradingConstants.gradepercentagereal,GRADE_DISPLAY_TYPE_PERCENTAGE_LETTER=gradingConstants.gradepercentageletter,GRADE_DISPLAY_TYPE_REAL=gradingConstants.gradereal,GRADE_DISPLAY_TYPE_REAL_PERCENTAGE=gradingConstants.graderealpercentage,GRADE_DISPLAY_TYPE_REAL_LETTER=gradingConstants.graderealletter,M.cfg.context=courseConfig.contextid,M.snapTheme={forcePassChange:forcePassChange},pageHasCourseContent&&require(["theme_snap/course-lazy"],(function(CourseLibAmd){!function(courseLib){var lastHash=location.hash;$(window).on("popstate hashchange",(function(e){var newHash=location.hash;log.info("hashchange"),newHash!==lastHash&&($("#page, #moodle-footer, #logo, .skiplinks").css("display",""),onCoursePage()&&(log.info("show section",e.target),courseLib.showSection())),lastHash=newHash}))}(new CourseLibAmd(courseConfig))})),$(document).ready((function(){var extraclasses;!function(){var xdebugs=$(".xdebug-error");if(xdebugs.length)for(var x=0;x<xdebugs.length;x++){var fontel=xdebugs[x].parentNode,br=$(fontel).prev("br");$(br).remove()}var msgs=$(".xdebug-error, .php-debug, .debuggingmessage");if(msgs.length){$(msgs).addClass("php-debug-footer");var errorcont=$('<div id="footer-error-cont"><h3>'+M.util.get_string("debugerrors","theme_snap")+"</h3><hr></div>");$("#page-footer").append(errorcont),$("#footer-error-cont").append(msgs),$(".php-debug-footer").after($("<hr>")),$("#mr-nav").addClass("errors-found");var errorlink=$('<a class="footer-error-link btn btn-danger" href="#footer-error-cont">'+M.util.get_string("problemsfound","theme_snap")+' <span class="badge">'+msgs.length+"</span></a>");$("#page-header").append(errorlink)}}(),$(".path-mod-forum tr.discussion td.topic.starter").attr("data-cellname",M.util.get_string("forumtopic","theme_snap")),$(".path-mod-forum tr.discussion td.picture:not('.group')").attr("data-cellname",M.util.get_string("forumauthor","theme_snap")),$(".path-mod-forum tr.discussion td.picture.group").attr("data-cellname",M.util.get_string("forumpicturegroup","theme_snap")),$(".path-mod-forum tr.discussion td.replies").attr("data-cellname",M.util.get_string("forumreplies","theme_snap")),$(".path-mod-forum tr.discussion td.lastpost").attr("data-cellname",M.util.get_string("forumlastpost","theme_snap")),addListeners(),function(){if(""===location.hash){var urlParams=getURLParams(location.href);onCoursePage()&&void 0!==urlParams.time&&(location.hash="coursetools",$(".block_calendar_month")&&util.scrollToElement($(".block_calendar_month")));var formselectors=["body.path-blocks-collect #notice form"],paramchecks=["bui_deleteid","bui_editid"];for(var p in paramchecks)if(void 0!==urlParams[paramchecks[p]]){formselectors.push("#notice form");break}$(formselectors.join(", ")).each((function(){var formurl=$(this).attr("action");-1===formurl.indexOf("#")&&formurl.indexOf("/course/view.php")>-1&&$(this).attr("action",$(this).attr("action")+"#coursetools")})),document.querySelectorAll("#coursetools li div.snap-participant-icons span.userinitials").forEach((function(el){el.setAttribute("aria-hidden","true")}))}}(),extraclasses=[],$("#notice.snap-continue-cancel").length&&extraclasses.push("hascontinuecancel"),$("body").addClass(extraclasses.join(" ")),mobileFormChecker(),util.processAnimatedImages(),$("#page-mod-assign-view #page-content").append($("#moodle-blocks")),$(".snap-header-card .snap-header-card-icons .disabled-snap-asset-completion-tracking").remove();var folders=$("li.snap-activity.modtype_folder");if($.each(folders,(function(index,folder){var content=$(folder).find("div.contentwithoutlink div.snap-assettype");if(content.length>0&&0==$(folder).find("div.activityinstance div.snap-header-card .asset-type").length){var folderAssetTypeHeader=$(folder).find("div.activityinstance div.snap-header-card");content.prependTo(folderAssetTypeHeader)}})),$("body").addClass("snap-js-loaded"),document.querySelector('[id^="page-mod-"]')){let contextHeader=document.querySelector("div.page-context-header"),regionMain=document.querySelector("#region-main");null!==contextHeader&&null!==regionMain&&regionMain.insertBefore(contextHeader,regionMain.firstChild)}if($(".snap-student-dashboard-progress .js-progressbar-circle").each((function(){createColoredDataCircle(this,(function(nodePointer){return $(nodePointer).attr("value")+"<small>%</small>"}))})),$(".snap-student-dashboard-grade .js-progressbar-circle").each((function(){createColoredDataCircle(this,(function(nodePointer){var nodeValue=$(nodePointer).attr("value"),gradeFormat=$(nodePointer).attr("gradeformat");return gradeFormat!=GRADE_DISPLAY_TYPE_PERCENTAGE&&gradeFormat!=GRADE_DISPLAY_TYPE_PERCENTAGE_REAL&&gradeFormat!=GRADE_DISPLAY_TYPE_PERCENTAGE_LETTER||(nodeValue+="<small>%</small>"),nodeValue}),(function(nodePointer){$(nodePointer).attr("value");var gradeFormat=$(nodePointer).attr("gradeformat");return gradeFormat==GRADE_DISPLAY_TYPE_REAL||gradeFormat==GRADE_DISPLAY_TYPE_REAL_PERCENTAGE||gradeFormat==GRADE_DISPLAY_TYPE_REAL_LETTER?0:$(nodePointer).attr("value")/100}))})),$("#snap-course-footer-recent-activity .info").each((function(){$(this).appendTo($(this).prev())})),$("#snap-course-footer-recent-activity .head .name").each((function(){$(this).prependTo($(this).closest(".head"))})),$(".notloggedin").length||($("body").hasClass("pagelayout-course")||$("body").hasClass("pagelayout-frontpage")?coverImage.courseImage(courseConfig.shortname,siteMaxBytes):$("body").hasClass("pagelayout-coursecategory")&&courseConfig.categoryid&&coverImage.categoryImage(courseConfig.categoryid,siteMaxBytes)),$("#page-admin-setting-themesettingsnap").length){var tabHash=location.hash;tabHash&&$('.nav-link[href="'+tabHash+'"]').length&&($('.nav-link[href="'+tabHash+'"]').tab("show"),$(window).scrollTop(0))}var firstlinkerror=$("#page-admin-setting-themesettingsnap #themesnapfeaturespots #admin-fs_one_title_link span.error"),secondlinkerror=$("#page-admin-setting-themesettingsnap #themesnapfeaturespots #admin-fs_two_title_link span.error"),thirdlinkerror=$("#page-admin-setting-themesettingsnap #themesnapfeaturespots #admin-fs_three_title_link span.error"),titlelinksettingone=$("#page-admin-setting-themesettingsnap #themesnapfeaturespots #admin-fs_one_title_link .form-label"),titlelinksettingtwo=$("#page-admin-setting-themesettingsnap #themesnapfeaturespots #admin-fs_two_title_link .form-label"),titlelinksettingthree=$("#page-admin-setting-themesettingsnap #themesnapfeaturespots #admin-fs_three_title_link .form-label");$("#page-admin-setting-themesettingsnap #themesnapfeaturespots #admin-fs_three_title").nextUntil("#page-admin-setting-themesettingsnap #themesnapfeaturespots #admin-fs_one_title_link_cb").wrapAll("<div class=fs-title-links></div>");var linktitlestyle={"padding-bottom":"2.1em"};firstlinkerror.length&&(titlelinksettingtwo.css(linktitlestyle),titlelinksettingthree.css(linktitlestyle)),secondlinkerror.length&&(titlelinksettingone.css(linktitlestyle),titlelinksettingthree.css(linktitlestyle)),thirdlinkerror.length&&(titlelinksettingone.css(linktitlestyle),titlelinksettingtwo.css(linktitlestyle));const sname=document.getElementById("id_name");if($("#page-course-editsection.format-topics").length?(sname.required="required",$(sname).attr("pattern",".*\\S+.*"),$("#id_cancel").on("click",(function(){return $(sname).removeAttr("required"),$(sname).removeAttr("pattern"),!0}))):($("#id_name_value").attr("pattern",".*\\S+.*"),$("#id_cancel").on("click",(function(){return $(sname).removeAttr("pattern"),!0}))),$('#page-mod-book-view a[href*="mod/book/tool/print/index.php"]').length){var urlParams=getURLParams(location.href);urlParams&&$('[data-block="_fake"]').append('<p><hr><a target="_blank" href="/mod/book/tool/print/index.php?id='+urlParams.id+'">'+M.util.get_string("printbook","booktool_print")+"</a></p>")}var modSettingsIdRe=/^page-mod-.*-mod$/,onModSettings=modSettingsIdRe.test($("body").attr("id"))&&location.href.indexOf("modedit")>-1;onModSettings||(onModSettings=(modSettingsIdRe=/^page-mod-.*-general$/).test($("body").attr("id"))&&location.href.indexOf("modedit")>-1);var onCourseSettings="page-course-edit"===$("body").attr("id"),onSectionSettings="page-course-editsection"===$("body").attr("id");$("#page-mod-hvp-mod .h5p-editor-iframe").parent().css({display:"block"});var pageNotInBlacklist=-1===["page-mod-hvp-mod"].indexOf($("body").attr("id"));if((onModSettings||onCourseSettings||onSectionSettings)&&pageNotInBlacklist){var vital=[":first","#page-course-edit #id_descriptionhdr","#id_contentsection","#id_general + #id_general","#id_content","#page-mod-choice-mod #id_optionhdr","#page-mod-workshop-mod #id_gradingsettings","#page-mod-choicegroup-mod #id_miscellaneoussettingshdr","#page-mod-choicegroup-mod #id_groups","#page-mod-scorm-mod #id_packagehdr"];vital=vital.join(),$('form[id^="mform1"] > fieldset').not(vital).wrapAll('<div class="snap-form-advanced col-md-4" />'),$(".snap-form-advanced").append($(".collapsible-actions"));const formContainers=$(".snap-form-advanced > fieldset > .fcontainer"),collapsemenu=$(".collapsible-actions > .collapsemenu")[0];$(".snap-form-advanced > fieldset > .fcontainer").on("hidden.bs.collapse",(()=>{[...formContainers].every((container=>!container.classList.contains("show")))&&(collapsemenu.classList.add("collapsed"),collapsemenu.setAttribute("aria-expanded",!1))})),$(".snap-form-advanced > fieldset > .fcontainer").on("shown.bs.collapse",(()=>{[...formContainers].every((container=>container.classList.contains("show")))&&(collapsemenu.classList.remove("collapsed"),collapsemenu.setAttribute("aria-expanded",!0))})),$("#page-course-edit").length||$(".snap-form-advanced fieldset").addClass("collapsed");for(var mainForm=$('form[id^="mform1"] fieldset:first'),appendTo=$('form[id^="mform1"] fieldset:first .fcontainer'),required=$('form[id^="mform1"] > fieldset').not('form[id^="mform1"] > fieldset:first'),i=0;i<required.length;i++){var content=$(required[i]).find(".fcontainer");$(appendTo).append(content),$(required[i]).remove()}if($(mainForm).wrap('<div class="snap-form-required col-md-8" />'),$("body#page-mod-lti-mod").length){var multipleLTIActivities=document.querySelector('section#region-main form.mform > div[data-attribute="dynamic-import"]');new MutationObserver((function(){$("fieldset#id_general > :nth-child(5)").detach().appendTo('section#region-main > div[role="main"] > form.mform')})).observe(multipleLTIActivities,{childList:!0})}var description=$('form[id^="mform1"] fieldset:first .fitem_feditor:not(.required)');if(onModSettings&&description){0===$(["body#page-mod-assign-mod","body#page-mod-choice-mod","body#page-mod-turnitintool-mod","body#page-mod-workshop-mod"].join()).length&&($(appendTo).append(description),$(appendTo).append($("#fitem_id_showdescription"))),$(["body#page-mod-url-mod","body#page-mod-resource-mod","body#page-mod-folder-mod","body#page-mod-imscp-mod","body#page-mod-lightboxgallery-mod","body#page-mod-scorm-mod"].join()).length>0&&str.get_strings([{key:"multimediacard",component:"theme_snap"}]).done((function(stringsjs){var activityCards=stringsjs[0],cardmultimedia=$("[id='id_showdescription']").closest(".form-group");$(cardmultimedia).append(activityCards)})),str.get_strings([{key:"pageactivitywithnodescription",component:"theme_snap"}]).done((function(stringsjs){let stringmsg=stringsjs[0],modpagelocation=$("#page-mod-page-mod").find("#id_coursecontentnotification").closest(".form-group");$(modpagelocation).append(stringmsg)}))}description=$("#page-mod-resource-mod [data-fieldtype='editor']").closest(".form-group");var showdescription=$("#page-mod-resource-mod [id='id_showdescription']").closest(".form-group");$("#page-mod-resource-mod .snap-form-advanced #id_modstandardelshdr .fcontainer").append(description),$("#page-mod-resource-mod .snap-form-advanced #id_modstandardelshdr .fcontainer").append(showdescription);var duedate=$("#page-mod-assign-mod [for='id_duedate']").closest(".form-group");$("#page-mod-assign-mod .snap-form-required .fcontainer").append(duedate);var availablity=$("#id_visible").closest(".form-group").addClass("snap-form-visibility"),label=$(availablity).find("label"),select=$(availablity).find("select");if($(label).insertBefore(select),$(label).text(M.util.get_string("visibility","theme_snap")+" "),$("#page-course-edit").length){var strDisabled="";str.get_strings([{key:"showallsectionsdisabled",component:"theme_snap"},{key:"disabled",component:"theme_snap"}]).then((function(strings){var strMessage=strings[0];return strDisabled=strings[1],templates.render("theme_snap/form_alert",{type:"warning",classes:"",message:strMessage})})).then((function(html){var op0=$('[name="coursedisplay"] > option[value="0"]'),op1=$('[name="coursedisplay"] > option[value="1"]'),selectNode=$('[name="coursedisplay"]');op0.attr("disabled","disabled"),op0.append(" ("+strDisabled+")"),op0.removeAttr("selected"),op1.attr("selected","selected"),selectNode.parent().append(html)}))}$(".snap-form-advanced").prepend(availablity);var savebuttons=$('form[id^="mform1"] > .form-group:last');$(mainForm).append(savebuttons);var errorElements=$(".form-group.has-danger");onModSettings&&errorElements.length&&errorElements.closest(".collapsible").removeClass("collapsed"),$("#page-mod-page-mod").length&&(str.get_strings([{key:"showappearancedisabled",component:"theme_snap"}]).then((function(localizedstring){return templates.render("theme_snap/form_alert",{type:"warning",classes:"",message:localizedstring})})).then((function(html){var pageInputs=$('[id="id_printheading"], [id="id_printintro"], [id="id_printlastmodified"], [id="id_display"], [id="id_popupwidth"], [id="id_popupheight"]');$("#id_display option:not(:selected)").attr("disabled",!0),pageInputs.attr("readonly",!0),$("#id_display").attr("disabled",!0),pageInputs.attr("tabindex",-1),pageInputs.click((function(e){return e.preventDefault(),!1})),pageInputs.parent().parent().parent().css("background-color","#f1f1f1"),pageInputs.parent().parent().parent().css("color","#d5d5d5"),$("#id_appearancehdrcontainer").append(html)})),$("#id_showdescription").parent().parent().parent().hide())}if(onSectionSettings&&$("#page-course-editsection.format-topics .form-group #id_name_value").length){document.getElementById("id_name_value").hasAttribute("disabled")&&document.getElementById("id_name_value").removeAttribute("disabled")}messageBadgeCountEnabled&&require(["theme_snap/conversation_badge_count-lazy"],(function(conversationBadgeCount){conversationBadgeCount.init(userId)})),$(".message-app .list-group").on("click",".list-group-item.list-group-item-action",(function(e){require(["theme_snap/conversation_badge_count-lazy"],(function(conversationBadgeCount){let conversationId=e.currentTarget.attributes["data-conversation-id"].value;conversationBadgeCount.init(userId,conversationId)}))}));var focustarget=$("#snap-coverimagecontrol label");focustarget&&focustarget.length&&focustarget.keypress((function(e){13===e.which&&$("#snap-coverfiles").trigger("click")})),$(".block_settings").length||($("#admin-menu-trigger").hide(),inAlternativeRole&&require(["theme_snap/alternative_role_handler-lazy"],(function(alternativeRoleHandler){alternativeRoleHandler.init(courseConfig.id)}))),$(".snap-settings-tab-link").on("click",(function(){var tab=$('a[href="'+$(this).attr("href")+'"].nav-link');tab.length&&tab.tab("show")})),"#course-detail-title"!==window.location.hash&&"#mod_book-chapter"!==window.location.hash||$("#mr-nav").removeClass("headroom--pinned").addClass("headroom--unpinned");var savebuttonsformrequired=$("div[role=main] .mform div.snap-form-required fieldset > div.form-group.fitem");if($(window).width()<767&&$(".snap-form-advanced").append(savebuttonsformrequired),$(".path-mod.theme-snap #id_coursecontentnotification").length){const notificationCheck=document.getElementById("id_coursecontentnotification").closest(".form-group.fitem"),submitButtons=$('.snap-form-required [data-groupname="buttonar"]');null!==notificationCheck&&submitButtons.length&&(notificationCheck.classList.add("snap_content_notification_check"),submitButtons.before(notificationCheck))}const snapFormFsRequired=$(".snap-form-required > fieldset");if(snapFormFsRequired&&snapFormFsRequired.hasClass("d-none")){const visibleFieldset=$(".snap-form-advanced > fieldset").not(".d-none");$(visibleFieldset).parent().removeClass("col-md-4");const notificationCheck=document.getElementById("id_coursecontentnotification").closest(".form-group.fitem");$(".snap-form-advanced").append(notificationCheck),$(".snap-form-advanced").append(savebuttonsformrequired)}if($("#page-home.theme-snap .intelliboard-page").length&&$(".snap-page-heading-button").length){document.getElementsByClassName("snap-page-heading-button")[0].classList.add("hidden")}var targetTilesSect=document.querySelector("section#tiles-section");if(targetTilesSect){new MutationObserver((function(){util.processAnimatedImages()})).observe(targetTilesSect,{childList:!0,subtree:!0})}if(document.querySelector("#page-site-index #frontpage-course-list .snap-home-course")&&(setHomeCourseFavourite("unset-favourite"),setHomeCourseFavourite("set-favourite")),$("body#page-site-index.format-site").length){var frontPageActivities=document.querySelector('div[role="main"] ul.section');new MutationObserver((function(){$('div[role="main"] ul.section > li[id^="module"]').each((function(){if(!$(this).hasClass("snap-activity")&&!$(this).hasClass("snap-asset")){let id=$(this).attr("id"),moduleid=id.match(/\d+$/)[0];$(this).hide(),ajax.call([{methodname:"theme_snap_course_module",args:{cmid:moduleid},done:function(response){let html=$.parseHTML(response.html);$("#"+id).replaceWith(html[0])}}])}}))})).observe(frontPageActivities,{childList:!0})}if($("body#page-site-index.theme-snap .frontpage-course-list-enrolled .paging-morelink").length){(moreCoursesButton=document.querySelector(".frontpage-course-list-enrolled .paging-morelink")).parentNode.parentNode.appendChild(moreCoursesButton)}if($("body#page-site-index.theme-snap .frontpage-course-list-all .paging-morelink").length){var moreCoursesButton;(moreCoursesButton=document.querySelector(".frontpage-course-list-all .paging-morelink")).parentNode.parentNode.appendChild(moreCoursesButton)}if(function(){var i=0,checker=setInterval((function(){(i+=1)>15?clearInterval(checker):0!=$("button.atto_fullscreen_button").length&&0!=$("div.editor_atto").length&&($("button.atto_fullscreen_button").click((function(){$("div.editor_atto").css("background-color","#eee"),$("div.editor_atto").css("z-index","1")})),$("button.atto_html_button").click((function(){$("#id_introeditor").css("z-index","1")})),clearInterval(checker))}),2e3)}(),$("body#page-report-competency-index").length>0){const userCompetency=$(".user-competency-course-navigation");userCompetency.length>0&&userCompetency.parent().addClass("ms-4")}editToggleURL("topics"),editToggleURL("weeks");document.querySelector("body.theme-snap.pagelayout-course.editing")&&require(["theme_snap/coursetools_blocks_management"],(function(CoursetoolsBlocksManagementAmd){CoursetoolsBlocksManagementAmd.init(courseConfig)}));const linkWithSection=document.querySelector('.breadcrumb-nav .breadcrumb-item [href*="#section-"]'),blockSettingsLink=document.querySelector('.block_settings [href*="course/modedit.php?update"]');if(linkWithSection&&blockSettingsLink){const sectionMatch=linkWithSection.href.match(/section-(\d+)/);if(sectionMatch){const sectionNumber=sectionMatch[1];blockSettingsLink.href+="&sr=".concat(sectionNumber)}}util.modchooserSectionReturn()})),accessibility.snapAxInit(),messages.init(),function(){const goLeftBtn=document.getElementById("goto-left-link");let ticking=!1;if(goLeftBtn){window.addEventListener("scroll",(()=>{ticking||(window.requestAnimationFrame((()=>{const isScrolled=window.scrollX>10,hasClass=goLeftBtn.classList.contains("scrolled");isScrolled&&!hasClass?goLeftBtn.classList.add("scrolled"):!isScrolled&&hasClass&&goLeftBtn.classList.remove("scrolled"),ticking=!1})),ticking=!0)}));const goLeftLink=goLeftBtn.querySelector("a");goLeftLink&&goLeftLink.addEventListener("click",(function(){window.scrollTo({left:0,behavior:"smooth"});const focusable=document.querySelector("body a, body [tabindex='0']");focusable&&focusable.focus()}))}const goTopBtn=document.getElementById("goto-top-link");if(goTopBtn){const goTopLink=goTopBtn.querySelector("a");goTopLink&&goTopLink.addEventListener("click",(function(){window.scrollTo({top:0,behavior:"smooth"});const focusable=document.querySelector("body a, body [tabindex='0']");focusable&&focusable.focus()}))}}();var noneditingblocks={blockxp:"#page-blocks-xp-index"};for(var block in noneditingblocks){!0===$(noneditingblocks[block]).hasClass("editing")&&$(noneditingblocks[block]).removeClass("editing")}}}}));

//# sourceMappingURL=snap.min.js.map