<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_opencast', language 'en'
 *
 * @package   block_opencast
 * @copyright 2017 Andreas Wagner, SYNERGY LEARNING
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['aclnothingtobesaved'] = 'No changes to the visibility have been made.';
$string['aclownerrole'] = 'ACL owner role';
$string['aclrolesadded'] = 'The change of visibility has been triggered to allow all students of the course to access the video: {$a->title}<br />Please refresh the site after some time to see the current visibility status.';
$string['aclrolesaddedgroup'] = 'The change of visibility has been triggered to allow students of selected groups to access the video: {$a->title}<br />Please refresh the site after some time to see the current visibility status.';
$string['aclrolesdeleted'] = 'The change of visibility has been triggered to prevent all students of the course from accessing the video: {$a->title}<br />Please refresh the site after some time to see the current visibility status.';
$string['actions'] = 'Comma-separated list of actions';
$string['addlti_defaulttitle'] = 'Opencast videos';
$string['addvideo'] = 'Add video';
$string['adhocfiledeletion'] = 'Delete videofile from moodle';
$string['adminchoice_noworkflow'] = "-- No workflow --";
$string['allowdownloadtranscriptionsetting'] = 'Allow download transcriptions';
$string['alloweduploadwfconfigs'] = 'Allowed upload workflow configurations';
$string['allowunassign'] = 'Allow unassign from course';
$string['backupopencastvideos'] = 'Include videos from Opencast instance {$a} in this course';
$string['batchupload'] = 'Add videos (batch)';
$string['blocksettings'] = 'Settings for a block instance';
$string['cachevalidtime'] = 'Cache valid time';
$string['changeowner'] = 'Change owner';
$string['changevisibility'] = 'Alter visibility';
$string['contributor'] = 'Contributor(s)';
$string['created'] = 'Created at';
$string['createdby'] = 'Uploaded by';
$string['createseriesforcourse'] = 'Create new series';
$string['creator'] = 'Presenter(s)';
$string['date'] = 'Start Date';
$string['default'] = 'Default';
$string['delete_block_and_mapping'] = 'Delete block and series mapping';
$string['delete_confirm_metadata'] = 'Are you sure you want to delete this metadata field?';
$string['delete_confirm_role'] = 'Are you sure you want to delete this role?';
$string['delete_mapping_explanation'] = 'The Opencast Block tracks which Opencast Series is mapped to the course.<br> You can choose whether to delete the mapping.<br> If you delete it, the series will no longer appear when you create the opencast block again.';
$string['delete_metadata'] = 'Delete metadata field';
$string['delete_role'] = 'Delete role';
$string['deletecheck_title_modal'] = 'Remove Opencast Block?';
$string['deletedraft'] = 'Delete a video before transfer to Opencast';
$string['deleteevent'] = 'Delete an event in Opencast';
$string['deleteworkflow'] = 'Workflow to start before event is be deleted';
$string['deleting'] = 'Going to be deleted';
$string['description'] = 'Description';
$string['downloadvideo'] = 'Download video';
$string['duplicateworkflow'] = 'Workflow for duplicating events';
$string['duration'] = 'Duration';
$string['editorbaseurl'] = 'Opencast Editor Base URL';
$string['editorendpointurl'] = 'Opencast Editor Endpoint';
$string['editseries'] = 'Edit series';
$string['enablechunkupload'] = 'Enable Chunkupload';
$string['enableopencasteditorlink'] = 'Show the link to opencast Editor in action menu';
$string['enableopencaststudiolink'] = 'Show the link to opencast studio';
$string['enableopencaststudioreturnbtn'] = 'Show a redirect back button in Studio';
$string['enableschedulingchangevisibility'] = 'Schedule a visibility change';
$string['enableuploadwfconfigpanel'] = 'Show workflow configurations during upload';
$string['engageurl'] = 'URL of the Opencast Engage server';
$string['error_seriesid_missing_course'] = 'The course {$a->coursefullname} (ID: {$a->courseid}) has no course series. The event ({$a->eventid}) could not be restored.';
$string['error_seriesid_missing_opencast'] = 'The series of course {$a->coursefullname} (ID: {$a->courseid}) can not be found in the opencast system. The event ({$a->eventid}) could not be restored.';
$string['error_seriesid_not_matching'] = 'The course {$a->coursefullname} (ID: {$a->courseid}) has a course series, that does not match the seriesid of the task. The event ({$a->eventid}) could not be restored.';
$string['error_workflow_not_exists'] = 'The workflow {$a->duplicateworkflow} can not be found in the opencast system. The event ({$a->eventid}) could not be restored for course {$a->coursefullname} (ID: {$a->courseid}).';
$string['error_workflow_not_started'] = 'The workflow to copy the video ({$a->eventid}) assigned to course {$a->coursefullname} (ID: {$a->courseid}) could not be started.';
$string['error_workflow_setup_missing'] = 'The plugin tool_opencast is not properly configurated. The duplication workflow is missing!';
$string['erroremailsubj'] = 'Error while executing opencast process duplicate task';
$string['errorgetblockvideos'] = 'List cannot be loaded (Error: {$a})';
$string['errorrestoremissingevents_subj'] = 'Opencast error during restore process';
$string['errorrestoremissingseries_subj'] = 'Opencast error during restore process';
$string['faileduploadretrylimit'] = 'Limit failed upload attempts';
$string['filetypes'] = 'Accepted file types';
$string['general_settings'] = 'General settings';
$string['gotooverview'] = 'Go to overview...';
$string['groupcreation'] = 'Create a group';
$string['groupname'] = 'Group name';
$string['heading_actions'] = 'Actions';
$string['heading_batchable'] = 'Batchable';
$string['heading_datatype'] = 'Field Type';
$string['heading_defaultable'] = 'Defaultable';
$string['heading_description'] = 'Field Description';
$string['heading_name'] = 'Field Name';
$string['heading_params'] = 'Parameters (JSON)';
$string['heading_permanent'] = 'Permanent';
$string['heading_readonly'] = 'Read Only';
$string['heading_required'] = 'Required';
$string['heading_role'] = 'Role';
$string['identifier'] = 'Identifier';
$string['importmode'] = 'Import mode';
$string['importseries'] = 'Import series';
$string['importvideos_wizard_event_cb_title'] = '{$a->title} (ID: {$a->identifier})';
$string['importvideos_wizard_series_cb_title'] = 'Series: {$a->title} (ID: {$a->identifier})';
$string['importvideos_wizard_unselectableeventreason'] = 'video selection';
$string['ingest_endpoint_notfound'] = 'The ingets endpoint is not available, this has to be fix by the system administrator.';
$string['ingestupload'] = 'Ingest upload';
$string['initialvisibilitystatus'] = 'Initial visibility of the video';
$string['invalidacldata'] = 'Invalid acl data';
$string['invalidmetadatafield'] = 'Invalid metadata field found: {$a}';
$string['language'] = 'Language';
$string['license'] = 'License';
$string['limituploadjobs'] = 'Limit upload job by cron';
$string['limitvideos'] = 'Number of videos';
$string['limitvideosdesc'] = 'Maximum number of videos to display in block';
$string['loading'] = 'Loading...';
$string['location'] = 'Location';
$string['managedefaultsforuser'] = 'Manage default values';
$string['manageseriesforcourse'] = 'Manage series';
$string['maxseries'] = 'Maximum number of series';
$string['maxtranscriptionupload'] = 'Maximum number of sets to upload';
$string['mediatype'] = 'Media Source';
$string['metadata'] = 'Event Metadata';
$string['metadataseries'] = 'Series Metadata';
$string['missingevent'] = 'Creation of event failed';
$string['missinggroup'] = 'Missing group in opencast';
$string['missingseries'] = 'Missing series in opencast';
$string['morethanonedefaultserieserror'] = 'This course has more than one default series. Please contact your system administrator.';
$string['morevideos'] = 'More videos...';
$string['notificationeventstatus'] = 'Allow event process status notification';
$string['notificationeventstatusdeletion'] = 'Cleanup notification jobs after (Days)';
$string['notificationeventstatusteachers'] = 'Notify all course teachers about the event process status';
$string['novideosavailable'] = 'No videos available';
$string['ocstatecapturing'] = 'Capturing';
$string['ocstatefailed'] = 'Failed';
$string['ocstateneedscutting'] = 'Needs cutting';
$string['ocstateprocessing'] = 'Processing';
$string['ocstatesucceeded'] = 'Succeeded';
$string['offerchunkuploadalternative'] = 'Offer filepicker as alternative';
$string['only_delete_block'] = 'Delete block, but keep series mapping';
$string['opencast:addinstance'] = 'Add a new opencast upload block';
$string['opencast:addvideo'] = 'Add a new video to opencast upload block';
$string['opencast:createseriesforcourse'] = 'Create a new series in opencast for a moodle course';
$string['opencast:deleteevent'] = 'Finally delete a video (event) in opencast';
$string['opencast:downloadvideo'] = 'Download processed videos';
$string['opencast:importseriesintocourse'] = 'Import an existing opencast series to a moodle course';
$string['opencast:manageseriesforcourse'] = 'Manage the opencast series of a moodle course: Access manageseries.php, unlink series from course and select default series.';
$string['opencast:myaddinstance'] = 'Add a new opencast upload block to Dashboard';
$string['opencast:sharedirectaccessvideolink'] = 'Share direct access link to video';
$string['opencast:startworkflow'] = 'Manually start workflows for videos';
$string['opencast:unassignevent'] = 'Unassign a video from the course, where the video was uploaded.';
$string['opencast:viewunpublishedvideos'] = 'View all the videos from opencast server, even when they are not published';
$string['opencaststudiobaseurl'] = 'Opencast Studio Base URL';
$string['opencaststudiocustomsettingsfilename'] = 'Custom Studio settings filename';
$string['opencaststudionewtab'] = 'Redirect to Studio in a new tab';
$string['opencaststudioreturnbtnlabel'] = 'Label for Studio\'s return button';
$string['opencaststudioreturnurl'] = 'Custom Studio return endpoint URL';
$string['overview'] = 'Overview';
$string['owner'] = 'Owner';
$string['planned'] = 'Planned';
$string['pluginname'] = 'Opencast Videos';
$string['presentation'] = 'Presentation video';
$string['presenter'] = 'Presenter video';
$string['privacy:metadata'] = 'The Opencast block plugin does not store any personal data.';
$string['publisher'] = 'Publisher';
$string['publishtoengage'] = 'Publish to Engage';
$string['readonly_disabled_tooltip_text'] = 'Unable to set readonly option while it is set to be required.';
$string['recordvideo'] = 'Record video';
$string['restoreopencastvideos'] = 'Restore videos from Opencast instance {$a}';
$string['reuseexistingupload'] = 'Reuse existing uploads';
$string['rightsHolder'] = 'Rights';
$string['rolename'] = 'Role name';
$string['scheduledvisibilitystatus'] = 'Change video visibility to';
$string['scheduledvisibilitytime'] = 'Change video visibility on';
$string['series'] = 'Series';
$string['series_already_exists'] = 'This course is already assigned to a series.';
$string['seriescreated'] = 'Series was created.';
$string['seriesname'] = 'Series name';
$string['seriesnotcreated'] = 'Series could not be created.';
$string['seriesoverview'] = 'Series overview';
$string['seriesoverviewof'] = 'Series overview of {$a} instance';
$string['settings'] = 'Opencast Videos';
$string['settings_page'] = 'Settings';
$string['settings_page_url'] = '{$a} Settings';
$string['source'] = 'Source';
$string['startDate'] = 'Date';
$string['startTime'] = 'Time';
$string['startworkflow'] = 'Start workflow';
$string['subjects'] = 'Subjects';
$string['submit'] = 'Save changes';
$string['termsofuse'] = 'Terms of use';
$string['title'] = 'Title';
$string['tool_requirement_not_fulfilled'] = 'The required version of tool_opencast is not installed.';
$string['transcription_flavor_confirm_delete'] = 'Are you sure you want to delete this flavor option pair?';
$string['transcription_flavor_delete'] = 'Delete flavor\'s option pair';
$string['transcription_flavor_key'] = 'Flavor key';
$string['transcription_flavor_value'] = 'Flavor value';
$string['transcriptionfileextensions'] = 'Allowed transcription file extensions';
$string['transcriptionflavors'] = 'Transcription Service Types (Flavors)';
$string['transcriptionworkflow'] = 'Workflow for transcription (speech to text)';
$string['type'] = 'Media Type';
$string['updatemetadata'] = 'Update metadata for this event';
$string['upload'] = 'File Upload';
$string['uploadfileextensions'] = 'Allowed file extensions';
$string['uploadfilelimit'] = 'Video size limit';
$string['uploadfilesizelimitmode'] = 'Video file size limitation mode';
$string['uploadingeventfailed'] = 'Creating of event failed';
$string['uploadtimeout'] = 'Moodle to Opencast upload timeout';
$string['uploadworkflow'] = 'Workflow to start after upload';
$string['video'] = 'Video';
$string['video_already_uploaded'] = 'Video already uploaded';
$string['videosavailable'] = 'Videos available in this course';
$string['visibility'] = 'Visibility of the video';
$string['visibility_group'] = 'Allow all students belonging to selected groups to access the video';
$string['visibility_massaction'] = 'Visibility of the selected video(s)';
