<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Manual import videos form for ACL Change import mode (Step 2: Summary).
 *
 * @package    tool_opencast
 * @copyright  2021 Farbod Zamani Boroujeni, ELAN e.V. <zamani@elan-ev.de>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace tool_opencast\local;

use moodleform;

defined('MOODLE_INTERNAL') || die();

require_once($CFG->dirroot . '/lib/formslib.php');

/**
 * Manual import videos form for ACL Change import mode (Step 2: Summary).
 *
 * @package    tool_opencast
 * @copyright  2021 Farbod Zamani Boroujeni, ELAN e.V. <zamani@elan-ev.de>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class importvideos_step3_form_acl extends moodleform {


    /**
     * Form definition.
     */
    public function definition() {
        global $PAGE;

        // Define mform.
        $mform = $this->_form;

        // Get renderer.
        $renderer = $PAGE->get_renderer('tool_opencast', 'importvideos');

        // Add hidden fields for transferring the wizard results and for wizard step processing.
        $mform->addElement('hidden', 'courseid', $this->_customdata['courseid']);
        $mform->setType('courseid', PARAM_INT);
        $mform->addElement('hidden', 'step', 3);
        $mform->setType('step', PARAM_INT);
        $mform->addElement('hidden', 'sourcecourseid', $this->_customdata['sourcecourseid']);
        $mform->setType('sourcecourseid', PARAM_INT);
        $mform->addElement('hidden', 'ocinstanceid', $this->_customdata['ocinstanceid']);
        $mform->setType('ocinstanceid', PARAM_INT);

        // Get an APIbridge instance.
        $apibridge = apibridge::get_instance($this->_customdata['ocinstanceid']);

        if ($this->_customdata['series']) {
            $seriesobject = $apibridge->get_series_by_identifier($this->_customdata['series']);
        } else {
            $seriesobject = $apibridge->get_default_course_series($this->_customdata['sourcecourseid']);
        }

        // If there isn't any series in the course.
        if (!$seriesobject) {
            // We are in a dead end situation, no chance to add anything.
            $notification = $renderer->wizard_error_notification(
                get_string('importvideos_wizardstep1seriesnotfound', 'tool_opencast'));
            $mform->addElement('html', $notification);
            $mform->addElement('cancel');

            return;
        }

        $mform->addElement('hidden', 'sourcecourseseries', $seriesobject->identifier);
        $mform->setType('sourcecourseseries', PARAM_ALPHANUMEXT);

        // Add intro.
        $notification = $renderer->wizard_intro_notification(
            get_string('importvideos_wizardstep4intro', 'tool_opencast'));
        $mform->addElement('html', $notification);

        // Summary item: Source course.
        $sourcecourse = get_course($this->_customdata['sourcecourseid']);
        $courseentry = $renderer->course_menu_entry($sourcecourse);
        $mform->addElement('static', 'summarysourcecourse',
            get_string('importvideos_wizardstep1sourcecourse', 'tool_opencast'),
            $courseentry);

        // Horizontal line.
        $mform->addElement('html', '<hr>');

        // Summary item: Series.
        $seriesentry = $renderer->series_menu_entry($seriesobject);
        $mform->addElement('static', 'summaryseries',
            get_string('importvideos_wizard_seriesimported', 'tool_opencast'),
            $seriesentry);

        // Horizontal line.
        $mform->addElement('html', '<hr>');

        // Summary item: Course videos.
        $coursevideossummary = importvideosmanager::get_import_acl_source_series_videos_summary($this->_customdata['ocinstanceid'],
            $seriesobject->identifier);
        $mform->addElement('static', 'summarycoursevideos',
            get_string('importvideos_wizardstep1coursevideos', 'tool_opencast'),
            $coursevideossummary);

        // Add action buttons.
        $this->add_action_buttons(true, get_string('importvideos_wizardstepbuttontitlerunimport', 'tool_opencast'));
    }
}
