/**
 * Javascript to initialise the opencast block.
 *
 * @module     tool_opencast
 * @copyright  2021 Tamara Gunkel, University of Münster
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tool_opencast/block_index",["jquery","core/modal_factory","core/modal_events","core/str","core/url","core/notification","core/toast","core/ajax"],(function($,ModalFactory,ModalEvents,str,url,Notification,Toast,Ajax){window.liveUpdateInterval=null,window.liveUpdateItemsWithError=[],window.liveUpdateState=null;var pauseLiveUpdate=function(liveupdate){liveupdate.enabled&&null!==window.liveUpdateInterval&&(clearInterval(window.liveUpdateInterval),window.liveUpdateState="paused")},resumeLiveUpdate=function(ocinstanceid,contextid,liveupdate){liveupdate.enabled&&"paused"==window.liveUpdateState&&(initLiveUpdate(ocinstanceid,contextid,liveupdate.timeout),window.liveUpdateState="resumed")},displayWorkflowPrivacyNotice=function(privacyworkflows,workflowid){Array.isArray(privacyworkflows)&&(0===privacyworkflows.length||privacyworkflows.includes(workflowid))?$("#privacynoticediv").removeClass("d-none"):$("#privacynoticediv").addClass("d-none")},displayWorkflowDescription=function(workflowobj){null!=workflowobj&&workflowobj.description?($("#workflowdescdiv").removeClass("d-none"),$("#workflowdesc").html(workflowobj.description)):$("#workflowdescdiv").addClass("d-none")},displayWorkflowConfigPanel=function(ocinstanceid,courseid,workflowid){$("#workflowconfigpaneldiv").addClass("d-none"),$("#workflowconfigpanelloading").removeClass("d-none"),$("#config-frame").attr("src","");var configpanelsrc=url.relativeUrl("admin/tool/opencast/serveworkflowconfigpanel.php",{ocinstanceid:ocinstanceid,courseid:courseid,workflowid:workflowid});$.ajax({url:configpanelsrc,success:data=>{""!==data.trim()&&($("#workflowconfigpaneldiv").removeClass("d-none"),$("#config-frame").attr("src",configpanelsrc))},async:!1})},initLiveUpdate=function(ocinstanceid,contextid,reloadtimeout){null!==window.liveUpdateInterval&&clearInterval(window.liveUpdateInterval),window.liveUpdateItemsWithError=[],getLiveUpdateItems().length&&(window.liveUpdateInterval=setInterval((function(){if("paused"!==window.liveUpdateState){var processingItems=getLiveUpdateProcessingItems(),uploadingItems=getLiveUpdateUploadingItems();if(0!=processingItems.length||0!=uploadingItems.length){for(var processingItem of processingItems)liveUpdatePerformAjax("processing",ocinstanceid,contextid,processingItem,reloadtimeout);for(var uploadingItem of uploadingItems)liveUpdatePerformAjax("uploading",ocinstanceid,contextid,uploadingItem,reloadtimeout)}else if(clearInterval(window.liveUpdateInterval),window.liveUpdateItemsWithError.length>0){var titles=window.liveUpdateItemsWithError.join("</li><li>");str.get_string("liveupdate_fail_notification_message","tool_opencast",titles).done((function(result){Notification.addNotification({message:result,type:"error"})})).fail(Notification.exception)}}}),5e3,ocinstanceid,contextid,url,reloadtimeout))},getLiveUpdateItems=function(){var processingItems=getLiveUpdateProcessingItems(),uploadingItems=getLiveUpdateUploadingItems();return processingItems.concat(uploadingItems)},getLiveUpdateProcessingItems=function(){var itemsNodeList=document.getElementsByName("liveupdate_processing_item");return Array.from(itemsNodeList)},getLiveUpdateUploadingItems=function(){var itemsNodeList=document.getElementsByName("liveupdate_uploading_item");return Array.from(itemsNodeList)},liveUpdatePerformAjax=function(type,ocinstanceid,contextid,item,reloadtimeout){var _item$dataset,identifier=item.value,title=null!=item&&null!==(_item$dataset=item.dataset)&&void 0!==_item$dataset&&_item$dataset.title?item.dataset.title:"";if(null==identifier||""==title)return window.liveUpdateItemsWithError.push(title),void item.remove();Ajax.call([{methodname:"tool_opencast_get_liveupdate_info",args:{contextid:contextid,ocinstanceid:ocinstanceid,type:type,identifier:identifier},done:function(status){if(""==status)return window.liveUpdateItemsWithError.push(title),void item.remove();var statusObject=JSON.parse(status);if(""!=statusObject.replace&&replaceLiveUpdateInfo(item,statusObject.replace),1==statusObject.remove){item.remove();var stringparams={timeout:reloadtimeout,title:title};str.get_string("liveupdate_toast_notification","tool_opencast",stringparams).done((function(result){Toast.add(result)})).fail(Notification.exception),setTimeout((function(){window.location.reload()}),1e3*reloadtimeout)}},fail:function(){window.liveUpdateItemsWithError.push(title),item.remove()}}])},replaceLiveUpdateInfo=function(item,replace){if(null!=item&&""!=replace&&"string"==typeof replace){var newDiv=document.createElement("div");newDiv.innerHTML=replace.trim();var replaceElm=newDiv.firstChild;if("#text"==replaceElm.nodeName){item.parentNode.firstChild.remove();var newText=document.createTextNode(replace.trim());item.parentNode.insertBefore(newText,item)}else if(item.previousElementSibling){var prevElm=item.previousElementSibling;newDiv.innerHTML=replace.trim(),areElementsEqual(replaceElm,prevElm)||(prevElm.remove(),item.parentNode.insertBefore(replaceElm,item))}}},areElementsEqual=function(baseElm,checkElm){var isEqual=!0,attributes=baseElm.getAttributeNames();for(var attributeName of attributes){var baseAttributeValue=baseElm.getAttribute(attributeName).trim(),checkAttributeValue="";checkElm.hasAttribute(attributeName)&&(checkAttributeValue=checkElm.getAttribute(attributeName).trim()),""!=checkAttributeValue&&(checkAttributeValue!=baseAttributeValue&&(isEqual=!1))}return isEqual},resetVideosTableBulkActions=function(container){let disabled=arguments.length>1&&void 0!==arguments[1]&&arguments[1];if(!container)return;const dropdowns=[...container.querySelectorAll(".opencast-videos-table-massactions")];dropdowns.forEach((dropdown=>{dropdown.value="",dropdown.disabled=disabled}))};return{init:function(courseid,ocinstanceid,contextid,liveupdate){str.get_strings([{key:"reportproblem_modal_title",component:"tool_opencast"},{key:"reportproblem_modal_body",component:"tool_opencast"},{key:"reportproblem_modal_placeholder",component:"tool_opencast"},{key:"reportproblem_modal_required",component:"tool_opencast"},{key:"reportproblem_modal_submit",component:"tool_opencast"},{key:"startworkflow",component:"tool_opencast"},{key:"startworkflow_modal_body",component:"tool_opencast"},{key:"startworkflow_modal_description_title",component:"tool_opencast"},{key:"startworkflow_modal_configpanel_title",component:"tool_opencast"},{key:"unarchiveuploadjob",component:"tool_opencast"},{key:"unarchiveuploadjobconfirmtext",component:"tool_opencast"},{key:"unarchiveuploadjobconfirmbtn_save",component:"tool_opencast"},{key:"videostable_massaction_startworkflow_modal_body",component:"tool_opencast"},{key:"videostable_massaction_startworkflow_modal_title",component:"tool_opencast"}]).then((function(results){!function(ocinstanceid,courseid,langstrings,contextid,liveupdate){if(document.getElementById("workflowsjson")){var workflows=JSON.parse($("#workflowsjson").text()),privacyinfohtml=null,privacytitle=null,privacyworkflows=null,hasprivacyinfo=!1;document.getElementById("workflowprivacynotice")&&(hasprivacyinfo=!0,privacyinfohtml=$("#swprivacynoticeinfotext").html(),privacytitle=$("#swprivacynoticetitle").text(),privacyworkflows=JSON.parse($("#swprivacynoticewfds").text())),$(".start-workflow").on("click",(function(e){e.preventDefault();const detail=(null==e?void 0:e.detail)||{};var clickedVideo=$(e.currentTarget),actionurl=url.relativeUrl("admin/tool/opencast/startworkflow.php",{ocinstanceid:ocinstanceid,courseid:courseid,videoid:clickedVideo.data("id")}),ismassaction=!1,bulkinfodiv="",massactioncontainer=null;if("bulk"===(null==detail?void 0:detail.type)&&null!=detail&&detail.selectedids&&null!=detail&&detail.container){ismassaction=!0;const table=(massactioncontainer=detail.container).querySelector("table.opencast-videos-table"),tableid=null==table?void 0:table.id;let seriesid="";tableid&&(seriesid=tableid.replace("opencast-videos-table-","")),bulkinfodiv='<div id="bulkinfodiv" class="w-100 mb-1">',bulkinfodiv+="<p>"+langstrings[12].replace("{$a}",detail.selectedtitles.join("</li><li>"))+"</p>",bulkinfodiv+="</div>";for(let videoid of detail.selectedids)bulkinfodiv+='<input type="hidden" name="videoids[]" value="'+videoid+'">';bulkinfodiv+='<input type="hidden" name="ismassaction" value="1">',actionurl=url.relativeUrl(detail.url,{ocinstanceid:ocinstanceid,courseid:courseid,seriesid:seriesid})}var select='<select class="custom-select mb-3" id="workflowselect" name="workflow">';for(let workflow in workflows)select+='<option value="'+workflow+'">'+workflows[workflow].title+"</option>";select+="</select>";var privacynoticediv="";hasprivacyinfo&&(privacynoticediv='<div id="privacynoticediv" class="w-100 mb-2 d-none">',privacynoticediv+="<strong>"+privacytitle+"</strong>",privacynoticediv+='<div class="pl-1 pr-1">'+privacyinfohtml+"</div>",privacynoticediv+="</div>");var workflowdescdiv='<div id="workflowdescdiv" class="mb-2 d-none"><strong>'+langstrings[7]+'</strong><p class="pl-1 pr-1" id="workflowdesc"></p></div>',workflowconfigpaneldiv='<div id="workflowconfigpaneldiv" class="d-none"><strong>'+langstrings[8]+'</strong><iframe id="config-frame" class="w-100 mh-100 m-0 p-0 border-0" sandbox="allow-forms allow-scripts"></iframe><input type="hidden" name="configparams" id="configparams"></div>',body='<form id="startWorkflowForm" method="post" action="'+actionurl+'"><div class="form-group">'+bulkinfodiv+"<p>"+langstrings[6]+"</p>"+select+workflowdescdiv+privacynoticediv+workflowconfigpaneldiv+"</div></form>";ModalFactory.create({type:ModalFactory.types.SAVE_CANCEL,title:ismassaction?langstrings[13]:langstrings[5],body:body},void 0).then((function(modal){pauseLiveUpdate(liveupdate),modal.setSaveButtonText(langstrings[5]);var root=modal.getRoot();root.on(ModalEvents.save,(function(e){$("#config-frame").is(":visible")?(document.getElementById("config-frame").contentWindow.postMessage("getdata","*"),e.preventDefault()):$("#startWorkflowForm").submit()})),root.on(ModalEvents.hidden,(function(){resumeLiveUpdate(ocinstanceid,contextid,liveupdate),modal.destroy(),resetVideosTableBulkActions(massactioncontainer)})),modal.show().then((function(){const workflowselect=$("#workflowselect");let workflowid=workflowselect.val();displayWorkflowDescription(workflows[workflowid]),displayWorkflowConfigPanel(ocinstanceid,courseid,workflowid),displayWorkflowPrivacyNotice(privacyworkflows,workflowid),workflowselect.change((function(){let workflowid=$(this).val();displayWorkflowDescription(workflows[workflowid]),displayWorkflowConfigPanel(ocinstanceid,courseid,workflowid),displayWorkflowPrivacyNotice(privacyworkflows,workflowid)}))})).catch(Notification.exception)})).catch(Notification.exception)}))}}(ocinstanceid,courseid,results,contextid,liveupdate),function(ocinstanceid,courseid,langstrings,contextid,liveupdate){$(".report-problem").on("click",(function(e){e.preventDefault();var clickedVideo=$(e.currentTarget);ModalFactory.create({type:ModalFactory.types.SAVE_CANCEL,title:langstrings[0],body:'<form id="reportProblemForm" method="post" action="'+url.relativeUrl("admin/tool/opencast/reportproblem.php",{ocinstanceid:ocinstanceid,courseid:courseid,videoid:clickedVideo.data("id")})+'"><div class="form-group"><label for="inputMessage">'+langstrings[1]+'</label><textarea class="form-control" id="inputMessage" name="inputMessage" rows="4" placeholder="'+langstrings[2]+'"></textarea>  <div class="invalid-feedback d-none" id="messageValidation">'+langstrings[3]+"</div></div></form>"}).then((function(modal){pauseLiveUpdate(liveupdate),modal.setSaveButtonText(langstrings[4]);var root=modal.getRoot();root.on(ModalEvents.save,(function(e){$("#inputMessage").val()?$("#reportProblemForm").submit():($("#inputMessage").addClass("is-invalid"),$("#messageValidation").removeClass("d-none")),e.preventDefault()})),root.on(ModalEvents.hidden,(function(){resumeLiveUpdate(ocinstanceid,contextid,liveupdate),modal.destroy()})),modal.show()})).catch(Notification.exception)}))}(ocinstanceid,courseid,results,contextid,liveupdate),function(ocinstanceid,langstrings,contextid,liveupdate){$(".unarchive-uploadjob").on("click",(function(e){e.preventDefault();var uploadjobid=$(e.currentTarget).data("id");ModalFactory.create({type:ModalFactory.types.SAVE_CANCEL,title:langstrings[9],body:langstrings[10]}).then((function(modal){pauseLiveUpdate(liveupdate),modal.setSaveButtonText(langstrings[11]);var root=modal.getRoot();root.on(ModalEvents.save,(function(e){Ajax.call([{methodname:"tool_opencast_unarchive_uploadjob",args:{contextid:contextid,ocinstanceid:ocinstanceid,uploadjobid:uploadjobid},done:function(){window.location.reload()},fail:Notification.exception}]),e.preventDefault()})),root.on(ModalEvents.hidden,(function(){resumeLiveUpdate(ocinstanceid,contextid,liveupdate),modal.destroy()})),modal.show()})).catch(Notification.exception)}))}(ocinstanceid,results,contextid,liveupdate)})).catch(Notification.exception),window.addEventListener("message",(function(event){"null"===event.origin&&(event.data===parseInt(event.data)?$("#config-frame").height(event.data):($("#configparams").val(event.data),$("#startWorkflowForm").submit()))})),liveupdate.enabled&&initLiveUpdate(ocinstanceid,contextid,liveupdate.timeout),$(".access-link-copytoclipboard").on("click",(function(e){e.preventDefault();var link=e.currentTarget.getAttribute("href");link?navigator.clipboard?navigator.clipboard.writeText(link).then((()=>{str.get_string("directaccess_copy_success","tool_opencast").done((function(result){Toast.add(result)})).fail(Notification.exception)})).catch():str.get_string("directaccess_copytoclipboard_unavialable","tool_opencast").done((function(result){Toast.add(result,{type:"danger",autohide:!1,closeButton:!0})})).fail(Notification.exception):str.get_string("directaccess_copy_no_link","tool_opencast").done((function(result){Toast.add(result,{type:"warning"})})).fail(Notification.exception)}))}}}));

//# sourceMappingURL=block_index.min.js.map