<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     tool_opencast
 * @category    string
 * @copyright   2018 Tobias Reischmann <tobias.reischmann@wi.uni-muenster.de>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesspolicies'] = 'Access Policies';
$string['acl_settingcontrol'] = 'Enable visibility control';
$string['acl_settingcontrol_desc'] = 'If enabled, teachers can control the visibility of an Opencast episode on upload.';
$string['acl_settingcontrolafter'] = 'Allow episode visibility control after processing';
$string['acl_settingcontrolafter_desc'] = 'If enabled, teachers can control the visibility of an Opencast episode after the episode has been processed in Opencast.';
$string['acl_settingcontrolgroup'] = 'Allow episode group restriction';
$string['acl_settingcontrolgroup_desc'] = 'If enabled, teachers can not only control the visibility of an Opencast episode for all course users but can also restrict the visibility to particular course groups.';
$string['acl_settingcontrolwaitingtime'] = 'Waiting time for scheduled visibility change (Minutes)';
$string['acl_settingcontrolwaitingtime_desc'] = 'It defines a minimum waiting time (in minutes) that scheduled visibility change process should wait. This time span will be added to current time for the scheduled video change date filed in add video form, it will also be used to validate that field. Based on how fast the Opencast instance processes the videos, this waiting time could be configured. <br />NOTE: When empty or (zero) "0", the default value is used.';
$string['acl_settingheader'] = 'Control episode visibility';
$string['aclgroupdeleted'] = 'Access deleted for video: {$a->title}';
$string['aclnothingtobesaved'] = 'No changes to the visibility have been made.';
$string['aclownerrole'] = 'ACL owner role';
$string['aclownerrole_desc'] = 'Name of the role that identifies the owner of a video/series. The role must also be specified in the roles table. The role must be permanent and include a user-related placeholder, e.g. ROLE_OWNER_[USER_EMAIL]. It should not include any course-related placeholders. If empty, owner-related plugin functionalities are disabled.';
$string['aclrolesadded'] = 'The change of visibility has been triggered to allow all students of the course to access the video: {$a->title}<br />Please refresh the site after some time to see the current visibility status.';
$string['aclrolesaddedgroup'] = 'The change of visibility has been triggered to allow students of selected groups to access the video: {$a->title}<br />Please refresh the site after some time to see the current visibility status.';
$string['aclroleschangeerror'] = 'Error during the change of visibility of the video: {$a->title}<br />Some changes might have not been saved. If this occurs repeatedly, please contact your support team.';
$string['aclrolesdeleted'] = 'The change of visibility has been triggered to prevent all students of the course from accessing the video: {$a->title}<br />Please refresh the site after some time to see the current visibility status.';
$string['aclrolesname'] = 'Roles';
$string['aclrolesnamedesc'] = 'You can use placeholders in the role name which are automatically replaced (<a target="_blank" href="https://moodle.docs.opencast.org/#block/general_settings/#placeholders">list of placeholders</a>). The list of actions must be comma-separated.';
$string['actions'] = 'Comma-separated list of actions';
$string['addactivity_addbuttonexplanation'] = 'The videos which are added to and are available in this course are not provided to your students automatically.<br />Using the "Provide" buttons, you can add activities to your course which provide either all videos in a series or single videos to your students.';
$string['addactivity_addbuttontitle'] = 'Add Opencast Video Provider activity to course';
$string['addactivity_addbuttontitlereturncourse'] = 'Add module and return to course';
$string['addactivity_addbuttontitlereturnoverview'] = 'Add module and return to overview';
$string['addactivity_defaulttitle'] = 'Opencast videos';
$string['addactivity_formactivityavailability'] = 'Opencast series module access restrictions';
$string['addactivity_formactivityintro'] = 'Opencast series module intro';
$string['addactivity_formactivitysection'] = 'Opencast series module target section';
$string['addactivity_formactivitytitle'] = 'Opencast series module title';
$string['addactivity_header'] = 'Provide videos (Embedded)';
$string['addactivity_modulecreated'] = 'The \'{$a}\' series module has been added to this course.';
$string['addactivity_moduleexists'] = 'There is already an Opencast series module added to this course. There is no need to add another one.';
$string['addactivity_modulenotcreated'] = 'The \'{$a}\' series module could not be created. Please try again or contact your Moodle administrator.';
$string['addactivity_noemptytitle'] = 'You have to set a title for the Opencast series module or to use the default title ("{$a}")';
$string['addactivity_settingavailability'] = 'Set series module availability';
$string['addactivity_settingavailability_desc'] = 'If enabled, teachers can set the availability conditions when a new Opencast Video Provider activity for series is added to a course.';
$string['addactivity_settingavailability_note'] = 'Please note: This feature is only available if availability is globally enabled on the {$a} admin setting page.';
$string['addactivity_settingdefaulttitle'] = 'Default Opencast activity series module title';
$string['addactivity_settingdefaulttitle_desc'] = 'The default title to be used when a new Opencast Video Provider activity for series is added to a course.';
$string['addactivity_settingenabled'] = 'Enable "Add Opencast activity series module"';
$string['addactivity_settingenabled_desc'] = 'If enabled, teachers can add an Opencast Activity series module to a course. This Activity series module will be pointing to the course\'s Opencast series.';
$string['addactivity_settingheader'] = 'Add Opencast Activity modules to courses';
$string['addactivity_settingintro'] = 'Add series module intro';
$string['addactivity_settingintro_desc'] = 'If enabled, teachers can add an intro to the Opencast activity series module. This intro will be shown on the course overview page.';
$string['addactivity_settingsection'] = 'Choose series module section';
$string['addactivity_settingsection_desc'] = 'If enabled, teachers can choose the section which the Opencast Activity series module will be added to.';
$string['addactivity_viewbuttonexplanation'] = 'An Opencast series module to provide the videos available in this course has been added to the course before.';
$string['addactivity_viewbuttontitle'] = 'View Opencast series module in course';
$string['addactivityepisode_addbuttontitlereturncourse'] = 'Add module and return to course';
$string['addactivityepisode_addbuttontitlereturnoverview'] = 'Add module and return to overview';
$string['addactivityepisode_addicontitle'] = 'Add Opencast episode module to course';
$string['addactivityepisode_defaulttitle'] = 'Opencast episode';
$string['addactivityepisode_explanation'] = 'Additionally, in the videos table above, you can add individual Opencast episode modules to your course which provide one single video activity to your students.';
$string['addactivityepisode_formactivityavailability'] = 'Opencast episode module access restrictions';
$string['addactivityepisode_formactivityintro'] = 'Opencast episode module intro';
$string['addactivityepisode_formactivitysection'] = 'Opencast episode module target section';
$string['addactivityepisode_formactivitytitle'] = 'Opencast episode module title';
$string['addactivityepisode_modulecreated'] = 'The \'{$a}\' episode module has been added to this course.';
$string['addactivityepisode_moduleexists'] = 'There is already an Opencast episode module added to this course. There is no need to add another one.';
$string['addactivityepisode_modulenotcreated'] = 'The \'{$a}\' episode module could not be created. Please try again or contact your Moodle administrator.';
$string['addactivityepisode_noemptytitle'] = 'You have to set a title for the Opencast episode module or to use the default title ("{$a}")';
$string['addactivityepisode_settingavailability'] = 'Set episode module availability';
$string['addactivityepisode_settingavailability_desc'] = 'If enabled, teachers can set the availability conditions when a new Opencast Activity episode module is added to a course.';
$string['addactivityepisode_settingenabled'] = 'Enable "Add Opencast Activity episode module"';
$string['addactivityepisode_settingenabled_desc'] = 'If enabled, teachers can add an Opencast Video Provider activity for episodes to a course. This Opencast Activity episode module will be pointing to an Opencast episode.';
$string['addactivityepisode_settingintro'] = 'Add episode module intro';
$string['addactivityepisode_settingintro_desc'] = 'If enabled, teachers can add a intro to the Opencast Activity episode module. This intro will be shown on the course overview page.';
$string['addactivityepisode_settingsection'] = 'Choose episode module section';
$string['addactivityepisode_settingsection_desc'] = 'If enabled, teachers can choose the section which the Opencast Activity episode module will be added to.';
$string['addactivityepisode_viewicontitle'] = 'View Opencast episode module in course';
$string['addcatalog'] = 'Add new metadata';
$string['addinstance'] = 'Add instance';
$string['additional_instance'] = 'Additional Settings: {$a}';
$string['additional_settings'] = 'Additional features';
$string['addlti_addbuttonexplanation'] = 'The videos which are added to and are available in this course are not provided to your students automatically.<br />Here, you can add an Opencast LTI series module to your course which provides all available videos as an Opencast series list to your students.';
$string['addlti_addbuttontitle'] = 'Add Opencast LTI series module to course';
$string['addlti_addbuttontitlereturncourse'] = 'Add module and return to course';
$string['addlti_addbuttontitlereturnoverview'] = 'Add module and return to overview';
$string['addlti_defaulttitle'] = 'Opencast videos';
$string['addlti_errornotenabledorworking'] = 'The \'Add Opencast series module\' feature is not enabled or not working';
$string['addlti_formltiavailability'] = 'Opencast series module access restrictions';
$string['addlti_formltiintro'] = 'Opencast series module intro';
$string['addlti_formltisection'] = 'Opencast series module target section';
$string['addlti_formltititle'] = 'Opencast series module title';
$string['addlti_header'] = 'Provide videos (LTI)';
$string['addlti_modulecreated'] = 'The \'{$a}\' series module has been added to this course.';
$string['addlti_moduleexists'] = 'There is already an Opencast series module added to this course. There is no need to add another one.';
$string['addlti_modulenotcreated'] = 'The \'{$a}\' series module could not be created. Please try again or contact your Moodle administrator.';
$string['addlti_noemptytitle'] = 'You have to set a title for the Opencast series module or to use the default title ("{$a}")';
$string['addlti_settingavailability'] = 'Set series module availability';
$string['addlti_settingavailability_desc'] = 'If enabled, teachers can set the availability conditions when a new Opencast LTI series module is added to a course.';
$string['addlti_settingavailability_note'] = 'Please note: This feature is only available if availability is globally enabled on the {$a} admin setting page.';
$string['addlti_settingdefaulttitle'] = 'Default LTI series module title';
$string['addlti_settingdefaulttitle_desc'] = 'The default title to be used when a new Opencast LTI series module is added to a course.';
$string['addlti_settingenabled'] = 'Enable "Add LTI series module"';
$string['addlti_settingenabled_desc'] = 'If enabled, teachers can add an Opencast LTI series module to a course. This LTI series module will be pointing to the course\'s Opencast series.';
$string['addlti_settingheader'] = 'Add Opencast LTI series modules to courses';
$string['addlti_settingintro'] = 'Add series module intro';
$string['addlti_settingintro_desc'] = 'If enabled, teachers can add an intro to the Opencast LTI series module. This intro will be shown on the course overview page.';
$string['addlti_settingpreconfiguredtool'] = 'Preconfigured LTI tool for series modules';
$string['addlti_settingpreconfiguredtool_desc'] = 'The preconfigured LTI tool to be used when a new Opencast LTI series module is added to a course.';
$string['addlti_settingpreconfiguredtool_notools'] = 'No preconfigured LTI tools to be used found. Please create an Opencast series LTI tool first on the {$a} admin setting page.';
$string['addlti_settingsection'] = 'Choose series module section';
$string['addlti_settingsection_desc'] = 'If enabled, teachers can choose the section which the Opencast LTI series module will be added to.';
$string['addlti_viewbuttonexplanation'] = 'An Opencast series module to provide the videos available in this course has been added to the course before.';
$string['addlti_viewbuttontitle'] = 'View Opencast LTI series module in course';
$string['addltiepisode_addbuttontitlereturncourse'] = 'Add module and return to course';
$string['addltiepisode_addbuttontitlereturnoverview'] = 'Add module and return to overview';
$string['addltiepisode_addicontitle'] = 'Add Opencast episode module to course';
$string['addltiepisode_defaulttitle'] = 'Opencast episode';
$string['addltiepisode_errorepisodeuuidnotvalid'] = 'The given episode UUID is not valid';
$string['addltiepisode_errornotenabledorworking'] = 'The \'Add Opencast episode module\' feature is not enabled or not working';
$string['addltiepisode_explanation'] = 'Additionally, in the videos table above, you can add individual Opencast episode modules to your course which provide one single video activity to your students.';
$string['addltiepisode_formltiavailability'] = 'Opencast episode module access restrictions';
$string['addltiepisode_formltiintro'] = 'Opencast episode module intro';
$string['addltiepisode_formltisection'] = 'Opencast episode module target section';
$string['addltiepisode_formltititle'] = 'Opencast episode module title';
$string['addltiepisode_modulecreated'] = 'The \'{$a}\' episode module has been added to this course.';
$string['addltiepisode_moduleexists'] = 'There is already an Opencast episode module added to this course. There is no need to add another one.';
$string['addltiepisode_modulenotcreated'] = 'The \'{$a}\' episode module could not be created. Please try again or contact your Moodle administrator.';
$string['addltiepisode_noemptytitle'] = 'You have to set a title for the Opencast episode module or to use the default title ("{$a}")';
$string['addltiepisode_settingavailability'] = 'Set episode module availability';
$string['addltiepisode_settingavailability_desc'] = 'If enabled, teachers can set the availability conditions when a new Opencast LTI episode module is added to a course.';
$string['addltiepisode_settingenabled'] = 'Enable "Add LTI episode module"';
$string['addltiepisode_settingenabled_desc'] = 'If enabled, teachers can add an Opencast LTI episode module to a course. This LTI episode module will be pointing to an Opencast episode.';
$string['addltiepisode_settingheader'] = 'Add Opencast LTI episode modules to courses';
$string['addltiepisode_settingintro'] = 'Add episode module intro';
$string['addltiepisode_settingintro_desc'] = 'If enabled, teachers can add a intro to the Opencast LTI episode module. This intro will be shown on the course overview page.';
$string['addltiepisode_settingpreconfiguredtool'] = 'Preconfigured LTI tool for episode modules';
$string['addltiepisode_settingpreconfiguredtool_desc'] = 'The preconfigured LTI tool to be used when a new Opencast LTI episode module is added to a course.';
$string['addltiepisode_settingpreconfiguredtool_notools'] = 'No preconfigured LTI tools to be used found. Please create an Opencast episode LTI tool first on the {$a} admin setting page.';
$string['addltiepisode_settingsection'] = 'Choose episode module section';
$string['addltiepisode_settingsection_desc'] = 'If enabled, teachers can choose the section which the Opencast LTI episode module will be added to.';
$string['addltiepisode_viewicontitle'] = 'View Opencast episode module in course';
$string['addnewcatalogfield'] = 'A new field has been added to metadata catalog.';
$string['addnewtranscription'] = 'Add new transcription';
$string['addnewtranscription_desc'] = 'Please upload a transcription file for each of the languages listed below.<br><strong>NOTE:</strong> Uploading a new file for a language that already has a subtitle will overwrite the existing one. This can be useful for applying updates or changes.';
$string['addrole'] = 'Add new role';
$string['addvideo'] = 'Add video';
$string['addvideonotallowed'] = 'You are not allowed to upload a video to this series.';
$string['adhocfiledeletion'] = 'Delete videofile from moodle';
$string['adhocfiledeletiondesc'] = 'If activated the plugin tries to delete the videofile from moodle\'s filessystem right after it was uploaded to opencast server. Please note that the file will still remain in the file system, if it is used within other places in moodle.';
$string['adminchoice_noconnection'] = "-- Workflows could not be retrieved --";
$string['adminchoice_noworkflow'] = "-- No workflow --";
$string['allowdownloadtranscriptionsetting'] = 'Allow download transcriptions';
$string['allowdownloadtranscriptionsetting_desc'] = 'Displays a download button on the transcription management page, allowing teachers to download existing transcription files. <br><b>Notice:</b> Ensure all prerequisites are configured, including LTI feature activation and appropriate permissions for accessing the /assets/ endpoint. These are required for successful LTI integration.';
$string['alloweduploadwfconfigs'] = 'Allowed upload workflow configurations';
$string['alloweduploadwfconfigsdesc'] = 'A comma separated list of allowed upload workflow configuration ids to be shown to the teachers in upload page, which already exist in the workflow configuration panel.<br />For example: straightToPublishing,whisper_de,vosk_en<br />NOTE: if empty, all elements in the workflow configuration panel such as input and select elements will be provided to the teachers.';
$string['allowunassign'] = 'Allow unassign from course';
$string['allowunassigndesc'] = 'Delete the assignment of a course series to control visibility in filepicker and course lists. This feature is only available, when it is possible to have events without series in opencast. Please ask the admistrator of the opencast system before activating this.';
$string['apicreadentialstestfailedlong'] = 'The given Username or Password for the Opencast API is not valid.<br />Please use valid Username and Password in order to avoid fatal error during tasks which use this setting.';
$string['apicreadentialstestfailedshort'] = 'Opencast API User Credentials test failed with http code: {$a}';
$string['apicreadentialstestsuccessfulshort'] = 'Opencast API User Credentials test successful.';
$string['apipassword'] = 'Password of Opencast API user';
$string['apipassworddesc'] = 'Configure the password of the Opencast user who is used to do the Opencast API calls.';
$string['apipasswordempty'] = 'Password of Opencast API user is not configured correctly. Go to the settings of the Opencast API tool to fix this.';
$string['apiurl'] = 'Opencast API URL';
$string['apiurldesc'] = 'Configure the base URL of the Opencast system. A valid URL is required here. If you omit the protocol part here, \'https://\' is added on-the-fly when doing Opencast API calls.';
$string['apiurlempty'] = 'URL of Opencast API is not configured correctly. Go to the settings of the Opencast API tool to fix this.';
$string['apiurltestfailedlong'] = 'There is no Opencast instance running on the given URL.<br />Please use a valid URL in order to avoid fatal error during tasks which use this setting.';
$string['apiurltestfailedshort'] = 'Opencast API URL test failed with http code: {$a}';
$string['apiurltestsucceedbutnocredentialslong'] = 'The Opencast API URL is valid, but Username or Password are not yet provided.<br />Please enter valid Username and Password in order to avoid fatal error during tasks which use this setting.';
$string['apiurltestsuccessfulshort'] = 'Opencast API URL test successful.';
$string['apiusername'] = 'Username of Opencast API user';
$string['apiusernamedesc'] = 'Configure the username of the Opencast user who is used to do the Opencast API calls. Moodle uses this Opencast user for all communication with Opencast. Authorization is done by adding suitable roles to the call.';
$string['apiusernameempty'] = 'Username of Opencast API user is not configured correctly. Go to the settings of the Opencast API tool to fix this.';
$string['appearance_instance'] = 'Appearance Settings: {$a}';
$string['appearance_overview_settingheader'] = 'Overview page';
$string['appearance_overview_settingshowenddate'] = 'Show end date';
$string['appearance_overview_settingshowenddate_desc'] = 'If enabled, the table of available videos on the overview page will contain a column which shows the end date of the Opencast episode.';
$string['appearance_overview_settingshowlocation'] = 'Show location';
$string['appearance_overview_settingshowlocation_desc'] = 'If enabled, the table of available videos on the overview page will contain a column which shows the location of the Opencast episode.';
$string['appearance_overview_settingshowpublicationchannels'] = 'Show publication channels';
$string['appearance_overview_settingshowpublicationchannels_desc'] = 'If enabled, the table of available videos on the overview page will contain a column which shows the publication channel of the Opencast episode. The same information will also be given on the Opencast episode deletion page.';
$string['appearance_settings'] = 'Appearance';
$string['backupopencastvideos'] = 'Include videos from Opencast instance {$a} in this course';
$string['batchupload'] = 'Add videos (batch)';
$string['batchupload_emptyvideosuploaderror'] = 'You must upload at least one presenter video file.';
$string['batchupload_errornotenabled'] = 'Unfortunately the batch video upload feature is unavailable for this Opencast instance, please try to contanct your system administrator.';
$string['batchupload_errorsaveuploadjobs'] = 'There were errors uploading {$a->count} out of {$a->total} video(s).';
$string['batchupload_errorseriesmismatched'] = 'Unfortunately the series is not defined in this course.';
$string['batchupload_filemanager_presenter_title'] = 'Presenter videos';
$string['batchupload_form_header'] = 'Batch Upload Files';
$string['batchupload_jobssaved'] = 'Batch of {$a} Video(s) successfully uploaded. <br> The videos are queued for transferring to Opencast. Therefore, you do not need to wait on this page for them to finish.';
$string['batchupload_metadata_desc'] = 'By uploading a batch of videos to Opencast at once, the following metadata will be set for each video.';
$string['batchupload_metadata_header'] = 'Batch Metadata';
$string['batchupload_setting'] = 'Enable batch video upload';
$string['batchupload_setting_desc'] = 'By enabling this option, the Opencast instance will provide a separate page to the users to upload videos in batch at once. Please note that the local_chunkupload plugin does not work in this upload mode. This means that the file size is limited based on your settings.<br /> To avoid cluttering the upload job queue up as well as decreasing the upload process time, it is recommended to increase the "Limit upload job by cron".<br /> To avoid any timeout error during video uploads, it is recommended to adjust timeout options in the following settings according to your needs: <br /> {$a->uploadtimeoutlink} <br /> {$a->toolopencastinstancelink} ';
$string['batchupload_visibility_desc'] = 'The batch visibility setting will be applied for each uploaded video in the batch.';
$string['batchupload_visibility_header'] = 'Batch Visibility';
$string['batchuploadexplanation'] = 'In this section you are able to upload multiple files at once. <br /> NOTE: Please keep in mind that the batch video upload is only available for presenter flavors.';
$string['blocksettings'] = 'Settings for a block instance';
$string['cachedef_videodata'] = 'Caches the result of the opencast api for the opencast-block.';
$string['cachevalidtime'] = 'Cache valid time';
$string['cachevalidtime_desc'] = 'Time in seconds, before the cache for the video data of each course is refreshed.';
$string['cantdeletedefaultseries'] = 'You cannot delete the default series. Please choose another series as default for this course before deleting this series.';
$string['cantdeletedefaultseries_modaltitle'] = 'Cannot Delete Default Series';
$string['catalog_params_noarray'] = "Parameters have to be either empty or a JSON representation of an array or an object.";
$string['catalog_static_params_empty'] = "Read only fields need to define a text in the parameters field.";
$string['catalogparam'] = 'Parameters in JSON-Format';
$string['catalogparam_help'] = '<b>JSON format:</b> {"param1":"value1", "param2":"value2"}<br><b>String (text), Long Text (textarea):</b> Parameters will be defined as attributes of the element. i.e. {"style":"min-width: 27ch;"} which defines the element´s style attribute <br><b>Drop Down (select):</b> Parameters will be defined as options of the select element. i.e. {"en": "English", "de": "German"} which takes the left side as value and right side as text to show.<b>(Multi-Language filters)</b> In order for each value of <i>Drop Down (select)</i> to get translated using filters such as <a target="_blank" href="https://moodle.org/plugins/filter_multilang2">Multi-Language Content (v2)</a>, each value should contain the placeholder, defined by that filter i.e. "{mlang en}No option selected{mlang}{mlang de}Keine Option ausgewählt{mlang}" or "{mlang en}English{mlang}{mlang de}Englisch{mlang}"<br><b>Arrays (autocomplete):</b> Parameters will be defined as <a target="_blank" href="https://docs.moodle.org/dev/lib/formslib.php_Form_Definition#autocomplete">suggestions</a>. i.e. {"1": "Dr. Doe", "2": "Johnson"} which shows (Dr. Doe and Johnson) as suggestions<br><b>Date Time Selector (datetime):</b> Parameters will be defined as <a target="_blank" href="https://docs.moodle.org/dev/lib/formslib.php_Form_Definition#date_selector">date_selector variables</a> . i.e. {"startyear": "1990", "stopyear": "2020"} which defines date range to be selected between 1990 - 2020';
$string['changeowner'] = 'Change owner';
$string['changeowner_explanation'] = 'Currently, you are the owner of the video {$a}.<br>You can transfer the ownership to another person.<br><b>Notice:</b> You might loose the right to access the video.';
$string['changeownerseries_explanation'] = 'Currently, you are the owner of the series {$a}.<br>You can transfer the ownership to another person.<br><b>Notice:</b> You might loose the right to access the series.';
$string['changescheduledvisibility'] = 'Change scheduled visibility for {$a}';
$string['changescheduledvisibilityfailed'] = 'Unabale to change scheduled visibility';
$string['changescheduledvisibilityheader'] = 'Scheduled visibility change';
$string['changescheduledvisibilitysuccess'] = 'Scheduled visibility successfully changed';
$string['changevisibility'] = 'Alter visibility';
$string['changevisibility_group'] = 'The video is visible to all student belonging to selected groups. Click to alter visibility.';
$string['changevisibility_header'] = 'Change visibility for {$a->title}';
$string['changevisibility_header_massaction'] = 'Change visibility for selected videos';
$string['changevisibility_hidden'] = 'The video is visible to no student. Click to alter visibility.';
$string['changevisibility_massaction'] = 'Alter visibility of selected videos.';
$string['changevisibility_massaction_aclchangeerror'] = 'The visibility change has been failed.';
$string['changevisibility_massaction_aclchangeerror_noscheduling'] = 'The visibility change could not be completed, and the scheduled visibility change was skipped.';
$string['changevisibility_massaction_notification_failed'] = 'Unable to change visibility for the following video(s): <br><ul><li>{$a}</li></ul>';
$string['changevisibility_massaction_notification_nochanges'] = 'No visibility changes were applied to the selected video(s) as the current visibility already matches the chosen setting: <br><ul><li>{$a}</li></ul>';
$string['changevisibility_massaction_notification_schedulingfailed'] = 'Unable to schedule visibility change for the following video(s): <br><ul><li>{$a}</li></ul>';
$string['changevisibility_massaction_notification_schedulingsucceeded'] = 'The visibility change for the selected video(s) has been successfully scheduled: <br><ul><li>{$a}</li></ul>';
$string['changevisibility_massaction_notification_succeeded'] = 'The visibility of the selected video(s) has been successfully updated: <br><ul><li>{$a}</li></ul>';
$string['changevisibility_massaction_novideos'] = 'Unable to find any video to alter the visibility.';
$string['changevisibility_massaction_report_failed'] = '{$a->title}: {$a->error}';
$string['changevisibility_massaction_videoerror'] = 'Change visibility for the video ({$a->title}) is not possible at the moment due to: {$a->error}';
$string['changevisibility_massaction_visibility_status'] = '<strong>{$a->title}</strong>: {$a->vstatusdesc}';
$string['changevisibility_massaction_visibility_status_with_scheduled'] = '<strong>{$a->title}</strong>: {$a->vstatusdesc} scheduled for "{$a->svstatus}" status on {$a->svdatetime}';
$string['changevisibility_mixed'] = 'The visibility of the video is in an invalid status. Click to choose the correct visibility.';
$string['changevisibility_visible'] = 'The video is visible to all students of the course. Click to alter visibility.';
$string['changingownerfailed'] = 'An error occured. The ownership could not be transferred.';
$string['changingownersuccess'] = 'The ownership was successfully transferred.';
$string['claimowner_explanation'] = 'Currently, nobody owns the video {$a}.<br>You can claim the ownership or set another person as owner.<br><b>Notice:</b> You might loose the right to access the video if you do not claim the ownership yourself.';
$string['claimownerseries_explanation'] = 'Currently, nobody owns the series {$a}.<br>You can claim the ownership or set another person as owner.<br><b>Notice:</b> You might loose the right to access the series if you do not claim the ownership yourself.';
$string['configuration'] = 'Configuration';
$string['configuration_instance'] = 'Configuration: {$a}';
$string['configurationpanel_header'] = 'Processing Settings';
$string['configurationpanelheader_explanation'] = 'The following settings options are available to customized the upload process according to your likings.';
$string['connection_failure'] = 'Could not reach Opencast server.';
$string['connecttimeout'] = 'Connection timeout';
$string['connecttimeoutdesc'] = 'Configure the time in milliseconds while Moodle is trying to connect to Opencast. If Opencast does not answer within this time, the connection attempt times out.';
$string['contributor'] = 'Contributor(s)';
$string['coursefullnameunknown'] = 'Unkown coursename';
$string['created'] = 'Created at';
$string['createdby'] = 'Uploaded by';
$string['createseriesforcourse'] = 'Create new series';
$string['createseriesforcourse_succeeded'] = 'A new series has been successfully created.';
$string['creator'] = 'Presenter(s)';
$string['cronsettings'] = 'Settings for upload jobs';
$string['date'] = 'Start Date';
$string['dcmitermsnotice'] = '<br /><strong>IMPORTANT</strong>: Opencast supports standardized Dublin Core metadata set, therefore all metadata fields should follow DCMI terms, otherwise attempting to add unknown metadata field will result in error.<br /> You can check the list of all available terms to use in <a target="_blank" href="https://www.dublincore.org/specifications/dublin-core/dcmi-terms/">DCMI Metadata Terms</a>.';
$string['default'] = 'Default';
$string['defaultssaved'] = 'Default values are saved.';
$string['delete_block_and_mapping'] = 'Delete block and series mapping';
$string['delete_confirm_metadata'] = 'Are you sure you want to delete this metadata field?';
$string['delete_confirm_role'] = 'Are you sure you want to delete this role?';
$string['delete_confirm_series'] = 'Are you sure you want to delete this series? <br/><b>Notice:</b> The series is only unlinked from this course but not deleted in Opencast.';
$string['delete_instance'] = 'Delete instance';
$string['delete_instance_confirm'] = 'Do you really want to delete this instance?<br>
Teachers will not be able to see videos used in this instance anymore.<br>
<b>Caution:</b> All data related to this instance will be lost.<br><br>
The deletion will be performed after you click on \'Save changes\' on the main settings page.';
$string['delete_mapping_explanation'] = 'The Opencast Block tracks which Opencast Series is mapped to the course.<br> You can choose whether to delete the mapping.<br> If you delete it, the series will no longer appear when you create the opencast block again.';
$string['delete_metadata'] = 'Delete metadata field';
$string['delete_role'] = 'Delete role';
$string['delete_series'] = 'Delete series';
$string['delete_series_failed'] = 'Deleting the series failed. Please try again later or contact an administrator.';
$string['delete_series_succeeded'] = 'The series has been successfully deleted.';
$string['deleteaclgroup'] = 'Delete video from this list.';
$string['deletecheck_title_modal'] = 'Remove Opencast Block?';
$string['deletedraft'] = 'Delete a video before transfer to Opencast';
$string['deletedraftdesc'] = 'You are about to delete this video before the transfer to Opencast.<br />It will be removed from the transfer queue and will not be processed. Please do not continue unless you are absolutely sure.';
$string['deleteevent'] = 'Delete an event in Opencast';
$string['deleteevent_massaction'] = 'Delete selected video(s) in Opencast';
$string['deleteevent_massaction_notification_failed'] = 'Failed to delete the following videos: <br><ul><li>{$a}</li></ul>';
$string['deleteevent_massaction_notification_nochange'] = 'Unable to delete any video due to missing video identifier.';
$string['deleteevent_massaction_notification_success'] = 'The following selected video will be deleted shortly: <br><ul><li>{$a}</li></ul>';
$string['deleteeventdesc'] = 'You are about to delete this video permanently and irreversibly from Opencast.<br />All embedded links to it will become invalid. Please do not continue unless you are absolutely sure.';
$string['deletegroupacldesc'] = 'You are about to delete the access to this video from this course.<br />If the access is deleted, the video is not displayed in filepicker and in the list of available videos. This does not affect videos, which are already embedded.<br />The video will not be deleted in Opencast.';
$string['deletetranscription'] = 'Delete transcription';
$string['deletetranscription_desc'] = 'You are about to delete the transcription.<br>Are you sure you would like to delete it?';
$string['deletetranscriptionworkflow'] = 'Workflow for delete transcription';
$string['deletetranscriptionworkflow_desc'] = 'Specifies the Opencast workflow to be triggered when a transcription file is deleted from a video. If not defined, the default workflow "publish" will be used.';
$string['deleteworkflow'] = 'Workflow to start before event is be deleted';
$string['deleteworkflowdesc'] = 'Before deleting a video, a workflow can be defined, which is called to retract the event from all publication channels.';
$string['deleting'] = 'Going to be deleted';
$string['demoservernotification'] = 'The Opencast API tool is currently configured to connect to the <a href=\'https://stable.opencast.org\'>public Opencast demo server</a>. You can use this Opencast server for evaluating this plugin.<br />Do not use it for any production purposes. Please <a href=\'https://docs.opencast.org/\'>setup your own Opencast server</a> instead.';
$string['description'] = 'Description';
$string['descriptionmdbatchable'] = 'Batchable';
$string['descriptionmdbatchable_help'] = 'When enabled, the metadata field can be set for batch video upload.';
$string['descriptionmddefaultable'] = 'Defaultable';
$string['descriptionmddefaultable_help'] = 'When enabled, users can add default value for this field.';
$string['descriptionmdfd'] = 'Field Description';
$string['descriptionmdfd_help'] = 'The content of this field is presented as a help icon near the metadata field.';
$string['descriptionmdfn'] = 'Field name';
$string['descriptionmdfn_help'] = 'This is the actual field name passing as metadata (id); the presented name according to this field name should be set in language string.';
$string['descriptionmdpj'] = 'The value should be JSON string format and it is used to define parameters for the field!';
$string['descriptionmdreadonly'] = 'Readonly';
$string['descriptionmdreadonly_help'] = 'Please note that, if a field is set to be required, the readonly option will be disabled. That means a field can only be readonly or required at a time.';
$string['directaccess_copy_no_link'] = 'Invalid direct access link';
$string['directaccess_copy_success'] = 'The direct access link has been successfully copied to clipboard.';
$string['directaccess_copytoclipboard_unavialable'] = 'It seems that your browser does not support the copy to clipboard functionality, try to copy the link manually from the dropdown item.';
$string['directaccess_setting'] = 'Direct access channel';
$string['directaccess_settingdesc'] = 'Opencast publication channel from which the videos are served when accessing them directly. Leaving this option empty will disable the feature.<br/><strong>Notice:</strong> It is recommended to take further caution using this feature, since it reveals the direct video data on the Opencast server upon accessing the link.';
$string['directaccesscopylink'] = 'Copy video direct access link';
$string['directaccesstovideo'] = 'Direct access to video';
$string['dodeleteaclgroup'] = 'Delete access to videos from this course';
$string['dodeletedraft'] = 'Delete video before transfer to Opencast';
$string['dodeleteevent'] = 'Delete video permanently';
$string['download_setting'] = 'Download channel';
$string['download_settingdesc'] = 'Opencast publication channel from which the videos are served when downloading them.';
$string['download_settingheader'] = 'Download videos';
$string['downloadtranscription'] = 'Download transcription';
$string['downloadvideo'] = 'Download video';
$string['duplicateworkflow'] = 'Workflow for duplicating events';
$string['duplicateworkflowdesc'] = 'This workflow is needed for importing opencast events from one course into another. If not set, it is not possible to import Opencast events.';
$string['duration'] = 'Duration';
$string['editorbaseurl'] = 'Opencast Editor Base URL';
$string['editorbaseurl_desc'] = 'The base URL to be used to call the Opencast Editor, the base url of the opencast instance is used if empty.';
$string['editorendpointurl'] = 'Opencast Editor Endpoint';
$string['editorendpointurl_desc'] = 'The editor endpoint to access the editor. The mediapackage ID will be added at the end of the url.';
$string['editseries'] = 'Edit series';
$string['editseries_succeeded'] = 'The series has been successfully updated.';
$string['embeddedasactivity'] = 'Embedded as activity';
$string['embeddedasactivitywolink'] = 'Embedded as activity without linked series';
$string['empty_catalogname'] = 'This field must not be empty';
$string['emptyvideouploaderror'] = 'You must either upload a presenter video or a presentation video file.';
$string['emptyvisibilitygroups'] = 'At least one group must be selected.';
$string['enablechunkupload'] = 'Enable Chunkupload';
$string['enablechunkupload_desc'] = 'If Chunkupload is enabled it will be possible to upload videos using the chunkupload plugin';
$string['enableopencasteditorlink'] = 'Show the link to opencast Editor in action menu';
$string['enableopencasteditorlink_desc'] = 'This option renders a button to opencast editor in the block content and the block overview. The following settings as well lti credentials have to be configured as well.';
$string['enableopencaststudiolink'] = 'Show the link to opencast studio';
$string['enableopencaststudiolink_desc'] = 'This option renders a button to opencast studio in the block content and the block overview. Opencast studio has to run on your opencast admin node and the following lti settings have to be configured as well.';
$string['enableopencaststudioreturnbtn'] = 'Show a redirect back button in Studio';
$string['enableopencaststudioreturnbtn_desc'] = 'When enabled, Studio then renders an additional button "Exit and go back" after up- or downloading the recording.';
$string['enableschedulingchangevisibility'] = 'Schedule a visibility change';
$string['enableschedulingchangevisibility_massaction'] = 'Schedule a visibility change for the selected video(s)';
$string['enableschedulingchangevisibilitydesc'] = 'Set a date and a visibility status for the event in future, which will be performed using a scheduled task.';
$string['enableschedulingchangevisibilitydesc_massaction'] = 'Set a date and a visibility status for the selected video(s) in future, which will be performed using a scheduled task.';
$string['enableuploadwfconfigpanel'] = 'Show workflow configurations during upload';
$string['enableuploadwfconfigpaneldesc'] = 'If activated, the configuration panel of the upload workflow will is shown to the teachers during uplaod video in the upload page. With this feature teachers are able to decide further processing options or input values during upload process in Opencast depending on the workflow structure.';
$string['engageplayerintegration'] = 'Engage player integration';
$string['engageredirect'] = 'Redirect to engage player';
$string['engageurl'] = 'URL of the Opencast Engage server';
$string['engageurl_desc'] = 'If empty, the video titles in the overview are not linked to the engage player.';
$string['error_block_delete_seriesmapping'] = 'Unfortunately, there was an error during course series mapping deletion, please contact the system administrator.';
$string['error_duplicated_event_acl_change'] = 'The visibility change for the duplicated event failed. Opencast duplicated event visibility change task ({$a->taskid}) for course {$a->coursefullname} (ID: {$a->courseid}).';
$string['error_duplicated_event_id_not_ready'] = 'The duplicated event is not available yet. Opencast duplicated event visibility change task ({$a->taskid}) for course {$a->coursefullname} (ID: {$a->courseid}).';
$string['error_eventid_taskdata_missing'] = 'The task data contains no event id. Opencast duplicate event task ({$a->taskid}) for course {$a->coursefullname} (ID: {$a->courseid}).';
$string['error_no_duplicate_origin_event_id'] = 'The origin event id is missing. Opencast duplicated event visibility change task ({$a->taskid}) for course {$a->coursefullname} (ID: {$a->courseid}).';
$string['error_no_duplicate_workflow_id'] = 'The duplicate workflow id is missing. Opencast duplicated event visibility change task ({$a->taskid}) for course {$a->coursefullname} (ID: {$a->courseid}).';
$string['error_seriesid_missing_course'] = 'The course {$a->coursefullname} (ID: {$a->courseid}) has no course series. The event ({$a->eventid}) could not be restored.';
$string['error_seriesid_missing_opencast'] = 'The series of course {$a->coursefullname} (ID: {$a->courseid}) can not be found in the opencast system. The event ({$a->eventid}) could not be restored.';
$string['error_seriesid_not_matching'] = 'The course {$a->coursefullname} (ID: {$a->courseid}) has a course series, that does not match the seriesid of the task. The event ({$a->eventid}) could not be restored.';
$string['error_seriesid_taskdata_missing'] = 'The task data contains no series id. Opencast duplicate event task ({$a->taskid}) for course {$a->coursefullname} (ID: {$a->courseid}).';
$string['error_workflow_not_exists'] = 'The workflow {$a->duplicateworkflow} can not be found in the opencast system. The event ({$a->eventid}) could not be restored for course {$a->coursefullname} (ID: {$a->courseid}).';
$string['error_workflow_not_started'] = 'The workflow to copy the video ({$a->eventid}) assigned to course {$a->coursefullname} (ID: {$a->courseid}) could not be started.';
$string['error_workflow_setup_missing'] = 'The plugin tool_opencast is not properly configurated. The duplication workflow is missing!';
$string['errorduplicatedeventvisibilitytaskretry'] = 'An error occured by executing a task for setting the duplicated event\'s visibility: {$a} Will try to start the workflow again by the next cron job.';
$string['errorduplicatedeventvisibilitytaskterminated'] = 'An error occured by executing a task for setting the duplicated event\'s visibility: {$a} After trying serveral time the task will be terminated now.';
$string['errorduplicatetaskretry'] = 'An error occured by executing a task for duplication of an event: {$a} Will try to start the workflow again by the next cron job.';
$string['errorduplicatetaskterminate'] = 'An error occured by executing a task for duplication of an event: {$a} After trying serveral time the task will be terminated now.';
$string['erroremailbody'] = '{$a->errorstr} Details: {$a->message}.';
$string['erroremailsubj'] = 'Error while executing opencast process duplicate task';
$string['errorgetblockvideos'] = 'List cannot be loaded (Error: {$a})';
$string['errornumdefaultinstances'] = 'There must be exactly one default Opencast instance.';
$string['errorrestorefailedeventsaclchange_body'] = 'There was a problem in the restore process of the course {$a->coursefullname} (ID: {$a->courseid}). The visibility of the video(s) with the following identifier(s) could not be changed. This video(s) will not be accessible in the new course:';
$string['errorrestorefailedeventsaclchange_subj'] = 'Opencast error during restore process';
$string['errorrestorefailedseriesaclchange_body'] = 'There was a problem in the restore process of the course {$a->coursefullname} (ID: {$a->courseid}). The series ACL could not be changed (series: {$a->seriesid}).';
$string['errorrestorefailedseriesaclchange_subj'] = 'Opencast error during restore process';
$string['errorrestorefailedseriesmapping_body'] = 'There was a problem in the restore process of the course {$a->coursefullname} (ID: {$a->courseid}). Mapping the series {$a->seriesid} to the new course failed.';
$string['errorrestorefailedseriesmapping_subj'] = 'Opencast error during restore process';
$string['errorrestoreincompletedimportmapping_body'] = 'There was a problem in the restore process of the course {$a->coursefullname} (ID: {$a->courseid}). The following events could not get the completion flag for the restore session, therefore they will not be processed later to fix the modules if any:';
$string['errorrestoremissingevents_body'] = 'There was a problem in the restore process of the course {$a->coursefullname} (ID: {$a->courseid}). The video(s) with the following identifier(s) could not be found in opencast system. This video(s) will not be restored:';
$string['errorrestoremissingevents_subj'] = 'Opencast error during restore process';
$string['errorrestoremissingimportmapping_subj'] = 'Opencast error during restore process (Import mapping)';
$string['errorrestoremissingimportmappingevents_body'] = 'There was a problem in the restore process of the course {$a->coursefullname} (ID: {$a->courseid}). The following events have no import mapping record, therefore, module fixing process might not be performed if exists:';
$string['errorrestoremissingimportmappingseries_body'] = 'There was a problem in the restore process of the course {$a->coursefullname} (ID: {$a->courseid}). The following series have no import mapping record, therefore, module fixing process might not be performed if exists:';
$string['errorrestoremissingimportmode_body'] = 'There was a problem in the restore process of the course {$a->coursefullname} (ID: {$a->courseid}). Import mode could not be identified, therefore restore task has failed.';
$string['errorrestoremissingimportmode_subj'] = 'Opencast error during restore process';
$string['errorrestoremissingseries_body'] = 'There was a problem in the restore process of the course {$a->coursefullname} (ID: {$a->courseid}). No opencast series could be created. Therefore, the following eventIDs could not be duplicated:';
$string['errorrestoremissingseries_subj'] = 'Opencast error during restore process';
$string['errorrestoremissingseriesid_body'] = 'There was a problem in the restore process of the course {$a->coursefullname} (ID: {$a->courseid}). Series id could not be found.';
$string['errorrestoremissingseriesid_subj'] = 'Opencast error during restore process';
$string['errorrestoremissingsourcecourseid_body'] = 'There was a problem in the restore process of the course {$a->coursefullname} (ID: {$a->courseid}). Source course id could not be found.';
$string['errorrestoremissingsourcecourseid_subj'] = 'Opencast error during restore process';
$string['eventdeleted'] = 'The video has been deleted.';
$string['eventdeletedfailed'] = 'Failed to delete the event';
$string['eventdeletionstarted'] = 'The video will be deleted shortly.';
$string['eventuploadfailed'] = 'Upload failed';
$string['eventuploadsucceeded'] = 'Upload succeeded';
$string['exception_code_unabletoaddhandler'] = 'There was an error loading the opencast api middleware, must be fixed by a developer.';
$string['exception_connect'] = 'Opencast API call failed: {$a}';
$string['exception_connect_generic'] = 'Opencast is unreachable due to a connection error.';
$string['exception_request_400'] = 'Unexpected Opencast API response error: (400) Bad Request!';
$string['exception_request_401'] = 'Unexpected Opencast API response error: (401) Unauthorized!';
$string['exception_request_403'] = 'Unexpected Opencast API response error: (403) Forbidden!';
$string['exception_request_404'] = 'Unexpected Opencast API response error: (404) Not found!';
$string['exception_request_405'] = 'Unexpected Opencast API response error: (405) Method not allowed!';
$string['exception_request_408'] = 'Unexpected Opencast API response error: (408) Request Timeout!';
$string['exception_request_409'] = 'Unexpected Opencast API response error: (409) Conflict!';
$string['exception_request_410'] = 'Unexpected Opencast API response error: (410) Gone!';
$string['exception_request_422'] = 'Unexpected Opencast API response error: (422) Unprocessable Conten!';
$string['exception_request_500'] = 'Unexpected Opencast API response error: (500) Internal Server Error!';
$string['exception_request_501'] = 'Unexpected Opencast API response error: (501) Not Implemented!';
$string['exception_request_502'] = 'Unexpected Opencast API response error: (502) Bad Gateway!';
$string['exception_request_503'] = 'Unexpected Opencast API response error: (503) Service Unavailable!';
$string['exception_request_generic'] = 'An error occurred while trying to reach Opencast Server. Please try again later.';
$string['exception_request_ingest_endpoint_notfound'] = 'The ingest endpoint is not available, this has to be fix by the system administrator.';
$string['exists_catalogname'] = 'The field is already existed';
$string['expirydate'] = 'Expiry Date';
$string['failedtogetvideo'] = 'Cannot get event data from Opencast.';
$string['failedtransferattempts'] = 'Failed transfer attempts: {$a}';
$string['faileduploadretrylimit'] = 'Limit failed upload attempts';
$string['faileduploadretrylimitdesc'] = 'Each upload job will be archived once the maximum number of failed attempts is reached. When a job is archived, teachers must decide whether to delete it or manually re-queue it. <br/>The uploader will always be notified. If the "event status notification" option ("eventstatusnotificationenabled") is enabled, other teachers in the course will also be informed about the archived status. <br/><strong>NOTE:</strong> A value of 0 (default) or leaving the field empty means there is no limit.';
$string['filetypes'] = 'Accepted file types';
$string['form_seriesid'] = 'Series ID';
$string['form_seriestitle'] = 'Series title';
$string['functionalitydisabled'] = 'This functionality is disabled.';
$string['general_instance'] = 'General Settings: {$a}';
$string['general_settings'] = 'General settings';
$string['gotooverview'] = 'Go to overview...';
$string['group_name_empty'] = 'The group name must not be empty if a group should be created.';
$string['groupcreation'] = 'Create a group';
$string['groupcreationdesc'] = 'If checked, a group is created during the upload.';
$string['groupname'] = 'Group name';
$string['groupnamedesc'] = 'Group to which the video is added. Important: The group name length is restricted to 128 Bytes. You can use the placeholders [COURSEID] and [COURSENAME] which are automatically replaced.';
$string['groupseries_header'] = 'Group and Series';
$string['haction'] = 'Action';
$string['heading_actions'] = 'Actions';
$string['heading_batchable'] = 'Batchable';
$string['heading_datatype'] = 'Field Type';
$string['heading_defaultable'] = 'Defaultable';
$string['heading_delete'] = 'Delete';
$string['heading_description'] = 'Field Description';
$string['heading_lti'] = 'Setting for LTI Configuration';
$string['heading_name'] = 'Field Name';
$string['heading_params'] = 'Parameters (JSON)';
$string['heading_permanent'] = 'Permanent';
$string['heading_position'] = 'Position';
$string['heading_readonly'] = 'Read Only';
$string['heading_required'] = 'Required';
$string['heading_role'] = 'Role';
$string['hend_date'] = 'End Date';
$string['hlocation'] = 'Location';
$string['hprovide'] = 'Provide';
$string['hprovidelti'] = 'Provide (LTI)';
$string['hpublished'] = 'Published';
$string['hscheduledvisibility'] = 'Scheduled Visibility';
$string['hstart_date'] = 'Start Date';
$string['htitle'] = 'Title';
$string['hvisibility'] = 'Visibility';
$string['hworkflow_state'] = 'Status';
$string['identifier'] = 'Identifier';
$string['importfailed'] = 'The series could not be imported.';
$string['importmapping_modulesfixtaskretry'] = 'An error occured by executing a task for fixing the duplicated event\'s modules: {$a} The task will be processed again later.';
$string['importmapping_modulesfixtasktermination'] = 'An error occured by executing a task for fixing the duplicated event\'s modules: {$a} After trying serveral time the task will be terminated now.';
$string['importmapping_no_duplicated_event_id_yet'] = 'The duplicated event is not available yet, therefore duplicated event modules fix task ({$a->taskid}) for course {$a->coursefullname} (ID: {$a->courseid}) has been postponed.';
$string['importmapping_restore_still_in_progress'] = 'The restore process is still in progress, therefore duplicated event modules fix task ({$a->taskid}) for course {$a->coursefullname} (ID: {$a->courseid}) has been postponed.';
$string['importmode'] = 'Import mode';
$string['importmodedesc'] = 'In order to define an approach to import videos into a course, a mode should be seleted. The default mode is Duplicating Events in which a new series would be created and events will be avaible in the series by using a dupliaction workflow. <br /> ACL Change approach on the other hand will use the same seriesid among courses but series and events\' ACLs are changes to grant access from the course which imports the videos.<br /><strong>NOTE:</strong> At the moment, the selection of events in import wizards (course and manual) for "ACL Change" is NOT possible, due to avoiding further complications in terms of permissions in Opencast.';
$string['importreducedduplication'] = 'Reduce the amount of duplicated events';
$string['importreducedduplication_desc'] = 'If enabled, the course backup will only duplicate events that are integrated into the course via the Opencast activity module or the Opencast LTI tool. If the Moodle site relies on the Opencast filter plugin to display videos in courses, this setting should not be used.';
$string['importseries'] = 'Import series';
$string['importseries_alreadyexists'] = 'The series you are trying to import is already present. Please choose a different series.';
$string['importseries_notallowed'] = 'Importing this series into this course is not allowed. Please select a different series or contact the system administrator for assistance.';
$string['importseries_succeeded'] = 'The series has been successfully imported.';
$string['importvideos_aclprocessingexplanation'] = 'The seriesid of the selected course will be used in this course and the series\' ACL as well as ACLs of its videos will be changed accordingly.';
$string['importvideos_errornotenabledorworking'] = 'The import videos feature is not enabled or not working';
$string['importvideos_importbuttontitle'] = 'Import videos';
$string['importvideos_importepisodecleanupfailed'] = 'At least one of the existing Opencast episode modules within this course could not be cleaned up. Please try again or contact your Moodle administrator.';
$string['importvideos_importheading'] = 'Import videos from another course';
$string['importvideos_importjobaclchangealleventsfailed'] = 'Import has partially failed, because ACL change for all videos has failed.<br />However, the series is now mapped to this course and its ACL has been changed.';
$string['importvideos_importjobaclchangedone'] = 'The import of the selected series with its videos into this course was successful. You can now access the videos from the list.';
$string['importvideos_importjobaclchangeeventsfailed'] = 'Import has partially failed, because ACL change for some of the videos has failed.<br />However, the series is now mapped to this course and its ACL has been changed.<br />The ACL of following eventIDs could not the changed:';
$string['importvideos_importjobaclchangeseriesfailed'] = 'Import failed, because the ACL change for selected series has failed.';
$string['importvideos_importjobaclchangeseriesmappingfailed'] = 'Import failed, becasue mapping the series to the course has failed.';
$string['importvideos_importjobcreated'] = 'The import of the selected videos into this course was scheduled. This process will happen in the background. You do not need to wait on this page. As soon as the process is started, the videos will appear in the <em>Videos available in this course</em> section.<br><b>Notice:</b>A process of adjusting the visibility for the imported videos will also be executed right after the import process is completed, therefore it is suggested to give more time to the overall processing duration.';
$string['importvideos_importjobcreationfailed'] = 'At least one of the videos could not be imported to this course. Please try again or contact your Moodle administrator.';
$string['importvideos_importseriescleanupfailed'] = 'At least one of the existing Opencast series modules within this course could not be cleaned up. Please try again or contact your Moodle administrator.';
$string['importvideos_instance'] = 'Import Videos Settings: {$a}';
$string['importvideos_processingexplanation'] = 'These video files will be duplicated in Opencast and then made available in this course.';
$string['importvideos_progressbarstep'] = 'Step {$a->current} of {$a->last}';
$string['importvideos_sectionexplanation'] = 'In this section, you can import existing video files from other Moodle courses to this Moodle course.';
$string['importvideos_settingcoreenabled'] = 'Allow video import within Moodle core course import wizard';
$string['importvideos_settingcoreenabled_desc'] = 'If enabled, teachers can import existing video files from other Moodle courses to their Moodle course by using the Moodle core course import wizard. Within the wizard, there is an additional option shown to import the videos which have been uploaded within the Opencast block in the other course. Using this feature, the teacher can import all videos from another course as bulk, but he cannot select individual videos.<br />When Dupliacting Events is selected as the Import mode then the videos are duplicated in Opencast by an ad-hoc task in Moodle and will show up in the course\'s video list with a short delay.<br />In case of ACL Change as Import mode, the seriesid of the course being imported is used but the ACL of the series and its videos will be changed in order to grant access within the new course.<br /><strong>NOTE:</strong> With "ACL Change" import mode, the selection of videos in the wizard is not provided.';
$string['importvideos_settingenabled'] = 'Allow video import';
$string['importvideos_settingenabled_desc'] = 'If enabled, teachers can import existing video files from other Moodle courses to their Moodle course. You have to further select an import mode between Duplicating Events or ACL Change approach. In both modes, you need to enable one or both of the two following settings to manually import videos or to import videos within the Moodle core course import wizard. If you don\'t enable any of these, this setting will have no effect.<br />In Duplicating Events mode, you need to further set a duplication workflow.';
$string['importvideos_settinghandleepisodeenabled'] = 'Handle Opencast episode modules during manual video import';
$string['importvideos_settinghandleepisodeenabled_desc'] = 'If enabled, teachers can handle Opencast episode modules which were created with the "Add LTI episode module" feature and which relate to the videos which are imported. This especially cleans up modules which have been imported from one course to another course but which still link to videos in the old course. The episode modules are handled by an ad-hoc task in Moodle and will be fixed in the course with a short delay.<br />Please note that this mechanism relies on the fact that the Opencast duplication workflow sets a workflow instance configuration field \'duplicate_media_package_1_id\' which contains the episode ID of the duplicated episode. If the workflow does not set this configuration field, this feature will always fail.';
$string['importvideos_settinghandleseriesenabled'] = 'Handle Opencast series modules during manual video import';
$string['importvideos_settinghandleseriesenabled_desc'] = 'If enabled, teachers can handle Opencast series modules which were created with the "Add LTI series module" feature and which relate to the videos which are imported. This especially cleans up modules which have been imported from one course to another course but which still link to the course series of the old course. The series module is instantly handled after the import wizard is finished.';
$string['importvideos_settingheader'] = 'Import videos from other courses';
$string['importvideos_settingmanualenabled'] = 'Allow manual video import';
$string['importvideos_settingmanualenabled_desc'] = 'If enabled, teachers can import existing video files from other Moodle courses to their Moodle course by using a dedicated Opencast video import wizard. This feature is offered on the Opencast block overview page.<br /> In Duplicating Events import mode, the teacher can import all or a subset of videos from another course as bulk. The videos which are selected within the import wizard are duplicated in Opencast by an ad-hoc task in Moodle and will show up in the course\'s video list with a short delay.<br />In ACL Change import mode, the seriesid of the the target course will be used in the new course. Additionally, the ACLs of the series itself and all of its videos will be changed in order to grant access to them within the new course.<br />Unlike in Duplicating Events Mode, there is no manual selection of videos available within the provided wizard.<br />Please note that there are corresponding capabilities tool/opencast:manualimporttarget and tool/opencast:manualimportsource for this feature which control who can import which courses to which courses. By default, managers and editing teachers have this capability and can use the feature as soon as it is enabled here.<br /><strong>NOTE:</strong> With "ACL Change" import mode, the selection of videos in the wizard is not provided.';
$string['importvideos_settingmodeacl'] = 'ACL Change';
$string['importvideos_settingmodeduplication'] = 'Duplicating Events';
$string['importvideos_settingonbackup'] = 'Allow video import within Moodle core course import wizard';
$string['importvideos_settingonbackup_desc'] = 'If enabled, Opencast videos inside an Moodle course will be automatically backed up and restored during course backup. The video backup is configured by the settings importmode and importreducedduplication.';
$string['importvideos_settingonbackupvalue'] = 'Handle Opencast Videos when backing up Moodle courses';
$string['importvideos_settingonbackupvalue_desc'] = 'If enabled, Opencast videos inside an Moodle course will be automatically backed up and restored during course backup. The video backup is configured by the settings importmode and importreducedduplication.';
$string['importvideos_settingonbackupvalue_false'] = 'Don\'t backup';
$string['importvideos_settingonbackupvalue_true'] = 'Backup';
$string['importvideos_settings'] = 'Import videos features';
$string['importvideos_wizard_availableseries'] = 'Available series in {$a}';
$string['importvideos_wizard_event_cb_title'] = '{$a->title} (ID: {$a->identifier})';
$string['importvideos_wizard_series_cb_title'] = 'Series: {$a->title} (ID: {$a->identifier})';
$string['importvideos_wizard_seriesimported'] = 'Series to be imported';
$string['importvideos_wizard_unselectableeventreason'] = 'video selection';
$string['importvideos_wizard_unselectableeventreason_help'] = 'The import mode for the opencast instance is set to "ACL Change", which does not provide single video selection, therefore, by selecting this series, all of its videos will be automatically imported.';
$string['importvideos_wizardstep1coursevideos'] = 'Videos to be imported';
$string['importvideos_wizardstep1heading'] = 'Select source course';
$string['importvideos_wizardstep1intro'] = 'Select the source course from where the videos should be imported from the following list of courses.<br />You can pick from all courses which you are allowed to import videos from.';
$string['importvideos_wizardstep1series'] = 'Default series of this course';
$string['importvideos_wizardstep1seriesnotfound'] = 'The source course has no valid series id, please make sure the course you have selected has a default series.';
$string['importvideos_wizardstep1sourcecourse'] = 'Import videos from this course';
$string['importvideos_wizardstep1sourcecoursenone'] = 'There isn\'t any other course than this course which you are allowed to import videos from.';
$string['importvideos_wizardstep2aclheading'] = 'Select series';
$string['importvideos_wizardstep2aclintro'] = 'Select the series which you want to import from the source course.<br/>All videos from this series are imported.';
$string['importvideos_wizardstep2coursevideos'] = 'Import these videos';
$string['importvideos_wizardstep2coursevideosnone'] = 'There isn\'t any video in the selected course.';
$string['importvideos_wizardstep2coursevideosnoneselected'] = 'You have to check at least one video to be imported.';
$string['importvideos_wizardstep2heading'] = 'Select videos';
$string['importvideos_wizardstep2intro'] = 'Select the videos which you want to import from the source course.<br />You can pick from all videos which have been processed completely in the series of the source course.<br/><b>Notice: </b>All selected videos will be imported into a single series.';
$string['importvideos_wizardstep3aclheading'] = 'Summary';
$string['importvideos_wizardstep3aclintro'] = 'Please verify that the summary of the video import matches your expectations before you run the import.';
$string['importvideos_wizardstep3episodemoduleexplanation'] = 'There is at least one Opencast episode module in this course which points to a video in the course from where you are going to import the videos now. After the import, this will be cleaned up so that it points to imported video within this course.';
$string['importvideos_wizardstep3episodemodulelabel'] = 'Yes, clean up the Opencast episode module(s) related to this import';
$string['importvideos_wizardstep3episodemodulesubheading'] = 'Clean up existing Opencast episode module(s)';
$string['importvideos_wizardstep3heading'] = 'Handle Opencast modules in this course';
$string['importvideos_wizardstep3intro'] = 'There are existing Opencast modules in this course which relate to the videos which you are going to import. These modules will be handled after the video import.<br /><strong>If you are unsure if you need this handling, please accept the given defaults.</strong>';
$string['importvideos_wizardstep3seriesmoduleexplanation'] = 'There is at least one Opencast series module in this course which points to the course from where you are going to import the videos now. After the import, this will be cleaned up so that only the Opencast series module which shows all (pre-existing and to be imported) videos of this course remains.';
$string['importvideos_wizardstep3seriesmodulelabel'] = 'Yes, clean up the Opencast series modules related to this import';
$string['importvideos_wizardstep3seriesmodulesubheading'] = 'Clean up existing Opencast series module(s)';
$string['importvideos_wizardstep3skipintro'] = 'There aren\'t any existing Opencast modules in this course which relate to the videos which you are going to import.<br />Nothing needs to be handled, please continue to the next step.';
$string['importvideos_wizardstep4coursevideosnone'] = 'There wasn\'t any video selected for import.';
$string['importvideos_wizardstep4heading'] = 'Summary';
$string['importvideos_wizardstep4intro'] = 'Please verify that the summary of the video import matches your expectations before you run the import.<br/>The videos are imported into the default series.';
$string['importvideos_wizardstep4sourcecoursenone'] = 'There wasn\'t any source course selected for import.';
$string['importvideos_wizardstepbuttontitlecontinue'] = 'Continue';
$string['importvideos_wizardstepbuttontitlerunimport'] = 'Import videos and return to overview';
$string['ingest_endpoint_notfound'] = 'The ingets endpoint is not available, this has to be fix by the system administrator.';
$string['ingeststateaddingacls'] = 'Adding rights and permissions...';
$string['ingeststateaddingcatalog'] = 'Adding event catalog...';
$string['ingeststateaddingfirsttrack'] = 'Adding first track...';
$string['ingeststateaddingsecondtrack'] = 'Adding second track...';
$string['ingeststatecreatingmedispackage'] = 'Creating mediapackage...';
$string['ingeststateingesting'] = 'Ingesting...';
$string['ingestupload'] = 'Ingest upload';
$string['ingestuploaddesc'] = 'Use the Opencast ingest service for uploading videos.';
$string['initialvisibilitystatus'] = 'Initial visibility of the video';
$string['invalidacldata'] = 'Invalid acl data';
$string['invalidmetadatafield'] = 'Invalid metadata field found: {$a}';
$string['isdefault'] = 'Default';
$string['isvisible'] = 'Is visible to teachers';
$string['language'] = 'Language';
$string['legendalt'] = 'More details about all possible values of this column.';
$string['legenddeletingdesc'] = 'The video is being deleted, and it will be removed shortly.';
$string['legendocstatecapturingdesc'] = 'Live capturing in progress.';
$string['legendocstatefaileddesc'] = 'Something went wrong while processing this video, and it has failed. Please contact the support/administrator in order to resolve this issue.';
$string['legendocstateneedscuttingdesc'] = 'The Video requires further attention in order to finish the processing stage.';
$string['legendocstateprocessingdesc'] = 'The video is uploaded, and it is being processed by Opencast.';
$string['legendocstatesucceededdesc'] = 'The video has been processed and it is ready.';
$string['legendplanneddesc'] = 'The video has been scheduled for processing.';
$string['legendtitle'] = 'Details Table';
$string['legendvisibility_group'] = 'Group Visibility';
$string['legendvisibility_groupdesc'] = 'The video is visible to all student belonging to selected groups.';
$string['legendvisibility_hidden'] = 'Hidden';
$string['legendvisibility_hiddendesc'] = 'The video is not visible to any student.';
$string['legendvisibility_mixed'] = 'Invalid';
$string['legendvisibility_mixeddesc'] = 'The visibility of the video is in an invalid status.';
$string['legendvisibility_visible'] = 'Visible';
$string['legendvisibility_visibledesc'] = 'The video is visible to all students of the course.';
$string['license'] = 'License';
$string['limituploadjobs'] = 'Limit upload job by cron';
$string['limituploadjobsdesc'] = 'Limit the count of uploadjobs done by one cronjob. The cronjob can be scheduled here: {$a}';
$string['limitvideos'] = 'Number of videos';
$string['linkedinblock'] = 'Linked in block';
$string['liveupdate_fail_notification_message'] = 'Unable to perform live status update for the following event(s):<br> <ul><li>{$a}</li></ul>';
$string['liveupdate_reloadtimeout'] = 'Page reload timeout (in seconds)';
$string['liveupdate_reloadtimeout_desc'] = 'The timeout in seconds by which the page will be reloaded, when there is an updated status identified. If empty or less than 0, a default value of 3 seconds will be considered.<br>NOTE: Before reloading the page a teachers will be notified. The reload is important, so that every required backend process take place.';
$string['liveupdate_settingenabled'] = 'Enable live status update feature';
$string['liveupdate_settingenabled_desc'] = 'When enabled, uploading status and workflow processing states will be watched when they are in an ongoing process,<br>This is done by pulling the status information for those processes in a 1 second interval.';
$string['liveupdate_settingheader'] = 'Live Status Update';
$string['liveupdate_toast_notification'] = 'Event: ({$a->title}) is updated. The page will be reloaded in {$a->timeout} seconds.';
$string['loading'] = 'Loading...';
$string['location'] = 'Location';
$string['lticonsumerkey'] = 'Consumer key';
$string['lticonsumerkey_desc'] = 'LTI Consumer key for the integration of Opencast services that require authentication such as Studio or the editor.';
$string['lticonsumersecret'] = 'Consumer secret';
$string['lticonsumersecret_desc'] = 'LTI Consumer secret for the integration of Opencast services that require authentication.';
$string['ltimodule_instance'] = 'LTI Module Settings: {$a}';
$string['ltimodule_settings'] = 'LTI module features';
$string['maintenance_default_notification_message'] = '<h5>Opencast Maintenance Notice</h5><br>Please note that Opencast is currently undergoing maintenance. As a result, some or all features related to Opencast may be temporarily unavailable. Thank you for your understanding.';
$string['maintenance_exception_message'] = 'Opencast is currently undergoing maintenance. Interactions are temporarily disabled.';
$string['maintenanceheader'] = 'Maintenance';
$string['maintenanceheader_desc'] = 'In this section the maintenance mode can be configured with the following settings.<br />Depending on Opencast feature and settings availability, is it also possible to {$a}';
$string['maintenancemode'] = 'Maintenance mode';
$string['maintenancemode_btn'] = 'Sync Opencast Maintenance Mode';
$string['maintenancemode_btn_disabled'] = 'Required js modules are not loaded.';
$string['maintenancemode_datetime_expired_error'] = 'This field should not be in the past!';
$string['maintenancemode_datetime_ge_error'] = 'This field should be before "{$a}"';
$string['maintenancemode_datetime_le_error'] = 'This field should be after "{$a}"';
$string['maintenancemode_desc'] = 'Setting maintenance mode to avoid conflict during Opencast downtime.<br>If Read-Only mode is selected, only reading resources from Opencast will be allowed.';
$string['maintenancemode_disable'] = 'Disable';
$string['maintenancemode_enable'] = 'Enable';
$string['maintenancemode_end'] = 'Maintenance ends at';
$string['maintenancemode_end_desc'] = 'The end date and time of maintenance';
$string['maintenancemode_message'] = 'Maintenance Message';
$string['maintenancemode_message_desc'] = 'An error message to display during maintenance.';
$string['maintenancemode_modal_sync_confirmation_btn'] = 'Sync';
$string['maintenancemode_modal_sync_confirmation_text'] = 'Are you sure to sync the maintenance mode with Opencast? This will overwrite the current configuration.';
$string['maintenancemode_modal_sync_confirmation_title'] = 'Sync Opencast Maintenance Mode';
$string['maintenancemode_modal_sync_error_noinstance_message'] = 'Unable to find the Opencast instance id!';
$string['maintenancemode_modal_sync_error_title'] = 'Syncing Error';
$string['maintenancemode_modal_sync_failed'] = 'Maintenance Synchronization Unsuccessful!';
$string['maintenancemode_modal_sync_succeeded'] = 'Maintenance successfully synchronized. The page will refresh in 3 seconds to apply the updated changes.';
$string['maintenancemode_notiflevel'] = 'Notification Level';
$string['maintenancemode_notiflevel_desc'] = 'By this setting you can set the level of notification message which helps rendering it in different styles and color based on the level e.g. Error Level will print a notification in a red box.';
$string['maintenancemode_notiflevel_error'] = 'Error';
$string['maintenancemode_notiflevel_info'] = 'Information';
$string['maintenancemode_notiflevel_success'] = 'Success';
$string['maintenancemode_notiflevel_warning'] = 'Warning';
$string['maintenancemode_readonly'] = 'Read Only';
$string['maintenancemode_start'] = 'Maintenance starts at';
$string['maintenancemode_start_desc'] = 'The start date and time of maintenance';
$string['managedefaultredirectlinkwithexp'] = 'You can add default values for these metadata fields, using: ';
$string['managedefaultsforuser'] = 'Manage default values';
$string['managedefaultsforuser_desc'] = 'Here you can manage default values for metadata fields used to add videos as well create new series. If you add a default value for a field here, it will be automatically inserted into the field as predefined value (default) inside those mentioned pages.<br />NOTE: In case this page is empty, or you are looking for a field that does not exist here, please contact your system administrator and ask him/her to configure the metadata fields as defaultable.';
$string['manageseriesforcourse'] = 'Manage series';
$string['managetranscription_overwrite_info'] = 'Overwriting subtitles is only supported for those manually uploaded via this plugin. Subtitles that are auto-generated, uploaded using legacy methods, or added outside this plugin cannot be overwritten unless they share the same caption flavor and tags.';
$string['managetranscriptions'] = 'Manage Transcriptions';
$string['managetranscriptions_header'] = 'Manage Event\'s Transcriptions';
$string['massaction_invalidactionparam'] = 'Invalid action url path parameter';
$string['massaction_invaliddefaultactions'] = 'Invalid actions detected!';
$string['massaction_selectedvideos_list'] = 'You have selected the following video(s): <br><ul><li>{$a}</li></ul>';
$string['massaction_videostatusmismatched'] = 'Inappropriate video processing state!';
$string['maxseries'] = 'Maximum number of series';
$string['maxseriesdesc'] = 'Specifies how many series can be assigned to a course. Teachers won\'t be able to add/import more series if the maximum number is reached.';
$string['maxseriesreached'] = 'You cannot add another series to this course because the course contains already the maximum number of series.';
$string['maxseriesreachedimport'] = 'Currently, you cannot import another series because the course contains already the maximum number of series.';
$string['mediatype'] = 'Media Source';
$string['messageprovider:error'] = 'Processing error notification';
$string['messageprovider:opencasteventstatus_notification'] = 'Opencast event status notification';
$string['messageprovider:reportproblem_confirmation'] = 'Copy of reported problems for Opencast videos';
$string['metadata'] = 'Event Metadata';
$string['metadata_autocomplete_noselectionstring'] = 'No {$a} provided!';
$string['metadata_autocomplete_placeholder'] = 'Enter {$a}';
$string['metadatadesc'] = 'Here you can define which metadata fields can or have to be set when uploading videos to Opencast. You can drag-and-drop rows to reorder them defining the position of fields in the form.';
$string['metadataexplanation'] = 'When uploading existing video files to Opencast, you can set several metadata fields. These will be stored together with the video.';
$string['metadataseries'] = 'Series Metadata';
$string['metadataseriesdesc'] = 'Here you can define which metadata fields can or have to be set for creating Opencast series. You can drag-and-drop rows to reorder them defining the position of fields in the form.';
$string['metadataseriesupdatefailed'] = 'Updating the series metadata failed.';
$string['missingevent'] = 'Creation of event failed';
$string['missinggroup'] = 'Missing group in opencast';
$string['missingseries'] = 'Missing series in opencast';
$string['missingseriesassignment'] = 'Missing series assignment';
$string['morethanonedefaultserieserror'] = 'This course has more than one default series. Please contact your system administrator.';
$string['morevideos'] = 'More videos...';
$string['mstatearchived'] = 'Archived';
$string['mstatecreatingevent'] = 'Uploading...';
$string['mstatecreatinggroup'] = 'Creating Opencast Group...';
$string['mstatecreatingseries'] = 'Creating Opencast Series...';
$string['mstatereadytoupload'] = 'Ready for transfer';
$string['mstatetransferred'] = 'Transferred';
$string['mstateunknown'] = 'State unknown';
$string['mstateuploaded'] = 'Processing post-upload tasks...';
$string['name'] = 'Name';
$string['needphp55orhigher'] = 'PHP Version 5.5 or higher is needed';
$string['no_ingest_services'] = 'No available ingest nodes found.';
$string['noconnectedseries'] = 'No series is defined yet.';
$string['nomockhandler'] = 'The Opencast Api Object is unable to handle the responses for testing purposes.';
$string['noseriesfound'] = 'Unable to find any series.';
$string['noseriesid'] = 'Series ID is not defined yet.';
$string['notestingjsonresponses'] = 'The JSON responses are not set, please make sure to use api_testable::add_json_response before running and using the class.';
$string['nothingtodisplay'] = 'In this section, you see the videos which are uploaded to this course.<br />Currently, no videos have been uploaded to this course yet.';
$string['notificationcleanupimportedmodules_subj'] = 'Opencast imported modules cleanup task notification';
$string['notificationcleanupimportedmodulescleanupfailed_body'] = 'Cleanup job with workflow id: ({$a->workflowid}) for course {$a->coursefullname} (ID: {$a->courseid}) failed during the update of the episode activities and is removed.';
$string['notificationcleanupimportedmodulesexpired_body'] = 'Cleanup job with workflow id: ({$a->workflowid}) for course {$a->coursefullname} (ID: {$a->courseid}) has been removed, as we have waited for 5 days without success to get the duplicated episode ID from OC.';
$string['notificationcleanupimportedmodulesgeneralexception_body'] = 'Cleanup job with workflow id: ({$a->workflowid}) for course {$a->coursefullname} (ID: {$a->courseid}) failed and is removed. The exception message contains: {$a->exceptionmessage}';
$string['notificationcleanupimportedmodulesnoeposideid_body'] = 'Cleanup job with workflow id: ({$a->workflowid}) for course {$a->coursefullname} (ID: {$a->courseid}) was removed as the stored OC workflow does not exist or does not and will not hold a duplicated episode ID.';
$string['notificationeventstatus'] = 'Allow event process status notification';
$string['notificationeventstatus_body'] = 'The process status of the uploaded video: {$a->videotitle} (ID: {$a->videoidentifier}) in the course: {$a->coursefullname} (ID: {$a->courseid}) has been changed to: {$a->statusmessage}';
$string['notificationeventstatus_desc'] = 'This option allows the system to send notification about the status of the uploaded video from Opencast during the process to the users. This option only includes uploader of the video into the user list. To Notify all teachers of the course, the following setting should be enabled.<br />This feature is done through a scheduled task that is recommended to run every minute.';
$string['notificationeventstatus_subj'] = 'Opencast Event Status Notification';
$string['notificationeventstatusdeletion'] = 'Cleanup notification jobs after (Days)';
$string['notificationeventstatusdeletion_desc'] = 'This setting sets a deadline in day for the jobs that are not yet completed. After the deadline has reached, the job will be deleted despite its process state. <br />This features helps to remove the pending notification jobs from the list and it is done through a scheduled task that is recommended to run once a day.<br />NOTE: (zero) "0" value disables the setting.';
$string['notificationeventstatusteachers'] = 'Notify all course teachers about the event process status';
$string['notificationeventstatusteachers_desc'] = 'With this option, apart from the uploader of the video, all the teachers of the course where the video is uploaded from get notified about the Opencast processing status.';
$string['notifications_settings_header'] = 'Notifications';
$string['notificationuploadarchived_body'] = 'The upload job for the video titled "{$a->title}" in the course "{$a->coursefullname}" (ID: {$a->courseid}) has been archived due to reaching the limit of failed attempts. Your action is now required to either delete the job or manually put the job back into the queue. Please contact your system administrator to ensure the upload problem is resolved.';
$string['notificationuploadarchived_subj'] = 'Opencast Archived Event Upload Notification';
$string['notificationuploaduqeuestatus_body'] = 'Processing of this video: {$a->videotitle} in the course: {$a->coursefullname} (ID: {$a->courseid}) is queued, but has not yet started. The video is currently waiting behind {$a->waitingnum} other video(s) in the processing queue.';
$string['notificationuploaduqeuestatus_subj'] = 'Opencast Event Upload Notification';
$string['notpublished'] = 'Not published';
$string['notranscription'] = 'This video has no transcription yet.';
$string['nouserselected'] = 'You must select a user.';
$string['novideosavailable'] = 'No videos available';
$string['novisibilitychange'] = 'No changes are identified, please make sure everything is correct.';
$string['novisibilityrecordfound'] = 'Visibility record could not be found.';
$string['ocinstances'] = 'Opencast Instances';
$string['ocinstancesdesc'] = 'Defines a list of Opencast Instances to which the Opencast plugins can connect.';
$string['ocstatecapturing'] = 'Capturing';
$string['ocstatefailed'] = 'Failed';
$string['ocstateneedscutting'] = 'Needs cutting';
$string['ocstateprocessing'] = 'Processing';
$string['ocstatesucceeded'] = 'Succeeded';
$string['offerchunkuploadalternative'] = 'Offer filepicker as alternative';
$string['offerchunkuploadalternative_desc'] = 'If this option is enabled, a checkbox labeled as \'{$a}\' will be shown below the chunk upload widget. As soon as this checkbox is checked, the chunk upload widget is hidden and the Moodle default file picker is shown, giving access to all Moodle repositories.';
$string['opencast:addactivity'] = 'Add Opencast Video Provider activity to course';
$string['opencast:addactivityepisode'] = 'Add Opencast Video Provider activity for an episode to course';
$string['opencast:addinstance'] = 'Add a new opencast upload block';
$string['opencast:addlti'] = 'Add Opencast LTI series module to course';
$string['opencast:addltiepisode'] = 'Add Opencast LTI episode module to course';
$string['opencast:addvideo'] = 'Add a new video to opencast upload block';
$string['opencast:autocompleteteacherroles'] = 'Teacher roles to be extracted and provided in the autocomplete list';
$string['opencast:canchangeownerforallvideos'] = 'Be able to change the owner for all videos';
$string['opencast:createseriesforcourse'] = 'Create a new series in opencast for a moodle course';
$string['opencast:deleteevent'] = 'Finally delete a video (event) in opencast';
$string['opencast:directaccessvideolink'] = 'Direct access to video via shared link';
$string['opencast:downloadvideo'] = 'Download processed videos';
$string['opencast:externalapi'] = 'Access to Opencast API webservices';
$string['opencast:importseriesintocourse'] = 'Import an existing opencast series to a moodle course';
$string['opencast:instructor'] = 'Gives the role of an instructor in Opencast';
$string['opencast:learner'] = 'Gives the role of a learner in Opencast';
$string['opencast:manageseriesforcourse'] = 'Manage the opencast series of a moodle course: Access manageseries.php, unlink series from course and select default series.';
$string['opencast:manualimportsource'] = 'Manually import videos from this course';
$string['opencast:manualimporttarget'] = 'Manually import videos from other courses';
$string['opencast:myaddinstance'] = 'Add a new opencast upload block to Dashboard';
$string['opencast:sharedirectaccessvideolink'] = 'Share direct access link to video';
$string['opencast:startworkflow'] = 'Manually start workflows for videos';
$string['opencast:unassignevent'] = 'Unassign a video from the course, where the video was uploaded.';
$string['opencast:viewunpublishedvideos'] = 'View all the videos from opencast server, even when they are not published';
$string['opencast:viewusers'] = 'View all users so that the series/event owner can be changed in dashboard.';
$string['opencasteditorintegration'] = 'Opencast Editor integration';
$string['opencastseries'] = 'Opencast Series';
$string['opencaststudiobaseurl'] = 'Opencast Studio Base URL';
$string['opencaststudiobaseurl_desc'] = 'The base URL to be used to call Opencast studio. The base URL of the opencast instance is used if empty.';
$string['opencaststudiocustomsettingsfilename'] = 'Custom Studio settings filename';
$string['opencaststudiocustomsettingsfilename_desc'] = 'This custom settings filename will be appended to the query when redirecting to Studio, afterwards the Studio looks for this filename relative to its directory and read its settings from that file.<br><b>NOTE</b>: Requires Opencast 14.2 or later.';
$string['opencaststudiointegration'] = 'Opencast studio integration';
$string['opencaststudionewtab'] = 'Redirect to Studio in a new tab';
$string['opencaststudionewtab_desc'] = 'When enabled, studio opens in a new tab.';
$string['opencaststudioreturnbtnlabel'] = 'Label for Studio\'s return button';
$string['opencaststudioreturnbtnlabel_desc'] = 'This label works as a short description where the return link leads to. This label will be appended to the Studio return button text, when empty, moodle site name will be passed as label.';
$string['opencaststudioreturnurl'] = 'Custom Studio return endpoint URL';
$string['opencaststudioreturnurl_desc'] = 'When empty the return url redirects back to the same Moodle opencast block overview where the request comes from. A custom endpoint URL will then be passed to Studio as return url when configured, in this case, admin is able to use 2 placeholders including [OCINSTANCEID] and [COURSEID]. Please NOTE: the URL must be relative to wwwroot.';
$string['overview'] = 'Overview';
$string['ownedvideosoverview'] = 'Your videos';
$string['ownedvideosoverview_explanation'] = 'Here you can see all videos that belong to you but to whose series you do not have access.';
$string['owner'] = 'Owner';
$string['planned'] = 'Planned';
$string['pluginname'] = 'Opencast API';
$string['presentation'] = 'Presentation video';
$string['presentationdesc'] = 'Use the presentation video if you have a video file of a slide presentation recording or a screencast.';
$string['presentationfile'] = 'Presentation file';
$string['presenter'] = 'Presenter video';
$string['presenterdesc'] = 'Use the presenter video if you have a video file of a person speaking to an audience or a motion picture.';
$string['presenterfile'] = 'Presenter file';
$string['privacy:metadata'] = 'The Opencast API admin tool only provides API endpoints and general settings for the set of Opencast plugins. It stores which Opencast series belongs to which Moodle course, but it does not store any personal data.';
$string['privacy:metadata:core_files'] = 'The opencast block stores files (videos) which have been uploaded by the user.';
$string['privacy:metadata:opencast'] = 'The block interacts with an opencast instance and thus data needs to be exchanged.';
$string['privacy:metadata:opencast:file'] = 'The file which is selected is uploaded to opencast.';
$string['privacy:metadata:tool_opencast_uploadjob'] = 'Information about video uploads.';
$string['privacy:metadata:tool_opencast_uploadjob:courseid'] = 'ID of the course where the video is uploaded';
$string['privacy:metadata:tool_opencast_uploadjob:fileid'] = 'ID of the file/video which is uploaded';
$string['privacy:metadata:tool_opencast_uploadjob:opencasteventid'] = 'ID of the opencast event that was created during upload';
$string['privacy:metadata:tool_opencast_uploadjob:presentation_fileid'] = 'ID of the presentation video file';
$string['privacy:metadata:tool_opencast_uploadjob:presenter_fileid'] = 'ID of the presenter video file';
$string['privacy:metadata:tool_opencast_uploadjob:status'] = 'Status of upload process';
$string['privacy:metadata:tool_opencast_uploadjob:timecreated'] = 'The date the upload job was created.';
$string['privacy:metadata:tool_opencast_uploadjob:timemodified'] = 'The date the upload job was last modified.';
$string['privacy:metadata:tool_opencast_uploadjob:userid'] = 'ID of the user who uploaded the video';
$string['processattachment'] = 'Process attachment upload jobs';
$string['processdelete'] = 'Process delete jobs for Opencast';
$string['processdeletenotification'] = 'Process delete notification jobs';
$string['processepisodecleanup'] = 'Process Opencast Video Provider/LTI episode cleanup after course imports';
$string['processltimodulecleanup'] = 'Process Opencast Video LTI episode routine cleanup';
$string['processltimodulecleanup_error'] = 'Something went wrong during LTI module cleanup process: {$a}';
$string['processnotification'] = 'Process event status notification jobs after upload';
$string['processupload'] = 'Process upload';
$string['processvisibility'] = 'Process scheduled visibility change jobs';
$string['publisher'] = 'Publisher';
$string['publishtoengage'] = 'Publish to Engage';
$string['publishtoengagedesc'] = 'Select this option to publish the video after upload to engage player. Setup workflow must support this.';
$string['readonly_disabled_tooltip_text'] = 'Unable to set readonly option while it is set to be required.';
$string['recordvideo'] = 'Record video';
$string['reportproblem_email'] = 'This is an automatic notification of the Moodle Opencast plugin.<br>Somebody reported a problem with a video.<br><br><b>User: </b>{$a->username}<br><b>User email: </b>{$a->useremail}<br><b>Moodle course: </b><a href="{$a->courselink}">{$a->course}</a><br><b>Opencast series: </b>{$a->series} (Id: {$a->seriesid})<br><b>Opencast event id: </b>{$a->event} (Id: {$a->eventid})<br><b>Message:</b><br><hr>{$a->message}<hr>';
$string['reportproblem_failure'] = 'The email could not be sent. Please contact the support team manually.';
$string['reportproblem_modal_body'] = 'If you there is a problem with a video, you can report it to the support team.';
$string['reportproblem_modal_placeholder'] = 'Please explain the problem.';
$string['reportproblem_modal_required'] = 'Please enter a message.';
$string['reportproblem_modal_submit'] = 'Report problem';
$string['reportproblem_modal_title'] = 'Report a problem';
$string['reportproblem_notification'] = '#### This is a copy of the email sent to the support team. ####<br>';
$string['reportproblem_subject'] = 'Moodle Opencast plugin: Problem reported';
$string['reportproblem_success'] = 'The email was successfully sent to the support team.';
$string['restoreopencastvideos'] = 'Restore videos from Opencast instance {$a}';
$string['reuseexistingupload'] = 'Reuse existing uploads';
$string['reuseexistinguploaddesc'] = 'If activated, multiple videos with the same content hash are uploaded to opencast only once. This saves storage and processing power, but it might cause problems, when you use specific access policies based on opencast series.';
$string['rightsHolder'] = 'Rights';
$string['role_not_defined'] = 'The role is not defined in the ACL roles table.';
$string['role_not_permanent'] = 'The role is not defined as permanent in the ACL roles table.';
$string['role_not_user_related'] = 'The role does not contain a user placeholder and can thus not be used to identify users.';
$string['rolename'] = 'Role name';
$string['savedefaults'] = 'Save Defaults';
$string['scheduledvisibilitychangecreated'] = 'A new visibility change is scheduled';
$string['scheduledvisibilitychangedeleted'] = 'The scheduled visibility change has been deleted';
$string['scheduledvisibilitychangefailed'] = 'Scheduling a visibility change was not successful. You can schedule a new one or disable it to remove its task.';
$string['scheduledvisibilitychangeskipped'] = '<br>NOTE: The task to schedule visibility change is skipped and would not take place.';
$string['scheduledvisibilitychangeupdated'] = 'The scheduled visibility change is updated.';
$string['scheduledvisibilitycreatefailed'] = 'Unable to schedule a visibility change.';
$string['scheduledvisibilitydeletefailed'] = 'Unable to delete the scheduled visibility change.';
$string['scheduledvisibilityicontitle'] = 'Click here to alter the scheduled visibility change for this event';
$string['scheduledvisibilitystatus'] = 'Change video visibility to';
$string['scheduledvisibilitystatuserror'] = 'The scheduled visibiliy and inital visibility must be different.';
$string['scheduledvisibilitytime'] = 'Change video visibility on';
$string['scheduledvisibilitytimeerror'] = 'The scheduled date to change visibility must be set at least {$a} minutes after the current data and time.';
$string['scheduledvisibilitytimehi'] = 'Scheduling date';
$string['scheduledvisibilitytimehi_help'] = 'This date must be set in the near future and as recommended at least {$a} minutes after the current date time, however the faster your opencast server processes the video the nearer this date could be set.';
$string['scheduledvisibilityupdatefailed'] = 'Unable to update scheduled visibility change.';
$string['series'] = 'Series';
$string['series_already_exists'] = 'This course is already assigned to a series.';
$string['series_does_not_exist'] = 'The series assigned to this course is not valid. Please contact your Administrator!';
$string['series_does_not_exist_admin'] = 'The series with the identifier \'{$a}\' could not be retrieved from Opencast.';
$string['series_name_empty'] = 'Series name must not be empty.';
$string['series_not_found'] = 'The series {$a} could not be found in the opencast system.';
$string['series_used'] = 'Used in {$a} courses';
$string['seriescreated'] = 'Series was created.';
$string['seriesidnotvalid'] = 'The series {$a} does not exist.';
$string['seriesidsaved'] = 'The series ID was saved.';
$string['seriesidunset'] = 'The series ID was removed.';
$string['serieslinkedinblock'] = 'Series linked in block';
$string['seriesname'] = 'Series name';
$string['seriesnamedesc'] = 'Series to which the video is added. You can use placeholders which are automatically replaced (<a target="_blank" href="https://moodle.docs.opencast.org/#block/general_settings/#placeholders">list of placeholders</a>).';
$string['seriesnotcreated'] = 'Series could not be created.';
$string['seriesonedefault'] = 'There must be exactly one default series.';
$string['seriesoverview'] = 'Series overview';
$string['seriesoverviewexplanation'] = 'Here you can see all series that are used in any course where you have the permission to manage videos.<br>Series might be manageable by the block in the course and/or might be provided as activity to the students.';
$string['seriesoverviewof'] = 'Series overview of {$a} instance';
$string['serverconnectionerror'] = 'There was a problem with the connection to the Opencast server. Please check your Opencast API credentials and your network settings.';
$string['servicename'] = 'Opencast';
$string['setdefaultseries'] = 'Do you really want to use this series as new default series?';
$string['setdefaultseries_heading'] = 'Set default series';
$string['setdefaultseriesfailed'] = 'Changing the default series failed. Please try again later or contact an administrator.';
$string['setdefaultseriessucceeded'] = 'The default series has been successfully changed.';
$string['setting_permanent'] = 'Is permanent';
$string['settings'] = 'Opencast Videos';
$string['settings_page'] = 'Settings';
$string['settings_page_url'] = '{$a} Settings';
$string['shared_settings'] = 'Shared settings';
$string['showvideos'] = 'Show videos';
$string['source'] = 'Source';
$string['space_catalogname'] = 'This field must not contain space';
$string['startDate'] = 'Date';
$string['startTime'] = 'Time';
$string['startworkflow'] = 'Start workflow';
$string['startworkflow_modal_body'] = 'Choose the workflow you want to start.';
$string['startworkflow_modal_configpanel_title'] = 'Workflow Configuration Panel';
$string['startworkflow_modal_description_title'] = 'Workflow Description';
$string['subjects'] = 'Subjects';
$string['submit'] = 'Save changes';
$string['support_setting'] = 'Support email';
$string['support_setting_notset'] = 'Support email is not set. Please contact the administrator and resubmit the report.';
$string['support_settingdesc'] = 'Email address to which reports are sent if users report problems with videos.';
$string['swprivacynotice_settingheader'] = 'Workflows Privacy Notice';
$string['swprivacynotice_settinginfotext'] = 'Workflow Privacy Notice Info Text';
$string['swprivacynotice_settinginfotext_desc'] = 'This input is used to provide information about privacy notice for workflows in start workflow dialog.<br><strong>NOTE:</strong> If empty, no notice will be displayed.';
$string['swprivacynotice_settingtitle'] = 'Workflow Privacy Notice Title';
$string['swprivacynotice_settingtitle_desc'] = 'A title to be displayed in start workflow dialog. It is intended to be configurable in order to be adjusted by the users. When empty, default string is used.';
$string['swprivacynotice_settingwfds'] = 'Workflows Definition List';
$string['swprivacynotice_settingwfds_desc'] = 'A comma separated list of workflow definitions, by which the privacy notice is displayed. When empty, the privacy notice will be displayed for all workflows.';
$string['swprivacynoticedefaulttitle'] = 'Privacy Notice';
$string['termsofuse'] = 'Terms of use';
$string['termsofuse_accept'] = 'I have read and agree to the {$a}.';
$string['termsofuse_accept_toggle'] = 'terms of use';
$string['termsofuse_desc'] = 'If you enter some text, a checkbox with the terms of use will appear on the "Video upload" page. The users must accept the entered terms of use before they can upload the video.';
$string['testtooldisabledbuttontitle'] = 'Unable to conduct the connection test due to unloaded js modules.';
$string['testtoolheader'] = 'Connection test tool';
$string['testtoolheaderdesc'] = 'To test the current Opencast API settings use: {$a}';
$string['testtoolurl'] = 'Connection Test Tool';
$string['timeout'] = 'Overall API request execution timeout';
$string['timeoutdesc'] = 'Configure the time in milliseconds each API request to Opencast may take. If Opencast does not finish answering the request within this time, the request is aborted.';
$string['title'] = 'Title';
$string['tool_requirement_not_fulfilled'] = 'The required version of tool_opencast is not installed.';
$string['transcription_language_confirm_delete'] = 'Are you sure you want to delete this language option pair?';
$string['transcription_language_delete'] = 'Delete language\'s option pair';
$string['transcription_language_key'] = 'Language key';
$string['transcription_language_value'] = 'Language name';
$string['transcriptionaction_thead'] = 'Actions';
$string['transcriptionaddnewbtn'] = 'Add more transcription set';
$string['transcriptionaddnewlanguage'] = 'Add new language';
$string['transcriptionauto'] = 'Auto';
$string['transcriptiondeletebtn'] = 'Delete transcription set';
$string['transcriptiondeletionfailed'] = 'Failed to delete transcription';
$string['transcriptiondeletionsucceeded'] = 'Transcription deleted successfully.';
$string['transcriptionemptylanguageoption'] = 'Please select a language';
$string['transcriptionfileextensions'] = 'Allowed transcription file extensions';
$string['transcriptionfileextensions_desc'] = 'Specifies a comma-separated list of allowed file extensions for transcription uploads (extensions must exist in Moodle\'s <a href="{$a}">File types</a> list). If left blank, all file types categorized as \'HTML track files\' will be allowed (refer to <a href="{$a}">File types</a> for more information).';
$string['transcriptionfilefield'] = 'Transcription for ({$a})';
$string['transcriptionheader'] = 'Upload Transcription Files';
$string['transcriptionheaderexplanation'] = 'In this section you are able to upload a transcription file for each provided language, with specified file extension, which then will be uploaded alongside the video and be processed accordingly to provide the (speech to text) capability.';
$string['transcriptionlanguage_thead'] = 'Language';
$string['transcriptionlanguagefield'] = 'Transcription Language';
$string['transcriptionlanguages'] = 'Transcription Supported Languages';
$string['transcriptionlanguages_desc'] = 'Defines the list of supported transcription languages. Each language will appear as a separate upload block when uploading transcriptions.<br><strong>NOTE:</strong> If no languages are configured, the transcription upload feature will be disabled.<br>The format should be key-value pairs, where keys are used by Opencast and names are human-readable language labels.<br><b>(Multi-Language filters)</b> In order for each language name to get translated using filters such as <a target="_blank" href="https://moodle.org/plugins/filter_multilang2">Multi-Language Content (v2)</a>, each language name should include the appropriate placeholders, defined by that filter i.e. "{mlang en}English{mlang}{mlang de}Deutsch{mlang}"';
$string['transcriptionltidownloadcompleted'] = 'The transcription is successfully downloaded. {$a}';
$string['transcriptionmanagementdisabled'] = 'Unfortunately, transcription management is currently unavailable.';
$string['transcriptionmanual'] = 'Manual';
$string['transcriptionmanuallegacy'] = 'Manual (Legacy)';
$string['transcriptionnothingtoupload'] = 'No files were found to upload.';
$string['transcriptionreturntomanagement'] = 'Go back to transcription management page';
$string['transcriptionsettingsenablemanage'] = 'Enable Transcription Management';
$string['transcriptionsettingsenablemanage_desc'] = 'Enables teachers to manage transcriptions for each video individually. This includes uploading new files, deleting existing ones, and overwriting current transcriptions. A dedicated action menu item will be added to each video entry on the overview page, allowing teachers to manage associated transcription files';
$string['transcriptionsettingsenableupload'] = 'Enable Transcription Upload';
$string['transcriptionsettingsenableupload_desc'] = 'Allows teachers to upload transcription files along with video content in the upload form. Once enabled, an additional section will appear where teachers can attach transcription files for the selected languages.';
$string['transcriptionsettingsheader'] = 'Settings for Transcription';
$string['transcriptionunknownlanguage'] = 'Unknown Language: {$a}';
$string['transcriptionuploadfailedall'] = 'All Transcription uploads failed!';
$string['transcriptionuploadsuccessedall'] = 'All Transcription files has been successfully uploaded.';
$string['transcriptionworkflow'] = 'Workflow for transcription (speech to text)';
$string['transcriptionworkflow_desc'] = 'Specifies the Opencast workflow to be triggered when transcription (subtitle) files are uploaded with a video or separately via "add new transcription". If not defined, the default workflow "publish" will be used.';
$string['type'] = 'Media Type';
$string['unabletoaddnewtranscription'] = 'Unable to add new transcription';
$string['unabletodeletetranscription'] = 'Unable to delete transcription';
$string['unabletodownloadtranscription'] = 'Unable to download transcription';
$string['unabletomanagetranscriptions'] = 'Due to an active processing state or an ongoing workflow, managing the event\'s transcriptions is not possible at the moment.';
$string['unarchiveuploadjob'] = 'Unarchive video upload job';
$string['unarchiveuploadjobbtntitle'] = 'Unarchive upload job';
$string['unarchiveuploadjobconfirmbtn_save'] = 'Proceed';
$string['unarchiveuploadjobconfirmtext'] = 'You are about to unarchive the video upload job. Please ensure that the upload issue has been resolved. Would you like to proceed?';
$string['unexpected_api_response'] = 'Unexpected API response.';
$string['unlimiteduploadfilesize'] = 'Unlimited Video Size';
$string['unlimiteduploadfilesize_desc'] = 'If enabled, there is no size limit to the video being upload. If you want to apply the size limit, make sure to diable this option, then you will be offered to enter the video size limit in respected setting.';
$string['updatemetadata'] = 'Update metadata for this event';
$string['updatemetadata_massaction'] = 'Update metadata for selected video(s)';
$string['updatemetadata_massaction_emptyformsubmission'] = 'At least one field must be enabled.';
$string['updatemetadata_massaction_notification_failed'] = 'Unable to update metadata for the following video(s): <br><ul><li>{$a}</li></ul>';
$string['updatemetadata_massaction_notification_nochange'] = 'No changes were made regarding metadata update for the selected video(s).';
$string['updatemetadata_massaction_notification_succeeded'] = 'The metadata of the selected video(s) has been successfully updated: <br><ul><li>{$a}</li></ul>';
$string['updatemetadata_massaction_videoerror'] = 'Update metadata for the video ({$a->title}) is not possible at the moment due to: {$a->error}';
$string['updatemetadata_short'] = 'Update metadata';
$string['updatemetadatafailed'] = 'The metadata could not be saved.';
$string['updatemetadatasaved'] = 'Metadata is saved.';
$string['upload'] = 'File Upload';
$string['uploadexplanation'] = 'You have the option to upload a presenter video file and / or a presentation video file.<br />Most likely you will only upload one file, but Opencast is also capable of dealing with two videos at once which will be combined in a media package.';
$string['uploadfileextensions'] = 'Allowed file extensions';
$string['uploadfileextensionsdesc'] = 'Comma separated list of allowed video file extensions (extensions must exist in Moodle\'s <a href="{$a}">File types</a> list). If left blank all extensions with type group \'video\' are allowed (again see <a href="{$a}">File types</a>).';
$string['uploadfilelimit'] = 'Video size limit';
$string['uploadfilelimitdesc'] = 'Limit the file size of uploaded videos through the chunkupload.';
$string['uploadfilesizelimited'] = 'Limited video size';
$string['uploadfilesizelimitmode'] = 'Video file size limitation mode';
$string['uploadfilesizelimitmode_desc'] = 'Use this option to specify whether to limit the video file size. If "Limited video size" is selected, you can define the video size limit in the corresponding setting.';
$string['uploadfilesizeunlimited'] = 'Unlimited video Size';
$string['uploadingeventfailed'] = 'Creating of event failed';
$string['uploadjobnotfound'] = 'The video upload job could not be found.';
$string['uploadjobssaved'] = 'Video upload successful.<br />The video is scheduled to be transferred to Opencast now. You do not need to wait on this page for this transfer to finish.';
$string['uploadprocessingexplanation'] = 'These video files will be processed in Opencast and then made available in this course.';
$string['uploadqueuetoopencast'] = 'Videos scheduled to be transferred to Opencast';
$string['uploadqueuetoopencastexplanation'] = 'In this section, you see the videos which have been uploaded to this Moodle course by you or some other user. These videos are scheduled to be transferred to Opencast now.<br />The transfer is happening automatically on the Moodle server in the background. You do not need to wait on this page for this transfer to finish.';
$string['uploadrecordvideos'] = 'Upload or record videos';
$string['uploadrecordvideosexplanation'] = 'In this section, you can upload existing video files to Moodle. Additionally, you can record video files directly with Opencast Studio.';
$string['uploadsettings'] = 'Settings for the chunkuploader';
$string['uploadtimeout'] = 'Moodle to Opencast upload timeout';
$string['uploadtimeoutdesc'] = 'Configure the time in seconds a single video upload may take during the background uploading task.';
$string['uploadtranscritpion'] = 'Upload transcription set';
$string['uploadvideos'] = 'Upload videos';
$string['uploadvideosexplanation'] = 'In this section, you can upload existing video files to Moodle.';
$string['uploadworkflow'] = 'Workflow to start after upload';
$string['uploadworkflowdesc'] = 'Setup the unique shortname of the workflow, that should be started after succesfully uploading a video file to opencast. If left blank the standard workflow (ng-schedule-and-upload) will be used. Ask for additional workflows that may have been created by the opencast administrator.';
$string['usedefaultfilepicker'] = 'Use Moodle default file picker to access all repositories';
$string['userisntowner'] = 'Only the owner of the video can change the ownership.';
$string['video'] = 'Video';
$string['video_already_uploaded'] = 'Video already uploaded';
$string['video_not_accessible'] = 'This video was not published in the direct access channel.';
$string['video_not_downloadable'] = 'This video was not published in the download channel.';
$string['video_notallowed'] = 'The video is not part of the course series.';
$string['video_retrieval_failed'] = 'Video could not be retrieved. Please check the connection to the Opencast server.';
$string['videodraftdeletionsucceeded'] = 'The video is deleted successfully';
$string['videodraftnotdeletable'] = 'The video cannot be deleted anymore before the transfer to Opencast as the processing status is already "{$a}"';
$string['videodraftnotfound'] = 'The video to be deleted before the transfer to Opencast was not found.';
$string['videoeditor_short'] = 'Video Editor';
$string['videoeditorinvalidconfig'] = 'Currently, it is not possible to use Opencast Editor in order to edit the event.';
$string['videonotfound'] = 'Video not found';
$string['videosavailable'] = 'Videos available in this course';
$string['videosoverviewexplanation'] = 'Here you can see in which courses the videos are provided as activity to the students.<br>The second column shows the activities of the courses where the series is managed by the Opencast block. The third column shows courses where the video is embedded without the series being managed by the block.';
$string['videostable_massaction_changevisibility'] = 'Change Visibility';
$string['videostable_massaction_changevisibility_modal_body'] = 'Are you sure you want to perform visibility change on the following selected videos:<br> <ul><li>{$a}</li></ul>';
$string['videostable_massaction_changevisibility_modal_title'] = 'Change Visibility for selected videos';
$string['videostable_massaction_delete'] = 'Delete';
$string['videostable_massaction_delete_modal_body'] = 'Are you sure you want to delete the following selected videos:<br> <ul><li>{$a}</li></ul>';
$string['videostable_massaction_delete_modal_title'] = 'Delete selected videos';
$string['videostable_massaction_startworkflow'] = 'Start workflow';
$string['videostable_massaction_startworkflow_info'] = 'You have selected the following videos to start the workflow on:';
$string['videostable_massaction_startworkflow_modal_body'] = 'You have selected the following videos to start workflow for:<br> <ul><li>{$a}</li></ul>Make sure the selected videos are correct and proceed.';
$string['videostable_massaction_startworkflow_modal_title'] = 'Start workflow for selected videos';
$string['videostable_massaction_updatemetadata'] = 'Update metadata';
$string['videostable_massaction_updatemetadata_modal_body'] = 'Are you sure you want to update the metadata of the following selected videos:<br> <ul><li>{$a}</li></ul>';
$string['videostable_massaction_updatemetadata_modal_title'] = 'Update metadata of selected videos';
$string['videostablemassaction_disabled_item'] = 'Not selectable';
$string['videostablemassaction_label'] = 'With Selected Videos...';
$string['videostablemassaction_notification_reasoning'] = '<strong>{$a->name}</strong>: {$a->reason}';
$string['videostoupload'] = 'Videos to upload to opencast';
$string['viewviedeosnotallowed'] = 'You are not allowed to view the videos in this series.';
$string['visibility'] = 'Visibility of the video';
$string['visibility_group'] = 'Allow all students belonging to selected groups to access the video';
$string['visibility_group_massaction'] = 'Allow all students belonging to selected groups to access the selected video(s)';
$string['visibility_hide'] = 'Prevent any student from accessing the video';
$string['visibility_hide_massaction'] = 'Prevent any student from accessing the selected video(s)';
$string['visibility_massaction'] = 'Visibility of the selected video(s)';
$string['visibility_show'] = 'Allow all students of the course to access the video';
$string['visibility_show_massaction'] = 'Allow all students of the course to access the selected video(s)';
$string['visibilityheader'] = 'Event Visibility';
$string['visibilityheaderexplanation'] = 'You are able to set the initial visibility status of the video before upload, as well as scheduling a visibility change when it is configured to do so.';
$string['workflow_invalid'] = 'This workflow does not exist or is not enabled.';
$string['workflow_not_existing'] = 'This workflow does not exist in Opencast.';
$string['workflow_opencast_invalid'] = 'This workflow does not exist in Opencast or is restricted. Please contact the administrator.';
$string['workflow_settings_opencast'] = 'Workflow Settings';
$string['workflow_started_failure'] = 'Starting workflow failed.';
$string['workflow_started_massaction_nochange'] = 'Unable to start workflow due to missing video(s).';
$string['workflow_started_massaction_notification_failed'] = 'Unable to start workflow for the following selected videos:<br><ul><li>{$a}</li></ul>';
$string['workflow_started_massaction_notification_success'] = 'Workflow has been successfully started for the selected videos:<br><ul><li>{$a}</li></ul>';
$string['workflow_started_success'] = 'Workflow successfully started.';
$string['workflownotdefined'] = 'The workflow for updating metadata is not defined.';
$string['workflowrolesdesc'] = 'This workflow is triggered when updating event metadata or deleting/adding nonpermanent ACL rules. If not set, it will not be possible to change the visibility of uploaded videos through the block.';
$string['workflowrolesname'] = 'Workflow for updating metadata';
$string['workflowtags_setting'] = 'Workflow tags';
$string['workflowtags_settingdesc'] = 'Comma separated list of tags for Opencast workflows that can be configured by the admin and manually started by teachers.';
$string['worklowisrunning'] = 'A workflow is running. You cannot change the visibility at the moment.';
$string['wrongmimetypedetected'] = 'Wrong mimetype was detected, while trying to upload {$a->filename} from course {$a->coursename}. You can only upload video files!';
