define("mod_trainingevaluation/manage_sections",["exports","core/modal_factory","core/modal_events","core/str","core/ajax","core/notification","core/templates"],(function(_exports,_modal_factory,_modal_events,_str,_ajax,_notification,_templates){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * JavaScript for managing sections in training evaluation.
   *
   * @module      mod_trainingevaluation/manage_sections
   * @copyright   Pelorus Labs
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0,_modal_factory=_interopRequireDefault(_modal_factory),_modal_events=_interopRequireDefault(_modal_events),_ajax=_interopRequireDefault(_ajax),_notification=_interopRequireDefault(_notification),_templates=_interopRequireDefault(_templates);_exports.init=trainingevaluationId=>{initAddSectionButton(trainingevaluationId),initAddSubsectionButtons(trainingevaluationId),initAddItemButtons(trainingevaluationId),initEditSectionButtons(trainingevaluationId),initEditItemButtons(trainingevaluationId),initDeleteSectionButtons(trainingevaluationId),initDeleteItemButtons(trainingevaluationId),initReorderSectionButtons(),initReorderItemButtons()};const initAddSectionButton=trainingevaluationId=>{const addSectionButton=document.getElementById("mod-trainingevaluation-add-section-btn");addSectionButton&&addSectionButton.addEventListener("click",(()=>{showSectionModal(trainingevaluationId)}))},initAddSubsectionButtons=trainingevaluationId=>{document.querySelectorAll(".mod-trainingevaluation-add-section-btn").forEach((button=>{button.addEventListener("click",(()=>{const parentSectionId=button.dataset.parentSectionId;showSectionModal(trainingevaluationId,parentSectionId)}))}))},initAddItemButtons=trainingevaluationId=>{document.querySelectorAll(".mod-trainingevaluation-add-item-btn").forEach((button=>{button.addEventListener("click",(()=>{const sectionId=button.dataset.sectionId;showItemModal(trainingevaluationId,sectionId)}))}))},initEditItemButtons=trainingevaluationId=>{document.querySelectorAll(".mod-trainingevaluation-edit-item-btn").forEach((button=>{button.addEventListener("click",(e=>{e.stopPropagation();const itemId=parseInt(button.dataset.itemId);showEditItemModal(trainingevaluationId,itemId)}))}))},showEditItemModal=async(trainingevaluationId,itemId)=>{try{const itemData=await getItemData(itemId),title=await(0,_str.get_string)("edititem","trainingevaluation"),{html:html,js:js}=await renderTypeConfig(itemData.type,itemData.config||{}),modal=await _modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL,title:title,body:_templates.default.render("mod_trainingevaluation/edit_item_modal",{name:itemData.name,description:itemData.description,isrequired:itemData.isrequired,typeConfigHtml:html})});modal.getRoot().on(_modal_events.default.bodyRendered,(()=>{js&&_templates.default.runTemplateJS(js)})),modal.getRoot().on(_modal_events.default.save,(e=>{e.preventDefault();const itemName=modal.getRoot().find("#edititemname").val().trim();if(!itemName)return void _notification.default.alert("",(0,_str.get_string)("enteritemname","trainingevaluation"));const itemDescription=modal.getRoot().find("#edititemdescription").val().trim(),itemIsRequired=modal.getRoot().find("#edititemisrequired").is(":checked"),config=collectTypeConfig(itemData.type,modal.getRoot());updateItem(itemId,itemName,itemDescription,itemIsRequired,null,config).then((()=>{window.location.reload()})).catch((error=>{_notification.default.exception(error)}))})),modal.show()}catch(error){_notification.default.exception(error)}},renderTypeConfig=async(itemType,config)=>{const templateName="mod_trainingevaluation/item_config_".concat(itemType);try{const{html:html,js:js}=await _templates.default.renderForPromise(templateName,config);return{html:html,js:js}}catch(error){return""}},collectTypeConfig=(itemType,modalRoot)=>{const config={};switch(itemType){case"textinput":{const maxLength=modalRoot.find("#editmaxlength").val(),rows=modalRoot.find("#editrows").val(),placeholdertext=modalRoot.find("#editplaceholdertext").val();maxLength&&(config.maxlength=maxLength),placeholdertext&&(config.placeholdertext=placeholdertext),rows&&(config.rows=rows);break}case"selectmenu":{const options=modalRoot.find("#editselectmenuoptions").val();options&&(config.options=JSON.parse(options));break}case"fileupload":{const filetypes=modalRoot.find("#editfiletypes").val();filetypes&&(config.filetypes=filetypes);break}}return config},updateItem=async function(id,name,description,isrequired){let movement=arguments.length>4&&void 0!==arguments[4]?arguments[4]:null,config=arguments.length>5&&void 0!==arguments[5]?arguments[5]:null;try{return(await _ajax.default.call([{methodname:"mod_trainingevaluation_update_item",args:{id:id,name:name,description:description,isrequired:isrequired,movement:movement,config:null!==config?JSON.stringify(config):null}}]))[0]}catch(error){throw _notification.default.exception(error),error}},initEditSectionButtons=trainingevaluationId=>{document.querySelectorAll(".mod-trainingevaluation-edit-section-btn").forEach((button=>{button.addEventListener("click",(e=>{e.stopPropagation();const sectionId=parseInt(button.dataset.sectionId);showEditSectionModal(trainingevaluationId,sectionId)}))}))},showEditSectionModal=async(trainingevaluationId,sectionId)=>{try{const sectionData=await getSectionData(sectionId),title=await(0,_str.get_string)("editsection","trainingevaluation"),modal=await _modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL,title:title,body:_templates.default.render("mod_trainingevaluation/edit_section_modal",{sectionName:sectionData.name})});modal.getRoot().on(_modal_events.default.shown,(()=>{const sectionNameInput=modal.getRoot().find("#editsectionname");sectionNameInput.val(sectionData.name),sectionNameInput.focus()})),modal.getRoot().on(_modal_events.default.save,(e=>{e.preventDefault();const sectionName=modal.getRoot().find("#editsectionname").val().trim();sectionName?updateSection(sectionId,sectionName).then((()=>{modal.destroy(),updateSectionNameInDOM(sectionId,sectionName)})).catch((error=>{_notification.default.exception(error)})):_notification.default.alert("","Please enter a section name")})),modal.show()}catch(error){_notification.default.exception(error)}},initDeleteSectionButtons=trainingevaluationId=>{document.querySelectorAll(".mod-trainingevaluation-delete-section-btn").forEach((button=>{button.addEventListener("click",(e=>{e.stopPropagation();const sectionId=parseInt(button.dataset.sectionId);showDeleteSectionModal(trainingevaluationId,sectionId)}))}))},showDeleteSectionModal=async(trainingevaluationId,sectionId)=>{try{const sectionData=await getSectionData(sectionId),title=await(0,_str.get_string)("deletesection","trainingevaluation"),modal=await _modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL,title:title,body:_templates.default.render("mod_trainingevaluation/delete_section_modal",{sectionName:sectionData.name})});modal.getRoot().on(_modal_events.default.save,(e=>{e.preventDefault(),deleteSection(sectionId).then((()=>{window.location.reload()})).catch((error=>{_notification.default.exception(error)}))})),modal.show()}catch(error){_notification.default.exception(error)}},initDeleteItemButtons=trainingevaluationId=>{document.querySelectorAll(".mod-trainingevaluation-delete-item-btn").forEach((button=>{button.addEventListener("click",(e=>{e.stopPropagation();const itemId=parseInt(button.dataset.itemId);showDeleteItemModal(trainingevaluationId,itemId)}))}))},showDeleteItemModal=async(trainingevaluationId,itemId)=>{try{const itemData=await getItemData(itemId),title=await(0,_str.get_string)("deleteitem","trainingevaluation"),modal=await _modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL,title:title,body:_templates.default.render("mod_trainingevaluation/delete_item_modal",{itemName:itemData.name})});modal.getRoot().on(_modal_events.default.save,(e=>{e.preventDefault(),deleteItem(itemId).then((()=>{window.location.reload()})).catch((error=>{_notification.default.exception(error)}))})),modal.show()}catch(error){_notification.default.exception(error)}},initReorderSectionButtons=()=>{document.querySelectorAll(".mod-trainingevaluation-up-section-btn").forEach((button=>{button.addEventListener("click",(()=>{const sectionId=parseInt(button.dataset.sectionId);updateSection(sectionId,null,"up").then((()=>{window.location.reload()})).catch((error=>{_notification.default.exception(error)}))}))})),document.querySelectorAll(".mod-trainingevaluation-down-section-btn").forEach((button=>{button.addEventListener("click",(()=>{const sectionId=parseInt(button.dataset.sectionId);updateSection(sectionId,null,"down").then((()=>{window.location.reload()})).catch((error=>{_notification.default.exception(error)}))}))}))},initReorderItemButtons=()=>{document.querySelectorAll(".mod-trainingevaluation-up-item-btn").forEach((button=>{button.addEventListener("click",(()=>{const itemId=parseInt(button.dataset.itemId);updateItem(itemId,null,null,null,"up").then((()=>{window.location.reload()})).catch((error=>{_notification.default.exception(error)}))}))})),document.querySelectorAll(".mod-trainingevaluation-down-item-btn").forEach((button=>{button.addEventListener("click",(()=>{const itemId=parseInt(button.dataset.itemId);updateItem(itemId,null,null,null,"down").then((()=>{window.location.reload()})).catch((error=>{_notification.default.exception(error)}))}))}))},getItemData=async itemId=>{try{const response=await _ajax.default.call([{methodname:"mod_trainingevaluation_get_item",args:{id:itemId}}])[0];return null!==response.config&&(response.config=JSON.parse(response.config)),response}catch(error){throw _notification.default.exception(error),error}},deleteItem=itemId=>_ajax.default.call([{methodname:"mod_trainingevaluation_delete_item",args:{id:itemId}}])[0],getSectionData=async sectionId=>{try{return(await _ajax.default.call([{methodname:"mod_trainingevaluation_get_section",args:{id:sectionId}}]))[0]}catch(error){throw _notification.default.exception(error),error}},updateSection=async function(sectionId,sectionName){let movement=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null;try{return(await _ajax.default.call([{methodname:"mod_trainingevaluation_update_section",args:{id:sectionId,name:sectionName,movement:movement}}]))[0]}catch(error){throw _notification.default.exception(error),error}},updateSectionNameInDOM=(sectionId,sectionName)=>{const sectionElement=document.querySelector('.mod-trainingevaluation-section[data-section-id="'.concat(sectionId,'"]'));if(sectionElement){const titleElement=sectionElement.querySelector(".mod-trainingevaluation-section-title");titleElement&&(titleElement.textContent=sectionName)}},deleteSection=sectionId=>_ajax.default.call([{methodname:"mod_trainingevaluation_delete_section",args:{id:sectionId}}])[0],showSectionModal=async function(trainingevaluationId){let parentSectionId=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null;try{const titleKey=parentSectionId?"addsubsection":"addsection",title=await(0,_str.get_string)(titleKey,"trainingevaluation"),modal=await _modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL,title:title,body:_templates.default.render("mod_trainingevaluation/add_section_modal",{isSubsection:!!parentSectionId})});modal.getRoot().on(_modal_events.default.save,(e=>{e.preventDefault();const sectionName=modal.getRoot().find("#newsectionname").val().trim();sectionName?saveNewSection(trainingevaluationId,sectionName,parentSectionId).then((()=>{window.location.reload()})).catch((error=>{_notification.default.exception(error)})):_notification.default.alert((0,_str.get_string)("error","core"),(0,_str.get_string)("sectionnamerequired","trainingevaluation"))})),modal.show()}catch(error){_notification.default.exception(error)}},showItemModal=async(trainingevaluationId,sectionId)=>{try{const modal=await _modal_factory.default.create({type:_modal_factory.default.types.SAVE_CANCEL,title:await(0,_str.get_string)("additem","trainingevaluation"),body:_templates.default.render("mod_trainingevaluation/add_item_modal",{})});modal.getRoot().on(_modal_events.default.save,(e=>{e.preventDefault();const itemName=modal.getRoot().find("#newitemname").val().trim(),itemDescription=modal.getRoot().find("#newitemdescription").val().trim(),itemIsRequired=modal.getRoot().find("#newitemisrequired").is(":checked"),itemType=modal.getRoot().find("#newitemtype").val().trim();itemName&&itemType?saveNewItem(trainingevaluationId,sectionId,itemName,itemDescription,itemIsRequired,itemType).then((()=>{window.location.reload()})).catch((error=>{_notification.default.exception(error)})):_notification.default.alert((0,_str.get_string)("error","core"),(0,_str.get_string)("itemnamerequired","trainingevaluation"))})),modal.show()}catch(error){_notification.default.exception(error)}},saveNewSection=function(trainingevaluationId,sectionName){let parentSectionId=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null;return _ajax.default.call([{methodname:"mod_trainingevaluation_add_section",args:{wtid:trainingevaluationId,name:sectionName,parentsection:parentSectionId}}])[0]},saveNewItem=(trainingevaluationId,sectionId,name,description,isrequired,type)=>_ajax.default.call([{methodname:"mod_trainingevaluation_add_item",args:{wtid:trainingevaluationId,sectionid:sectionId,name:name,description:description,isrequired:isrequired,type:type}}])[0]}));

//# sourceMappingURL=manage_sections.min.js.map