define("tiny_c4l/ui",["exports","./common","./modal","./components","core/str","./options","core/modal_events","./variantslib","core/notification"],(function(_exports,_common,_modal,_components,_str,_options,_modal_events,_variantslib,_notification){function _interopRequireDefault(e){return e&&e.__esModule?e:{default:e}}
/**
   * Tiny C4L UI.
   *
   * @module      tiny_c4l/ui
   * @copyright   2022 Marc Català <reskit@gmail.com>
   * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.handleAction=void 0,_modal=_interopRequireDefault(_modal),_modal_events=_interopRequireDefault(_modal_events),_notification=_interopRequireDefault(_notification);let userStudent=!1,previewC4L=!0,allowedComponents=[],Contexts=[],langStrings={},previewCSS="",customComponents=[];_exports.handleAction=async editor=>{userStudent=(0,_options.isStudent)(editor),previewC4L=(0,_options.showPreview)(editor),customComponents=(0,_options.getcustomComponents)(editor),addCustomComponents(),allowedComponents=(0,_options.getallowedComponents)(editor),previewCSS=(0,_options.getpreviewCSS)(editor),langStrings=await getAllStrings(),(0,_variantslib.loadVariantPreferences)(_components.components).then((()=>{displayDialogue(editor)})).catch(_notification.default.exception)};const displayDialogue=async editor=>{const data=Object.assign({},{}),modal=await _modal.default.create({templateContext:await getTemplateContext(editor,data)}),modalClass=previewC4L?"c4l-modal":"c4l-modal-no-preview";if(editor.targetElm.closest("body").classList.add(modalClass),""!==previewCSS){const styles=document.createElement("style");styles.textContent=previewCSS,editor.targetElm.closest("body").appendChild(styles)}modal.show(),modal.getRoot().on(_modal_events.default.hidden,(()=>{handleModalHidden(editor)}));modal.getRoot()[0].querySelectorAll(".c4l-button-filter").forEach((node=>{node.addEventListener("click",(event=>{handleButtonFilterClick(event,modal)}))})),modal.getRoot()[0].querySelector(".c4l-select-filter").addEventListener("change",(event=>{handleSelectFilterChange(event,modal)}));modal.getRoot()[0].querySelectorAll(".c4lt-dialog-button").forEach((node=>{node.addEventListener("click",(event=>{handleButtonClick(event,editor,modal)})),previewC4L&&(node.addEventListener("mouseenter",(event=>{handleButtonMouseEvent(event,modal,!0)})),node.addEventListener("mouseleave",(event=>{handleButtonMouseEvent(event,modal,!1)})))}));modal.getRoot()[0].querySelectorAll(".c4l-button-variant").forEach((node=>{node.addEventListener("click",(event=>{handleVariantClick(event,modal)})),previewC4L&&(node.addEventListener("mouseenter",(event=>{handleVariantMouseEvent(event,modal,!0)})),node.addEventListener("mouseleave",(event=>{handleVariantMouseEvent(event,modal,!1)})))}))},handleSelectFilterChange=(event,modal)=>{const select=event.target.closest("select");if(select){const currentContext=select.value;if(-1!==Contexts.indexOf(currentContext)){modal.getRoot()[0].querySelectorAll(".c4l-buttons-filters button").forEach((node=>node.classList.remove("c4l-button-filter-enabled")));modal.getRoot()[0].querySelector('.c4l-button-filter[data-filter="'+currentContext+'"]').classList.add("c4l-button-filter-enabled"),showContextButtons(modal,currentContext)}}},handleButtonFilterClick=(event,modal)=>{const button=event.target.closest("button"),currentContext=button.dataset.filter;if(-1!==Contexts.indexOf(currentContext)){modal.getRoot()[0].querySelectorAll(".c4l-buttons-filters button").forEach((node=>node.classList.remove("c4l-button-filter-enabled"))),button.classList.add("c4l-button-filter-enabled");modal.getRoot()[0].querySelector(".c4l-select-filter").selectedIndex=Contexts.indexOf(currentContext),showContextButtons(modal,currentContext)}},handleModalHidden=editor=>{editor.targetElm.closest("body").classList.remove("c4l-modal-no-preview"),(0,_variantslib.saveVariantPreferences)(_components.components)},handleButtonClick=(event,editor,modal)=>{const selectedButton=event.target.closest("button").dataset.id,component=_components.components.find((element=>element.name==selectedButton));if(null!=component){const sel=editor.selection.getContent();let componentCode=component.code;const placeholder=sel.length>0?sel:component.text,randomId=generateRandomID(),newNode=document.createElement("span");newNode.dataset.id=randomId,newNode.innerHTML=placeholder,componentCode=componentCode.replace("{{PLACEHOLDER}}",newNode.outerHTML);const variants=(0,_variantslib.getVariantsClass)(component.name);variants.length>0?(componentCode=componentCode.replace("{{VARIANTS}}",variants.join(" ")),componentCode=componentCode.replace("{{VARIANTSHTML}}",(0,_variantslib.getVariantsHtml)(component.name))):(componentCode=componentCode.replace("{{VARIANTS}}",""),componentCode=componentCode.replace("{{VARIANTSHTML}}","")),componentCode=applyRandomID(componentCode),componentCode=applyLangStrings(componentCode),editor.selection.setContent(componentCode);const nodeSel=editor.dom.select('span[data-id="'+randomId+'"]');nodeSel?.[0]&&editor.selection.select(nodeSel[0]),modal.destroy(),editor.focus()}},handleButtonMouseEvent=(event,modal,show)=>{const selectedButton=event.target.closest("button").dataset.id,node=modal.getRoot()[0].querySelector('div[data-id="code-preview-'+selectedButton+'"]'),previewDefault=modal.getRoot()[0].querySelector('div[data-id="code-preview-default"]');node&&(show?(previewDefault.classList.toggle("c4l-hidden"),node.classList.toggle("c4l-hidden")):(node.classList.toggle("c4l-hidden"),previewDefault.classList.toggle("c4l-hidden")))},handleVariantMouseEvent=(event,modal,show)=>{const variant=event.target.closest("span"),variantEnabled="on"==variant.dataset.state,button=event.target.closest("button");variantEnabled||updateVariantComponentState(variant,button,modal,show,!1)},handleVariantClick=(event,modal)=>{event.stopPropagation();const variant=event.target.closest("span"),button=event.target.closest("button");updateVariantComponentState(variant,button,modal,!1,!0)},getTemplateContext=async(editor,data)=>Object.assign({},{elementid:editor.id,buttons:await getButtons(editor),filters:await getFilters(),preview:previewC4L},data),getFilters=async()=>{const filters=[],stringValues=await(0,_str.get_strings)(Contexts.map((key=>({key:key,component:_common.component}))));return Contexts.forEach(((context,index)=>{filters.push({name:stringValues[index],type:context,filterClass:0===index?"c4l-button-filter-enabled":""})})),filters},getButtons=editor=>{const buttons=[],sel=editor.selection.getContent();let componentCode="",placeholder="",variants=[],buttonText="";return _components.components.forEach((component=>{if(!userStudent||userStudent&&allowedComponents.includes(component.name)){if(previewC4L){placeholder=sel.length>0?sel:component.text,componentCode=component.code,componentCode=componentCode.replace("{{PLACEHOLDER}}",placeholder),variants=(0,_variantslib.getVariantsClass)(component.name);const variantsNode=document.createElement("span");variantsNode.dataset.id="variantHTML-"+component.id,variants.length>0?(componentCode=componentCode.replace("{{VARIANTS}}",variants.join(" ")),variantsNode.innerHTML=(0,_variantslib.getVariantsHtml)(component.name),componentCode=componentCode.replace("{{VARIANTSHTML}}",variantsNode.outerHTML)):(componentCode=componentCode.replace("{{VARIANTS}}",""),componentCode=componentCode.replace("{{VARIANTSHTML}}",variantsNode.outerHTML)),componentCode=applyLangStrings(componentCode)}-1===Contexts.indexOf(component.type)&&Contexts.push(component.type),buttonText="custom"==component.type?component.buttonname:langStrings.get(component.name),buttons.push({id:component.name,name:buttonText,type:component.type,icon:component.icon??"",imageClass:component.imageClass,classComponent:"c4lv-"+component.name,htmlcode:componentCode,css:component.css??"",variants:getVariantsState(component.name,component.variants)}),0!==Contexts.indexOf(component.type)&&(buttons[buttons.length-1].imageClass+=" c4l-hidden")}})),buttons},getVariantsState=(component,elements)=>{const variants=[];let variantState="",variantClass="";return elements.length>3&&(elements=elements.slice(0,2)),elements.forEach(((variant,index)=>{(0,_variantslib.variantExists)(component,variant)?(variantState="on",variantClass="on "):(variantState="off",variantClass=""),variantClass+=variant+"-variant-"+variantState,variants.push({id:index,name:variant,state:variantState,imageClass:variantClass,title:langStrings.get(variant)})})),variants},updateVariantComponentState=(variant,button,modal,show,updateHtml)=>{const selectedVariant="c4l-"+variant.dataset.variant+"-variant",component=_components.components.find((element=>element.name==button.dataset.id)),componentClass=button.dataset.classcomponent,previewComponent=modal.getRoot()[0].querySelector('div[data-id="code-preview-'+button.dataset.id+'"] .'+componentClass),variantPreview=modal.getRoot()[0].querySelector('span[data-id="variantHTML-'+component.id+'"]');let variantsHtml="";previewComponent?updateHtml?("on"==variant.dataset.state?((0,_variantslib.removeVariant)(component.name,variant.dataset.variant),updateVariantButtonState(variant,!1),previewComponent.classList.remove(selectedVariant)):((0,_variantslib.addVariant)(component.name,variant.dataset.variant),updateVariantButtonState(variant,!0),previewComponent.classList.add(selectedVariant)),variantPreview&&(variantPreview.innerHTML=(0,_variantslib.getVariantsHtml)(component.name))):(variantsHtml=(0,_variantslib.getVariantsHtml)(component.name),show?(previewComponent.classList.add(selectedVariant),variantsHtml+=(0,_variantslib.getVariantHtml)(variant.dataset.variant)):previewComponent.classList.remove(selectedVariant),variantPreview&&(variantPreview.innerHTML=variantsHtml)):updateHtml&&("on"==variant.dataset.state?((0,_variantslib.removeVariant)(component.name,variant.dataset.variant),updateVariantButtonState(variant,!1)):((0,_variantslib.addVariant)(component.name,variant.dataset.variant),updateVariantButtonState(variant,!0)))},updateVariantButtonState=(variant,activate)=>{activate?(variant.dataset.state="on",variant.classList.remove(variant.dataset.variant+"-variant-off"),variant.classList.add(variant.dataset.variant+"-variant-on"),variant.classList.add("on")):(variant.dataset.state="off",variant.classList.remove(variant.dataset.variant+"-variant-on"),variant.classList.add(variant.dataset.variant+"-variant-off"),variant.classList.remove("on"))},showContextButtons=(modal,context)=>{const showNodes=modal.getRoot()[0].querySelectorAll('button[data-type="'+context+'"]'),hideNodes=modal.getRoot()[0].querySelectorAll('button[data-type]:not([data-type="'+context+'"])');showNodes.forEach((node=>node.classList.remove("c4l-hidden"))),hideNodes.forEach((node=>node.classList.add("c4l-hidden")))},applyLangStrings=text=>([...text.matchAll(/{{#([^}]*)}}/g)].forEach((strLang=>{text=text.replace("{{#"+strLang[1]+"}}",langStrings.get(strLang[1]))})),text),generateRandomID=()=>{const timestamp=(new Date).getTime();return"R"+Math.round(1e5*Math.random())+"-"+timestamp},applyRandomID=text=>{const compRegex=/{{@ID}}/g;return text.match(compRegex)&&(text=text.replace(compRegex,generateRandomID())),text},getAllStrings=async()=>{const keys=[],compRegex=/{{#([^}]*)}}/g;_components.components.forEach((element=>{-1==element.name.indexOf("customcomp")&&keys.push(element.name),element.variants.forEach((variant=>{-1===keys.indexOf(variant)&&keys.push(variant)})),[...element.code.matchAll(compRegex)].forEach((strLang=>{-1===keys.indexOf(strLang[1])&&keys.push(strLang[1])})),[...element.text.matchAll(compRegex)].forEach((strLang=>{-1===keys.indexOf(strLang[1])&&keys.push(strLang[1])}))}));const stringValues=await(0,_str.get_strings)(keys.map((key=>({key:key,component:_common.component}))));return new Map(keys.map(((key,index)=>[key,stringValues[index]])))},addCustomComponents=()=>{customComponents.length>0&&customComponents.forEach((customcomp=>{null==_components.components.find((element=>element.id==customcomp.id+1e3))&&_components.components.push({id:customcomp.id+1e3,name:customcomp.name,buttonname:customcomp.buttonname,type:"custom",imageClass:"c4l-custom-icon",code:replaceCustomPlaceholders(customcomp),text:customcomp.text.length>0?customcomp.text:"{{#textplaceholder}}",variants:customcomp.variants?["full-width"]:[],icon:customcomp.icon,css:customcomp.css})}))},replaceCustomPlaceholders=component=>{let html=component.code;const variants=component.variants?" {{VARIANTS}}":"";return html=html.replace("{{CUSTOMCLASS}}","c4lv-"+component.name+" c4lv-custom-component"+variants),html}}));

//# sourceMappingURL=ui.min.js.map