/**
 * Handle opening a dialogue to configure condition data.
 *
 * @module     profilefield_conditional/conditionconfig
 * @copyright  2016 Shamim Rezaie <http://foodle.org>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("profilefield_conditional/conditionconfig",["jquery","core/notification","core/templates","core/ajax","profilefield_conditional/dialogue","profilefield_conditional/otherfields"],(function($,notification,templates,ajax,Dialogue,ModOtherFields){var ConditionConfig=function(selectSelector,inputSelector,triggerSelector,fieldId){this.selectSelector=selectSelector,this.inputSelector=inputSelector,this.triggerSelector=triggerSelector,this.fieldId=fieldId,$(triggerSelector).click(this.showConfig.bind(this))};return ConditionConfig.prototype.selectSelector=null,ConditionConfig.prototype.inputSelector=null,ConditionConfig.prototype.triggerSelector=null,ConditionConfig.prototype.fieldId=null,ConditionConfig.prototype.otherFields=null,ConditionConfig.prototype.options=null,ConditionConfig.prototype.popup=null,ConditionConfig.prototype.showConfig=function(){var self=this;this.options=[],$(this.selectSelector).val().replace(/\r\n/,"\n").split("\n").forEach((function(value,index){value&&self.options.push({index:index,option:value})})),this.getOtherFields(this.fieldId).done((function(){var context={options:self.options,fields:self.otherFields};templates.render("profilefield_conditional/condition_configuration_page",context).done((function(html){new Dialogue("",html,self.initConditionConfig.bind(self))})).fail(notification.exception)})).fail(notification.exception)},ConditionConfig.prototype.retrieveConditionConfig=function(){var jsonstring=$(this.inputSelector).val();return""!==jsonstring?$.parseJSON(jsonstring):""},ConditionConfig.prototype.applyRestriction=function(source){source.closest(".profilefield_conditional_config")&&source.parentElement.parentElement.querySelectorAll('[type="checkbox"]').forEach((checkbox=>{checkbox!==source&&(source.checked?(checkbox.checked=!1,checkbox.disabled=!0):checkbox.disabled=!1)}))},ConditionConfig.prototype.initConditionConfig=function(popup){this.popup=popup;var self=this,body=$(popup.getContent()),currentconfig=this.retrieveConditionConfig();""!==currentconfig&&currentconfig.forEach((function(option){var slashedoption=option.option.replace(/\\/g,"\\\\").replace(/'/g,"\\'").replace(/"/g,'\\"').replace(/\0/g,"\\0");option.requiredfields.forEach((function(field){body.find('[data-field="profilefield_conditional_field_required_'+slashedoption+"_"+field+'"]').attr("checked",!0),body.find('[data-field="profilefield_conditional_field_required_'+slashedoption+"_"+field+'"]').each((function(){self.applyRestriction(this)}))})),option.hiddenfields.forEach((function(field){body.find('[data-field="profilefield_conditional_field_hidden_'+slashedoption+"_"+field+'"]').attr("checked",!0),body.find('[data-field="profilefield_conditional_field_hidden_'+slashedoption+"_"+field+'"]').each((function(){self.applyRestriction(this)}))})),option.hiddenclearedfields&&option.hiddenclearedfields.forEach((function(field){body.find('[data-field="profilefield_conditional_field_hiddencleared_'.concat(slashedoption,"_").concat(field,'"]')).attr("checked",!0),body.find('[data-field="profilefield_conditional_field_hiddencleared_'.concat(slashedoption,"_").concat(field,'"]')).each((function(){self.applyRestriction(this)}))}))})),body.on("click",'[data-action="close"]',function(){this.setConditionConfig(),popup.close()}.bind(this)),body.on("click",'[data-action="cancel"]',(function(){popup.close()})),body.on("click",'[type="checkbox"]',function(e){this.applyRestriction(e.target)}.bind(this))},ConditionConfig.prototype.setConditionConfig=function(){var self=this,body=$(this.popup.getContent()),data=[];this.options.forEach((function(option){var requiredfields=[],hiddenfields=[],hiddenclearedfields=[],slashedoption=option.option.replace(/\\/g,"\\\\").replace(/'/g,"\\'").replace(/"/g,'\\"').replace(/\0/g,"\\0");self.otherFields.forEach((function(field){body.find('[data-field="profilefield_conditional_field_required_'+slashedoption+"_"+field.shortname+'"]').is(":checked")&&requiredfields.push(field.shortname),body.find('[data-field="profilefield_conditional_field_hidden_'+slashedoption+"_"+field.shortname+'"]').is(":checked")&&hiddenfields.push(field.shortname),body.find('[data-field="profilefield_conditional_field_hiddencleared_'+slashedoption+"_"+field.shortname+'"]').is(":checked")&&hiddenclearedfields.push(field.shortname)})),data.push({option:option.option,requiredfields:requiredfields,hiddenfields:hiddenfields,hiddenclearedfields:hiddenclearedfields})}));var datastring=JSON.stringify(data);$(this.inputSelector).val(datastring)},ConditionConfig.prototype.getOtherFields=function(fieldId){return ModOtherFields.getFields(fieldId).then(function(values){return this.otherFields=values,values}.bind(this))},{init:function(selectSelector,inputSelector,triggerSelector,fieldId){return new ConditionConfig(selectSelector,inputSelector,triggerSelector,fieldId)}}}));

//# sourceMappingURL=conditionconfig.min.js.map