/**
 *
 * @module      mod_nextblocks/chat
 * @copyright   2025 Rui Correia<rjr.correia@campus.fct.unl.pt>
 * @copyright   based on work by 2024 Duarte Pereira<dg.pereira@campus.fct.unl.pt>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

define ("mod_nextblocks/chat", [], function () {
  return {
    run: function (userName, activityId, saveMessage) {
      let serverUrl = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 'ws://localhost:8060';
      const socket = new WebSocket(serverUrl);
      socket.addEventListener("open", () => chatSetup(socket, userName, activityId, saveMessage));
      socket.addEventListener("message", event => appendMessage(event.data, activityId));
    },
    populate: function (getMessages, activityId) {
      const messagesPromise = getMessages(100, activityId);
      messagesPromise.then(messages => {
        messages.forEach(dbMessage => {
          const message = {
            type: "dbMessage",
            sender: dbMessage.username,
            text: dbMessage.message,
            activity: activityId,
            timestamp: dbMessage.timestamp
          };
          appendMessage(message, activityId, true);
        });
      });
    }
  };
});
const socketError = function (activityId) {
  let errorMessage = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "Connection error";
  const errorJSON = {
    type: "error",
    sender: "System",
    text: errorMessage,
    activity: activityId,
    timestamp: Date.now()
  };
  appendMessage(errorJSON, activityId, true);
};
const appendMessage = function (message, activityId) {
  let isParsed = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  if (!isParsed) {
    console.log(message);
    message = parseMessage(message);
  }
  if (activityId === message.activity) {
    const chatDiv = document.getElementById('messages');
    const timestampDate = new Date(message.timestamp);
    chatDiv.innerHTML += `<p>(${String(timestampDate.getHours()).padStart(2, '0')}:${String(timestampDate.getMinutes()).padStart(2, '0')})
            ${message.sender}: ${message.text}</p>`;
  }
};
const parseMessage = function (message) {
  let msg;
  try {
    msg = JSON.parse(message);
  } catch (e) {
    throw new Error("Invalid message format");
  }
  return msg;
};
const chatSetup = function (socket, userName, activityId, saveMessage) {
  const msgForm = document.querySelector('form.msg-form');
  const msgFormSubmit = event => {
    event.preventDefault();
    const msgField = document.getElementById('msg');
    const msgText = msgField.value;
    const timestamp = Date.now();
    saveMessage(msgText, userName, activityId, timestamp);
    let msg = {
      type: "normal",
      sender: userName,
      text: msgText,
      activity: activityId,
      timestamp: timestamp
    };
    msg = JSON.stringify(msg);
    socket.send(msg);
    msgField.value = '';
  };
  msgForm.addEventListener('submit', event => msgFormSubmit(event, socket));
};

//# sourceMappingURL=chat.min.js.map