<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package     mod_nextblocks
 * @copyright   2025 Rui Correia<rjr.correia@campus.fct.unl.pt>
 * @copyright   based on work by 2024 Duarte Pereira<dg.pereira@campus.fct.unl.pt>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

/**
 * Defines the step to restore NextBlocks' structure
 */
class restore_nextblocks_activity_structure_step extends restore_activity_structure_step{

    /**
     * Defines NextBlocks' structure
     */
    protected function define_structure() {
        $paths = [];

        $paths[] = new restore_path_element(
            'nextblocks',
            '/activity/nextblocks'
        );

        $paths[] = new restore_path_element(
            'customblock',
            '/activity/nextblocks/customblocks/customblock'
        );
        $paths[] = new restore_path_element(
            'blocklimit',
            '/activity/nextblocks/blocklimits/blocklimit'
        );
        $paths[] = new restore_path_element(
            'message',
            '/activity/nextblocks/messages/message'
        );
        if ($this->get_setting_value('userinfo')) {
            $paths[] = new restore_path_element(
                'userdata',
                '/activity/nextblocks/userdatas/userdata'
            );
        }

        return $this->prepare_activity_structure($paths);
    }

    /**
     * Processes NextBlocks' restore data
     *
     * @param $data
     */
    protected function process_nextblocks($data) {
        global $DB;

        $data = (object)$data;

        $data->course = $this->get_courseid();
        $data->timecreated = time();
        $data->timemodified = time();

        $newitemid = $DB->insert_record('nextblocks', $data);
        $this->apply_activity_instance($newitemid);
    }

    /**
     * Processes Custom Blocks related data
     *
     * @param $data
     */
    protected function process_customblock($data) {
        global $DB;

        $data = (object)$data;
        $data->nextblocksid = $this->get_new_parentid('nextblocks');
        $DB->insert_record('nextblocks_customblocks', $data);
    }

    /**
     * Processes Block Limit related data
     *
     * @param $data
     */
    protected function process_blocklimit($data) {
        global $DB;

        $data = (object)$data;
        $data->nextblocksid = $this->get_new_parentid('nextblocks');
        $DB->insert_record('nextblocks_blocklimit', $data);
    }

    /**
     * Processes chat messages related data
     *
     * @param $data
     */
    protected function process_message($data) {
        global $DB;

        $data = (object)$data;
        $data->nextblocksid = $this->get_new_parentid('nextblocks');
        $DB->insert_record('nextblocks_messages', $data);
    }

    /**
     * Processes user data
     *
     * @param $data
     */
    protected function process_userdata($data) {
        global $DB;

        $data = (object)$data;
        $data->nextblocksid = $this->get_new_parentid('nextblocks');
        $data->userid = $this->get_mappingid('user', $data->userid);
        $DB->insert_record('nextblocks_userdata', $data);
    }


    /**
     * Handles tests file duplication after execution
     */
    protected function after_execute() {
        global $DB;
        $oldinstanceid = $this->task->get_old_activityid();
        $newinstanceid = $this->get_new_parentid('nextblocks');

        $oldname = 'tests' . $oldinstanceid . '.json';
        $newname = 'tests' . $newinstanceid . '.json';

        $records = $DB->get_records_sql("
            SELECT contextid, filepath, filename
            FROM {files}
            WHERE component = :component
              AND filearea  = :filearea
              AND itemid    = :itemid
              AND filename != '.'",
            [
                'component' => 'mod_nextblocks',
                'filearea'  => 'attachment',
                'itemid'    => $oldinstanceid,
                'filename'  => $oldname,
            ]
        );

        $rec = reset($records);

        $fs = get_file_storage();
        $file = $fs->get_file(
            $rec->contextid,
            'mod_nextblocks',
            'attachment',
            $oldinstanceid,
            $rec->filepath,
            $rec->filename
        );

        $fileinfo = [
            'contextid' => $rec->contextid,
            'component' => 'mod_nextblocks',
            'filearea'  => 'attachment',
            'itemid'    => $newinstanceid,
            'filepath'  => $rec->filepath,
            'filename'  => $newname,
        ];

        $fs->create_file_from_storedfile($fileinfo, $file);

        $this->add_related_files('mod_nextblocks', 'intro', null);

    }
}
