/**
 *
 * @module      mod_nextblocks/codeenv
 * @copyright   2025 Rui Correia<rjr.correia@campus.fct.unl.pt>
 * @copyright   based on work by 2024 Duarte Pereira<dg.pereira@campus.fct.unl.pt>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 *  */
define("mod_nextblocks/codeenv",["mod_nextblocks/lib","mod_nextblocks/repository","mod_nextblocks/chat","core/str"],(function(lib,repository,chat,str){let toolbox={kind:"categoryToolbox",readOnly:!0,contents:[{kind:"toolboxlabel",name:"NextBlocks",colour:"darkslategrey"},{kind:"category",name:"Logic",colour:"5b80a5",cssConfig:{icon:"customIcon fa fa-cog"},contents:[{kind:"block",type:"controls_if"},{kind:"block",type:"logic_compare"},{kind:"block",type:"logic_negate"},{kind:"block",type:"logic_operation"},{kind:"block",type:"logic_boolean"},{kind:"block",type:"logic_null"},{kind:"block",type:"logic_ternary"}]},{kind:"category",name:"Loops",colour:"5ba580",cssConfig:{icon:"customIcon fa-solid fa-sync"},contents:[{kind:"block",type:"controls_repeat_ext"},{kind:"block",type:"controls_whileUntil"},{kind:"block",type:"controls_for"},{kind:"block",type:"controls_forEach"},{kind:"block",type:"controls_flow_statements"}]},{kind:"category",name:"Math",colour:"5b67a5",cssConfig:{icon:"customIcon fa-solid fa-plus-minus"},contents:[{kind:"block",type:"math_number"},{kind:"block",type:"math_arithmetic"},{kind:"block",type:"math_single"},{kind:"block",type:"math_trig"},{kind:"block",type:"math_constant"},{kind:"block",type:"math_number_property"},{kind:"block",type:"math_round"},{kind:"block",type:"math_on_list"},{kind:"block",type:"math_modulo"},{kind:"block",type:"math_constrain"},{kind:"block",type:"math_random_int"},{kind:"block",type:"math_random_float"},{kind:"block",type:"math_atan2"},{kind:"block",type:"text_to_number"}]},{kind:"category",name:"Text",colour:"5ba58c",cssConfig:{icon:"customIcon fa-solid fa-font"},contents:[{kind:"block",type:"text"},{kind:"block",type:"text_multiline"},{kind:"block",type:"text_join"},{kind:"block",type:"text_append"},{kind:"block",type:"text_length"},{kind:"block",type:"text_isEmpty"},{kind:"block",type:"text_indexOf"},{kind:"block",type:"text_charAt"},{kind:"block",type:"text_getSubstring"},{kind:"block",type:"text_changeCase"},{kind:"block",type:"text_trim"},{kind:"block",type:"text_count"},{kind:"block",type:"text_replace"},{kind:"block",type:"text_reverse"},{kind:"block",type:"text_print"},{kind:"block",type:"text_ask"}]},{kind:"category",name:"Lists",colour:"5b80a5",cssConfig:{icon:"customIcon fa-solid fa-list"},contents:[{kind:"block",type:"lists_create_with"},{kind:"block",type:"lists_repeat"},{kind:"block",type:"lists_length"},{kind:"block",type:"lists_isEmpty"},{kind:"block",type:"lists_indexOf"},{kind:"block",type:"lists_getIndex"},{kind:"block",type:"lists_setIndex"},{kind:"block",type:"lists_getSublist"},{kind:"block",type:"lists_split"},{kind:"block",type:"lists_sort"},{kind:"block",type:"lists_reverse"}]},{kind:"category",name:"Variables",colour:"a55b80",cssConfig:{icon:"customIcon fa-solid fa-clipboard-list"},custom:"VARIABLE"},{kind:"category",name:"Functions",colour:"995ba5",cssConfig:{icon:"customIcon fa-solid fa-code"},custom:"PROCEDURE"}]},nextblocksWorkspace;async function runCode(code){const outputDiv=document.getElementById("output-div");outputDiv.classList.remove("tests-active");var codeString=code.getCompleteCodeString();codeString=lib.errorPrevention(codeString);const output=await lib.silentRunCode(codeString),outputHTML=String(output).replace(/\n/g,"<br />");output.includes("Error")?outputDiv.innerHTML=`<div style="max-height: 100%; overflow-y: auto; color: red !important; background-color: black;"><pre>${outputHTML}</pre></div>`:outputDiv.innerHTML=`<div style="max-height: 100%; overflow-y: auto; color: white !important; background-color: black;"><pre>${outputHTML}</pre></div>`}const saveState=isTeacherReport=>{const state=Blockly.serialization.workspaces.save(nextblocksWorkspace),stateB64=btoa(JSON.stringify(state)),cmid=getCMID();if(isTeacherReport){const queryString=window.location.search,userId=new URLSearchParams(queryString).get("userid");repository.saveWorkspace(cmid,stateB64,userId)}else repository.saveWorkspace(cmid,stateB64)},submitWorkspace=async inputFuncDecs=>{const codeString=lib.getWorkspaceCode(nextblocksWorkspace,inputFuncDecs).getTestableCodeString(),state=Blockly.serialization.workspaces.save(nextblocksWorkspace),stateB64=btoa(JSON.stringify(state)),cmid=getCMID();repository.submitWorkspace(cmid,stateB64,codeString);var ms;await(ms=1e3,new Promise((resolve=>setTimeout(resolve,ms)))),location.reload(),str.get_string("submitsuccess","mod_nextblocks").then((function(text){alert(text)}))};async function displayTestResults(results,tests){const testResultsDiv=document.getElementById("output-div");testResultsDiv.classList.add("tests-active"),testResultsDiv.innerHTML="",testResultsDiv.innerHTML=await lib.testsAccordion(results,tests)}const changeImageBackground=function(img){const imgs=document.getElementsByClassName("emoji-img");Array.from(imgs).forEach((otherImg=>{otherImg!==img&&(otherImg.classList.remove("bg-primary"),otherImg.classList.add("bg-secondary"))})),img.classList.contains("bg-primary")?(img.classList.remove("bg-primary"),img.classList.add("bg-secondary")):(img.classList.remove("bg-secondary"),img.classList.add("bg-primary"))};function setupButtons(tests,workspace,inputFuncDecs,lastUserReaction,isTeacherReport){if(document.getElementById("runButton").addEventListener("click",(function(){runCode(lib.getWorkspaceCode(workspace,inputFuncDecs))})),null!==tests){document.getElementById("runTestsButton").addEventListener("click",(async()=>{const code=lib.getWorkspaceCode(workspace,inputFuncDecs).getCompleteCodeString();lib.runTests(code,tests).then((results=>{displayTestResults(results,tests)}))}))}document.getElementById("saveButton").addEventListener("click",(()=>{saveState(isTeacherReport)}));const submitButton=document.getElementById("submitButton");null!==submitButton&&submitButton.addEventListener("click",(()=>{submitWorkspace(inputFuncDecs)}));let lastUserReactionString="";1===lastUserReaction?lastUserReactionString="easy":2===lastUserReaction?lastUserReactionString="medium":3===lastUserReaction&&(lastUserReactionString="hard");const imgs=document.getElementsByClassName("emoji-img");Array.from(imgs).forEach((img=>{let imageType="";img.src.includes("easy")?imageType="easy":img.src.includes("think")?imageType="medium":img.src.includes("hard")&&(imageType="hard"),lastUserReactionString===imageType&&changeImageBackground(img),isTeacherReport||img.addEventListener("click",(()=>{repository.submitReaction(getCMID(),imageType).then((newReactions=>{updatePercentages(newReactions.reactionseasy,newReactions.reactionsmedium,newReactions.reactionshard),changeImageBackground(img)}))}))}));const textCodeButton=document.getElementById("showCodeButton");let overlayDiv,codeVisible=!1;function updateOverlayCode(lang){let codeString="";codeString="python"==lang?lib.formatPythonCodeHTML(lib.getWorkspaceCodePython(workspace,inputFuncDecs)):lib.formatCodeHTML(lib.getWorkspaceCode(workspace,inputFuncDecs)),codeString=codeString.replace(/\n/g,"<br />");const codeContentDiv=document.getElementById("codeContent");codeContentDiv&&(codeContentDiv.innerHTML=codeString)}textCodeButton.addEventListener("click",(()=>{const blocklyArea=document.getElementById("blocklyArea"),paddingLeft=parseInt(window.getComputedStyle(blocklyArea).getPropertyValue("padding-left")),paddingRight=parseInt(window.getComputedStyle(blocklyArea).getPropertyValue("padding-right"));if(codeVisible)overlayDiv.style.display="none",codeVisible=!1;else{if(!overlayDiv){overlayDiv=document.createElement("div"),overlayDiv.style.position="absolute",overlayDiv.style.top="0",overlayDiv.style.left=`${paddingLeft}px`,overlayDiv.style.width=`calc(100% - ${paddingLeft+paddingRight}px)`,overlayDiv.style.height="100%",overlayDiv.style.backgroundColor="white",overlayDiv.style.border="1px solid #ddd",overlayDiv.style.padding="10px",overlayDiv.style.fontFamily='"Lucida Console", "Courier New", monospace',overlayDiv.style.zIndex="1000",blocklyArea.appendChild(overlayDiv);const headerDiv=document.createElement("div");headerDiv.id="langContainer",headerDiv.style.position="absolute",headerDiv.style.top="5px",headerDiv.style.left="5px",headerDiv.style.zIndex="1100",overlayDiv.appendChild(headerDiv);const jsButton=document.createElement("button");jsButton.id="jsButton",jsButton.textContent="JavaScript",jsButton.style.marginRight="5px",headerDiv.appendChild(jsButton);const pyButton=document.createElement("button");pyButton.id="pyButton",pyButton.textContent="Python",headerDiv.appendChild(pyButton);const codeContentDiv=document.createElement("div");codeContentDiv.id="codeContent",codeContentDiv.style.marginTop="40px",overlayDiv.appendChild(codeContentDiv),jsButton.addEventListener("click",(()=>{updateOverlayCode("javascript"),jsButton.classList.add("selected-button"),pyButton.classList.remove("selected-button")})),pyButton.addEventListener("click",(()=>{updateOverlayCode("python"),pyButton.classList.add("selected-button"),jsButton.classList.remove("selected-button")})),jsButton.classList.add("selected-button")}updateOverlayCode("javascript"),document.querySelectorAll(".blocklyHtmlInput").forEach((input=>{input.style.display="none"})),overlayDiv.style.display="block",codeVisible=!0}}))}Blockly.JavaScript.forBlock.text_print=function(block,generator){return"customPrintln("+(generator.valueToCode(block,"TEXT",Blockly.JavaScript.ORDER_NONE)||"''")+");\n"},Blockly.JavaScript.forBlock.text_ask=function(block,generator){return["await input("+(generator.valueToCode(block,"TEXT",Blockly.JavaScript.ORDER_NONE)||"''")+")",Blockly.JavaScript.ORDER_NONE]},Blockly.Python.forBlock.text_ask=function(block,generator){return["input("+(generator.valueToCode(block,"TEXT",Blockly.Python.ORDER_NONE)||"''")+")",Blockly.Python.ORDER_NONE]},Blockly.Blocks.text_ask={init:function(){this.appendValueInput("TEXT").setCheck(null).appendField("input"),this.setOutput(!0,"String"),this.setColour(160),this.setTooltip(""),this.setHelpUrl("")}},Blockly.JavaScript.forBlock.text_to_number=function(block,generator){return["text_to_number("+(generator.valueToCode(block,"TEXT",Blockly.JavaScript.ORDER_NONE)||"''").trim()+")",Blockly.JavaScript.ORDER_NONE]},Blockly.Python.forBlock.text_to_number=function(block,generator){return["text_to_number("+(generator.valueToCode(block,"TEXT",Blockly.Python.ORDER_NONE)||"''").trim()+")",Blockly.Python.ORDER_NONE]},Blockly.Blocks.text_to_number={init:function(){this.appendValueInput("TEXT").setCheck(null).appendField("text to number"),this.setOutput(!0,"Number"),this.setColour("#5b67a5"),this.setTooltip(""),this.setHelpUrl("")}},Blockly.Blocks.number_input={init:function(){this.appendDummyInput().appendField("number input").appendField(new Blockly.FieldNumber(0),"number_input"),this.setOutput(!0,"Number"),this.setColour(180),this.setTooltip(""),this.setHelpUrl("")}},Blockly.Blocks.text_input={init:function(){this.appendDummyInput().appendField("text input:").appendField(new Blockly.FieldTextInput("text"),"text_input"),this.setOutput(!0,"String"),this.setColour(180),this.setTooltip(""),this.setHelpUrl("")}},Blockly.Blocks.text_multiline_input={init:function(){this.appendDummyInput().appendField("multiline text input:").appendField(new Blockly.FieldMultilineInput("multiline \n text"),"text_input"),this.setOutput(!0,"String"),this.setColour(180),this.setTooltip(""),this.setHelpUrl("")}},Blockly.Blocks.start={init:function(){this.appendDummyInput().appendField("start"),this.setNextStatement(!0,null),this.setColour(60),this.setTooltip(""),this.setHelpUrl(""),this.setDeletable(!1)}},Blockly.JavaScript.forBlock.start=function(block,generator){return""},Blockly.JavaScript.forBlock.number_input=function(block,generator){return["input("+block.getFieldValue("number_input")+")",Blockly.JavaScript.ORDER_NONE]},Blockly.JavaScript.forBlock.text_input=function(block,generator){return['input("'+block.getFieldValue("text_input")+'")',Blockly.JavaScript.ORDER_NONE]},Blockly.JavaScript.forBlock.text_multiline_input=function(block,generator){return["input(`"+block.getFieldValue("text_input")+"`)",Blockly.JavaScript.ORDER_NONE]};class ToolboxLabel extends Blockly.ToolboxItem{constructor(toolboxItemDef,parentToolbox){super(toolboxItemDef,parentToolbox)}init(){this.label=document.createElement("label"),this.label.textContent=this.toolboxItemDef_.name,this.label.style.color=this.toolboxItemDef_.colour}getDiv(){return this.label}}class CustomCategory extends Blockly.ToolboxCategory{constructor(categoryDef,toolbox,optParent){super(categoryDef,toolbox,optParent)}addColourBorder_(colour){this.rowDiv_.style.backgroundColor=colour}setSelected(isSelected){var labelDom=this.rowDiv_.getElementsByClassName("blocklyTreeLabel")[0];isSelected?(this.rowDiv_.style.backgroundColor="white",labelDom.style.color=this.colour_,this.iconDom_.style.color=this.colour_):(this.rowDiv_.style.backgroundColor=this.colour_,labelDom.style.color="white",this.iconDom_.style.color="white"),Blockly.utils.aria.setState(this.htmlDiv_,Blockly.utils.aria.State.SELECTED,isSelected)}}return Blockly.registry.register(Blockly.registry.Type.TOOLBOX_ITEM,"toolboxlabel",ToolboxLabel),Blockly.registry.register(Blockly.registry.Type.TOOLBOX_ITEM,Blockly.ToolboxCategory.registrationName,CustomCategory,!0),{init:function(contents,loadedSave,customBlocks,remainingSubmissions,reactions,lastUserReaction){let reportType=arguments.length>6&&void 0!==arguments[6]?arguments[6]:0,userName=arguments.length>7?arguments[7]:void 0,activityId=arguments.length>8?arguments[8]:void 0,blockLimits=arguments.length>9?arguments[9]:void 0;2===reportType&&remainingSubmissions>0&&(reportType=0),updatePercentages(reactions[0],reactions[1],reactions[2]);const blocklyDiv=document.getElementById("blocklyDiv"),blocklyArea=document.getElementById("blocklyArea");customBlocks.length>0&&toolbox.contents.push({kind:"category",name:"Custom Blocks",colour:"a55b80",cssConfig:{icon:"customIcon fa-solid fa-code"},contents:[]}),customBlocks.forEach((block=>{let splitTest=block.generator.split("forBlock['"),dotCase=!1;if(splitTest.length<2){if(splitTest=block.generator.split("forBlock."),splitTest.length<2)throw new Error("Invalid generator");dotCase=!0}const blockName=splitTest[1].split(dotCase?" = ":"']")[0].trim();toolbox.contents[toolbox.contents.length-1].contents.push({kind:"block",type:blockName});const definition=JSON.parse(block.definition);if(Blockly.defineBlocksWithJsonArray([definition]),eval(block.generator),0===block.pythongenerator.length){var code="Blockly.Python.forBlock['"+blockName+"'] = function(block) {\n  const code = '"+blockName+"()';\n  return [code, Blockly.Python.ORDER_ATOMIC];\n};\n";eval(code)}else eval(block.pythongenerator)})),Object.keys(blockLimits).forEach((function(k){blockLimits[k]=parseInt(blockLimits[k],10)})),nextblocksWorkspace=Blockly.inject(blocklyDiv,getOptions(remainingSubmissions,0!==reportType,blockLimits)),Blockly.JavaScript.init(nextblocksWorkspace),Blockly.Python.init(nextblocksWorkspace);const resizeObserver=new ResizeObserver((()=>onResize(blocklyArea,blocklyDiv,nextblocksWorkspace)));resizeObserver.observe(blocklyArea);const tests=JSON.parse(contents);let inputFunctionDeclarations={funcDecs:""};null!==loadedSave?loadSave(loadedSave,nextblocksWorkspace):addBlockToWorkspace("start",nextblocksWorkspace),0!==reportType&&lockWorkspaceBlocks(nextblocksWorkspace),setupButtons(tests,nextblocksWorkspace,inputFunctionDeclarations.funcDecs,lastUserReaction,1===reportType)}};function updatePercentages(easy,medium,hard){let inc=arguments.length>3&&void 0!==arguments[3]?arguments[3]:"";const elements={easy:document.getElementById("percentage-easy"),medium:document.getElementById("percentage-medium"),hard:document.getElementById("percentage-hard")},values={easy:easy,medium:medium,hard:hard};inc in values&&values[inc]++;let percentages=calcPercentages(values.easy,values.medium,values.hard);elements.easy.innerHTML=percentages[0]+"%",elements.medium.innerHTML=percentages[1]+"%",elements.hard.innerHTML=percentages[2]+"%"}function calcPercentages(easy,medium,hard){const total=easy+medium+hard;return 0===total?[0,0,0]:[easy,medium,hard].map((val=>Math.round(val/total*100)))}function getOptions(remainingSubmissions,readOnly,blockLimits){return{toolbox:readOnly?null:toolbox,collapse:!0,comments:!0,disable:!1,maxBlocks:1/0,trashcan:!readOnly,horizontalLayout:!1,toolboxPosition:"start",css:!0,media:"https://blockly-demo.appspot.com/static/media/",rtl:!1,scrollbars:!0,sounds:!0,oneBasedIndex:!1,readOnly:remainingSubmissions<=0,grid:{spacing:20,length:1,colour:"#888",snap:!1},zoom:{controls:!0,wheel:!0,startScale:1,maxScale:3,minScale:.3,scaleSpeed:1.2},maxInstances:blockLimits}}function onResize(blocklyArea,blocklyDiv,nextblocksWorkspace){let element=blocklyArea,x=0,y=0;do{x+=element.offsetLeft,y+=element.offsetTop,element=element.offsetParent}while(element);blocklyDiv.style.left=x+"px",blocklyDiv.style.top=y+"px",blocklyDiv.style.width=blocklyArea.offsetWidth+"px",blocklyDiv.style.height=blocklyArea.offsetHeight+"px",Blockly.svgResize(nextblocksWorkspace)}function addBlockToWorkspace(blockName,workspace){const newBlock=workspace.newBlock(blockName);return newBlock.initSvg(),newBlock.render(),newBlock}function loadSave(loadedSave,workspace){const state=JSON.parse(atob(loadedSave));Blockly.serialization.workspaces.load(state,workspace)}function getCMID(){const classList=document.body.classList,cmidClass=Array.from(classList).find((className=>className.startsWith("cmid-")));return parseInt(cmidClass.split("-")[1])}}));

//# sourceMappingURL=codeenv.min.js.map