/**
 *
 * @module      mod_nextblocks/chat
 * @copyright   2025 Rui Correia<rjr.correia@campus.fct.unl.pt>
 * @copyright   based on work by 2024 Duarte Pereira<dg.pereira@campus.fct.unl.pt>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_nextblocks/chat",[],(function(){return{run:function(userName,activityId,saveMessage){const socket=new WebSocket(arguments.length>3&&void 0!==arguments[3]?arguments[3]:"ws://localhost:8060");socket.addEventListener("open",(()=>chatSetup(socket,userName,activityId,saveMessage))),socket.addEventListener("message",(event=>appendMessage(event.data,activityId)))},populate:function(getMessages,activityId){getMessages(100,activityId).then((messages=>{messages.forEach((dbMessage=>{const message={type:"dbMessage",sender:dbMessage.username,text:dbMessage.message,activity:activityId,timestamp:dbMessage.timestamp};appendMessage(message,activityId,!0)}))}))}}}));const appendMessage=function(message,activityId){if(arguments.length>2&&void 0!==arguments[2]&&arguments[2]||(message=parseMessage(message)),activityId===message.activity){const chatDiv=document.getElementById("messages"),timestampDate=new Date(message.timestamp);chatDiv.innerHTML+=`<p>(${String(timestampDate.getHours()).padStart(2,"0")}:${String(timestampDate.getMinutes()).padStart(2,"0")})\n            ${message.sender}: ${message.text}</p>`}},parseMessage=function(message){let msg;try{msg=JSON.parse(message)}catch(e){throw new Error("Invalid message format")}return msg},chatSetup=function(socket,userName,activityId,saveMessage){const msgForm=document.querySelector("form.msg-form");msgForm.addEventListener("submit",(event=>(event=>{event.preventDefault();const msgField=document.getElementById("msg"),msgText=msgField.value,timestamp=Date.now();saveMessage(msgText,userName,activityId,timestamp);let msg={type:"normal",sender:userName,text:msgText,activity:activityId,timestamp:timestamp};msg=JSON.stringify(msg),socket.send(msg),msgField.value=""})(event)))};

//# sourceMappingURL=chat.min.js.map