<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package     mod_nextblocks
 * @copyright   2025 Rui Correia<rjr.correia@campus.fct.unl.pt>
 * @copyright   based on work by 2024 Duarte Pereira<dg.pereira@campus.fct.unl.pt>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

require_once(__DIR__ . '/restore_nextblocks_stepslib.php');

/**
 * Handles general settings for activity restore API.
 */
class restore_nextblocks_activity_task extends restore_activity_task{
    /**
     * No settings needed in this case.
     */
    protected function define_my_settings() {
    }

    /**
     * Defines the steps needed to backup.
     */
    protected function define_my_steps() {
        $this->add_step(new restore_nextblocks_activity_structure_step('nextblocks_structure', 'nextblocks.xml'));
    }

    /**
     * Indicates which areas can files be found during restore.
     */
    public function get_fileareas() {
        return ['intro'];
    }

    /**
     * No config data
     */
    public function get_configdata_encoded_attributes() {
        return [];
    }

    /**
     * No decode contents
     */
    static public function define_decode_contents() {
        return [];
    }

    /**
     * No decode rules
     */
    static public function define_decode_rules() {
        return [];
    }
}
