/**
 *
 * @module      mod_nextblocks/codestring
 * @copyright   2025 Rui Correia<rjr.correia@campus.fct.unl.pt>
 * @copyright   based on work by 2024 Duarte Pereira<dg.pereira@campus.fct.unl.pt>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_nextblocks/codestring",[],(function(){class CodeString{#codeString;#originalCodeString;#userFunctionLinesCount;static#judge0codeheader="\n        const fs = require('fs');\n        const stdin = fs.readFileSync(0, 'utf-8').trim().split('\\n');\n        let nextInput = 0;\n        function input(promptText) {\n          return stdin[nextInput++] || \"\";\n        }\n        \n        ";static#auxFunctions="\nconst runningTests = false;\nconst testInputs = [];\nconst MAX_ITERATIONS = 10000;\nvar nextInput = 0;\nvar loopIterations = 0;\nvar error = \"\";\n\ncustomPrintln = function(string) {\n  outputString += string + '\\n';\n  updateTerminal();\n  return string;\n};\n\nupdateTerminal = function(){\n  if (runningTests) return;\n  const outputDiv = document.getElementById('output-div');\n  if (outputDiv) {\n    outputDiv.innerHTML = \"\";\n    const pre = document.createElement('pre');\n    pre.style.whiteSpace = 'pre-wrap'; \n    pre.textContent = outputString; \n    outputDiv.appendChild(pre);\n  }\n}\n\ntext_to_number = function(string){\n    let result = parseFloat(string);\n    if (isNaN(result)){\n        if (error.length == 0) error = \"Error: Cannot convert \"  + string + \" to a number.\";\n        return 0;\n    }\n    return result;\n}\n\nasync function input(promptText) {\n  if(error.length > 0) return \"\";\n  if(runningTests){\n    if(nextInput++ >= testInputs.length) return \"\";\n    return testInputs[nextInput-1];\n  }\n  const terminal = document.getElementById('output-div')\n  customPrintln(promptText);\n  const inputBox = document.createElement('input');\n  inputBox.setAttribute('id', 'input-box-inline');\n  \n  inputBox.style.backgroundColor = \"black\";\n  inputBox.style.color=\"white\";\n  \n  inputBox.style.display = 'inline-block';\n  inputBox.style.marginLeft = '5px';\n  inputBox.style.position = 'relative';\n  inputBox.style.top = '-40px'; \n  inputBox.style.left = ''+(promptText.length*7.5)+'px';\n  terminal.appendChild(inputBox);\n  inputBox.focus();\n\n  return new Promise((resolve) => {\n    const handleKeyDown = (e) => {\n      if (e.key === 'Enter') {\n        e.preventDefault();\n        inputBox.removeEventListener('keydown', handleKeyDown);\n        const answer = inputBox.value.trim();\n        terminal.removeChild(inputBox);\n        resolve(answer);\n      }\n    };\n    inputBox.addEventListener('keydown', handleKeyDown);\n  });\n}\n\n\n\n\n";static#codeEnding='})();\n        if(nextInput > testInputs.length) return "Error: Too many inputs";\n        if(error.length > 0) return error;\n        return outputString;\n})();\n';constructor(codeString){this.#originalCodeString=CodeString.#judge0codeheader,arguments.length>0?(this.addAsyncDeclaration(),this.#codeString+=codeString,this.#originalCodeString=codeString,this.addVariable("outputString",'""')):(this.#codeString="",this.addAsyncDeclaration(),this.addVariable("outputString",'""')),this.#userFunctionLinesCount=0}getCompleteCodeString(){return this.#codeString}getPrintableCodeString(){const codeLines=this.#codeString.replaceAll("customPrintln","print").replaceAll("text_to_number","parseFloat").split(/(?<!\\)\n/),startIndex=codeLines.findIndex((line=>line.includes("await (async () => {")))+1,endIndex=codeLines.findIndex((line=>line.includes("})();")));return codeLines.slice(startIndex,endIndex).join("\n")}getSubmittableCodeString(){let lastIndex=this.#codeString.lastIndexOf("return outputString;");return this.#codeString.substring(0,lastIndex)+"process.stdout.write(outputString);"+this.#codeString.substring(lastIndex+20)}getTestableCodeString(){return this.#originalCodeString=this.#originalCodeString.replaceAll("customPrintln","console.log"),this.#originalCodeString=this.#originalCodeString.replaceAll("undefined",""),this.#originalCodeString=this.#originalCodeString.replaceAll("await ",""),this.#originalCodeString=this.#originalCodeString.replaceAll("text_to_number","parseFloat"),this.#originalCodeString}addVariable(variableName,variableValue){if(!/^[a-zA-Z_][a-zA-Z0-9_]*$/.test(variableName))throw new Error("Invalid variable name");return this.#codeString+="let "+variableName+" = "+variableValue+";\n","outputString"!==variableName&&(this.#originalCodeString+="let "+variableName+" = "+variableValue+";\n"),this.#codeString}addAsyncDeclaration(){return this.#codeString+="(async () => {\n",this.#codeString}addLine(line){if(line.includes("\n"))throw new Error("Invalid line");return this.#codeString+=line+"\n",line.includes("async")||(this.#originalCodeString+=line+"\n"),this.#codeString}addEnding(){return this.#codeString+=CodeString.#codeEnding,this.#codeString}addAuxFunctions(inputFuncDecs){const auxFunctions=inputFuncDecs+CodeString.#auxFunctions;return this.#codeString+=auxFunctions,this.#codeString}addMainCode(codeString){return this.#codeString+=codeString,this.#originalCodeString+=codeString,this.#codeString}addFunction(functionCode){const functionLinesCount=(functionCode.match(/(?<!\\)\n/g)||[]).length;return this.#userFunctionLinesCount+=functionLinesCount,this.#codeString=functionCode+this.#codeString,this.#originalCodeString=functionCode+this.#originalCodeString,this.#codeString}}return CodeString}));

//# sourceMappingURL=codestring.min.js.map