/**
 *
 * @module      mod_nextblocks/lib
 * @copyright   2025 Rui Correia<rjr.correia@campus.fct.unl.pt>
 * @copyright   based on work by 2024 Duarte Pereira<dg.pereira@campus.fct.unl.pt>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_nextblocks/lib",["mod_nextblocks/codestring","mod_nextblocks/codestringPython","core/str"],(function(CodeString,CodeStringPython,str){function generateFunctionCode(block){Blockly.JavaScript.blockToCode(block);let functionName="%"+Blockly.JavaScript.nameDB_.getName(block.getFieldValue("NAME"),Blockly.Procedures.NAME_TYPE);return functionName=functionName.substring(0,functionName.length-1),Blockly.JavaScript.definitions_[functionName]+"\n"}function generateFunctionCodePython(block){Blockly.Python.blockToCode(block);let functionName="%"+Blockly.Python.nameDB_.getName(block.getFieldValue("NAME"),Blockly.Procedures.NAME_TYPE);return functionName=functionName.substring(0,functionName.length-1),Blockly.Python.definitions_[functionName]+"\n"}function generateDescendantsCode(block){let descendantsCode="";return block.getChildren(!0).forEach((child=>{descendantsCode+=Blockly.JavaScript.blockToCode(child)})),descendantsCode}function generateDescendantsCodePython(block){let descendantsCode="";return block.getChildren(!0).forEach((child=>{descendantsCode+=Blockly.Python.blockToCode(child)})),descendantsCode}return{silentRunCode:async function(code){const result=await eval(code);return void 0===result?code:result},formatCodeHTML:function(code){return arguments.length>1&&void 0!==arguments[1]&&arguments[1]?"<pre>"+code.getCompleteCodeString()+"</pre>":"<pre>"+code.getPrintableCodeString()+"</pre>"},formatPythonCodeHTML:function(code){return arguments.length>1&&void 0!==arguments[1]&&arguments[1]?"<pre>"+code.getCompleteCodeString()+"</pre>":"<pre>"+code.getPrintableCodeString()+"</pre>"},testsAccordion:async function(results,testsJSON){const testCaseCount=testsJSON.length;let accordion='<div class="d-flex flex-wrap" style="max-height: 100%; overflow-y: auto;">',strtest=await str.get_string("test","mod_nextblocks"),strtestnotrun=await str.get_string("testnotrun","mod_nextblocks"),strtesterror=await str.get_string("testerror","mod_nextblocks"),strtestpassed=await str.get_string("testpassed","mod_nextblocks"),strtestfailed=await str.get_string("testfailed","mod_nextblocks"),strtestinput=await str.get_string("testinput","mod_nextblocks"),strexpectedtestoutput=await str.get_string("expectedtestoutput","mod_nextblocks"),stryouroutput=await str.get_string("youroutput","mod_nextblocks");for(let i=0;i<testCaseCount;i++)accordion+='<div class="card m-2" style="flex: 1 1 calc(25% - 20px); min-width: 250px;">',accordion+='<details class="card-body">',accordion+='<summary class="card-header" style="border-bottom: none;">',accordion+=strtest+(i+1),null===results||void 0===results[i]?accordion+='<span class="badge badge-warning float-right">'+strtestnotrun+"</span>":results[i].includes("Error")?accordion+='<span class="badge badge-warning float-right" style="color: black !important;">'+strtesterror+"</span>":results[i]===testsJSON[i].output?accordion+='<span class="badge badge-success float-right" style="color: green !important;">'+strtestpassed+"</span>":accordion+='<span class="badge badge-danger float-right" style="color: red !important;">'+strtestfailed+"</span>",accordion+="</summary>",accordion+='<div class="pt-2" style="background-color: white !important;">',testsJSON[i].inputs.forEach((input=>{const prompt=Object.keys(input)[0],values=Object.values(input[prompt])[0],combination=[prompt].concat(values);let inputString="";for(const v of combination)inputString+=v,inputString+="\n";accordion+='<p class="pt-2 m-0">'+strtestinput+"</p>",accordion+='<pre class="mt-1 mb-0 test-input">'+inputString+"</pre>"})),accordion+='<p class="pt-2 mt-2 mb-0">'+strexpectedtestoutput+"</p>",accordion+='<pre class="mt-1 mb-0 test-output">'+testsJSON[i].output+"</pre>",accordion+='<div class="p-0">',accordion+='<p class="pt-2 m-0">'+stryouroutput+"</p>",null===results?accordion+='<pre class="mt-1 mb-0 test-output">'+strtestnotrun+"</pre>":results[i].includes("Error")?accordion+='<pre class="mt-1 mb-0 test-output" style="color: red !important;">'+results[i]+"</pre>":accordion+='<pre class="pb-2 mt-1 mb-0 test-output">'+results[i]+"</pre>",accordion+="</div>",accordion+="</div>",accordion+="</details>",accordion+="</div>";return accordion+="</div>",accordion},errorPrevention:code=>{let strerrormaxtime="";return str.get_string("errormaxtime","mod_nextblocks").then((function(text){strerrormaxtime=text})),code=code.replace(/((?:while|for)\s*\([^)]*\)\s*\{)/g,'$1\nif(loopIterations++>MAX_ITERATIONS) return outputString = "'+strerrormaxtime+'";')},runTests:async function(code,tests){let results=[];code=code.replace("runningTests = false;","runningTests = true;"),code=this.errorPrevention(code);for(const test of tests){let thisTestCode=code;const inputs=test.inputs;for(const input of inputs){const prompt=Object.keys(input)[0],values=Object.values(input[prompt])[0],combination=[prompt].concat(values);thisTestCode=thisTestCode.replace("const testInputs = [];","const testInputs = ["+combination.toString()+"];")}let codeOutput=await this.silentRunCode(thisTestCode);codeOutput=codeOutput.trim(),results.push(codeOutput)}return results},getWorkspaceCode:function(workspace,inputFuncDecs){Blockly.JavaScript.addReservedWords("print, input");let codeString=new CodeString;codeString.addAuxFunctions(inputFuncDecs);codeString.addLine("await (async () => {");let blocks=workspace.getTopBlocks(!0);for(let b=0;b<blocks.length;b++){const block=blocks[b];"start"===block.type?codeString.addMainCode(generateDescendantsCode(block)):"procedures_defnoreturn"!==block.type&&"procedures_defreturn"!==block.type||codeString.addFunction(generateFunctionCode(block))}return codeString.addEnding(),codeString},getWorkspaceCodePython:function(workspace,inputFuncDecs){Blockly.Python.addReservedWords("print, input, text_ask");let codeString=new CodeStringPython;codeString.addAuxFunctions(inputFuncDecs);codeString.addLine("await (async () => {");let blocks=workspace.getTopBlocks(!0);for(let b=0;b<blocks.length;b++){const block=blocks[b];"start"===block.type?codeString.addMainCode(generateDescendantsCodePython(block)):"procedures_defnoreturn"!==block.type&&"procedures_defreturn"!==block.type||codeString.addFunction(generateFunctionCodePython(block))}return codeString.addEnding(),codeString}}}));

//# sourceMappingURL=lib.min.js.map