/**
 * Adds the base function of a Calculator.
 *
 * @module      block_calculator/calculator_base
 * @copyright   2024 Leon Berau <leon.berau@ruhr-uni-bochum.de>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("block_calculator/calculator_base",["core/str","block_calculator/shunting_yard_converter","block_calculator/rpn_evaluator"],(function(cstr,ShuntingYardConverter,RPNEvaluator){const $=selector=>{const elements=document.querySelectorAll(selector);return 1===elements.length?elements[0]:elements},SELECTORS_CALCULATOR_DRAG_HEADER="#data-block-drag-header",SELECTORS_CALCULATOR="#data-block-calculator",SELECTORS_CURRENTOPERAND="#data-block-calculator-current-operand",SELECTORS_PREVIOUSOPERAND="#data-block-calculator-previous-operand",SELECTORS_NUMBERS=".data-block-calculator-number",SELECTORS_OPERATIONS=".data-block-calculator-operation",SELECTORS_EQUALS=".data-block-calculator-equals",SELECTORS_DELETE=".data-block-calculator-delete",SELECTORS_AC=".data-block-calculator-all-clear",SELECTORS_OPENPARENTHESISCOUNT="#data-block-parenthesis-open-count",SELECTORS_POPOUT=".button-block-calculator-popout",SELECTORS_POPOUT_TEXT="#button-block-calculator-popout-text",SELECTORS_POPOUT_ICON="#button-block-calculator-popout-icon",SELECTORS_COLLAPSE_BUTTON="#block-calculator-accordion-collapse",SELECTORS_COLLAPSE_BODY="#block-calculator-accordion-body",CSS_DRAGGABLE_CSS_ON={position:"fixed",width:"350px","z-index":1031,visibility:"visible"},CSS_DRAGGABLE_CSS_OFF={position:"",width:"","z-index":"",visibility:""},CSS_DRAGGABLE_CLASS="",CSS_POPOUT_CLASS="fa-arrow-up-right-from-square",CSS_POPOUT_CLOSE_CLASS="fa-circle-xmark",CSS_COLLAPSE_ICON_HIDDEN="fa-plus",CSS_COLLAPSE_ICON_SHOWN="fa-minus",KEY_MAP=[0,1,2,3,4,5,6,7,8,9,".",",","+","-","*","/","(",")","Enter","Backspace","Escape","n"],KEY_NAME_MAP={"/":"divide",Enter:"equals",Backspace:"DEL",Escape:"AC",",":"decimal",".":"decimal","+":"plus","-":"minus","*":"multiply","(":"parenthesis-open",")":"parenthesis-close",n:"negative"},OPERATOR_REGEX=/\+|-|\*|÷/;var draggable=!1,position={clientX:0,clientY:0,X:0,Y:0,offset:0},memory={currentOperand:"",previousOperand:"",temporayOperand:"",operation:null,parenthesis:[]},base_calculator={init:function(){this.registerEvents()},registerEvents:function(){this.popoutButton(),this.numbersButton(),this.operationsButton(),this.clearAllButton(),this.deleteButton(),this.equalsButton(),this.collapseButton(),this.keyInput(),this.drag()},collapseButton:function(){var _$;null===(_$=$(SELECTORS_COLLAPSE_BUTTON))||void 0===_$||_$.addEventListener("click",(e=>{var _$2,_$3,_$4,_$5,body=$(SELECTORS_COLLAPSE_BODY);body&&(body.style.display="none"===body.style.display?"block":"none","block"===body.style.display?(null===(_$2=$(SELECTORS_COLLAPSE_BUTTON))||void 0===_$2||_$2.classList.remove(CSS_COLLAPSE_ICON_HIDDEN),null===(_$3=$(SELECTORS_COLLAPSE_BUTTON))||void 0===_$3||_$3.classList.add(CSS_COLLAPSE_ICON_SHOWN)):(null===(_$4=$(SELECTORS_COLLAPSE_BUTTON))||void 0===_$4||_$4.classList.add(CSS_COLLAPSE_ICON_HIDDEN),null===(_$5=$(SELECTORS_COLLAPSE_BUTTON))||void 0===_$5||_$5.classList.remove(CSS_COLLAPSE_ICON_SHOWN)))}))},numbersButton:function(){$(SELECTORS_NUMBERS).forEach((n=>{n.addEventListener("click",(function(e){var _$6;e.target.blur();var number=n.getAttribute("data-char");"."===number&&""===memory.temporayOperand&&memory.currentOperand.includes(".")&&(number=""),""!==memory.temporayOperand?(memory.previousOperand.includes("=")&&(memory.previousOperand=""),")"===number&&0!==memory.parenthesis.length&&base_calculator.hasNumbers(memory.temporayOperand)?(memory.previousOperand=memory.previousOperand.toString()+memory.operation.toString()+memory.temporayOperand.toString()+number.toString(),memory.currentOperand="",memory.operation=null,memory.parenthesis.pop()):"."===number?memory.currentOperand.includes(".")||""!==memory.temporayOperand?memory.currentOperand="0"+number.toString():memory.currentOperand=memory.currentOperand.toString()+number.toString():memory.currentOperand=number.toString(),"("===number&&memory.parenthesis.push(number),memory.temporayOperand=""):"."!==number||memory.currentOperand.includes(".")?""==memory.currentOperand||"("!==number||isNaN(memory.currentOperand.charAt(memory.currentOperand.length-1))?""==memory.previousOperand||isNaN(number)||null!==memory.operation||")"!==memory.previousOperand.charAt(memory.previousOperand.length-1)?""!=memory.previousOperand&&"("===number&&null===memory.operation&&")"===memory.previousOperand.charAt(memory.previousOperand.length-1)?(memory.currentOperand="",memory.previousOperand=memory.previousOperand.toString()+"*(",memory.parenthesis.push(number),base_calculator.update()):"("===number?(memory.parenthesis.push(number),null!==memory.operation?(memory.previousOperand=memory.previousOperand.toString()+memory.operation.toString()+number.toString(),memory.operation=null):memory.previousOperand=memory.previousOperand.toString()+number.toString()):")"===number?0!==memory.parenthesis.length&&(memory.parenthesis.pop(),""==memory.currentOperand?memory.previousOperand=memory.previousOperand.toString()+number.toString():(null!==memory.operation?memory.previousOperand=memory.previousOperand.toString()+memory.operation.toString()+memory.currentOperand.toString()+number.toString():memory.previousOperand=memory.previousOperand.toString()+memory.currentOperand.toString()+number.toString(),memory.currentOperand="",memory.operation=null)):"0"===memory.currentOperand.charAt(0)&&""===memory.currentOperand.charAt(1)&&"."!==number?memory.currentOperand=number.toString():memory.currentOperand=memory.currentOperand.toString()+number.toString():(memory.operation="*",memory.currentOperand=number.toString(),base_calculator.update()):(""===memory.previousOperand&&null===memory.operation?memory.previousOperand=memory.currentOperand.toString()+"*"+number.toString():memory.previousOperand=memory.previousOperand.toString()+memory.operation.toString()+memory.currentOperand.toString()+"*"+number.toString(),memory.currentOperand="",memory.operation=null,memory.parenthesis.push(number),base_calculator.update()):""===memory.currentOperand?memory.currentOperand="0"+number.toString():""!==memory.currentOperand&&"("===memory.currentOperand?memory.currentOperand=memory.currentOperand.toString()+"0"+number.toString():""!==memory.currentOperand&&base_calculator.hasNumbers(memory.currentOperand)&&(memory.currentOperand=memory.currentOperand.toString()+number.toString()),base_calculator.update(),null===(_$6=$(SELECTORS_CALCULATOR))||void 0===_$6||_$6.focus()}))}))},operationsButton:function(){$(SELECTORS_OPERATIONS).forEach((op=>{op.addEventListener("click",(function(e){e.target.blur();var operation=op.getAttribute("data-char");if(""!==memory.currentOperand&&base_calculator.hasNumbers(memory.currentOperand)&&"+/-"===operation)if(memory.currentOperand.includes("-"))memory.currentOperand=memory.currentOperand.replace("-","");else{for(var tempOperand="",c=0;c<memory.currentOperand.length;c++)memory.currentOperand[c].match(/\(|\)/)||tempOperand.includes("-")||(tempOperand+="-"),tempOperand+=memory.currentOperand[c];memory.currentOperand=tempOperand}else""!==memory.currentOperand&&""!==memory.previousOperand&&null!==memory.operation&&base_calculator.hasNumbers(memory.currentOperand)?(memory.previousOperand=memory.previousOperand.toString()+memory.operation.toString()+memory.currentOperand.toString(),memory.currentOperand.includes("(")?memory.currentOperand=memory.currentOperand.slice(1):memory.currentOperand.includes(")")&&(memory.currentOperand=memory.currentOperand.slice(0,-1)),memory.temporayOperand=memory.currentOperand,memory.operation=operation):""!==memory.previousOperand&&""!==memory.currentOperand&&null===memory.operation&&base_calculator.hasNumbers(memory.currentOperand)&&memory.previousOperand.includes("=")?(memory.previousOperand=memory.currentOperand,memory.currentOperand="",memory.operation=operation):""!==memory.currentOperand&&""===memory.previousOperand&&base_calculator.hasNumbers(memory.currentOperand)?(memory.previousOperand=memory.currentOperand,memory.currentOperand.includes("(")?memory.currentOperand=memory.currentOperand.slice(1):memory.currentOperand.includes(")")&&(memory.currentOperand=memory.currentOperand.slice(0,-1)),memory.temporayOperand=memory.currentOperand,memory.operation=operation):""===memory.currentOperand&&""!==memory.previousOperand&&null===memory.operation?memory.operation=operation:""!==memory.currentOperand&&""!==memory.previousOperand&&null===memory.operation&&(memory.previousOperand=memory.previousOperand.toString()+memory.currentOperand.toString(),memory.currentOperand.includes("(")?memory.currentOperand=memory.currentOperand.slice(1):memory.currentOperand.includes(")")&&(memory.currentOperand=memory.currentOperand.slice(0,-1)),memory.temporayOperand=memory.currentOperand,memory.operation=operation);"("!==memory.currentOperand&&"("!==memory.previousOperand||(memory.operation=null),base_calculator.update(),$(SELECTORS_CALCULATOR).focus()}))}))},equalsButton:function(){$(SELECTORS_EQUALS).addEventListener("click",(function(e){e.target.blur(),base_calculator.calculate(),$(SELECTORS_CALCULATOR).focus()}))},deleteButton:function(){$(SELECTORS_DELETE).addEventListener("click",(function(e){if(e.target.blur(),""==memory.currentOperand){if(""!==memory.previousOperand){null!==memory.operation&&(memory.operation=null),memory.previousOperand=memory.previousOperand.includes("=")?memory.previousOperand.slice(0,-1):memory.previousOperand;var nearestOperand=base_calculator.getNearestOperation(memory.previousOperand.toString(),!0);memory.previousOperand=nearestOperand[0],memory.currentOperand=nearestOperand[1],memory.operation=nearestOperand[2],memory.temporayOperand=""}}else{var current_last_char=memory.currentOperand.charAt(memory.currentOperand.length-1),current_second_last_char=memory.currentOperand.charAt(memory.currentOperand.length-2);"("===current_last_char?memory.parenthesis.pop():")"===current_last_char&&memory.parenthesis.push("("),isNaN(current_last_char)||void 0===current_second_last_char||"."!==current_second_last_char&&"-"!==current_second_last_char?memory.currentOperand=memory.currentOperand.toString().slice(0,-1):memory.currentOperand=memory.currentOperand.toString().slice(0,-2)}base_calculator.update(),$(SELECTORS_CALCULATOR).focus()}))},clearAllButton:function(){$(SELECTORS_AC).addEventListener("click",(function(e){e.target.blur(),base_calculator.clearAll(),$(SELECTORS_CALCULATOR).focus()}))},clearAll:function(){memory.currentOperand="",memory.previousOperand="",memory.temporayOperand="",memory.operation=null,memory.parenthesis=[],base_calculator.update()},popoutButton:function(){var _$7;null===(_$7=$(SELECTORS_POPOUT))||void 0===_$7||_$7.addEventListener("click",(()=>{if(draggable){var _$12,_$13,_$11;if(draggable=!1,Object.assign($(SELECTORS_CALCULATOR).style,CSS_DRAGGABLE_CSS_OFF),CSS_DRAGGABLE_CLASS)null===(_$11=$(SELECTORS_CALCULATOR))||void 0===_$11||_$11.classList.remove(CSS_DRAGGABLE_CLASS);null===(_$12=$(SELECTORS_POPOUT_ICON))||void 0===_$12||_$12.classList.remove(CSS_POPOUT_CLOSE_CLASS),null===(_$13=$(SELECTORS_POPOUT_ICON))||void 0===_$13||_$13.classList.add(CSS_POPOUT_CLASS),cstr.get_string("calculator_popout","block_calculator").done((function(popup){$(SELECTORS_POPOUT_TEXT).textContent=popup}))}else{var _$9,_$10,_$8;if(draggable=!0,Object.assign($(SELECTORS_CALCULATOR).style,CSS_DRAGGABLE_CSS_ON),CSS_DRAGGABLE_CLASS)null===(_$8=$(SELECTORS_CALCULATOR))||void 0===_$8||_$8.classList.add(CSS_DRAGGABLE_CLASS);null===(_$9=$(SELECTORS_POPOUT_ICON))||void 0===_$9||_$9.classList.remove(CSS_POPOUT_CLASS),null===(_$10=$(SELECTORS_POPOUT_ICON))||void 0===_$10||_$10.classList.add(CSS_POPOUT_CLOSE_CLASS),cstr.get_string("calculator_close","block_calculator").done((function(popup){$(SELECTORS_POPOUT_TEXT).textContent=popup}))}}))},getNearestOperation:function(str){let removeFromString=arguments.length>1&&void 0!==arguments[1]&&arguments[1];for(var char_until=0,c=str.length;c>=0;c--)if(void 0!==str[c]&&str[c].match(OPERATOR_REGEX)){if("-"===str[c]){if(void 0===str[c-1]){char_until=-1;break}if(str[c-1].match(OPERATOR_REGEX)){char_until=c-1;break}continue}char_until=c;break}var operation="",operator=-1!==char_until&&str[char_until].match(OPERATOR_REGEX)?str[char_until]:null,chars_index=void 0!==str[char_until]&&str[char_until].match(OPERATOR_REGEX)?char_until+1:char_until;for(c=chars_index;c<=str.length;c++)void 0!==str[c]&&(operation+=str[c]);if(removeFromString){var _str=str.slice(0,-1!==char_until?char_until:char_until+1);return[_str,operation,operator,char_until]}return[operation,operator,char_until]},hasNumbers:function(str){for(var hasNumbers=!1,i=0;i<str.length;i++)void 0!==str[i]&&(isNaN(str[i])||(hasNumbers=!0));return hasNumbers},validateCorrectParenthesis:function(str){for(var parenthesis=[],i=0;i<str.length;i++)void 0!==str[i]&&("("==str[i]?parenthesis.push(str[i]):")"==str[i]&&(0==parenthesis.length?parenthesis.push(str[i]):parenthesis.pop()));return 0==parenthesis.length},translateKey:function(key){return void 0!==KEY_NAME_MAP[key]?KEY_NAME_MAP[key]:key},keyInput:function(){window.addEventListener("keypress",(function(e){"/"==e.key&&document.activeElement===$(SELECTORS_CALCULATOR)&&e.preventDefault()})),$(SELECTORS_CALCULATOR).addEventListener("click",(()=>{$(SELECTORS_CALCULATOR).focus()})),$(SELECTORS_CALCULATOR).addEventListener("keydown",(e=>{KEY_MAP.forEach((function(key){if(e.key==key){var translatedKey=base_calculator.translateKey(key),element=$("#data-block-"+translatedKey);element&&element.classList&&element.classList.add("data-block-calculator-pseudo-active")}}))})),$(SELECTORS_CALCULATOR).addEventListener("keyup",(e=>{KEY_MAP.forEach((function(key){if(e.key==key){var translatedKey=base_calculator.translateKey(key),element=$("#data-block-"+translatedKey);element&&(element.click(),element.classList&&element.classList.remove("data-block-calculator-pseudo-active"))}}))}))},drag:function(){var dragHeader=$(SELECTORS_CALCULATOR_DRAG_HEADER);dragHeader&&dragHeader.addEventListener("mousedown",(e=>{if(draggable){$(SELECTORS_CALCULATOR).blur(),e.preventDefault(),position.clientX=e.clientX,position.clientY=e.clientY;var mouseMoveHandler=function(e){e.preventDefault(),position.X=position.clientX-e.clientX,position.Y=position.clientY-e.clientY,position.clientX=e.clientX,position.clientY=e.clientY;var calc=$(SELECTORS_CALCULATOR),rect=calc.getBoundingClientRect();calc.style.top=rect.top-position.Y+"px",calc.style.left=rect.left-position.X+"px"},mouseUpHandler=function(e){e.preventDefault(),document.removeEventListener("mousemove",mouseMoveHandler),document.removeEventListener("mouseup",mouseUpHandler)};document.addEventListener("mouseup",mouseUpHandler),document.addEventListener("mousemove",mouseMoveHandler)}}))},calculate:function(){if(!memory.previousOperand.toString().includes("=")){var validateParenthesis=this.validateCorrectParenthesis(memory.previousOperand.toString()+(null===memory.operation?"":memory.operation.toString())+memory.currentOperand.toString());if(memory.previousOperand=memory.previousOperand.toString()+(null===memory.operation?"":memory.operation.toString())+memory.currentOperand.toString(),!validateParenthesis)for("("===memory.previousOperand[memory.previousOperand.length-1]&&(memory.previousOperand=memory.previousOperand+"0");memory.parenthesis.length>0;)memory.previousOperand=memory.previousOperand.toString()+")",memory.parenthesis.shift();memory.previousOperand=memory.previousOperand.toString()+"=";var result=memory.previousOperand.slice(0,memory.previousOperand.length-1);memory.currentOperand="",memory.temporayOperand="",memory.operation=null,base_calculator.hasNumbers(memory.previousOperand)?result.match(/÷0(?!\.)|÷-0(?!\.)/)?(memory.previousOperand="",this.update(),cstr.get_string("calculator_divide_by_zero","block_calculator").done((function(msg){$(SELECTORS_CURRENTOPERAND).textContent=msg}))):("-0"===(result=new RPNEvaluator((new ShuntingYardConverter).toRPN(result)).eval())&&(result="0"),null!==result?"NaN"===result||"Infinity"===result?(memory.currentOperand="0",memory.temporayOperand="0",memory.operation=null,cstr.get_string("invalidinput","block_calculator").done((function(msg){$(SELECTORS_CURRENTOPERAND).textContent=msg}))):(memory.currentOperand=result,memory.temporayOperand=result):(memory.currentOperand="0",memory.temporayOperand="0",memory.operation=null,cstr.get_string("invalidinput","block_calculator").done((function(msg){$(SELECTORS_CURRENTOPERAND).textContent=msg})))):memory.currentOperand="0"}this.update()},update:function(){let currentOperand=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null,previousOperand=arguments.length>1&&void 0!==arguments[1]?arguments[1]:null,operation=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null;currentOperand=null===currentOperand?memory.currentOperand:currentOperand,previousOperand=null===previousOperand?memory.previousOperand:previousOperand,operation=null===operation?memory.operation:operation,$(SELECTORS_CURRENTOPERAND).textContent=currentOperand.valueOf(),$(SELECTORS_OPENPARENTHESISCOUNT).textContent=0!=memory.parenthesis.length?memory.parenthesis.length:"",$(SELECTORS_PREVIOUSOPERAND).textContent=null!==operation?previousOperand+operation:previousOperand}};return base_calculator}));

//# sourceMappingURL=calculator_base.min.js.map