define("block_calculator/decimal",["exports"],(function(_exports){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.Decimal=void 0;var inexact,quadrant,EXP_LIMIT=9e15,NUMERALS="0123456789abcdef",LN10="2.3025850929940456840179914546843642076011014886287729760333279009675726096773524802359972050895982983419677840422862486334095254650828067566662873690987816894829072083255546808437998948262331985283935053089653777326288461633662222876982198867465436674744042432743651550489343149393914796194044002221051017141748003688084012647080685567743216228355220114804663715659121373450747856947683463616792101806445070648000277502684916746550586856935673420670581136429224554405758925724208241314695689016758940256776311356919292033376587141660230105703089634572075440370847469940168269282808481184289314848524948644871927809676271275775397027668605952496716674183485704422507197965004714951050492214776567636938662976979522110718264549734772662425709429322582798502585509785265383207606726317164309505995087807523710333101197857547331541421808427543863591778117054309827482385045648019095610299291824318237525357709750539565187697510374970888692180205189339507238539205144634197265287286965110862571492198849978748873771345686209167058",PI="3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679821480865132823066470938446095505822317253594081284811174502841027019385211055596446229489549303819644288109756659334461284756482337867831652712019091456485669234603486104543266482133936072602491412737245870066063155881748815209209628292540917153643678925903600113305305488204665213841469519415116094330572703657595919530921861173819326117931051185480744623799627495673518857527248912279381830119491298336733624406566430860213949463952247371907021798609437027705392171762931767523846748184676694051320005681271452635608277857713427577896091736371787214684409012249534301465495853710507922796892589235420199561121290219608640344181598136297747713099605187072113499999983729780499510597317328160963185950244594553469083026425223082533446850352619311881710100031378387528865875332083814206171776691473035982534904287554687311595628638823537875937519577818577805321712268066130019278766111959092164201989380952572010654858632789",DEFAULTS={precision:20,rounding:4,modulo:1,toExpNeg:-7,toExpPos:21,minE:-EXP_LIMIT,maxE:EXP_LIMIT,crypto:!1},external=!0,invalidArgument="[DecimalError] Invalid argument: ",tag="[object Decimal]",mathfloor=Math.floor,mathpow=Math.pow,isBinary=/^0b([01]+(\.[01]*)?|\.[01]+)(p[+-]?\d+)?$/i,isHex=/^0x([0-9a-f]+(\.[0-9a-f]*)?|\.[0-9a-f]+)(p[+-]?\d+)?$/i,isOctal=/^0o([0-7]+(\.[0-7]*)?|\.[0-7]+)(p[+-]?\d+)?$/i,isDecimal=/^(\d+(\.\d*)?|\.\d+)(e[+-]?\d+)?$/i,BASE=1e7,LN10_PRECISION=LN10.length-1,PI_PRECISION=PI.length-1,P={toStringTag:tag};function digitsToString(d){var i,k,ws,indexOfLastWord=d.length-1,str="",w=d[0];if(indexOfLastWord>0){for(str+=w,i=1;i<indexOfLastWord;i++)(k=7-(ws=d[i]+"").length)&&(str+=getZeroString(k)),str+=ws;(k=7-(ws=(w=d[i])+"").length)&&(str+=getZeroString(k))}else if(0===w)return"0";for(;w%10==0;)w/=10;return str+w}function checkInt32(i,min,max){if(i!==~~i||i<min||i>max)throw Error(invalidArgument+i)}function checkRoundingDigits(d,i,rm,repeating){var di,k,r,rd;for(k=d[0];k>=10;k/=10)--i;return--i<0?(i+=7,di=0):(di=Math.ceil((i+1)/7),i%=7),k=mathpow(10,7-i),rd=d[di]%k|0,null==repeating?i<3?(0==i?rd=rd/100|0:1==i&&(rd=rd/10|0),r=rm<4&&99999==rd||rm>3&&49999==rd||5e4==rd||0==rd):r=(rm<4&&rd+1==k||rm>3&&rd+1==k/2)&&(d[di+1]/k/100|0)==mathpow(10,i-2)-1||(rd==k/2||0==rd)&&0==(d[di+1]/k/100|0):i<4?(0==i?rd=rd/1e3|0:1==i?rd=rd/100|0:2==i&&(rd=rd/10|0),r=(repeating||rm<4)&&9999==rd||!repeating&&rm>3&&4999==rd):r=((repeating||rm<4)&&rd+1==k||!repeating&&rm>3&&rd+1==k/2)&&(d[di+1]/k/1e3|0)==mathpow(10,i-3)-1,r}function convertBase(str,baseIn,baseOut){for(var j,arrL,arr=[0],i=0,strL=str.length;i<strL;){for(arrL=arr.length;arrL--;)arr[arrL]*=baseIn;for(arr[0]+=NUMERALS.indexOf(str.charAt(i++)),j=0;j<arr.length;j++)arr[j]>baseOut-1&&(void 0===arr[j+1]&&(arr[j+1]=0),arr[j+1]+=arr[j]/baseOut|0,arr[j]%=baseOut)}return arr.reverse()}P.absoluteValue=P.abs=function(){var x=new this.constructor(this);return x.s<0&&(x.s=1),finalise(x)},P.ceil=function(){return finalise(new this.constructor(this),this.e+1,2)},P.clampedTo=P.clamp=function(min,max){var x=this,Ctor=x.constructor;if(min=new Ctor(min),max=new Ctor(max),!min.s||!max.s)return new Ctor(NaN);if(min.gt(max))throw Error(invalidArgument+max);return x.cmp(min)<0?min:x.cmp(max)>0?max:new Ctor(x)},P.comparedTo=P.cmp=function(y){var i,j,xdL,ydL,x=this,xd=x.d,yd=(y=new x.constructor(y)).d,xs=x.s,ys=y.s;if(!xd||!yd)return xs&&ys?xs!==ys?xs:xd===yd?0:!xd^xs<0?1:-1:NaN;if(!xd[0]||!yd[0])return xd[0]?xs:yd[0]?-ys:0;if(xs!==ys)return xs;if(x.e!==y.e)return x.e>y.e^xs<0?1:-1;for(i=0,j=(xdL=xd.length)<(ydL=yd.length)?xdL:ydL;i<j;++i)if(xd[i]!==yd[i])return xd[i]>yd[i]^xs<0?1:-1;return xdL===ydL?0:xdL>ydL^xs<0?1:-1},P.cosine=P.cos=function(){var pr,rm,x=this,Ctor=x.constructor;return x.d?x.d[0]?(pr=Ctor.precision,rm=Ctor.rounding,Ctor.precision=pr+Math.max(x.e,x.sd())+7,Ctor.rounding=1,x=function(Ctor,x){var k,len,y;if(x.isZero())return x;(len=x.d.length)<32?y=(1/tinyPow(4,k=Math.ceil(len/3))).toString():(k=16,y="2.3283064365386962890625e-10");Ctor.precision+=k,x=taylorSeries(Ctor,1,x.times(y),new Ctor(1));for(var i=k;i--;){var cos2x=x.times(x);x=cos2x.times(cos2x).minus(cos2x).times(8).plus(1)}return Ctor.precision-=k,x}(Ctor,toLessThanHalfPi(Ctor,x)),Ctor.precision=pr,Ctor.rounding=rm,finalise(2==quadrant||3==quadrant?x.neg():x,pr,rm,!0)):new Ctor(1):new Ctor(NaN)},P.cubeRoot=P.cbrt=function(){var e,m,n,r,rep,s,sd,t,t3,t3plusx,x=this,Ctor=x.constructor;if(!x.isFinite()||x.isZero())return new Ctor(x);for(external=!1,(s=x.s*mathpow(x.s*x,1/3))&&Math.abs(s)!=1/0?r=new Ctor(s.toString()):(n=digitsToString(x.d),(s=((e=x.e)-n.length+1)%3)&&(n+=1==s||-2==s?"0":"00"),s=mathpow(n,1/3),e=mathfloor((e+1)/3)-(e%3==(e<0?-1:2)),(r=new Ctor(n=s==1/0?"5e"+e:(n=s.toExponential()).slice(0,n.indexOf("e")+1)+e)).s=x.s),sd=(e=Ctor.precision)+3;;)if(t3plusx=(t3=(t=r).times(t).times(t)).plus(x),r=divide(t3plusx.plus(x).times(t),t3plusx.plus(t3),sd+2,1),digitsToString(t.d).slice(0,sd)===(n=digitsToString(r.d)).slice(0,sd)){if("9999"!=(n=n.slice(sd-3,sd+1))&&(rep||"4999"!=n)){+n&&(+n.slice(1)||"5"!=n.charAt(0))||(finalise(r,e+1,1),m=!r.times(r).times(r).eq(x));break}if(!rep&&(finalise(t,e+1,0),t.times(t).times(t).eq(x))){r=t;break}sd+=4,rep=1}return external=!0,finalise(r,e,Ctor.rounding,m)},P.decimalPlaces=P.dp=function(){var w,d=this.d,n=NaN;if(d){if(n=7*((w=d.length-1)-mathfloor(this.e/7)),w=d[w])for(;w%10==0;w/=10)n--;n<0&&(n=0)}return n},P.dividedBy=P.div=function(y){return divide(this,new this.constructor(y))},P.dividedToIntegerBy=P.divToInt=function(y){var Ctor=this.constructor;return finalise(divide(this,new Ctor(y),0,1,1),Ctor.precision,Ctor.rounding)},P.equals=P.eq=function(y){return 0===this.cmp(y)},P.floor=function(){return finalise(new this.constructor(this),this.e+1,3)},P.greaterThan=P.gt=function(y){return this.cmp(y)>0},P.greaterThanOrEqualTo=P.gte=function(y){var k=this.cmp(y);return 1==k||0===k},P.hyperbolicCosine=P.cosh=function(){var k,n,pr,rm,len,x=this,Ctor=x.constructor,one=new Ctor(1);if(!x.isFinite())return new Ctor(x.s?1/0:NaN);if(x.isZero())return one;pr=Ctor.precision,rm=Ctor.rounding,Ctor.precision=pr+Math.max(x.e,x.sd())+4,Ctor.rounding=1,(len=x.d.length)<32?n=(1/tinyPow(4,k=Math.ceil(len/3))).toString():(k=16,n="2.3283064365386962890625e-10"),x=taylorSeries(Ctor,1,x.times(n),new Ctor(1),!0);for(var cosh2_x,i=k,d8=new Ctor(8);i--;)cosh2_x=x.times(x),x=one.minus(cosh2_x.times(d8.minus(cosh2_x.times(d8))));return finalise(x,Ctor.precision=pr,Ctor.rounding=rm,!0)},P.hyperbolicSine=P.sinh=function(){var k,pr,rm,len,x=this,Ctor=x.constructor;if(!x.isFinite()||x.isZero())return new Ctor(x);if(pr=Ctor.precision,rm=Ctor.rounding,Ctor.precision=pr+Math.max(x.e,x.sd())+4,Ctor.rounding=1,(len=x.d.length)<3)x=taylorSeries(Ctor,2,x,x,!0);else{k=(k=1.4*Math.sqrt(len))>16?16:0|k,x=taylorSeries(Ctor,2,x=x.times(1/tinyPow(5,k)),x,!0);for(var sinh2_x,d5=new Ctor(5),d16=new Ctor(16),d20=new Ctor(20);k--;)sinh2_x=x.times(x),x=x.times(d5.plus(sinh2_x.times(d16.times(sinh2_x).plus(d20))))}return Ctor.precision=pr,Ctor.rounding=rm,finalise(x,pr,rm,!0)},P.hyperbolicTangent=P.tanh=function(){var pr,rm,x=this,Ctor=x.constructor;return x.isFinite()?x.isZero()?new Ctor(x):(pr=Ctor.precision,rm=Ctor.rounding,Ctor.precision=pr+7,Ctor.rounding=1,divide(x.sinh(),x.cosh(),Ctor.precision=pr,Ctor.rounding=rm)):new Ctor(x.s)},P.inverseCosine=P.acos=function(){var halfPi,x=this,Ctor=x.constructor,k=x.abs().cmp(1),pr=Ctor.precision,rm=Ctor.rounding;return-1!==k?0===k?x.isNeg()?getPi(Ctor,pr,rm):new Ctor(0):new Ctor(NaN):x.isZero()?getPi(Ctor,pr+4,rm).times(.5):(Ctor.precision=pr+6,Ctor.rounding=1,x=x.asin(),halfPi=getPi(Ctor,pr+4,rm).times(.5),Ctor.precision=pr,Ctor.rounding=rm,halfPi.minus(x))},P.inverseHyperbolicCosine=P.acosh=function(){var pr,rm,x=this,Ctor=x.constructor;return x.lte(1)?new Ctor(x.eq(1)?0:NaN):x.isFinite()?(pr=Ctor.precision,rm=Ctor.rounding,Ctor.precision=pr+Math.max(Math.abs(x.e),x.sd())+4,Ctor.rounding=1,external=!1,x=x.times(x).minus(1).sqrt().plus(x),external=!0,Ctor.precision=pr,Ctor.rounding=rm,x.ln()):new Ctor(x)},P.inverseHyperbolicSine=P.asinh=function(){var pr,rm,x=this,Ctor=x.constructor;return!x.isFinite()||x.isZero()?new Ctor(x):(pr=Ctor.precision,rm=Ctor.rounding,Ctor.precision=pr+2*Math.max(Math.abs(x.e),x.sd())+6,Ctor.rounding=1,external=!1,x=x.times(x).plus(1).sqrt().plus(x),external=!0,Ctor.precision=pr,Ctor.rounding=rm,x.ln())},P.inverseHyperbolicTangent=P.atanh=function(){var pr,rm,wpr,xsd,x=this,Ctor=x.constructor;return x.isFinite()?x.e>=0?new Ctor(x.abs().eq(1)?x.s/0:x.isZero()?x:NaN):(pr=Ctor.precision,rm=Ctor.rounding,xsd=x.sd(),Math.max(xsd,pr)<2*-x.e-1?finalise(new Ctor(x),pr,rm,!0):(Ctor.precision=wpr=xsd-x.e,x=divide(x.plus(1),new Ctor(1).minus(x),wpr+pr,1),Ctor.precision=pr+4,Ctor.rounding=1,x=x.ln(),Ctor.precision=pr,Ctor.rounding=rm,x.times(.5))):new Ctor(NaN)},P.inverseSine=P.asin=function(){var halfPi,k,pr,rm,x=this,Ctor=x.constructor;return x.isZero()?new Ctor(x):(k=x.abs().cmp(1),pr=Ctor.precision,rm=Ctor.rounding,-1!==k?0===k?((halfPi=getPi(Ctor,pr+4,rm).times(.5)).s=x.s,halfPi):new Ctor(NaN):(Ctor.precision=pr+6,Ctor.rounding=1,x=x.div(new Ctor(1).minus(x.times(x)).sqrt().plus(1)).atan(),Ctor.precision=pr,Ctor.rounding=rm,x.times(2)))},P.inverseTangent=P.atan=function(){var i,j,k,n,px,t,r,wpr,x2,x=this,Ctor=x.constructor,pr=Ctor.precision,rm=Ctor.rounding;if(x.isFinite()){if(x.isZero())return new Ctor(x);if(x.abs().eq(1)&&pr+4<=PI_PRECISION)return(r=getPi(Ctor,pr+4,rm).times(.25)).s=x.s,r}else{if(!x.s)return new Ctor(NaN);if(pr+4<=PI_PRECISION)return(r=getPi(Ctor,pr+4,rm).times(.5)).s=x.s,r}for(Ctor.precision=wpr=pr+10,Ctor.rounding=1,i=k=Math.min(28,wpr/7+2|0);i;--i)x=x.div(x.times(x).plus(1).sqrt().plus(1));for(external=!1,j=Math.ceil(wpr/7),n=1,x2=x.times(x),r=new Ctor(x),px=x;-1!==i;)if(px=px.times(x2),t=r.minus(px.div(n+=2)),px=px.times(x2),void 0!==(r=t.plus(px.div(n+=2))).d[j])for(i=j;r.d[i]===t.d[i]&&i--;);return k&&(r=r.times(2<<k-1)),external=!0,finalise(r,Ctor.precision=pr,Ctor.rounding=rm,!0)},P.isFinite=function(){return!!this.d},P.isInteger=P.isInt=function(){return!!this.d&&mathfloor(this.e/7)>this.d.length-2},P.isNaN=function(){return!this.s},P.isNegative=P.isNeg=function(){return this.s<0},P.isPositive=P.isPos=function(){return this.s>0},P.isZero=function(){return!!this.d&&0===this.d[0]},P.lessThan=P.lt=function(y){return this.cmp(y)<0},P.lessThanOrEqualTo=P.lte=function(y){return this.cmp(y)<1},P.logarithm=P.log=function(base){var isBase10,d,denominator,k,inf,num,sd,r,Ctor=this.constructor,pr=Ctor.precision,rm=Ctor.rounding;if(null==base)base=new Ctor(10),isBase10=!0;else{if(d=(base=new Ctor(base)).d,base.s<0||!d||!d[0]||base.eq(1))return new Ctor(NaN);isBase10=base.eq(10)}if(d=this.d,this.s<0||!d||!d[0]||this.eq(1))return new Ctor(d&&!d[0]?-1/0:1!=this.s?NaN:d?0:1/0);if(isBase10)if(d.length>1)inf=!0;else{for(k=d[0];k%10==0;)k/=10;inf=1!==k}if(external=!1,num=naturalLogarithm(this,sd=pr+5),denominator=isBase10?getLn10(Ctor,sd+10):naturalLogarithm(base,sd),checkRoundingDigits((r=divide(num,denominator,sd,1)).d,k=pr,rm))do{if(num=naturalLogarithm(this,sd+=10),denominator=isBase10?getLn10(Ctor,sd+10):naturalLogarithm(base,sd),r=divide(num,denominator,sd,1),!inf){+digitsToString(r.d).slice(k+1,k+15)+1==1e14&&(r=finalise(r,pr+1,0));break}}while(checkRoundingDigits(r.d,k+=10,rm));return external=!0,finalise(r,pr,rm)},P.minus=P.sub=function(y){var d,e,i,j,k,len,pr,rm,xd,xe,xLTy,yd,x=this,Ctor=x.constructor;if(y=new Ctor(y),!x.d||!y.d)return x.s&&y.s?x.d?y.s=-y.s:y=new Ctor(y.d||x.s!==y.s?x:NaN):y=new Ctor(NaN),y;if(x.s!=y.s)return y.s=-y.s,x.plus(y);if(xd=x.d,yd=y.d,pr=Ctor.precision,rm=Ctor.rounding,!xd[0]||!yd[0]){if(yd[0])y.s=-y.s;else{if(!xd[0])return new Ctor(3===rm?-0:0);y=new Ctor(x)}return external?finalise(y,pr,rm):y}if(e=mathfloor(y.e/7),xe=mathfloor(x.e/7),xd=xd.slice(),k=xe-e){for((xLTy=k<0)?(d=xd,k=-k,len=yd.length):(d=yd,e=xe,len=xd.length),k>(i=Math.max(Math.ceil(pr/7),len)+2)&&(k=i,d.length=1),d.reverse(),i=k;i--;)d.push(0);d.reverse()}else{for((xLTy=(i=xd.length)<(len=yd.length))&&(len=i),i=0;i<len;i++)if(xd[i]!=yd[i]){xLTy=xd[i]<yd[i];break}k=0}for(xLTy&&(d=xd,xd=yd,yd=d,y.s=-y.s),len=xd.length,i=yd.length-len;i>0;--i)xd[len++]=0;for(i=yd.length;i>k;){if(xd[--i]<yd[i]){for(j=i;j&&0===xd[--j];)xd[j]=BASE-1;--xd[j],xd[i]+=BASE}xd[i]-=yd[i]}for(;0===xd[--len];)xd.pop();for(;0===xd[0];xd.shift())--e;return xd[0]?(y.d=xd,y.e=getBase10Exponent(xd,e),external?finalise(y,pr,rm):y):new Ctor(3===rm?-0:0)},P.modulo=P.mod=function(y){var q,x=this,Ctor=x.constructor;return y=new Ctor(y),!x.d||!y.s||y.d&&!y.d[0]?new Ctor(NaN):!y.d||x.d&&!x.d[0]?finalise(new Ctor(x),Ctor.precision,Ctor.rounding):(external=!1,9==Ctor.modulo?(q=divide(x,y.abs(),0,3,1)).s*=y.s:q=divide(x,y,0,Ctor.modulo,1),q=q.times(y),external=!0,x.minus(q))},P.naturalExponential=P.exp=function(){return naturalExponential(this)},P.naturalLogarithm=P.ln=function(){return naturalLogarithm(this)},P.negated=P.neg=function(){var x=new this.constructor(this);return x.s=-x.s,finalise(x)},P.plus=P.add=function(y){var carry,d,e,i,k,len,pr,rm,xd,yd,x=this,Ctor=x.constructor;if(y=new Ctor(y),!x.d||!y.d)return x.s&&y.s?x.d||(y=new Ctor(y.d||x.s===y.s?x:NaN)):y=new Ctor(NaN),y;if(x.s!=y.s)return y.s=-y.s,x.minus(y);if(xd=x.d,yd=y.d,pr=Ctor.precision,rm=Ctor.rounding,!xd[0]||!yd[0])return yd[0]||(y=new Ctor(x)),external?finalise(y,pr,rm):y;if(k=mathfloor(x.e/7),e=mathfloor(y.e/7),xd=xd.slice(),i=k-e){for(i<0?(d=xd,i=-i,len=yd.length):(d=yd,e=k,len=xd.length),i>(len=(k=Math.ceil(pr/7))>len?k+1:len+1)&&(i=len,d.length=1),d.reverse();i--;)d.push(0);d.reverse()}for((len=xd.length)-(i=yd.length)<0&&(i=len,d=yd,yd=xd,xd=d),carry=0;i;)carry=(xd[--i]=xd[i]+yd[i]+carry)/BASE|0,xd[i]%=BASE;for(carry&&(xd.unshift(carry),++e),len=xd.length;0==xd[--len];)xd.pop();return y.d=xd,y.e=getBase10Exponent(xd,e),external?finalise(y,pr,rm):y},P.precision=P.sd=function(z){var k,x=this;if(void 0!==z&&z!==!!z&&1!==z&&0!==z)throw Error(invalidArgument+z);return x.d?(k=getPrecision(x.d),z&&x.e+1>k&&(k=x.e+1)):k=NaN,k},P.round=function(){var x=this,Ctor=x.constructor;return finalise(new Ctor(x),x.e+1,Ctor.rounding)},P.sine=P.sin=function(){var pr,rm,x=this,Ctor=x.constructor;return x.isFinite()?x.isZero()?new Ctor(x):(pr=Ctor.precision,rm=Ctor.rounding,Ctor.precision=pr+Math.max(x.e,x.sd())+7,Ctor.rounding=1,x=function(Ctor,x){var k,len=x.d.length;if(len<3)return x.isZero()?x:taylorSeries(Ctor,2,x,x);k=(k=1.4*Math.sqrt(len))>16?16:0|k,x=x.times(1/tinyPow(5,k)),x=taylorSeries(Ctor,2,x,x);for(var sin2_x,d5=new Ctor(5),d16=new Ctor(16),d20=new Ctor(20);k--;)sin2_x=x.times(x),x=x.times(d5.plus(sin2_x.times(d16.times(sin2_x).minus(d20))));return x}(Ctor,toLessThanHalfPi(Ctor,x)),Ctor.precision=pr,Ctor.rounding=rm,finalise(quadrant>2?x.neg():x,pr,rm,!0)):new Ctor(NaN)},P.squareRoot=P.sqrt=function(){var m,n,sd,r,rep,t,x=this,d=x.d,e=x.e,s=x.s,Ctor=x.constructor;if(1!==s||!d||!d[0])return new Ctor(!s||s<0&&(!d||d[0])?NaN:d?x:1/0);for(external=!1,0==(s=Math.sqrt(+x))||s==1/0?(((n=digitsToString(d)).length+e)%2==0&&(n+="0"),s=Math.sqrt(n),e=mathfloor((e+1)/2)-(e<0||e%2),r=new Ctor(n=s==1/0?"5e"+e:(n=s.toExponential()).slice(0,n.indexOf("e")+1)+e)):r=new Ctor(s.toString()),sd=(e=Ctor.precision)+3;;)if(r=(t=r).plus(divide(x,t,sd+2,1)).times(.5),digitsToString(t.d).slice(0,sd)===(n=digitsToString(r.d)).slice(0,sd)){if("9999"!=(n=n.slice(sd-3,sd+1))&&(rep||"4999"!=n)){+n&&(+n.slice(1)||"5"!=n.charAt(0))||(finalise(r,e+1,1),m=!r.times(r).eq(x));break}if(!rep&&(finalise(t,e+1,0),t.times(t).eq(x))){r=t;break}sd+=4,rep=1}return external=!0,finalise(r,e,Ctor.rounding,m)},P.tangent=P.tan=function(){var pr,rm,x=this,Ctor=x.constructor;return x.isFinite()?x.isZero()?new Ctor(x):(pr=Ctor.precision,rm=Ctor.rounding,Ctor.precision=pr+10,Ctor.rounding=1,(x=x.sin()).s=1,x=divide(x,new Ctor(1).minus(x.times(x)).sqrt(),pr+10,0),Ctor.precision=pr,Ctor.rounding=rm,finalise(2==quadrant||4==quadrant?x.neg():x,pr,rm,!0)):new Ctor(NaN)},P.times=P.mul=function(y){var carry,e,i,k,r,rL,t,xdL,ydL,x=this,Ctor=x.constructor,xd=x.d,yd=(y=new Ctor(y)).d;if(y.s*=x.s,!(xd&&xd[0]&&yd&&yd[0]))return new Ctor(!y.s||xd&&!xd[0]&&!yd||yd&&!yd[0]&&!xd?NaN:xd&&yd?0*y.s:y.s/0);for(e=mathfloor(x.e/7)+mathfloor(y.e/7),(xdL=xd.length)<(ydL=yd.length)&&(r=xd,xd=yd,yd=r,rL=xdL,xdL=ydL,ydL=rL),r=[],i=rL=xdL+ydL;i--;)r.push(0);for(i=ydL;--i>=0;){for(carry=0,k=xdL+i;k>i;)t=r[k]+yd[i]*xd[k-i-1]+carry,r[k--]=t%BASE|0,carry=t/BASE|0;r[k]=(r[k]+carry)%BASE|0}for(;!r[--rL];)r.pop();return carry?++e:r.shift(),y.d=r,y.e=getBase10Exponent(r,e),external?finalise(y,Ctor.precision,Ctor.rounding):y},P.toBinary=function(sd,rm){return toStringBinary(this,2,sd,rm)},P.toDecimalPlaces=P.toDP=function(dp,rm){var x=this,Ctor=x.constructor;return x=new Ctor(x),void 0===dp?x:(checkInt32(dp,0,1e9),void 0===rm?rm=Ctor.rounding:checkInt32(rm,0,8),finalise(x,dp+x.e+1,rm))},P.toExponential=function(dp,rm){var str,x=this,Ctor=x.constructor;return void 0===dp?str=finiteToString(x,!0):(checkInt32(dp,0,1e9),void 0===rm?rm=Ctor.rounding:checkInt32(rm,0,8),str=finiteToString(x=finalise(new Ctor(x),dp+1,rm),!0,dp+1)),x.isNeg()&&!x.isZero()?"-"+str:str},P.toFixed=function(dp,rm){var str,y,x=this,Ctor=x.constructor;return void 0===dp?str=finiteToString(x):(checkInt32(dp,0,1e9),void 0===rm?rm=Ctor.rounding:checkInt32(rm,0,8),str=finiteToString(y=finalise(new Ctor(x),dp+x.e+1,rm),!1,dp+y.e+1)),x.isNeg()&&!x.isZero()?"-"+str:str},P.toFraction=function(maxD){var d,d0,d1,d2,e,k,n,n0,n1,pr,q,r,x=this,xd=x.d,Ctor=x.constructor;if(!xd)return new Ctor(x);if(n1=d0=new Ctor(1),d1=n0=new Ctor(0),k=(e=(d=new Ctor(d1)).e=getPrecision(xd)-x.e-1)%7,d.d[0]=mathpow(10,k<0?7+k:k),null==maxD)maxD=e>0?d:n1;else{if(!(n=new Ctor(maxD)).isInt()||n.lt(n1))throw Error(invalidArgument+n);maxD=n.gt(d)?e>0?d:n1:n}for(external=!1,n=new Ctor(digitsToString(xd)),pr=Ctor.precision,Ctor.precision=e=7*xd.length*2;q=divide(n,d,0,1,1),1!=(d2=d0.plus(q.times(d1))).cmp(maxD);)d0=d1,d1=d2,d2=n1,n1=n0.plus(q.times(d2)),n0=d2,d2=d,d=n.minus(q.times(d2)),n=d2;return d2=divide(maxD.minus(d0),d1,0,1,1),n0=n0.plus(d2.times(n1)),d0=d0.plus(d2.times(d1)),n0.s=n1.s=x.s,r=divide(n1,d1,e,1).minus(x).abs().cmp(divide(n0,d0,e,1).minus(x).abs())<1?[n1,d1]:[n0,d0],Ctor.precision=pr,external=!0,r},P.toHexadecimal=P.toHex=function(sd,rm){return toStringBinary(this,16,sd,rm)},P.toNearest=function(y,rm){var x=this,Ctor=x.constructor;if(x=new Ctor(x),null==y){if(!x.d)return x;y=new Ctor(1),rm=Ctor.rounding}else{if(y=new Ctor(y),void 0===rm?rm=Ctor.rounding:checkInt32(rm,0,8),!x.d)return y.s?x:y;if(!y.d)return y.s&&(y.s=x.s),y}return y.d[0]?(external=!1,x=divide(x,y,0,rm,1).times(y),external=!0,finalise(x)):(y.s=x.s,x=y),x},P.toNumber=function(){return+this},P.toOctal=function(sd,rm){return toStringBinary(this,8,sd,rm)},P.toPower=P.pow=function(y){var e,k,pr,r,rm,s,x=this,Ctor=x.constructor,yn=+(y=new Ctor(y));if(!(x.d&&y.d&&x.d[0]&&y.d[0]))return new Ctor(mathpow(+x,yn));if((x=new Ctor(x)).eq(1))return x;if(pr=Ctor.precision,rm=Ctor.rounding,y.eq(1))return finalise(x,pr,rm);if((e=mathfloor(y.e/7))>=y.d.length-1&&(k=yn<0?-yn:yn)<=9007199254740991)return r=intPow(Ctor,x,k,pr),y.s<0?new Ctor(1).div(r):finalise(r,pr,rm);if((s=x.s)<0){if(e<y.d.length-1)return new Ctor(NaN);if(0==(1&y.d[e])&&(s=1),0==x.e&&1==x.d[0]&&1==x.d.length)return x.s=s,x}return(e=0!=(k=mathpow(+x,yn))&&isFinite(k)?new Ctor(k+"").e:mathfloor(yn*(Math.log("0."+digitsToString(x.d))/Math.LN10+x.e+1)))>Ctor.maxE+1||e<Ctor.minE-1?new Ctor(e>0?s/0:0):(external=!1,Ctor.rounding=x.s=1,k=Math.min(12,(e+"").length),(r=naturalExponential(y.times(naturalLogarithm(x,pr+k)),pr)).d&&checkRoundingDigits((r=finalise(r,pr+5,1)).d,pr,rm)&&(e=pr+10,+digitsToString((r=finalise(naturalExponential(y.times(naturalLogarithm(x,e+k)),e),e+5,1)).d).slice(pr+1,pr+15)+1==1e14&&(r=finalise(r,pr+1,0))),r.s=s,external=!0,Ctor.rounding=rm,finalise(r,pr,rm))},P.toPrecision=function(sd,rm){var str,x=this,Ctor=x.constructor;return void 0===sd?str=finiteToString(x,x.e<=Ctor.toExpNeg||x.e>=Ctor.toExpPos):(checkInt32(sd,1,1e9),void 0===rm?rm=Ctor.rounding:checkInt32(rm,0,8),str=finiteToString(x=finalise(new Ctor(x),sd,rm),sd<=x.e||x.e<=Ctor.toExpNeg,sd)),x.isNeg()&&!x.isZero()?"-"+str:str},P.toSignificantDigits=P.toSD=function(sd,rm){var Ctor=this.constructor;return void 0===sd?(sd=Ctor.precision,rm=Ctor.rounding):(checkInt32(sd,1,1e9),void 0===rm?rm=Ctor.rounding:checkInt32(rm,0,8)),finalise(new Ctor(this),sd,rm)},P.toString=function(){var x=this,Ctor=x.constructor,str=finiteToString(x,x.e<=Ctor.toExpNeg||x.e>=Ctor.toExpPos);return x.isNeg()&&!x.isZero()?"-"+str:str},P.truncated=P.trunc=function(){return finalise(new this.constructor(this),this.e+1,1)},P.valueOf=P.toJSON=function(){var x=this,Ctor=x.constructor,str=finiteToString(x,x.e<=Ctor.toExpNeg||x.e>=Ctor.toExpPos);return x.isNeg()?"-"+str:str};var divide=function(){function multiplyInteger(x,k,base){var temp,carry=0,i=x.length;for(x=x.slice();i--;)temp=x[i]*k+carry,x[i]=temp%base|0,carry=temp/base|0;return carry&&x.unshift(carry),x}function compare(a,b,aL,bL){var i,r;if(aL!=bL)r=aL>bL?1:-1;else for(i=r=0;i<aL;i++)if(a[i]!=b[i]){r=a[i]>b[i]?1:-1;break}return r}function subtract(a,b,aL,base){for(var i=0;aL--;)a[aL]-=i,i=a[aL]<b[aL]?1:0,a[aL]=i*base+a[aL]-b[aL];for(;!a[0]&&a.length>1;)a.shift()}return function(x,y,pr,rm,dp,base){var cmp,e,i,k,logBase,more,prod,prodL,q,qd,rem,remL,rem0,sd,t,xi,xL,yd0,yL,yz,Ctor=x.constructor,sign=x.s==y.s?1:-1,xd=x.d,yd=y.d;if(!(xd&&xd[0]&&yd&&yd[0]))return new Ctor(x.s&&y.s&&(xd?!yd||xd[0]!=yd[0]:yd)?xd&&0==xd[0]||!yd?0*sign:sign/0:NaN);for(base?(logBase=1,e=x.e-y.e):(base=BASE,logBase=7,e=mathfloor(x.e/logBase)-mathfloor(y.e/logBase)),yL=yd.length,xL=xd.length,qd=(q=new Ctor(sign)).d=[],i=0;yd[i]==(xd[i]||0);i++);if(yd[i]>(xd[i]||0)&&e--,null==pr?(sd=pr=Ctor.precision,rm=Ctor.rounding):sd=dp?pr+(x.e-y.e)+1:pr,sd<0)qd.push(1),more=!0;else{if(sd=sd/logBase+2|0,i=0,1==yL){for(k=0,yd=yd[0],sd++;(i<xL||k)&&sd--;i++)t=k*base+(xd[i]||0),qd[i]=t/yd|0,k=t%yd|0;more=k||i<xL}else{for((k=base/(yd[0]+1)|0)>1&&(yd=multiplyInteger(yd,k,base),xd=multiplyInteger(xd,k,base),yL=yd.length,xL=xd.length),xi=yL,remL=(rem=xd.slice(0,yL)).length;remL<yL;)rem[remL++]=0;(yz=yd.slice()).unshift(0),yd0=yd[0],yd[1]>=base/2&&++yd0;do{k=0,(cmp=compare(yd,rem,yL,remL))<0?(rem0=rem[0],yL!=remL&&(rem0=rem0*base+(rem[1]||0)),(k=rem0/yd0|0)>1?(k>=base&&(k=base-1),1==(cmp=compare(prod=multiplyInteger(yd,k,base),rem,prodL=prod.length,remL=rem.length))&&(k--,subtract(prod,yL<prodL?yz:yd,prodL,base))):(0==k&&(cmp=k=1),prod=yd.slice()),(prodL=prod.length)<remL&&prod.unshift(0),subtract(rem,prod,remL,base),-1==cmp&&(cmp=compare(yd,rem,yL,remL=rem.length))<1&&(k++,subtract(rem,yL<remL?yz:yd,remL,base)),remL=rem.length):0===cmp&&(k++,rem=[0]),qd[i++]=k,cmp&&rem[0]?rem[remL++]=xd[xi]||0:(rem=[xd[xi]],remL=1)}while((xi++<xL||void 0!==rem[0])&&sd--);more=void 0!==rem[0]}qd[0]||qd.shift()}if(1==logBase)q.e=e,inexact=more;else{for(i=1,k=qd[0];k>=10;k/=10)i++;q.e=i+e*logBase-1,finalise(q,dp?pr+q.e+1:pr,rm,more)}return q}}();function finalise(x,sd,rm,isTruncated){var digits,i,j,k,rd,roundUp,w,xd,xdi,Ctor=x.constructor;out:if(null!=sd){if(!(xd=x.d))return x;for(digits=1,k=xd[0];k>=10;k/=10)digits++;if((i=sd-digits)<0)i+=7,j=sd,rd=(w=xd[xdi=0])/mathpow(10,digits-j-1)%10|0;else if((xdi=Math.ceil((i+1)/7))>=(k=xd.length)){if(!isTruncated)break out;for(;k++<=xdi;)xd.push(0);w=rd=0,digits=1,j=(i%=7)-7+1}else{for(w=k=xd[xdi],digits=1;k>=10;k/=10)digits++;rd=(j=(i%=7)-7+digits)<0?0:w/mathpow(10,digits-j-1)%10|0}if(isTruncated=isTruncated||sd<0||void 0!==xd[xdi+1]||(j<0?w:w%mathpow(10,digits-j-1)),roundUp=rm<4?(rd||isTruncated)&&(0==rm||rm==(x.s<0?3:2)):rd>5||5==rd&&(4==rm||isTruncated||6==rm&&(i>0?j>0?w/mathpow(10,digits-j):0:xd[xdi-1])%10&1||rm==(x.s<0?8:7)),sd<1||!xd[0])return xd.length=0,roundUp?(sd-=x.e+1,xd[0]=mathpow(10,(7-sd%7)%7),x.e=-sd||0):xd[0]=x.e=0,x;if(0==i?(xd.length=xdi,k=1,xdi--):(xd.length=xdi+1,k=mathpow(10,7-i),xd[xdi]=j>0?(w/mathpow(10,digits-j)%mathpow(10,j)|0)*k:0),roundUp)for(;;){if(0==xdi){for(i=1,j=xd[0];j>=10;j/=10)i++;for(j=xd[0]+=k,k=1;j>=10;j/=10)k++;i!=k&&(x.e++,xd[0]==BASE&&(xd[0]=1));break}if(xd[xdi]+=k,xd[xdi]!=BASE)break;xd[xdi--]=0,k=1}for(i=xd.length;0===xd[--i];)xd.pop()}return external&&(x.e>Ctor.maxE?(x.d=null,x.e=NaN):x.e<Ctor.minE&&(x.e=0,x.d=[0])),x}function finiteToString(x,isExp,sd){if(!x.isFinite())return nonFiniteToString(x);var k,e=x.e,str=digitsToString(x.d),len=str.length;return isExp?(sd&&(k=sd-len)>0?str=str.charAt(0)+"."+str.slice(1)+getZeroString(k):len>1&&(str=str.charAt(0)+"."+str.slice(1)),str=str+(x.e<0?"e":"e+")+x.e):e<0?(str="0."+getZeroString(-e-1)+str,sd&&(k=sd-len)>0&&(str+=getZeroString(k))):e>=len?(str+=getZeroString(e+1-len),sd&&(k=sd-e-1)>0&&(str=str+"."+getZeroString(k))):((k=e+1)<len&&(str=str.slice(0,k)+"."+str.slice(k)),sd&&(k=sd-len)>0&&(e+1===len&&(str+="."),str+=getZeroString(k))),str}function getBase10Exponent(digits,e){var w=digits[0];for(e*=7;w>=10;w/=10)e++;return e}function getLn10(Ctor,sd,pr){if(sd>LN10_PRECISION)throw external=!0,pr&&(Ctor.precision=pr),Error("[DecimalError] Precision limit exceeded");return finalise(new Ctor(LN10),sd,1,!0)}function getPi(Ctor,sd,rm){if(sd>PI_PRECISION)throw Error("[DecimalError] Precision limit exceeded");return finalise(new Ctor(PI),sd,rm,!0)}function getPrecision(digits){var w=digits.length-1,len=7*w+1;if(w=digits[w]){for(;w%10==0;w/=10)len--;for(w=digits[0];w>=10;w/=10)len++}return len}function getZeroString(k){for(var zs="";k--;)zs+="0";return zs}function intPow(Ctor,x,n,pr){var isTruncated,r=new Ctor(1),k=Math.ceil(pr/7+4);for(external=!1;;){if(n%2&&truncate((r=r.times(x)).d,k)&&(isTruncated=!0),0===(n=mathfloor(n/2))){n=r.d.length-1,isTruncated&&0===r.d[n]&&++r.d[n];break}truncate((x=x.times(x)).d,k)}return external=!0,r}function isOdd(n){return 1&n.d[n.d.length-1]}function maxOrMin(Ctor,args,ltgt){for(var y,x=new Ctor(args[0]),i=0;++i<args.length;){if(!(y=new Ctor(args[i])).s){x=y;break}x[ltgt](y)&&(x=y)}return x}function naturalExponential(x,sd){var denominator,guard,j,pow,sum,t,wpr,rep=0,i=0,k=0,Ctor=x.constructor,rm=Ctor.rounding,pr=Ctor.precision;if(!x.d||!x.d[0]||x.e>17)return new Ctor(x.d?x.d[0]?x.s<0?0:1/0:1:x.s?x.s<0?0:x:NaN);for(null==sd?(external=!1,wpr=pr):wpr=sd,t=new Ctor(.03125);x.e>-2;)x=x.times(t),k+=5;for(wpr+=guard=Math.log(mathpow(2,k))/Math.LN10*2+5|0,denominator=pow=sum=new Ctor(1),Ctor.precision=wpr;;){if(pow=finalise(pow.times(x),wpr,1),denominator=denominator.times(++i),digitsToString((t=sum.plus(divide(pow,denominator,wpr,1))).d).slice(0,wpr)===digitsToString(sum.d).slice(0,wpr)){for(j=k;j--;)sum=finalise(sum.times(sum),wpr,1);if(null!=sd)return Ctor.precision=pr,sum;if(!(rep<3&&checkRoundingDigits(sum.d,wpr-guard,rm,rep)))return finalise(sum,Ctor.precision=pr,rm,external=!0);Ctor.precision=wpr+=10,denominator=pow=t=new Ctor(1),i=0,rep++}sum=t}}function naturalLogarithm(y,sd){var c,c0,denominator,e,numerator,rep,sum,t,wpr,x1,x2,n=1,x=y,xd=x.d,Ctor=x.constructor,rm=Ctor.rounding,pr=Ctor.precision;if(x.s<0||!xd||!xd[0]||!x.e&&1==xd[0]&&1==xd.length)return new Ctor(xd&&!xd[0]?-1/0:1!=x.s?NaN:xd?0:x);if(null==sd?(external=!1,wpr=pr):wpr=sd,Ctor.precision=wpr+=10,c0=(c=digitsToString(xd)).charAt(0),!(Math.abs(e=x.e)<15e14))return t=getLn10(Ctor,wpr+2,pr).times(e+""),x=naturalLogarithm(new Ctor(c0+"."+c.slice(1)),wpr-10).plus(t),Ctor.precision=pr,null==sd?finalise(x,pr,rm,external=!0):x;for(;c0<7&&1!=c0||1==c0&&c.charAt(1)>3;)c0=(c=digitsToString((x=x.times(y)).d)).charAt(0),n++;for(e=x.e,c0>1?(x=new Ctor("0."+c),e++):x=new Ctor(c0+"."+c.slice(1)),x1=x,sum=numerator=x=divide(x.minus(1),x.plus(1),wpr,1),x2=finalise(x.times(x),wpr,1),denominator=3;;){if(numerator=finalise(numerator.times(x2),wpr,1),digitsToString((t=sum.plus(divide(numerator,new Ctor(denominator),wpr,1))).d).slice(0,wpr)===digitsToString(sum.d).slice(0,wpr)){if(sum=sum.times(2),0!==e&&(sum=sum.plus(getLn10(Ctor,wpr+2,pr).times(e+""))),sum=divide(sum,new Ctor(n),wpr,1),null!=sd)return Ctor.precision=pr,sum;if(!checkRoundingDigits(sum.d,wpr-10,rm,rep))return finalise(sum,Ctor.precision=pr,rm,external=!0);Ctor.precision=wpr+=10,t=numerator=x=divide(x1.minus(1),x1.plus(1),wpr,1),x2=finalise(x.times(x),wpr,1),denominator=rep=1}sum=t,denominator+=2}}function nonFiniteToString(x){return String(x.s*x.s/0)}function parseDecimal(x,str){var e,i,len;for((e=str.indexOf("."))>-1&&(str=str.replace(".","")),(i=str.search(/e/i))>0?(e<0&&(e=i),e+=+str.slice(i+1),str=str.substring(0,i)):e<0&&(e=str.length),i=0;48===str.charCodeAt(i);i++);for(len=str.length;48===str.charCodeAt(len-1);--len);if(str=str.slice(i,len)){if(len-=i,x.e=e=e-i-1,x.d=[],i=(e+1)%7,e<0&&(i+=7),i<len){for(i&&x.d.push(+str.slice(0,i)),len-=7;i<len;)x.d.push(+str.slice(i,i+=7));i=7-(str=str.slice(i)).length}else i-=len;for(;i--;)str+="0";x.d.push(+str),external&&(x.e>x.constructor.maxE?(x.d=null,x.e=NaN):x.e<x.constructor.minE&&(x.e=0,x.d=[0]))}else x.e=0,x.d=[0];return x}function parseOther(x,str){var base,Ctor,divisor,i,isFloat,len,p,xd,xe;if(str.indexOf("_")>-1){if(str=str.replace(/(\d)_(?=\d)/g,"$1"),isDecimal.test(str))return parseDecimal(x,str)}else if("Infinity"===str||"NaN"===str)return+str||(x.s=NaN),x.e=NaN,x.d=null,x;if(isHex.test(str))base=16,str=str.toLowerCase();else if(isBinary.test(str))base=2;else{if(!isOctal.test(str))throw Error(invalidArgument+str);base=8}for((i=str.search(/p/i))>0?(p=+str.slice(i+1),str=str.substring(2,i)):str=str.slice(2),isFloat=(i=str.indexOf("."))>=0,Ctor=x.constructor,isFloat&&(i=(len=(str=str.replace(".","")).length)-i,divisor=intPow(Ctor,new Ctor(base),i,2*i)),i=xe=(xd=convertBase(str,base,BASE)).length-1;0===xd[i];--i)xd.pop();return i<0?new Ctor(0*x.s):(x.e=getBase10Exponent(xd,xe),x.d=xd,external=!1,isFloat&&(x=divide(x,divisor,4*len)),p&&(x=x.times(Math.abs(p)<54?mathpow(2,p):Decimal.pow(2,p))),external=!0,x)}function taylorSeries(Ctor,n,x,y,isHyperbolic){var j,t,u,x2,pr=Ctor.precision,k=Math.ceil(pr/7);for(external=!1,x2=x.times(x),u=new Ctor(y);;){if(t=divide(u.times(x2),new Ctor(n++*n++),pr,1),u=isHyperbolic?y.plus(t):y.minus(t),y=divide(t.times(x2),new Ctor(n++*n++),pr,1),void 0!==(t=u.plus(y)).d[k]){for(j=k;t.d[j]===u.d[j]&&j--;);if(-1==j)break}j=u,u=y,y=t,t=j}return external=!0,t.d.length=k+1,t}function tinyPow(b,e){for(var n=b;--e;)n*=b;return n}function toLessThanHalfPi(Ctor,x){var t,isNeg=x.s<0,pi=getPi(Ctor,Ctor.precision,1),halfPi=pi.times(.5);if((x=x.abs()).lte(halfPi))return quadrant=isNeg?4:1,x;if((t=x.divToInt(pi)).isZero())quadrant=isNeg?3:2;else{if((x=x.minus(t.times(pi))).lte(halfPi))return quadrant=isOdd(t)?isNeg?2:3:isNeg?4:1,x;quadrant=isOdd(t)?isNeg?1:4:isNeg?3:2}return x.minus(pi).abs()}function toStringBinary(x,baseOut,sd,rm){var base,e,i,k,len,roundUp,str,xd,y,Ctor=x.constructor,isExp=void 0!==sd;if(isExp?(checkInt32(sd,1,1e9),void 0===rm?rm=Ctor.rounding:checkInt32(rm,0,8)):(sd=Ctor.precision,rm=Ctor.rounding),x.isFinite()){for(isExp?(base=2,16==baseOut?sd=4*sd-3:8==baseOut&&(sd=3*sd-2)):base=baseOut,(i=(str=finiteToString(x)).indexOf("."))>=0&&(str=str.replace(".",""),(y=new Ctor(1)).e=str.length-i,y.d=convertBase(finiteToString(y),10,base),y.e=y.d.length),e=len=(xd=convertBase(str,10,base)).length;0==xd[--len];)xd.pop();if(xd[0]){if(i<0?e--:((x=new Ctor(x)).d=xd,x.e=e,xd=(x=divide(x,y,sd,rm,0,base)).d,e=x.e,roundUp=inexact),i=xd[sd],k=base/2,roundUp=roundUp||void 0!==xd[sd+1],roundUp=rm<4?(void 0!==i||roundUp)&&(0===rm||rm===(x.s<0?3:2)):i>k||i===k&&(4===rm||roundUp||6===rm&&1&xd[sd-1]||rm===(x.s<0?8:7)),xd.length=sd,roundUp)for(;++xd[--sd]>base-1;)xd[sd]=0,sd||(++e,xd.unshift(1));for(len=xd.length;!xd[len-1];--len);for(i=0,str="";i<len;i++)str+=NUMERALS.charAt(xd[i]);if(isExp){if(len>1)if(16==baseOut||8==baseOut){for(i=16==baseOut?4:3,--len;len%i;len++)str+="0";for(len=(xd=convertBase(str,base,baseOut)).length;!xd[len-1];--len);for(i=1,str="1.";i<len;i++)str+=NUMERALS.charAt(xd[i])}else str=str.charAt(0)+"."+str.slice(1);str=str+(e<0?"p":"p+")+e}else if(e<0){for(;++e;)str="0"+str;str="0."+str}else if(++e>len)for(e-=len;e--;)str+="0";else e<len&&(str=str.slice(0,e)+"."+str.slice(e))}else str=isExp?"0p+0":"0";str=(16==baseOut?"0x":2==baseOut?"0b":8==baseOut?"0o":"")+str}else str=nonFiniteToString(x);return x.s<0?"-"+str:str}function truncate(arr,len){if(arr.length>len)return arr.length=len,!0}function abs(x){return new this(x).abs()}function acos(x){return new this(x).acos()}function acosh(x){return new this(x).acosh()}function add(x,y){return new this(x).plus(y)}function asin(x){return new this(x).asin()}function asinh(x){return new this(x).asinh()}function atan(x){return new this(x).atan()}function atanh(x){return new this(x).atanh()}function atan2(y,x){y=new this(y),x=new this(x);var r,pr=this.precision,rm=this.rounding,wpr=pr+4;return y.s&&x.s?y.d||x.d?!x.d||y.isZero()?(r=x.s<0?getPi(this,pr,rm):new this(0)).s=y.s:!y.d||x.isZero()?(r=getPi(this,wpr,1).times(.5)).s=y.s:x.s<0?(this.precision=wpr,this.rounding=1,r=this.atan(divide(y,x,wpr,1)),x=getPi(this,wpr,1),this.precision=pr,this.rounding=rm,r=y.s<0?r.minus(x):r.plus(x)):r=this.atan(divide(y,x,wpr,1)):(r=getPi(this,wpr,1).times(x.s>0?.25:.75)).s=y.s:r=new this(NaN),r}function cbrt(x){return new this(x).cbrt()}function ceil(x){return finalise(x=new this(x),x.e+1,2)}function clamp(x,min,max){return new this(x).clamp(min,max)}function config(obj){if(!obj||"object"!=typeof obj)throw Error("[DecimalError] Object expected");var i,p,v,useDefaults=!0===obj.defaults,ps=["precision",1,1e9,"rounding",0,8,"toExpNeg",-EXP_LIMIT,0,"toExpPos",0,EXP_LIMIT,"maxE",0,EXP_LIMIT,"minE",-EXP_LIMIT,0,"modulo",0,9];for(i=0;i<ps.length;i+=3)if(p=ps[i],useDefaults&&(this[p]=DEFAULTS[p]),void 0!==(v=obj[p])){if(!(mathfloor(v)===v&&v>=ps[i+1]&&v<=ps[i+2]))throw Error(invalidArgument+p+": "+v);this[p]=v}if(p="crypto",useDefaults&&(this[p]=DEFAULTS[p]),void 0!==(v=obj[p])){if(!0!==v&&!1!==v&&0!==v&&1!==v)throw Error(invalidArgument+p+": "+v);if(v){if("undefined"==typeof crypto||!crypto||!crypto.getRandomValues&&!crypto.randomBytes)throw Error("[DecimalError] crypto unavailable");this[p]=!0}else this[p]=!1}return this}function cos(x){return new this(x).cos()}function cosh(x){return new this(x).cosh()}function div(x,y){return new this(x).div(y)}function exp(x){return new this(x).exp()}function floor(x){return finalise(x=new this(x),x.e+1,3)}function hypot(){var i,n,t=new this(0);for(external=!1,i=0;i<arguments.length;)if((n=new this(arguments[i++])).d)t.d&&(t=t.plus(n.times(n)));else{if(n.s)return external=!0,new this(1/0);t=n}return external=!0,t.sqrt()}function isDecimalInstance(obj){return obj instanceof Decimal||obj&&obj.toStringTag===tag||!1}function ln(x){return new this(x).ln()}function log(x,y){return new this(x).log(y)}function log2(x){return new this(x).log(2)}function log10(x){return new this(x).log(10)}function max(){return maxOrMin(this,arguments,"lt")}function min(){return maxOrMin(this,arguments,"gt")}function mod(x,y){return new this(x).mod(y)}function mul(x,y){return new this(x).mul(y)}function pow(x,y){return new this(x).pow(y)}function random(sd){var d,e,k,n,i=0,r=new this(1),rd=[];if(void 0===sd?sd=this.precision:checkInt32(sd,1,1e9),k=Math.ceil(sd/7),this.crypto)if(crypto.getRandomValues)for(d=crypto.getRandomValues(new Uint32Array(k));i<k;)(n=d[i])>=429e7?d[i]=crypto.getRandomValues(new Uint32Array(1))[0]:rd[i++]=n%1e7;else{if(!crypto.randomBytes)throw Error("[DecimalError] crypto unavailable");for(d=crypto.randomBytes(k*=4);i<k;)(n=d[i]+(d[i+1]<<8)+(d[i+2]<<16)+((127&d[i+3])<<24))>=214e7?crypto.randomBytes(4).copy(d,i):(rd.push(n%1e7),i+=4);i=k/4}else for(;i<k;)rd[i++]=1e7*Math.random()|0;for(sd%=7,(k=rd[--i])&&sd&&(n=mathpow(10,7-sd),rd[i]=(k/n|0)*n);0===rd[i];i--)rd.pop();if(i<0)e=0,rd=[0];else{for(e=-1;0===rd[0];e-=7)rd.shift();for(k=1,n=rd[0];n>=10;n/=10)k++;k<7&&(e-=7-k)}return r.e=e,r.d=rd,r}function round(x){return finalise(x=new this(x),x.e+1,this.rounding)}function sign(x){return(x=new this(x)).d?x.d[0]?x.s:0*x.s:x.s||NaN}function sin(x){return new this(x).sin()}function sinh(x){return new this(x).sinh()}function sqrt(x){return new this(x).sqrt()}function sub(x,y){return new this(x).sub(y)}function sum(){var i=0,args=arguments,x=new this(args[i]);for(external=!1;x.s&&++i<args.length;)x=x.plus(args[i]);return external=!0,finalise(x,this.precision,this.rounding)}function tan(x){return new this(x).tan()}function tanh(x){return new this(x).tanh()}function trunc(x){return finalise(x=new this(x),x.e+1,1)}P[Symbol.for("nodejs.util.inspect.custom")]=P.toString,P[Symbol.toStringTag]="Decimal";var Decimal=P.constructor=function clone(obj){var i,p,ps;function Decimal(v){var e,i,t,x=this;if(!(x instanceof Decimal))return new Decimal(v);if(x.constructor=Decimal,isDecimalInstance(v))return x.s=v.s,void(external?!v.d||v.e>Decimal.maxE?(x.e=NaN,x.d=null):v.e<Decimal.minE?(x.e=0,x.d=[0]):(x.e=v.e,x.d=v.d.slice()):(x.e=v.e,x.d=v.d?v.d.slice():v.d));if("number"===(t=typeof v)){if(0===v)return x.s=1/v<0?-1:1,x.e=0,void(x.d=[0]);if(v<0?(v=-v,x.s=-1):x.s=1,v===~~v&&v<1e7){for(e=0,i=v;i>=10;i/=10)e++;return void(external?e>Decimal.maxE?(x.e=NaN,x.d=null):e<Decimal.minE?(x.e=0,x.d=[0]):(x.e=e,x.d=[v]):(x.e=e,x.d=[v]))}return 0*v!=0?(v||(x.s=NaN),x.e=NaN,void(x.d=null)):parseDecimal(x,v.toString())}if("string"!==t)throw Error(invalidArgument+v);return 45===(i=v.charCodeAt(0))?(v=v.slice(1),x.s=-1):(43===i&&(v=v.slice(1)),x.s=1),isDecimal.test(v)?parseDecimal(x,v):parseOther(x,v)}if(Decimal.prototype=P,Decimal.ROUND_UP=0,Decimal.ROUND_DOWN=1,Decimal.ROUND_CEIL=2,Decimal.ROUND_FLOOR=3,Decimal.ROUND_HALF_UP=4,Decimal.ROUND_HALF_DOWN=5,Decimal.ROUND_HALF_EVEN=6,Decimal.ROUND_HALF_CEIL=7,Decimal.ROUND_HALF_FLOOR=8,Decimal.EUCLID=9,Decimal.config=Decimal.set=config,Decimal.clone=clone,Decimal.isDecimal=isDecimalInstance,Decimal.abs=abs,Decimal.acos=acos,Decimal.acosh=acosh,Decimal.add=add,Decimal.asin=asin,Decimal.asinh=asinh,Decimal.atan=atan,Decimal.atanh=atanh,Decimal.atan2=atan2,Decimal.cbrt=cbrt,Decimal.ceil=ceil,Decimal.clamp=clamp,Decimal.cos=cos,Decimal.cosh=cosh,Decimal.div=div,Decimal.exp=exp,Decimal.floor=floor,Decimal.hypot=hypot,Decimal.ln=ln,Decimal.log=log,Decimal.log10=log10,Decimal.log2=log2,Decimal.max=max,Decimal.min=min,Decimal.mod=mod,Decimal.mul=mul,Decimal.pow=pow,Decimal.random=random,Decimal.round=round,Decimal.sign=sign,Decimal.sin=sin,Decimal.sinh=sinh,Decimal.sqrt=sqrt,Decimal.sub=sub,Decimal.sum=sum,Decimal.tan=tan,Decimal.tanh=tanh,Decimal.trunc=trunc,void 0===obj&&(obj={}),obj&&!0!==obj.defaults)for(ps=["precision","rounding","toExpNeg","toExpPos","maxE","minE","modulo","crypto"],i=0;i<ps.length;)obj.hasOwnProperty(p=ps[i++])||(obj[p]=this[p]);return Decimal.config(obj),Decimal}(DEFAULTS);_exports.Decimal=Decimal,LN10=new Decimal(LN10),PI=new Decimal(PI)}));

//# sourceMappingURL=decimal.min.js.map