/**
 * JavaScript for image fullscreen functionality.
 *
 * @module     filter_imagefullscreen/fullscreen
 * @copyright  2025 Sandip R <radadiyasandip89@gmail.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("filter_imagefullscreen/fullscreen",["jquery","core/notification"],(function($,Notification){var startX,startY,currentZoom=1,isDragging=!1,translateX=0,translateY=0,createModal=function(){if($("#fullscreen-modal").length)return $.Deferred().resolve();return $("body").append('<div id="fullscreen-modal"><span class="close-modal">&times;</span><img class="modal-content" alt=""><div class="image-title"></div><div class="zoom-controls"><button class="zoom-out" title="Zoom Out">−</button><span class="zoom-level">100%</span><button class="zoom-in" title="Zoom In">+</button><button class="zoom-reset" title="Reset Zoom">↺</button></div></div>'),$.Deferred().resolve()},registerEventListeners=function(){$("body").on("click",".fullscreen-icon",(function(e){e.preventDefault(),e.stopPropagation();var img=$(this).closest(".image-fullscreen-container").find("img"),imgSrc=img.attr("src"),imgAlt=img.attr("alt")||"",modal=$("#fullscreen-modal");modal.find(".modal-content").attr("src",imgSrc).attr("alt",imgAlt),imgAlt?modal.find(".image-title").text(imgAlt):modal.find(".image-title").remove(),modal.addClass("show"),$(document).on("keydown.fullscreen",(function(event){"Escape"===event.key&&closeModal()}))})),$("#fullscreen-modal").on("click",(function(e){$(e.target).closest(".zoom-controls").length||$(e.target).is(".modal-content")||closeModal()})),$(".zoom-controls button").on("click",(function(e){e.stopPropagation()}))},closeModal=function(){$("#fullscreen-modal").removeClass("show"),$(document).off("keydown.fullscreen"),resetZoom()},registerZoomListeners=function(){var modal=$("#fullscreen-modal"),modalContent=modal.find(".modal-content");modal.find(".zoom-in").on("click",(function(){zoom(.1)})),modal.find(".zoom-out").on("click",(function(){zoom(-.1)})),modal.find(".zoom-reset").on("click",resetZoom),modal.on("wheel",(function(e){e.preventDefault(),zoom(e.originalEvent.deltaY<0?.1:-.1)})),modalContent.on("mousedown touchstart",startDrag),$(document).on("mousemove touchmove",drag),$(document).on("mouseup touchend mouseleave",stopDrag),modalContent.on("dragstart",(function(e){e.preventDefault()}))},zoom=function(delta){var newZoom=Math.min(Math.max(currentZoom+delta,.5),3);newZoom!==currentZoom&&(currentZoom=newZoom,updateTransform(),$("#fullscreen-modal .zoom-level").text(Math.round(100*currentZoom)+"%"))},resetZoom=function(){currentZoom=1,translateX=0,translateY=0,updateTransform(),$("#fullscreen-modal .zoom-level").text("100%"),$("#fullscreen-modal .modal-content").removeClass("zoomed")},startDrag=function(e){if(currentZoom>1){isDragging=!0;var pos=getEventPos(e);startX=pos.x-translateX,startY=pos.y-translateY,$("#fullscreen-modal .modal-content").addClass("zoomed")}},drag=function(e){if(isDragging){e.preventDefault();var pos=getEventPos(e);translateX=pos.x-startX,translateY=pos.y-startY;var modalContent=$("#fullscreen-modal .modal-content"),imgWidth=modalContent[0].naturalWidth,imgHeight=modalContent[0].naturalHeight,maxTranslateX=(imgWidth*currentZoom-imgWidth)/2,maxTranslateY=(imgHeight*currentZoom-imgHeight)/2;translateX=Math.min(Math.max(translateX,-maxTranslateX),maxTranslateX),translateY=Math.min(Math.max(translateY,-maxTranslateY),maxTranslateY),updateTransform()}},stopDrag=function(){isDragging=!1,1===currentZoom&&$("#fullscreen-modal .modal-content").removeClass("zoomed")},getEventPos=function(e){if(e.type.startsWith("touch")){var touch=e.originalEvent.touches[0]||e.originalEvent.changedTouches[0];return{x:touch.clientX,y:touch.clientY}}return{x:e.clientX,y:e.clientY}},updateTransform=function(){$("#fullscreen-modal .modal-content").css("transform","translate(-50%, -50%) translate("+translateX+"px, "+translateY+"px) scale("+currentZoom+")")};return{init:function(){createModal().then((function(){registerEventListeners(),registerZoomListeners()})).catch(Notification.exception)}}}));

//# sourceMappingURL=fullscreen.min.js.map