<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Settings for imagefullscreen filter
 *
 * @package    filter_imagefullscreen
 * @copyright  2025 Sandip R <radadiyasandip89@gmail.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

if ($ADMIN->fulltree) {
    // Activity modules where the filter should be active.
    $settings->add(new admin_setting_configmulticheckbox(
        'filter_imagefullscreen/enabledactivities',
        get_string('enabledactivities', 'filter_imagefullscreen'),
        get_string('enabledactivities_desc', 'filter_imagefullscreen'),
        ['mod_book' => 1],
        function() {
            // Get all installed activity modules.
            $modules = core_component::get_plugin_list('mod');
            $activities = [];

            // Create array of all available activities.
            foreach ($modules as $module => $path) {
                $modname = 'mod_' . $module;
                if (get_string_manager()->string_exists('modulename', $modname)) {
                    $activities[$modname] = get_string('modulename', $modname);
                } else {
                    $activities[$modname] = $module;
                }
            }

            // Sort activities alphabetically.
            asort($activities);

            return $activities;
        }
    ));
}
