# Image Fullscreen Filter

A modern Moodle filter plugin that adds fullscreen functionality to images in activity content. This filter enhances the viewing experience by allowing users to expand images to fullscreen mode with a simple click.

## Features

- **Smart Detection**: Automatically detects images in activity content
- **Activity-Specific**: Only activates within activity contexts (configurable per activity type)
- **Configurable**: Choose which activity modules should have the filter enabled
- **Modern Architecture**: Built with Moodle 4.5+ standards using namespaced classes and Mustache templates
- **Responsive Design**: Works seamlessly across desktop and mobile devices
- **Lightweight**: Minimal performance impact with efficient image detection

## How It Works

The filter scans content for `<img>` tags and adds a fullscreen icon overlay. Users can:

1. **View Images**: Click the fullscreen icon to expand any image to fullscreen mode
2. **Navigate**: Use keyboard shortcuts or click outside to exit fullscreen
3. **Zoom**: Native browser zooming capabilities in fullscreen mode

## Installation

### Method 1: Manual Installation
1. Download or clone this repository
2. Copy the `imagefullscreen` folder to your Moodle's `/filter/` directory
3. Visit **Site Administration > Notifications** to complete the installation
4. Go to **Site Administration > Plugins > Filters > Manage filters**
5. Enable "Image Fullscreen Filter" by setting it to "On"

### Method 2: Plugin Directory (if available)
1. Go to **Site Administration > Plugins > Install plugins**
2. Search for "Image Fullscreen Filter"
3. Follow the installation wizard

## Configuration

### Enable the Filter
1. Navigate to **Site Administration > Plugins > Filters > Manage filters**
2. Find "Image Fullscreen Filter" and set it to **"On"**
3. Adjust the order if needed (recommended after "Convert URLs to links")

### Activity Settings
1. Go to **Site Administration > Plugins > Filters > Image Fullscreen Filter**
2. Select which activity modules should have the filter enabled:
   - **Book** (enabled by default)
   - **Page**
   - **Lesson** 
   - **Forum**
   - **Quiz**
   - And any other installed activity modules

## Technical Details

### Requirements
- **Moodle**: 4.5 or later
- **PHP**: 8.1 or later (as required by Moodle 4.5)
- **Browser**: Modern browser with JavaScript enabled

### Architecture
- **Namespace**: `filter_imagefullscreen`
- **Main Class**: `\filter_imagefullscreen\text_filter`
- **Templates**: Mustache templates in `/templates/` directory
- **Privacy Compliant**: Implements null privacy provider

### File Structure
```
filter/imagefullscreen/
├── classes/
│   ├── text_filter.php          # Main filter logic
│   └── privacy/provider.php     # Privacy compliance
├── templates/                   # Mustache templates
│   ├── fullscreen_icon.mustache # SVG icon template
│   ├── image_container.mustache # Standalone image wrapper
│   └── span_image.mustache      # Span-wrapped image template
├── amd/                         # JavaScript modules
├── lang/                        # Language strings
├── db/                          # Database definitions
└── styles.css                   # Custom styles
```

### Performance
- **Efficient**: Only processes content in activity contexts
- **Selective**: Applies only to enabled activity types
- **Cached**: Uses Moodle's template caching system
- **Minimal DOM**: Adds minimal HTML overhead

## Customization

### Styling
Override styles by adding CSS to your theme:
```css
.image-fullscreen-container {
    /* Custom container styles */
}

.fullscreen-icon {
    /* Custom icon styles */
}
```

### Templates
Templates can be overridden in your theme:
- Copy templates to `theme/yourtheme/templates/filter_imagefullscreen/`
- Modify as needed while maintaining required context variables

### JavaScript
The fullscreen functionality uses AMD modules located in `/amd/src/fullscreen.js`

## Troubleshooting

### Filter Not Working
1. Ensure the filter is enabled in **Manage filters**
2. Check that you're viewing content within an enabled activity
3. Verify JavaScript is enabled in your browser
4. Clear Moodle caches: **Site Administration > Development > Purge caches**

### Performance Issues
1. Limit the filter to specific activity types
2. Check for conflicts with other image-related filters
3. Ensure your Moodle version meets requirements

### Browser Compatibility
- **Chrome/Chromium**: Fully supported
- **Firefox**: Fully supported  
- **Safari**: Fully supported
- **Edge**: Fully supported
- **Mobile browsers**: Responsive design supported

## Development

### Contributing
1. Fork the repository
2. Create a feature branch
3. Follow Moodle coding standards
4. Add appropriate tests
5. Submit a pull request

### Testing
Run Moodle's code checker:
```bash
php local/codechecker/run.php filter/imagefullscreen/
```

## License

This plugin is licensed under the **GNU General Public License v3 or later**.

## Support

- **Documentation**: This README file
- **Issues**: Report bugs and feature requests via the project repository
- **Community**: Moodle forums and developer community

## Changelog

### Version 2025062000
- **NEW**: Moodle 4.5+ compatibility
- **NEW**: Namespaced classes and modern architecture
- **NEW**: Mustache template system
- **NEW**: Activity-only filtering
- **NEW**: Configurable activity modules
- **IMPROVED**: Performance optimizations
- **IMPROVED**: Code standards compliance

---

**Author**: Sandip R <radadiyasandip89@gmail.com>  
**Copyright**: 2025 Sandip R  
**License**: GPL v3+
