<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language file.
 *
 * @package    local_easycustmenu
 * @copyright  2024 https://santoshmagar.com.np/
 * @author     santoshtmp7 https://github.com/santoshtmp/moodle-local_easycustmenu
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 *
 */


defined('MOODLE_INTERNAL') || die();

$string['pluginname'] = 'Easy Custom Menu';
$string['pluginname_desc'] = 'Local plugin to easily customize Moodle menus';
$string['privacy:metadata'] = 'The local easycustmenu plugin manages site menu item orders and does not store any data itself.';
$string['configtitle'] = 'Easy Custom Menu Settings';
$string['general_setting'] = 'General Setting';
$string['user_menu_setting'] = 'User Menu Setting';
$string['header_nav_menu_setting'] = 'Header Nav Menu Setting';
$string['hide'] = 'Hide';
$string['show'] = 'Show';
$string['hide_primarynavigation_description'] = 'You can hide the default primary navigation by selecting one or multiple values.';
$string['hide_primarynavigation_title'] = 'Hide primary navigation';
$string['add_page_title'] = 'Easy Custom Menu - ' . 'Add Item';
$string['edit_page_title'] = 'Easy Custom Menu - ' . 'Edit Item';
$string['delete_page_title'] = 'Easy Custom Menu - ' . 'Delete Item';
$string['delete_conform_heading'] = 'Delete Menu Item?';
$string['delete_conform_text'] = 'Are you sure you want to delete "{$a->menulabel}"?';
$string['edit'] = 'Edit';
$string['delete'] = 'Delete';
$string['label'] = 'Label';
$string['invalidtypeparam'] = 'Invalid type param. Check type param';
$string['invalidactionparam'] = 'Invalid action param. Check action param';
$string['invalideditaccess'] = 'Not allowed to edit menu, you need admin access.';
$string['invalidsesskey'] = 'Your session key is missing or invalid.';
$string['navmenu'] = 'Nav Menu Item';
$string['usermenu'] = 'User Menu Item';
$string['menu_item'] = 'Menu Item';
$string['add_menu_item'] = 'Add menu item';
$string['edit_menu_item'] = 'Edit menu item';
$string['menu_type'] = 'Menu Type';
$string['menu_label'] = 'Menu label';
$string['menu_label_tooltip_title'] = 'Menu label tooltip title';
$string['menu_link'] = 'Menu Link';
$string['menu_context'] = 'Menu context';
$string['allcourses'] = 'All Courses';
$string['alllanguages'] = 'All Languages';
$string['menu_condition_lang'] = 'Menu condition language';
$string['menu_condition_role'] = 'Menu condition role';
$string['everyone'] = 'Everyone';
$string['open_in_a_new_browser_tab'] = 'Open in a new browser tab';
$string['label_error'] = 'Menu Label "{$a->menu_label}" alrady exist.';
$string['menu_added'] = 'Menu item "{$a->menu_label}" sucessfully added.';
$string['menu_updated'] = 'Menu item "{$a->menu_label}" sucessfully updated.';
$string['menu_delete'] = 'Menu item "{$a->menu_label}" sucessfully deleted.';
$string['menu_error_delete'] = 'Error on Menu item delete.';
$string['menu_error_submit'] = 'Error on Menu item submit.';
$string['menu_delete_missing'] = 'Menu delete data is missing.';
$string['menu_update_id_missing'] = 'Update menu data is missing.';
$string['no_menu_items_please_add'] = 'No menu item added. Please add menu item.';
$string['save_order'] = 'Save Re-Order';
$string['invalidmenudepth'] = 'Invalid menu depth detected! Please adjust highlighted rows.';
$string['menu_parent'] = 'Menu parent';
$string['show_through_site'] = 'Show site-wide';
$string['show_in_course'] = 'Show within course';
$string['setting_activate'] = 'Activate';
$string['setting_activate_desc'] = 'Activate the Easy Custom Menu feature.';
$string['setting_general'] = 'General';
$string['setting_primarynav_heading'] = 'Primary Navigation';
$string['setting_show_ecm_core'] = 'Show ECM in Default Custom Menu';
$string['setting_show_ecm_core_desc'] = 'This will hide or show the Easy Custom Menu (ECM) link in the default admin custom menu section.';
$string['setting_user_menu_heading'] = 'User Menu Settings';
$string['managenavmenulabel'] = 'Manage Menu Through Easy Custom Menu';
$string['manageusermenulabel'] = 'Manage User Menu Through Easy Custom Menu';
