<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * Main entry for User Course Reports.
 *
 * @package    report_usercoursereports
 * @copyright  2024 https://santoshmagar.com.np/
 * @author     santoshtmp7
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use report_usercoursereports\form\filter_form;
use report_usercoursereports\usercoursereports;

// Get require config file.
require_once(dirname(__FILE__) . '/../../config.php');
require_once($CFG->libdir . '/adminlib.php');
defined('MOODLE_INTERNAL') || die();

// Access checks and Capability check.
require_login(null, false);
admin_externalpage_setup('report_usercoursereports');
$context = \context_system::instance();
if (!has_capability('report/usercoursereports:view', $context)) {
    throw new moodle_exception('invalidaccess', 'report_usercoursereports');
}
$type = required_param('type', PARAM_TEXT);
if (!$type || !in_array($type, ['course', 'user'])) {
    throw new moodle_exception('invalidtypeparam', 'report_usercoursereports');
}

// Get request parameters (with defaults).
$parameters = [
    'type'              => $type,
    'id'                => optional_param('id', 0, PARAM_INT),
    'search'            => optional_param('search', '', PARAM_TEXT),
    'page'              => optional_param('page', 0, PARAM_INT),
    'perpage'           => optional_param('perpage', 50, PARAM_INT),
    'courseformat'      => optional_param('courseformat', '', PARAM_TEXT),
    'coursevisibility'  => optional_param('coursevisibility', '', PARAM_TEXT),
    'enrolmethod'       => optional_param('enrolmethod', '', PARAM_TEXT),
    'createdfrom'       => optional_param_array('createdfrom', 0, PARAM_INT),
    'createdto'         => optional_param_array('createdto', 0, PARAM_INT),
    'startdatefrom'     => optional_param_array('startdatefrom', 0, PARAM_INT),
    'startdateto'       => optional_param_array('startdateto', 0, PARAM_INT),
    'categoryids'       => optional_param_array('categoryids', 0, PARAM_INT),
    'courseids'         => optional_param_array('courseids', 0, PARAM_INT),
    'roleids'           => optional_param_array('roleids', 0, PARAM_INT),
    'suspended'         => optional_param('suspended', '', PARAM_TEXT),
    'confirmed'         => optional_param('confirmed', '', PARAM_TEXT),
    'download'          => optional_param('download', 0, PARAM_INT),
    'sortby'            => optional_param('sortby', 'timemodified', PARAM_TEXT),
    'sortdir'           => optional_param('sortdir', SORT_DESC, PARAM_INT),
];

// Prepare the page information.
$pagepath       = '/report/usercoursereports/index.php';
$urlparams      = usercoursereports::urlparam($parameters);
$parameters['pagepath'] = $pagepath;
$parameters['urlparams'] = $urlparams;
$pageurl        = new moodle_url($pagepath, $urlparams);
$redirecturl    = new moodle_url($pagepath, ['type' => $type]);
$pagetitle     = get_string('pluginname', 'report_usercoursereports');

// Setup page information.
$PAGE->set_context($context);
$PAGE->set_url($pageurl);
$PAGE->set_pagelayout('report');
$PAGE->set_pagetype('report_usercoursereports');
$PAGE->set_subpage((string)$type);
$PAGE->set_title($pagetitle);
$PAGE->set_heading($pagetitle);
$PAGE->add_body_class('report-usercoursereports');
$PAGE->navbar->add(get_string($type . 'reports', 'report_usercoursereports'), $pageurl);
$PAGE->requires->jquery();

// Load AMD module.
$PAGE->requires->js_call_amd(
    'report_usercoursereports/usercoursereports',
    'init',
    [
        'urlpath' => $pagepath,
        'type' => $type,
    ]
);
// Load filter.
$filterform = new filter_form(
    $redirecturl,
    $parameters,
    'GET',
    '',
    [
        'id' => 'usercoursereports-filter',
        'class' => 'mform report-usercoursereports-filter pt-3 pb-3 me',
        'data-usercoursereports-type' => $type,
    ]
);
if ($filterform->is_cancelled()) {
    redirect($redirecturl);
}

// Get the data and display.
$contents = '';
$contents .= usercoursereports::get_report_list($type, $pagepath);
if ($type == 'user' && $parameters['id']) {
    $contents .= usercoursereports::get_singleuser_info($parameters['id']);
} else if ($type == 'course') {
    $contents .= $filterform->render();
    $contents .= usercoursereports::get_course_info_table($pageurl, $parameters);
} else if ($type == 'user') {
    $contents .= $filterform->render();
    $contents .= usercoursereports::get_user_info_table($pageurl, $parameters);
}

// Output Content.
echo $OUTPUT->header();
echo $contents;
echo $OUTPUT->footer();
